/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.utils.geohash.GeomDistance;
import org.locationtech.geomesa.utils.geohash.GeomDistance$Distance$;
import org.locationtech.geomesa.utils.text.ObjectPoolFactory$;
import org.locationtech.geomesa.utils.text.ObjectPoolUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import scala.Function0;
import scala.Function1;

public final class VincentyModel$
implements GeomDistance {
    public static final VincentyModel$ MODULE$ = new VincentyModel$();
    private static final GeometryFactory geometryFactory;
    private static final ObjectPoolUtils<GeodeticCalculator> geodeticCalculatorPool;
    private static volatile GeomDistance$Distance$ Distance$module;

    static {
        GeomDistance.$init$(MODULE$);
        geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);
        geodeticCalculatorPool = ObjectPoolFactory$.MODULE$.apply((Function0 & Serializable)() -> new GeodeticCalculator(), ObjectPoolFactory$.MODULE$.apply$default$2());
    }

    @Override
    public GeomDistance$Distance$ Distance() {
        if (Distance$module == null) {
            this.Distance$lzycompute$1();
        }
        return Distance$module;
    }

    private GeometryFactory geometryFactory() {
        return geometryFactory;
    }

    private ObjectPoolUtils<GeodeticCalculator> geodeticCalculatorPool() {
        return geodeticCalculatorPool;
    }

    public GeomDistance.Distance getDistanceBetweenTwoPoints(Point a, Point b) {
        return this.getDistanceBetweenTwoPoints(a.getX(), a.getY(), b.getX(), b.getY());
    }

    public GeomDistance.Distance getDistanceBetweenTwoPoints(double x1, double y1, double x2, double y2) {
        return (GeomDistance.Distance)this.geodeticCalculatorPool().withResource((Function1 & Serializable)calc -> {
            calc.setStartingGeographicPoint(x1, y1);
            calc.setDestinationGeographicPoint(x2, y2);
            return new GeomDistance.Distance(MODULE$, calc.getOrthodromicDistance());
        });
    }

    public Point moveWithBearingAndDistance(Point a, double bearing, double distance) {
        return this.moveWithBearingAndDistance(a.getX(), a.getY(), bearing, distance);
    }

    public Point moveWithBearingAndDistance(double x, double y, double bearing, double distance) {
        return (Point)this.geodeticCalculatorPool().withResource((Function1 & Serializable)calc -> {
            calc.setStartingGeographicPoint(x, y);
            calc.setDirection(bearing, distance);
            Point2D point = calc.getDestinationGeographicPoint();
            return MODULE$.geometryFactory().createPoint(new Coordinate(point.getX(), point.getY()));
        });
    }

    private final void Distance$lzycompute$1() {
        VincentyModel$ vincentyModel$ = this;
        synchronized (vincentyModel$) {
            if (Distance$module == null) {
                Distance$module = new GeomDistance$Distance$(this);
            }
        }
    }

    private VincentyModel$() {
    }
}

