/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeohashUtils;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class GeometryUtils$
implements LazyLogging {
    public static final GeometryUtils$ MODULE$ = new GeometryUtils$();
    private static final GeometryFactory geoFactory;
    private static final Point zeroPoint;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        geoFactory = JTSFactoryFinder.getGeometryFactory();
        zeroPoint = MODULE$.geoFactory().createPoint(new Coordinate(0.0, 0.0));
    }

    private Logger logger$lzycompute() {
        GeometryUtils$ geometryUtils$ = this;
        synchronized (geometryUtils$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public GeometryFactory geoFactory() {
        return geoFactory;
    }

    public Point zeroPoint() {
        return zeroPoint;
    }

    public Tuple2<Object, Object> distanceDegrees(Geometry geom, double meters) {
        Geometry geometry = geom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return this.distanceDegrees(point, meters, new GeodeticCalculator());
        }
        return this.distanceDegrees(geom.getEnvelopeInternal(), meters);
    }

    public Tuple2<Object, Object> distanceDegrees(Point point, double meters, GeodeticCalculator calc) {
        Tuple2<Object, Object> tuple2 = this.directionalDegrees(point, meters, calc);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double east = tuple2._1$mcD$sp();
        double north = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(east, north);
        double east2 = sp2._1$mcD$sp();
        double north2 = sp2._2$mcD$sp();
        if (east2 > north2) {
            return new Tuple2.mcDD.sp(north2, east2);
        }
        return new Tuple2.mcDD.sp(east2, north2);
    }

    public Tuple2<Object, Object> distanceDegrees(Envelope env, double meters) {
        .colon.colon distances = new .colon.colon(this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMaxX(), env.getMaxY())), meters), (List)new .colon.colon(this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMaxX(), env.getMinY())), meters), (List)new .colon.colon(this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMinX(), env.getMinY())), meters), (List)new .colon.colon(this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMinX(), env.getMaxY())), meters), (List)Nil$.MODULE$))));
        return new Tuple2.mcDD.sp(((Tuple2)distances.minBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2._1$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._1$mcD$sp(), ((Tuple2)distances.maxBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._2$mcD$sp());
    }

    public Tuple2<Object, Object> directionalDegrees(Point point, double meters, GeodeticCalculator calc) {
        calc.setStartingGeographicPoint(point.getX(), point.getY());
        return new Tuple2.mcDD.sp(package$.MODULE$.min(this.degrees$1(90.0, calc, meters, point), this.degrees$1(-90.0, calc, meters, point)), package$.MODULE$.min(this.degrees$1(0.0, calc, meters, point), this.degrees$1(180.0, calc, meters, point)));
    }

    public List<Coordinate> addWayPoints(Seq<Coordinate> coords) {
        return this.unfoldRight(coords, (Function1 & Serializable)x0$1 -> {
            SeqOps seqOps;
            SeqOps seqOps2;
            SeqOps seqOps3;
            Seq seq = x0$1;
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0) == 0) {
                return None$.MODULE$;
            }
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) {
                Coordinate pt = (Coordinate)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                return new Some((Object)new Tuple2((Object)pt, (Object)Nil$.MODULE$));
            }
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) >= 0) {
                Coordinate first = (Coordinate)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Coordinate second = (Coordinate)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                Seq rest = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                double d = second.x - first.x;
                if (d > (double)120) {
                    Coordinate coordinate = new Coordinate(first.x + (double)120, first.y);
                    Coordinate coordinate2 = second;
                    return new Some((Object)new Tuple2((Object)first, ((SeqOps)rest.$plus$colon((Object)coordinate2)).$plus$colon((Object)coordinate)));
                }
                if (d < (double)-120) {
                    Coordinate coordinate = new Coordinate(first.x - (double)120, first.y);
                    Coordinate coordinate3 = second;
                    return new Some((Object)new Tuple2((Object)first, ((SeqOps)rest.$plus$colon((Object)coordinate3)).$plus$colon((Object)coordinate)));
                }
                Coordinate coordinate = second;
                return new Some((Object)new Tuple2((Object)first, rest.$plus$colon((Object)coordinate)));
            }
            throw new MatchError((Object)seq);
        });
    }

    private <A, B> List<A> unfoldRight(B seed, Function1<B, Option<Tuple2<A, B>>> f) {
        Some some;
        Tuple2 tuple2;
        Option option = (Option)f.apply(seed);
        if (None$.MODULE$.equals(option)) {
            return Nil$.MODULE$;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Object a = tuple2._1();
            Object b = tuple2._2();
            Object object = a;
            return this.unfoldRight(b, f).$colon$colon(object);
        }
        throw new MatchError((Object)option);
    }

    public Tuple4<Object, Object, Object, Object> bounds(Geometry geometry) {
        Envelope env = geometry.getEnvelopeInternal();
        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)env.getMinX()), (Object)BoxesRunTime.boxToDouble((double)env.getMinY()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxX()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxY()));
    }

    public Seq<Tuple4<Object, Object, Object, Object>> bounds(Geometry geometry, int maxBounds, int maxBitResolution) {
        List list;
        if (maxBounds < 2 || this.isRectangular(geometry)) {
            return new .colon.colon(this.bounds(geometry), (List)Nil$.MODULE$);
        }
        try {
            GeohashUtils.ResolutionRange resolution = new GeohashUtils.ResolutionRange(0, maxBitResolution | 1, 5);
            List<GeoHash> geohashes = GeohashUtils$.MODULE$.decomposeGeometry(geometry, maxBounds, resolution, true);
            list = geohashes.map((Function1 & Serializable)gh -> new Tuple4((Object)BoxesRunTime.boxToDouble((double)gh.bbox().ll().getX()), (Object)BoxesRunTime.boxToDouble((double)gh.bbox().ll().getY()), (Object)BoxesRunTime.boxToDouble((double)gh.bbox().ur().getX()), (Object)BoxesRunTime.boxToDouble((double)gh.bbox().ur().getY())));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error decomposing geometry, falling back to envelope bounds:", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                list = new .colon.colon(this.bounds(geometry), (List)Nil$.MODULE$);
            }
            throw throwable;
        }
        return list;
    }

    public boolean isRectangular(Geometry geometry) {
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Point) {
            return true;
        }
        if (geometry2 instanceof Polygon) {
            Polygon polygon = (Polygon)geometry2;
            return this.isRectangular(polygon);
        }
        return false;
    }

    public boolean isRectangular(Polygon p) {
        if (p.isEmpty()) {
            return true;
        }
        if (p.getNumInteriorRing() != 0) {
            return false;
        }
        Envelope env = p.getEnvelopeInternal();
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)env.getMinX()), (Object)BoxesRunTime.boxToDouble((double)env.getMinY()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxX()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxY()));
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax));
        double xmin2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
        double ymin2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
        double xmax2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
        double ymax2 = BoxesRunTime.unboxToDouble((Object)tuple42._4());
        Coordinate[] coords = p.getCoordinates();
        for (int i = 1; i < coords.length; ++i) {
            Coordinate c = coords[i];
            if (!GeometryUtils$.cutout$1(c, xmin2, xmax2, ymin2, ymax2) && (c.x == coords[i - 1].x || c.y == coords[i - 1].y)) continue;
            return false;
        }
        return !GeometryUtils$.cutout$1(coords[0], xmin2, xmax2, ymin2, ymax2);
    }

    public boolean crossesIDL(Coordinate point1, Coordinate point2) {
        return Math.abs(point1.x - point2.x) >= (double)180;
    }

    public double calcIDLIntercept(Coordinate point1, Coordinate point2) {
        if (point1.x < 0.0) {
            return this.calcCrossLat(point1, new Coordinate(point2.x - (double)360, point2.y), -180.0);
        }
        return this.calcCrossLat(point1, new Coordinate(point2.x + (double)360, point2.y), 180.0);
    }

    public double calcCrossLat(Coordinate point1, Coordinate point2, double crossLon) {
        double slope = (point1.y - point2.y) / (point1.x - point2.x);
        double intercept = point1.y - slope * point1.x;
        return slope * crossLon + intercept;
    }

    public Seq<ReferencedEnvelope> splitBoundingBox(ReferencedEnvelope envelope) {
        .colon.colon colon2;
        try {
            ReferencedEnvelope translated;
            ReferencedEnvelope referencedEnvelope;
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            if (envelope.getMinX() >= 180.0) {
                double multiplier = package$.MODULE$.ceil((envelope.getMinX() - 180.0) / 360.0);
                double left = envelope.getMinX() - 360.0 * multiplier;
                double right = envelope.getMaxX() - 360.0 * multiplier;
                referencedEnvelope = new ReferencedEnvelope(left, right, envelope.getMinY(), envelope.getMaxY(), crs);
            } else if (envelope.getMaxX() <= -180.0) {
                double multiplier = package$.MODULE$.ceil((envelope.getMaxX() + 180.0) / -360.0);
                double left = envelope.getMinX() + 360.0 * multiplier;
                double right = envelope.getMaxX() + 360.0 * multiplier;
                referencedEnvelope = new ReferencedEnvelope(left, right, envelope.getMinY(), envelope.getMaxY(), crs);
            } else {
                referencedEnvelope = translated = envelope;
            }
            if (translated.getMinX() < -180.0 && translated.getMaxX() < 180.0) {
                ReferencedEnvelope trimmed = new ReferencedEnvelope(-180.0, translated.getMaxX(), envelope.getMinY(), envelope.getMaxY(), crs);
                ReferencedEnvelope wrapped = new ReferencedEnvelope(translated.getMinX() + 360.0, 180.0, envelope.getMinY(), envelope.getMaxY(), crs);
                colon2 = new .colon.colon((Object)trimmed, (List)new .colon.colon((Object)wrapped, (List)Nil$.MODULE$));
            } else if (translated.getMaxX() > 180.0 && translated.getMinX() > -180.0) {
                ReferencedEnvelope trimmed = new ReferencedEnvelope(translated.getMinX(), 180.0, envelope.getMinY(), envelope.getMaxY(), crs);
                ReferencedEnvelope wrapped = new ReferencedEnvelope(-180.0, translated.getMaxX() - 360.0, envelope.getMinY(), envelope.getMaxY(), crs);
                colon2 = new .colon.colon((Object)trimmed, (List)new .colon.colon((Object)wrapped, (List)Nil$.MODULE$));
            } else {
                colon2 = new .colon.colon((Object)translated, (List)Nil$.MODULE$);
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(41).append("Error splitting bounding box envelope '").append(envelope).append("':").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                colon2 = new .colon.colon((Object)envelope, (List)Nil$.MODULE$);
            }
            throw throwable;
        }
        return colon2;
    }

    private final double degrees$1(double azimuth, GeodeticCalculator calc$1, double meters$1, Point point$1) {
        calc$1.setDirection(azimuth, meters$1);
        Point2D dest = calc$1.getDestinationGeographicPoint();
        return point$1.distance((Geometry)this.geoFactory().createPoint(new Coordinate(dest.getX(), dest.getY())));
    }

    private static final boolean cutout$1(Coordinate c, double xmin$1, double xmax$1, double ymin$1, double ymax$1) {
        return c.x != xmin$1 && c.x != xmax$1 && c.y != ymin$1 && c.y != ymax$1;
    }

    private GeometryUtils$() {
    }
}

