/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import java.io.Serializable;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%\u0011\bC\u0003>\u0001\u0011\u0005a\b\u0003\u0005E\u0001!\u0015\r\u0011\"\u0001F\u0011\u001dI\u0005A1A\u0005\n)CaA\u0014\u0001!\u0002\u0013Y\u0005bB(\u0001\u0005\u0004%IA\u0013\u0005\u0007!\u0002\u0001\u000b\u0011B&\t\u000fE\u0003!\u0019!C\u0005\u0015\"1!\u000b\u0001Q\u0001\n-Cqa\u0015\u0001C\u0002\u0013%!\n\u0003\u0004U\u0001\u0001\u0006Ia\u0013\u0005\b+\u0002\u0011\r\u0011\"\u0003K\u0011\u00191\u0006\u0001)A\u0005\u0017\"9q\u000b\u0001b\u0001\n\u0013Q\u0005B\u0002-\u0001A\u0003%1\nC\u0004Z\u0001\t\u0007I\u0011\u0002&\t\ri\u0003\u0001\u0015!\u0003L\u0011\u001dY\u0006A1A\u0005\n)Ca\u0001\u0018\u0001!\u0002\u0013Y\u0005\"B/\u0001\t\u0003q\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u00021\u0001\t\u0003)\u0007\"\u00023\u0001\t\u00039\u0007\"B5\u0001\t\u0003Q\u0007\"\u00029\u0001\t\u0003\t(\u0001C$sS\u0012\u001cf.\u00199\u000b\u0005yy\u0012\u0001C4f_R|w\u000e\\:\u000b\u0005\u0001\n\u0013!B;uS2\u001c(B\u0001\u0012$\u0003\u001d9Wm\\7fg\u0006T!\u0001J\u0013\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u0003\r)gN\u001e\t\u0003cYj\u0011A\r\u0006\u0003gQ\nAaZ3p[*\u0011QgI\u0001\u0004UR\u001c\u0018BA\u001c3\u0005!)eN^3m_B,\u0017!\u0002=TSj,\u0007C\u0001\u0016;\u0013\tY4FA\u0002J]R\fQ!_*ju\u0016\fa\u0001P5oSRtD\u0003B B\u0005\u000e\u0003\"\u0001\u0011\u0001\u000e\u0003uAQa\f\u0003A\u0002ABQ\u0001\u000f\u0003A\u0002eBQ\u0001\u0010\u0003A\u0002e\n\u0001\"\u001a8wK2|\u0007/Z\u000b\u0002\rB\u0011\u0011gR\u0005\u0003\u0011J\u0012\u0001bR3p[\u0016$(/_\u0001\u0005q6Kg.F\u0001L!\tQC*\u0003\u0002NW\t1Ai\\;cY\u0016\fQ\u0001_'j]\u0002\nA\u0001_'bq\u0006)\u00010T1yA\u0005!\u00110T5o\u0003\u0015IX*\u001b8!\u0003\u0011IX*\u0019=\u0002\u000bel\u0015\r\u001f\u0011\u0002\u0005\u0011D\u0018a\u00013yA\u0005\u0011A-_\u0001\u0004If\u0004\u0013a\u0002=PM\u001a\u001cX\r^\u0001\tq>3gm]3uA\u00059\u0011p\u00144gg\u0016$\u0018\u0001C=PM\u001a\u001cX\r\u001e\u0011\u0002\u0003a$\"aS0\t\u000b\u00014\u0002\u0019A\u001d\u0002\u0003%\f\u0011!\u001f\u000b\u0003\u0017\u000eDQ\u0001Z\fA\u0002e\n\u0011A\u001b\u000b\u0003s\u0019DQ!\u0018\rA\u0002-#\"!\u000f5\t\u000b\u0005L\u0002\u0019A&\u0002\tMt\u0017\r\u001d\u000b\u0004W:|\u0007\u0003\u0002\u0016m\u0017.K!!\\\u0016\u0003\rQ+\b\u000f\\33\u0011\u0015i&\u00041\u0001L\u0011\u0015\t'\u00041\u0001L\u00035\u0011'/Z:f]\"\fW\u000eT5oKRA!o`A\u0002\u0003\u000f\tY\u0001E\u0002twzt!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]<\u0013A\u0002\u001fs_>$h(C\u0001-\u0013\tQ8&A\u0004qC\u000e\\\u0017mZ3\n\u0005ql(\u0001C%uKJ\fGo\u001c:\u000b\u0005i\\\u0003\u0003\u0002\u0016mseBa!!\u0001\u001c\u0001\u0004I\u0014A\u0001=1\u0011\u0019\t)a\u0007a\u0001s\u0005\u0011\u0011\u0010\r\u0005\u0007\u0003\u0013Y\u0002\u0019A\u001d\u0002\u0005a\f\u0004BBA\u00077\u0001\u0007\u0011(\u0001\u0002zc\u0001")
public class GridSnap {
    private Geometry envelope;
    private Envelope env;
    private final int xSize;
    private final int ySize;
    private final double xMin;
    private final double xMax;
    private final double yMin;
    private final double yMax;
    private final double dx;
    private final double dy;
    private final double xOffset;
    private final double yOffset;
    private volatile boolean bitmap$0;

    private Geometry envelope$lzycompute() {
        GridSnap gridSnap = this;
        synchronized (gridSnap) {
            if (!this.bitmap$0) {
                this.envelope = GeometryUtils$.MODULE$.geoFactory().toGeometry(this.env);
                this.bitmap$0 = true;
            }
        }
        this.env = null;
        return this.envelope;
    }

    public Geometry envelope() {
        if (!this.bitmap$0) {
            return this.envelope$lzycompute();
        }
        return this.envelope;
    }

    private double xMin() {
        return this.xMin;
    }

    private double xMax() {
        return this.xMax;
    }

    private double yMin() {
        return this.yMin;
    }

    private double yMax() {
        return this.yMax;
    }

    private double dx() {
        return this.dx;
    }

    private double dy() {
        return this.dy;
    }

    private double xOffset() {
        return this.xOffset;
    }

    private double yOffset() {
        return this.yOffset;
    }

    public double x(int i) {
        return this.xOffset() + this.dx() * (double)i;
    }

    public double y(int j) {
        return this.yOffset() + this.dy() * (double)j;
    }

    public int i(double x) {
        if (x < this.xMin() || x > this.xMax()) {
            return -1;
        }
        int i = (int)package$.MODULE$.floor((x - this.xMin()) / this.dx());
        if (i >= this.xSize) {
            return this.xSize - 1;
        }
        return i;
    }

    public int j(double y) {
        if (y < this.yMin() || y > this.yMax()) {
            return -1;
        }
        int i = (int)package$.MODULE$.floor((y - this.yMin()) / this.dy());
        if (i >= this.ySize) {
            return this.ySize - 1;
        }
        return i;
    }

    public Tuple2<Object, Object> snap(double x, double y) {
        return new Tuple2.mcDD.sp(this.x(this.i(x)), this.y(this.j(y)));
    }

    public Iterator<Tuple2<Object, Object>> bresenhamLine(int x0, int y0, int x1, int y1) {
        int stepY;
        int deltaX = package$.MODULE$.abs(x1 - x0);
        int deltaY = package$.MODULE$.abs(y1 - y0);
        if (deltaX == 0 && deltaY == 0) {
            return scala.package$.MODULE$.Iterator().single((Object)new Tuple2.mcII.sp(x0, y0));
        }
        int stepX = x0 < x1 ? 1 : -1;
        int n = stepY = y0 < y1 ? 1 : -1;
        if (deltaX > deltaY) {
            double deltaError = (double)deltaY / (double)deltaX;
            DoubleRef error = DoubleRef.create((double)0.0);
            return scala.package$.MODULE$.Iterator().iterate((Object)new Tuple2.mcII.sp(x0, y0), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    int y = tuple2._2$mcI$sp();
                    error$1.elem += deltaError;
                    if (error$1.elem >= 0.5) {
                        error$1.elem -= 1.0;
                        return new Tuple2.mcII.sp(x + stepX, y + stepY);
                    }
                    return new Tuple2.mcII.sp(x + stepX, y);
                }
                throw new MatchError((Object)tuple2);
            }).take(deltaX);
        }
        double deltaError = (double)deltaX / (double)deltaY;
        DoubleRef error = DoubleRef.create((double)0.0);
        return scala.package$.MODULE$.Iterator().iterate((Object)new Tuple2.mcII.sp(x0, y0), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int x = tuple2._1$mcI$sp();
                int y = tuple2._2$mcI$sp();
                error$2.elem += deltaError;
                if (error$2.elem >= 0.5) {
                    error$2.elem -= 1.0;
                    return new Tuple2.mcII.sp(x + stepX, y + stepY);
                }
                return new Tuple2.mcII.sp(x, y + stepY);
            }
            throw new MatchError((Object)tuple2);
        }).take(deltaY);
    }

    public GridSnap(Envelope env, int xSize, int ySize) {
        this.env = env;
        this.xSize = xSize;
        this.ySize = ySize;
        this.xMin = env.getMinX();
        this.xMax = env.getMaxX();
        this.yMin = env.getMinY();
        this.yMax = env.getMaxY();
        this.dx = (this.xMax() - this.xMin()) / (double)xSize;
        this.dy = (this.yMax() - this.yMin()) / (double)ySize;
        this.xOffset = this.xMin() + this.dx() / (double)2;
        this.yOffset = this.yMin() + this.dy() / (double)2;
    }
}

