/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\u0010!\u0001-B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\n\u0001B\u0001B\u0003%a\tC\u0003K\u0001\u0011\u00051\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rY\u0003\u0001\u0015!\u0003T\u0011\u001d9\u0006A1A\u0005\naCaa\u001a\u0001!\u0002\u0013I\u0006b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007U\u0002\u0001\u000b\u0011\u00023\t\u000f-\u0004!\u0019!C\u0005S\"1A\u000e\u0001Q\u0001\n\u0011Dq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\bg\u0002\u0001\r\u0011\"\u0003u\u0011\u001dA\b\u00011A\u0005\neDaa \u0001!B\u0013)\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0003\u0001A\u0011AA\n\u0011\u001d\t\t\u0001\u0001C\u0001\u0003CAq!!\u0001\u0001\t\u0003\ty\u0003C\u0004\u0002\u0002\u0001!\t!!\u0010\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002L!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005e\u0003BBA4\u0001\u0011\u0005a\u000e\u0003\u0004\u0002j\u0001!\t\u0001\u001e\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u001c\u0002!I!!(\u0003\u001bI+g\u000eZ3sS:<wI]5e\u0015\t\t#%\u0001\u0005hK>$xn\u001c7t\u0015\t\u0019C%A\u0003vi&d7O\u0003\u0002&M\u00059q-Z8nKN\f'BA\u0014)\u00031awnY1uS>tG/Z2i\u0015\u0005I\u0013aA8sO\u000e\u00011c\u0001\u0001-eA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005]B\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003e\n1aY8n\u0013\tYDGA\u0006MCjLHj\\4hS:<\u0017aA3omB\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005O\u0016|WN\u0003\u0002CM\u0005\u0019!\u000e^:\n\u0005\u0011{$\u0001C#om\u0016dw\u000e]3\u0002\u000ba\u001c\u0016N_3\u0011\u00055:\u0015B\u0001%/\u0005\rIe\u000e^\u0001\u0006sNK'0Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1su\n\u0015\t\u0003\u001b\u0002i\u0011\u0001\t\u0005\u0006y\u0011\u0001\r!\u0010\u0005\u0006\u000b\u0012\u0001\rA\u0012\u0005\u0006\u0013\u0012\u0001\rAR\u0001\u0005OJLG-F\u0001T!\tiE+\u0003\u0002VA\tAqI]5e':\f\u0007/A\u0003he&$\u0007%\u0001\u0004qSb,Gn]\u000b\u00023B!!lX1e\u001b\u0005Y&B\u0001/^\u0003\u001diW\u000f^1cY\u0016T!A\u0018\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002a7\n\u0019Q*\u00199\u0011\t5\u0012gIR\u0005\u0003G:\u0012a\u0001V;qY\u0016\u0014\u0004CA\u0017f\u0013\t1gF\u0001\u0004E_V\u0014G.Z\u0001\ba&DX\r\\:!\u0003\u0011AX*\u001b8\u0016\u0003\u0011\fQ\u0001_'j]\u0002\nA\u0001_'bq\u0006)\u00010T1yA\u0005!q/\u001b3f+\u0005y\u0007CA\u0017q\u0013\t\thFA\u0004C_>dW-\u00198\u0002\u000b]LG-\u001a\u0011\u0002\u000b\r|WO\u001c;\u0016\u0003U\u0004\"!\f<\n\u0005]t#\u0001\u0002'p]\u001e\f\u0011bY8v]R|F%Z9\u0015\u0005il\bCA\u0017|\u0013\tahF\u0001\u0003V]&$\bb\u0002@\u0011\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\n\u0014AB2pk:$\b%\u0001\u0004sK:$WM\u001d\u000b\u0006u\u0006\u0015\u0011q\u0002\u0005\b\u0003\u000f\u0011\u0002\u0019AA\u0005\u0003\u0015\u0001x.\u001b8u!\rq\u00141B\u0005\u0004\u0003\u001by$!\u0002)pS:$\bBBA\t%\u0001\u0007A-\u0001\u0004xK&<\u0007\u000e\u001e\u000b\u0006u\u0006U\u0011q\u0004\u0005\b\u0003/\u0019\u0002\u0019AA\r\u0003)iW\u000f\u001c;j!>Lg\u000e\u001e\t\u0004}\u0005m\u0011bAA\u000f\u007f\tQQ*\u001e7uSB{\u0017N\u001c;\t\r\u0005E1\u00031\u0001e)\u0015Q\u00181EA\u0017\u0011\u001d\t)\u0003\u0006a\u0001\u0003O\t!\u0002\\5oKN#(/\u001b8h!\rq\u0014\u0011F\u0005\u0004\u0003Wy$A\u0003'j]\u0016\u001cFO]5oO\"1\u0011\u0011\u0003\u000bA\u0002\u0011$RA_A\u0019\u0003wAq!a\r\u0016\u0001\u0004\t)$A\bnk2$\u0018\u000eT5oKN#(/\u001b8h!\rq\u0014qG\u0005\u0004\u0003sy$aD'vYRLG*\u001b8f'R\u0014\u0018N\\4\t\r\u0005EQ\u00031\u0001e)\u0015Q\u0018qHA%\u0011\u001d\t\tE\u0006a\u0001\u0003\u0007\nq\u0001]8ms\u001e|g\u000eE\u0002?\u0003\u000bJ1!a\u0012@\u0005\u001d\u0001v\u000e\\=h_:Da!!\u0005\u0017\u0001\u0004!G#\u0002>\u0002N\u0005]\u0003bBA(/\u0001\u0007\u0011\u0011K\u0001\r[VdG/\u001b)pYf<wN\u001c\t\u0004}\u0005M\u0013bAA+\u007f\taQ*\u001e7uSB{G._4p]\"1\u0011\u0011C\fA\u0002\u0011$RA_A.\u0003KBq!!\u0018\u0019\u0001\u0004\ty&\u0001\u0005hK>lW\r\u001e:z!\rq\u0014\u0011M\u0005\u0004\u0003Gz$\u0001C$f_6,GO]=\t\r\u0005E\u0001\u00041\u0001e\u0003\u001dI7/R7qif\fAa]5{K\u0006A\u0011\u000e^3sCR|'/\u0006\u0002\u0002pA1\u0011\u0011OAA\u0003\u000fsA!a\u001d\u0002~9!\u0011QOA>\u001b\t\t9HC\u0002\u0002z)\na\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0007\u0005}d&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0015Q\u0011\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011q\u0010\u0018\u0011\t5\u0012\u0017\rZ\u0001\u0006G2,\u0017M\u001d\u000b\u0002u\u0006IAO]1og2\fG/\u001a\u000b\u0005\u0003#\u000b9\nE\u0003\u0002r\u0005Me)\u0003\u0003\u0002\u0016\u0006\u0015%aA*fc\"1\u0011\u0011T\u000fA\u0002\u0011\f\u0011\u0001_\u0001\u0006o&$WM\u001c\u000b\u0005\u0003#\u000by\n\u0003\u0004\u0002\u001az\u0001\r\u0001\u001a")
public class RenderingGrid
implements LazyLogging {
    private final GridSnap grid;
    private final Map<Tuple2<Object, Object>, Object> pixels;
    private final double xMin;
    private final double xMax;
    private final boolean wide;
    private long count;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        RenderingGrid renderingGrid = this;
        synchronized (renderingGrid) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private GridSnap grid() {
        return this.grid;
    }

    private Map<Tuple2<Object, Object>, Object> pixels() {
        return this.pixels;
    }

    private double xMin() {
        return this.xMin;
    }

    private double xMax() {
        return this.xMax;
    }

    private boolean wide() {
        return this.wide;
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    public void render(Point point, double weight) {
        int j = this.grid().j(point.getY());
        if (j != -1) {
            this.translate(point.getX()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(i, j);
                this.pixels().update((Object)sp2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.pixels().apply((Object)sp2)) + weight)));
            });
        }
        this.count_$eq(this.count() + 1L);
    }

    public void render(MultiPoint multiPoint, double weight) {
        int i;
        for (i = 0; i < multiPoint.getNumGeometries(); ++i) {
            this.render((Point)multiPoint.getGeometryN(i), weight);
        }
        this.count_$eq(this.count() + (long)(1 - i));
    }

    public void render(LineString lineString, double weight) {
        if (lineString.getNumPoints() > 0) {
            IntRef iN = IntRef.create((int)-1);
            IntRef jN = IntRef.create((int)-1);
            Coordinate p0 = null;
            ObjectRef i0 = ObjectRef.create(null);
            int j0 = -1;
            Coordinate p1 = lineString.getCoordinateN(0);
            Seq<Object> i1 = this.translate(p1.x);
            int j1 = this.grid().j(p1.y);
            for (int n = 1; n < lineString.getNumPoints(); ++n) {
                p0 = p1;
                i0.elem = i1;
                j0 = j1;
                p1 = lineString.getCoordinateN(n);
                i1 = this.translate(p1.x);
                j1 = this.grid().j(p1.y);
                if (((Seq)i0.elem).isEmpty() || j0 == -1 || i1.isEmpty() || j1 == -1) {
                    try {
                        Geometry intersection = GeometryUtils$.MODULE$.geoFactory().createLineString((Coordinate[])((Object[])new Coordinate[]{p0, p1})).intersection(this.grid().envelope());
                        if (intersection.isEmpty()) continue;
                        this.render(intersection, weight);
                        this.count_$eq(this.count() - 1L);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            if (this.logger().underlying().isErrorEnabled()) {
                                this.logger().underlying().error(new StringBuilder(40).append("Error intersecting line string [").append(p0).append(" ").append(p1).append("] with ").append(this.grid().envelope()).toString(), e);
                            }
                            continue;
                        }
                        throw throwable;
                    }
                }
                Iterator<Tuple2<Object, Object>> bresenham = this.grid().bresenhamLine(BoxesRunTime.unboxToInt((Object)((Seq)i0.elem).head()), j0, BoxesRunTime.unboxToInt((Object)i1.head()), j1);
                Tuple2 tuple2 = (Tuple2)bresenham.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int iF = tuple2._1$mcI$sp();
                int jF = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(iF, jF);
                int iF2 = sp2._1$mcI$sp();
                int jF2 = sp2._2$mcI$sp();
                if (iF2 != iN.elem || jF2 != jN.elem) {
                    Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(iF2, jF2);
                    this.pixels().update((Object)sp3, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.pixels().apply((Object)sp3)) + weight)));
                    ((IterableOnceOps)((Seq)i0.elem).tail()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i0N -> {
                        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(iF2 - BoxesRunTime.unboxToInt((Object)((Seq)i0$1.elem).head()) + i0N, jF2);
                        this.pixels().update((Object)sp2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.pixels().apply((Object)sp2)) + weight)));
                    });
                }
                if (!bresenham.hasNext()) {
                    iN.elem = iF2;
                    jN.elem = jF2;
                    continue;
                }
                this.writeNext$1(bresenham, weight, i0, iN, jN);
            }
        }
        this.count_$eq(this.count() + 1L);
    }

    public void render(MultiLineString multiLineString, double weight) {
        int i;
        for (i = 0; i < multiLineString.getNumGeometries(); ++i) {
            this.render((LineString)multiLineString.getGeometryN(i), weight);
        }
        this.count_$eq(this.count() + (long)(1 - i));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void render(Polygon polygon, double weight) {
        block9: {
            Envelope envelope = polygon.getEnvelopeInternal();
            Seq<Object> imins = this.translate(envelope.getMinX());
            Seq<Object> imaxes = this.translate(envelope.getMaxX());
            int jmin = this.grid().j(envelope.getMinY());
            int jmax = this.grid().j(envelope.getMaxY());
            if (imins.isEmpty() || imaxes.isEmpty() || jmin == -1 || jmax == -1) {
                try {
                    Geometry intersection = polygon.intersection(this.grid().envelope());
                    if (!intersection.isEmpty()) {
                        this.render(intersection, weight);
                        this.count_$eq(this.count() - 1L);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 == null) throw throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) throw throwable;
                    Throwable e = (Throwable)option.get();
                    if (!this.logger().underlying().isErrorEnabled()) break block9;
                    this.logger().underlying().error(new StringBuilder(35).append("Error intersecting polygon [").append(polygon).append("] with ").append(this.grid().envelope()).toString(), e);
                }
            } else {
                int imin = BoxesRunTime.unboxToInt((Object)imins.head());
                int iLength = BoxesRunTime.unboxToInt((Object)imaxes.head()) - imin + 1;
                int jLength = jmax - jmin + 1;
                BufferedImage image = new BufferedImage(iLength, jLength, 12);
                Graphics2D graphics = image.createGraphics();
                LinearRing border = polygon.getExteriorRing();
                int[] xPoints = (int[])Array$.MODULE$.ofDim(border.getNumPoints(), (ClassTag)ClassTag$.MODULE$.Int());
                int[] yPoints = (int[])Array$.MODULE$.ofDim(border.getNumPoints(), (ClassTag)ClassTag$.MODULE$.Int());
                for (int i = 0; i < xPoints.length; ++i) {
                    Coordinate coord = border.getCoordinateN(i);
                    xPoints[i] = BoxesRunTime.unboxToInt((Object)this.translate(coord.x).head()) - imin;
                    yPoints[i] = this.grid().j(coord.y) - jmin;
                }
                graphics.fillPolygon(xPoints, yPoints, xPoints.length);
                WritableRaster raster = image.getRaster();
                IntRef i = IntRef.create((int)0);
                IntRef j = IntRef.create((int)0);
                while (i.elem < iLength) {
                    while (j.elem < jLength) {
                        if (raster.getSample(i.elem, j.elem, 0) != 0) {
                            imins.foreach((Function1)(JFunction1.mcVI.sp & Serializable)im -> {
                                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(i$2.elem + im, j$3.elem + jmin);
                                this.pixels().update((Object)sp2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.pixels().apply((Object)sp2)) + weight)));
                            });
                        }
                        ++j.elem;
                    }
                    j.elem = 0;
                    ++i.elem;
                }
            }
        }
        this.count_$eq(this.count() + 1L);
    }

    public void render(MultiPolygon multiPolygon, double weight) {
        int i;
        for (i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            this.render((Polygon)multiPolygon.getGeometryN(i), weight);
        }
        this.count_$eq(this.count() + (long)(1 - i));
    }

    public void render(Geometry geometry, double weight) {
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Point) {
            Point point = (Point)geometry2;
            this.render(point, weight);
            return;
        }
        if (geometry2 instanceof LineString) {
            LineString lineString = (LineString)geometry2;
            this.render(lineString, weight);
            return;
        }
        if (geometry2 instanceof Polygon) {
            Polygon polygon = (Polygon)geometry2;
            this.render(polygon, weight);
            return;
        }
        if (geometry2 instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)geometry2;
            this.render(multiPoint, weight);
            return;
        }
        if (geometry2 instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry2;
            this.render(multiLineString, weight);
            return;
        }
        if (geometry2 instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry2;
            this.render(multiPolygon, weight);
            return;
        }
        if (geometry2 instanceof GeometryCollection) {
            int i;
            GeometryCollection geometryCollection = (GeometryCollection)geometry2;
            for (i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                this.render(geometryCollection.getGeometryN(i), weight);
            }
            this.count_$eq(this.count() + (long)(1 - i));
            return;
        }
        throw new NotImplementedError(new StringBuilder(26).append("Unexpected geometry type: ").append(geometry).toString());
    }

    public boolean isEmpty() {
        return this.pixels().isEmpty();
    }

    public long size() {
        return this.count();
    }

    public Iterator<Tuple2<Tuple2<Object, Object>, Object>> iterator() {
        return this.pixels().iterator();
    }

    public void clear() {
        this.pixels().clear();
    }

    private Seq<Object> translate(double x) {
        if (x < this.xMin()) {
            double xt = x + 360.0 * package$.MODULE$.ceil((this.xMin() - x) / (double)360);
            if (xt > this.xMax()) {
                return (Seq)scala.package$.MODULE$.Seq().empty();
            }
            return this.widen(xt);
        }
        if (x > this.xMax()) {
            double xt = x - 360.0 * package$.MODULE$.ceil((x - this.xMax()) / (double)360);
            if (xt < this.xMin()) {
                return (Seq)scala.package$.MODULE$.Seq().empty();
            }
            return this.widen(xt);
        }
        return this.widen(x);
    }

    private Seq<Object> widen(double x) {
        if (this.wide()) {
            Builder seq = scala.package$.MODULE$.Seq().newBuilder();
            for (double xup = x - 360.0 * package$.MODULE$.floor((x - this.xMin()) / (double)360); xup <= this.xMax(); xup += 360.0) {
                seq.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.grid().i(xup)));
            }
            return (Seq)seq.result();
        }
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.grid().i(x)}));
    }

    private final void writeNext$1(Iterator bresenham$1, double weight$2, ObjectRef i0$1, IntRef iN$1, IntRef jN$1) {
        int j;
        int i;
        do {
            Tuple2 tuple2;
            if ((tuple2 = (Tuple2)bresenham$1.next()) == null) {
                throw new MatchError((Object)tuple2);
            }
            int i2 = tuple2._1$mcI$sp();
            int j2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(i2, j2);
            i = sp2._1$mcI$sp();
            j = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(i, j);
            this.pixels().update((Object)sp3, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.pixels().apply((Object)sp3)) + weight$2)));
            ((IterableOnceOps)((Seq)i0$1.elem).tail()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i0N -> {
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(i - BoxesRunTime.unboxToInt((Object)((Seq)i0$1.elem).head()) + i0N, j);
                this.pixels().update((Object)sp2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.pixels().apply((Object)sp2)) + weight$2)));
            });
        } while (bresenham$1.hasNext());
        iN$1.elem = i;
        jN$1.elem = j;
    }

    public RenderingGrid(Envelope env, int xSize, int ySize) {
        LazyLogging.$init$((LazyLogging)this);
        this.grid = new GridSnap(env, xSize, ySize);
        this.pixels = ((Map)Map$.MODULE$.empty()).withDefaultValue((Object)BoxesRunTime.boxToDouble((double)0.0));
        this.xMin = env.getMinX();
        this.xMax = env.getMaxX();
        this.wide = this.xMax() - this.xMin() > 360.0;
        this.count = 0L;
    }
}

