/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.locationtech.geomesa.utils.conf.ArgResolver;
import org.locationtech.geomesa.utils.conf.ArgResolver$ArgTypes$;
import org.locationtech.geomesa.utils.geotools.ConfigSftParsing$;
import org.locationtech.geomesa.utils.geotools.SftArgs;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class SftArgResolver$
implements ArgResolver<SimpleFeatureType, SftArgs> {
    public static final SftArgResolver$ MODULE$ = new SftArgResolver$();
    private static final Seq<String> confStrings;
    private static final String specStrReg;
    private static final String fileNameReg;
    private static final String specStrRegError;
    private static final Seq<Function1<SftArgs, Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType>>> parseMethodList;
    private static ConfigParseOptions parseOpts;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        ArgResolver.$init$(MODULE$);
        confStrings = new .colon.colon((Object)"geomesa{", (List)new .colon.colon((Object)"geomesa {", (List)new .colon.colon((Object)"geomesa.sfts", (List)Nil$.MODULE$)));
        specStrReg = "^[a-zA-Z0-9]+[:][String|Integer|Double|Point|Date|Map|List].*";
        fileNameReg = "([^.]*)\\.([^.]*)";
        specStrRegError = "^[a-zA-Z0-9]+[:][a-zA-Z0-9]+.*";
        parseMethodList = new .colon.colon((Function1 & Serializable)args -> MODULE$.getLoadedSft((SftArgs)args), (List)new .colon.colon((Function1 & Serializable)args -> MODULE$.parseSpecString((SftArgs)args), (List)new .colon.colon((Function1 & Serializable)args -> MODULE$.parseConfStr((SftArgs)args), (List)new .colon.colon((Function1 & Serializable)args -> MODULE$.parseSpecStringFile((SftArgs)args), (List)new .colon.colon((Function1 & Serializable)args -> MODULE$.parseConfFile((SftArgs)args), (List)Nil$.MODULE$)))));
    }

    @Override
    public Either getArg(Object args) {
        return ArgResolver.getArg$(this, args);
    }

    @Override
    public ConfigParseOptions parseOpts() {
        return parseOpts;
    }

    @Override
    public void org$locationtech$geomesa$utils$conf$ArgResolver$_setter_$parseOpts_$eq(ConfigParseOptions x$1) {
        parseOpts = x$1;
    }

    private Logger logger$lzycompute() {
        SftArgResolver$ sftArgResolver$ = this;
        synchronized (sftArgResolver$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private Seq<String> confStrings() {
        return confStrings;
    }

    private String specStrReg() {
        return specStrReg;
    }

    private String fileNameReg() {
        return fileNameReg;
    }

    private String specStrRegError() {
        return specStrRegError;
    }

    @Override
    public Enumeration.Value argType(SftArgs args) {
        if (this.confStrings().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SftArgResolver$.$anonfun$argType$1(args, x$1)))) {
            return ArgResolver$ArgTypes$.MODULE$.CONFSTR();
        }
        if (args.spec().matches(this.specStrReg())) {
            return ArgResolver$ArgTypes$.MODULE$.SPECSTR();
        }
        if (args.spec().matches(this.fileNameReg()) || args.spec().contains("/")) {
            return ArgResolver$ArgTypes$.MODULE$.PATH();
        }
        if (args.spec().matches(this.specStrRegError())) {
            return ArgResolver$ArgTypes$.MODULE$.SPECSTR();
        }
        return ArgResolver$ArgTypes$.MODULE$.NAME();
    }

    @Override
    public Seq<Function1<SftArgs, Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType>>> parseMethodList() {
        return parseMethodList;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> getLoadedSft(SftArgs args) {
        Option option = SimpleFeatureTypeLoader$.MODULE$.sfts().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SftArgResolver$.$anonfun$getLoadedSft$1(args, x$1))).map((Function1 & Serializable)sft -> {
            block3: {
                block2: {
                    if (args.featureName() == null) break block2;
                    String string = args.featureName();
                    String string2 = sft.getTypeName();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                }
                return sft;
            }
            return SimpleFeatureTypes$.MODULE$.renameSft((SimpleFeatureType)sft, args.featureName());
        });
        if (option instanceof Some) {
            Some some = (Some)option;
            SimpleFeatureType sft2 = (SimpleFeatureType)some.value();
            return package$.MODULE$.Right().apply((Object)sft2);
        }
        if (None$.MODULE$.equals(option)) {
            RuntimeException error = new RuntimeException(new StringBuilder(50).append("Unable to find SFT with name: ").append(args.spec()).append("\n  ").append("Available types: ").append(SimpleFeatureTypeLoader$.MODULE$.sfts().map((Function1 & Serializable)x$2 -> x$2.getTypeName()).mkString(", ")).toString());
            return package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringBuilder(31).append("Unable to get loaded SFT using ").append(args.spec()).toString(), (Object)error, (Object)ArgResolver$ArgTypes$.MODULE$.NAME()));
        }
        throw new MatchError((Object)option);
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseSpecString(SftArgs args) {
        Right right;
        try {
            String name = (String)Option$.MODULE$.apply((Object)args.featureName()).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Feature name was not provided");
            });
            right = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.createType(name, args.spec()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                right = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringBuilder(31).append("Unable to parse sft spec from: ").append(args.spec()).toString(), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.SPECSTR()));
            }
            throw throwable;
        }
        return right;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseSpecStringFile(SftArgs args) {
        Right right;
        try {
            String name = (String)Option$.MODULE$.apply((Object)args.featureName()).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Feature name was not provided");
            });
            String file = (String)Option$.MODULE$.apply((Object)args.spec()).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("No input file specified");
            });
            String spec = FileUtils.readFileToString((File)new File(file), (Charset)StandardCharsets.UTF_8);
            right = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.createType(name, spec));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                right = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringBuilder(36).append("Unable to parse sft spec from file: ").append(args.spec()).toString(), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH()));
            }
            throw throwable;
        }
        return right;
    }

    public Either<Throwable, SimpleFeatureType> parseConf(Reader input, String name) {
        Left left;
        block15: {
            try {
                Seq<SimpleFeatureType> sfts = ConfigSftParsing$.MODULE$.parseConf(ConfigFactory.parseReader((Reader)input, (ConfigParseOptions)this.parseOpts()).resolve());
                if (sfts.isEmpty()) {
                    throw new RuntimeException("No feature types parsed from config string");
                }
                if (name == null) {
                    BoxedUnit boxedUnit;
                    if (sfts.lengthCompare(1) > 0) {
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Found more than one SFT conf in input arg");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    left = package$.MODULE$.Right().apply(sfts.head());
                    break block15;
                }
                Option option = sfts.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SftArgResolver$.$anonfun$parseConf$1(name, x$3)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SimpleFeatureType sft = (SimpleFeatureType)some.value();
                    left = package$.MODULE$.Right().apply((Object)sft);
                    break block15;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (sfts.lengthCompare(1) > 0) {
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Found more than one SFT conf in input arg");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    left = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.renameSft((SimpleFeatureType)sfts.head(), name));
                    break block15;
                }
                throw new MatchError((Object)option);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    left = package$.MODULE$.Left().apply((Object)e);
                }
                throw throwable;
            }
        }
        return left;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseConfStr(SftArgs args) {
        return this.parseConf(new StringReader(args.spec()), args.featureName()).left().map((Function1 & Serializable)e -> new Tuple3((Object)new StringBuilder(45).append("Unable to parse sft spec from configuration: ").append(args.spec()).toString(), e, (Object)ArgResolver$ArgTypes$.MODULE$.CONFSTR()));
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseConfFile(SftArgs args) {
        Either either;
        try {
            FileSystemDelegate.FileHandle handle = (FileSystemDelegate.FileHandle)PathUtils$.MODULE$.interpretPath(args.spec()).headOption().getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(23).append("Could not read file at ").append(args.spec()).toString());
            });
            either = (Either)package$WithClose$.MODULE$.apply(handle.open(), (Function1 & Serializable)streams -> {
                if (streams.hasNext()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)((Tuple2)streams.next())._2(), StandardCharsets.UTF_8);
                    return MODULE$.parseConf(reader, args.featureName()).left().map((Function1 & Serializable)e -> new Tuple3((Object)new StringBuilder(36).append("Unable to parse sft spec from file: ").append(args.spec()).toString(), e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH()));
                }
                throw new RuntimeException(new StringBuilder(23).append("Could not read file at ").append(args.spec()).toString());
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                either = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringBuilder(21).append("Unable to load file: ").append(args.spec()).toString(), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH()));
            }
            throw throwable;
        }
        return either;
    }

    public static final /* synthetic */ boolean $anonfun$argType$1(SftArgs args$1, CharSequence x$1) {
        return args$1.spec().contains(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getLoadedSft$1(SftArgs args$2, SimpleFeatureType x$1) {
        String string = x$1.getTypeName();
        String string2 = args$2.spec();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseConf$1(String name$1, SimpleFeatureType x$3) {
        String string = x$3.getTypeName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private SftArgResolver$() {
    }
}

