/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import java.io.Serializable;
import org.locationtech.geomesa.utils.collection.TieredOrdering;
import org.locationtech.geomesa.utils.geotools.AttributeOrdering$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$FidOrdering$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class SimpleFeatureOrdering$ {
    public static final SimpleFeatureOrdering$ MODULE$ = new SimpleFeatureOrdering$();

    public Ordering<SimpleFeature> apply(SimpleFeatureType sft, String sortBy) {
        return this.apply(sft, sortBy, false);
    }

    public Ordering<SimpleFeature> apply(SimpleFeatureType sft, String sortBy, boolean reverse) {
        SimpleFeatureOrdering$FidOrdering$ sort;
        Object object;
        if (sortBy == null || sortBy.isEmpty() || sortBy.equalsIgnoreCase("id")) {
            object = SimpleFeatureOrdering$FidOrdering$.MODULE$;
        } else {
            int i = sft.indexOf(sortBy);
            if (i == -1) {
                throw new IllegalArgumentException(new StringBuilder(58).append("Trying to sort by an attribute that is not in the schema: ").append(sortBy).toString());
            }
            object = sort = new SimpleFeatureOrdering.SimpleFeatureOrdering(i, AttributeOrdering$.MODULE$.apply(sft.getDescriptor(i)));
        }
        if (reverse) {
            return sort.reverse();
        }
        return sort;
    }

    public Ordering<SimpleFeature> apply(SimpleFeatureType sft, Seq<Tuple2<String, Object>> sortBy) {
        if (sortBy.lengthCompare(1) == 0) {
            return this.apply(sft, (String)((Tuple2)sortBy.head())._1(), ((Tuple2)sortBy.head())._2$mcZ$sp());
        }
        return new TieredOrdering<SimpleFeature>((Seq)sortBy.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String field = (String)tuple2._1();
                boolean reverse = tuple2._2$mcZ$sp();
                return MODULE$.apply(sft, field, reverse);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public Ordering<SimpleFeature> apply(SimpleFeatureType sft, SortBy sortBy) {
        String name = (String)Option$.MODULE$.apply((Object)sortBy.getPropertyName()).map((Function1 & Serializable)x$1 -> x$1.getPropertyName()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        SortOrder sortOrder = sortBy.getSortOrder();
        SortOrder sortOrder2 = SortOrder.DESCENDING;
        return this.apply(sft, name, !(sortOrder != null ? !sortOrder.equals(sortOrder2) : sortOrder2 != null));
    }

    public Ordering<SimpleFeature> apply(SimpleFeatureType sft, SortBy[] sortBy) {
        if (sortBy.length == 1) {
            return this.apply(sft, (SortBy)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])sortBy)));
        }
        return new TieredOrdering<SimpleFeature>((Seq<Ordering<SimpleFeature>>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sortBy), (Function1 & Serializable)x$2 -> MODULE$.apply(sft, (SortBy)x$2), ClassTag$.MODULE$.apply(Ordering.class))));
    }

    public Ordering<SimpleFeature> fid() {
        return SimpleFeatureOrdering$FidOrdering$.MODULE$;
    }

    private SimpleFeatureOrdering$() {
    }
}

