/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessors;
import org.opengis.feature.simple.SimpleFeature;
import scala.None$;
import scala.Option;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.runtime.BoxedUnit;

public final class SimpleFeaturePropertyAccessor$
implements LazyLogging {
    public static final SimpleFeaturePropertyAccessor$ MODULE$ = new SimpleFeaturePropertyAccessor$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        SimpleFeaturePropertyAccessor$ simpleFeaturePropertyAccessor$ = this;
        synchronized (simpleFeaturePropertyAccessor$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public void initialize() {
        this.invoke(null, "");
    }

    public Option<PropertyAccessor> getAccessor(SimpleFeature sf, String name) {
        List<PropertyAccessor> list = this.invoke(sf, name);
        if (list == null) {
            return None$.MODULE$;
        }
        return ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).headOption();
    }

    private List<PropertyAccessor> invoke(SimpleFeature sf, String name) {
        List list;
        BoxedUnit boxedUnit;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Bypassing context classloader {} for PropertyAccessor loading.", (Object)contextClassLoader);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            list = PropertyAccessors.findPropertyAccessors((Object)sf, (String)name, null, null);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return list;
    }

    private SimpleFeaturePropertyAccessor$() {
    }
}

