/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import org.locationtech.geomesa.utils.geotools.ConfigSftParsing;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$URLSftProvider$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeProvider;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Uq!B\n\u0015\u0011\u0003yb!B\u0011\u0015\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\u0002C\u0016\u0002\u0011\u000b\u0007I\u0011\u0002\u0017\t\u000bq\nA\u0011A\u001f\t\u000b%\u000bA\u0011\u0001&\t\u000bQ\u000bA\u0011A+\u0007\tm\u000b\u0001\u0001\u0018\u0005\u0006S\u001d!\t\u0001\u001b\u0005\u0006W\u001e!\t\u0005\u001c\u0004\u0005e\u0006\u00011\u000fC\u0003*\u0015\u0011\u0005A\u000fC\u0003l\u0015\u0011\u0005C\u000eC\u0003w\u0015\u0011%qoB\u0004\u0002\u0004\u0005A\t!!\u0002\u0007\rI\f\u0001\u0012AA\u0004\u0011\u0019Is\u0002\"\u0001\u0002\n!I\u00111B\bC\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003'y\u0001\u0015!\u0003\u0002\u0010\u000592+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3M_\u0006$WM\u001d\u0006\u0003+Y\t\u0001bZ3pi>|Gn\u001d\u0006\u0003/a\tQ!\u001e;jYNT!!\u0007\u000e\u0002\u000f\u001d,w.\\3tC*\u00111\u0004H\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002;\u0005\u0019qN]4\u0004\u0001A\u0011\u0001%A\u0007\u0002)\t92+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3M_\u0006$WM]\n\u0003\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 \u0003%\u0001(o\u001c<jI\u0016\u00148/F\u0001.!\rqc'\u000f\b\u0003_Qr!\u0001M\u001a\u000e\u0003ER!A\r\u0010\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013BA\u001b&\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000e\u001d\u0003\t1K7\u000f\u001e\u0006\u0003k\u0015\u0002\"\u0001\t\u001e\n\u0005m\"\"!G*j[BdWMR3biV\u0014X\rV=qKB\u0013xN^5eKJ\fAa\u001d4ugV\ta\bE\u0002/m}\u0002\"\u0001Q$\u000e\u0003\u0005S!AQ\"\u0002\rMLW\u000e\u001d7f\u0015\t!U)A\u0004gK\u0006$XO]3\u000b\u0005\u0019c\u0012aB8qK:<\u0017n]\u0005\u0003\u0011\u0006\u0013\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u00035a\u0017n\u001d;UsB,g*Y7fgV\t1\nE\u0002/m1\u0003\"!T)\u000f\u00059{\u0005C\u0001\u0019&\u0013\t\u0001V%\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)&\u0003)\u0019h\r\u001e$pe:\u000bW.\u001a\u000b\u0003-f\u00032\u0001J,@\u0013\tAVE\u0001\u0004PaRLwN\u001c\u0005\u00065\u001a\u0001\r\u0001T\u0001\u0002]\n!2\t\\1tgB\u000bG\u000f[*giB\u0013xN^5eKJ\u001cBaB/:KB\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0005Y\u0006twMC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&AB(cU\u0016\u001cG\u000f\u0005\u0002!M&\u0011q\r\u0006\u0002\u0011\u0007>tg-[4TMR\u0004\u0016M]:j]\u001e$\u0012!\u001b\t\u0003U\u001ei\u0011!A\u0001\nY>\fG\rV=qKN$\u0012!\u001c\t\u0004]F|T\"A8\u000b\u0005A\f\u0017\u0001B;uS2L!aN8\u0003\u001dU\u0013Fj\u00154u!J|g/\u001b3feN!!\"X\u001df)\u0005)\bC\u00016\u000b\u0003)\u0019wN\u001c4jOV\u0013Fj]\u000b\u0002qB\u0019a&_>\n\u0005iD$aA*fcB\u0011Ap`\u0007\u0002{*\u0011a0Y\u0001\u0004]\u0016$\u0018bAA\u0001{\n\u0019QK\u0015'\u0002\u001dU\u0013Fj\u00154u!J|g/\u001b3feB\u0011!nD\n\u0003\u001f\r\"\"!!\u0002\u0002\u001bM3GoQ8oM&<WK\u0015't+\t\ty\u0001E\u0002_\u0003#I!AU0\u0002\u001dM3GoQ8oM&<WK\u0015'tA\u0001")
public final class SimpleFeatureTypeLoader {
    public static Option<SimpleFeatureType> sftForName(String n) {
        return SimpleFeatureTypeLoader$.MODULE$.sftForName(n);
    }

    public static List<String> listTypeNames() {
        return SimpleFeatureTypeLoader$.MODULE$.listTypeNames();
    }

    public static List<SimpleFeatureType> sfts() {
        return SimpleFeatureTypeLoader$.MODULE$.sfts();
    }

    public static class ClassPathSftProvider
    implements SimpleFeatureTypeProvider,
    ConfigSftParsing {
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        @Override
        public Seq<SimpleFeatureType> parseConf(Config config) {
            return ConfigSftParsing.parseConf$(this, config);
        }

        private Logger logger$lzycompute() {
            ClassPathSftProvider classPathSftProvider = this;
            synchronized (classPathSftProvider) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public java.util.List<SimpleFeatureType> loadTypes() {
            BoxedUnit boxedUnit;
            Seq<SimpleFeatureType> sfts = this.parseConf(ConfigFactory.load());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Loading SFTs from classpath {}", (Object)((IterableOnceOps)sfts.map((Function1 & Serializable)x$4 -> x$4.getTypeName())).mkString(", "));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(sfts).asJava();
        }

        public ClassPathSftProvider() {
            LazyLogging.$init$((LazyLogging)this);
            ConfigSftParsing.$init$(this);
        }
    }

    public static class URLSftProvider
    implements SimpleFeatureTypeProvider,
    ConfigSftParsing {
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        @Override
        public Seq<SimpleFeatureType> parseConf(Config config) {
            return ConfigSftParsing.parseConf$(this, config);
        }

        private Logger logger$lzycompute() {
            URLSftProvider uRLSftProvider = this;
            synchronized (uRLSftProvider) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public java.util.List<SimpleFeatureType> loadTypes() {
            BoxedUnit boxedUnit;
            List urls = this.configURLs().toList();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Loading config from urls: {}", (Object)urls.mkString(", "));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            List configs = urls.flatMap((Function1 & Serializable)url -> {
                Some some;
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Attempting to parse config from url {}", url);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                try {
                    some = new Some((Object)ConfigFactory.parseURL((URL)url).resolve());
                }
                catch (Throwable e) {
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Unable to load SFT config from url {}", url);
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(new StringBuilder(35).append("Unable to load SFT config from url ").append(url).toString(), e);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    some = None$.MODULE$;
                }
                return some;
            });
            Option option = configs.reduceLeftOption((Function2 & Serializable)(x$5, x$6) -> x$5.withFallback((ConfigMergeable)x$6));
            if (option instanceof Some) {
                Some some = (Some)option;
                Config c = (Config)some.value();
                return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.parseConf(c)).asJava();
            }
            if (None$.MODULE$.equals(option)) {
                return Collections.emptyList();
            }
            throw new MatchError((Object)option);
        }

        private Seq<URL> configURLs() {
            Config config = ConfigFactory.load();
            if (!config.hasPath(SimpleFeatureTypeLoader$URLSftProvider$.MODULE$.SftConfigURLs())) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            Object object = config.getAnyRef(SimpleFeatureTypeLoader$URLSftProvider$.MODULE$.SftConfigURLs());
            if (object instanceof String) {
                String string = (String)object;
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(string), ',')), (Function1 & Serializable)s -> new URL(s.trim()), ClassTag$.MODULE$.apply(URL.class))).toList();
            }
            if (object instanceof java.util.List) {
                java.util.List list = (java.util.List)object;
                return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable)x$7 -> new URL((String)x$7))).toSeq();
            }
            throw new MatchError(object);
        }

        public URLSftProvider() {
            LazyLogging.$init$((LazyLogging)this);
            ConfigSftParsing.$init$(this);
        }
    }
}

