/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.text.StringEscapeUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.utils.geotools.NameableFeatureTypeFactory;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$AttributeOptions$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecConfig$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecParser$;
import org.locationtech.geomesa.utils.geotools.sft.package;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.parboiled.errors.ParsingException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SimpleFeatureTypes$ {
    public static final SimpleFeatureTypes$ MODULE$ = new SimpleFeatureTypes$();
    private static final ConcurrentHashMap<Tuple2<String, String>, package.ImmutableSimpleFeatureType> cache = new ConcurrentHashMap();

    private ConcurrentHashMap<Tuple2<String, String>, package.ImmutableSimpleFeatureType> cache() {
        return cache;
    }

    public SimpleFeatureType createType(String typeName, String spec) {
        Tuple2<String, String> tuple2 = this.parseTypeName(typeName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String namespace = (String)tuple2._1();
        String name = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)namespace, (Object)name);
        String namespace2 = (String)tuple22._1();
        String name2 = (String)tuple22._2();
        return this.createType(namespace2, name2, spec);
    }

    public SimpleFeatureType createType(String namespace, String name, String spec) {
        SimpleFeatureSpec simpleFeatureSpec;
        try {
            simpleFeatureSpec = SimpleFeatureSpecParser$.MODULE$.parse(spec, SimpleFeatureSpecParser$.MODULE$.parse$default$2());
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        SimpleFeatureSpec parsed = simpleFeatureSpec;
        return this.createFeatureType(namespace, name, parsed, this.createFeatureType$default$4());
    }

    public SimpleFeatureType createImmutableType(String typeName, String spec) {
        Object object;
        package.ImmutableSimpleFeatureType sft = this.cache().get(new Tuple2((Object)typeName, (Object)spec));
        if (sft == null) {
            sft = (package.ImmutableSimpleFeatureType)this.immutable(this.createType(typeName, spec), this.immutable$default$2());
            object = this.cache().put((Tuple2<String, String>)new Tuple2((Object)typeName, (Object)spec), sft);
        } else {
            object = BoxedUnit.UNIT;
        }
        return sft;
    }

    public SimpleFeatureType createImmutableType(String namespace, String name, String spec) {
        return this.createImmutableType(namespace == null ? name : new java.lang.StringBuilder(1).append(namespace).append(":").append(name).toString(), spec);
    }

    public SimpleFeatureType createType(Config conf, Option<String> typeName, Option<String> path) {
        Tuple2<Option<String>, SimpleFeatureSpec> tuple2 = SimpleFeatureSpecConfig$.MODULE$.parse(conf, path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option nameFromConf = (Option)tuple2._1();
        SimpleFeatureSpec spec = (SimpleFeatureSpec)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nameFromConf, (Object)spec);
        Option nameFromConf2 = (Option)tuple22._1();
        SimpleFeatureSpec spec2 = (SimpleFeatureSpec)tuple22._2();
        Tuple2<String, String> tuple23 = this.parseTypeName((String)nameFromConf2.orElse((Function0 & Serializable)() -> typeName).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Unable to parse type name from provided argument or config");
        }));
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        String namespace = (String)tuple23._1();
        String name = (String)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)namespace, (Object)name);
        String namespace2 = (String)tuple24._1();
        String name2 = (String)tuple24._2();
        return this.createFeatureType(namespace2, name2, spec2, this.createFeatureType$default$4());
    }

    public Option<String> createType$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createType$default$3() {
        return new Some((Object)"sft");
    }

    public NameableFeatureTypeFactory.NameableSimpleFeatureType createNameableType(String spec) {
        SimpleFeatureSpec simpleFeatureSpec;
        try {
            simpleFeatureSpec = SimpleFeatureSpecParser$.MODULE$.parse(spec, SimpleFeatureSpecParser$.MODULE$.parse$default$2());
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        SimpleFeatureSpec parsed = simpleFeatureSpec;
        return (NameableFeatureTypeFactory.NameableSimpleFeatureType)this.createFeatureType(null, "", parsed, (Option<FeatureTypeFactory>)new Some((Object)new NameableFeatureTypeFactory()));
    }

    public AttributeDescriptor createDescriptor(String spec) {
        AttributeDescriptor attributeDescriptor;
        try {
            attributeDescriptor = SimpleFeatureSpecParser$.MODULE$.parseAttribute(spec, SimpleFeatureSpecParser$.MODULE$.parseAttribute$default$2()).toDescriptor();
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return attributeDescriptor;
    }

    public String encodeType(SimpleFeatureType sft) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable)x$4 -> MODULE$.encodeDescriptor(sft, (AttributeDescriptor)x$4))).mkString(",");
    }

    public String encodeType(SimpleFeatureType sft, boolean includeUserData) {
        if (includeUserData) {
            return new java.lang.StringBuilder(0).append(this.encodeType(sft)).append(this.encodeUserData(sft)).toString();
        }
        return this.encodeType(sft);
    }

    public String encodeDescriptor(SimpleFeatureType sft, AttributeDescriptor descriptor) {
        return SimpleFeatureSpec$.MODULE$.attribute(sft, descriptor).toSpec();
    }

    public String encodeUserData(SimpleFeatureType sft) {
        scala.collection.immutable.Seq<String> prefixes = RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getUserDataPrefixes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        StringBuilder result = new StringBuilder(";");
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(sft.getUserData()).asScala()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                if (k != null) {
                    Object object = k;
                    if (v != null) {
                        String string;
                        Object object2 = v;
                        if (object2 != null && prefixes.exists(arg_0 -> SimpleFeatureTypes$.$anonfun$encodeUserData$2$adapted(string = object.toString(), arg_0))) {
                            return result.append(MODULE$.encodeUserData(object, object2)).append(",");
                        }
                        return BoxedUnit.UNIT;
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (result.lengthCompare(1) > 0) {
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    public String encodeUserData(Map<?, ?> data) {
        if (data.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(";");
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(data).asScala()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                return result.append(MODULE$.encodeUserData(k, v)).append(",");
            }
            throw new MatchError((Object)tuple2);
        });
        return result.substring(0, result.length() - 1);
    }

    public String encodeUserData(Object key, Object value) {
        return new java.lang.StringBuilder(3).append(key).append("='").append(StringEscapeUtils.escapeJava((String)value.toString())).append("'").toString();
    }

    public Config toConfig(SimpleFeatureType sft, boolean includeUserData, boolean includePrefix) {
        return SimpleFeatureSpecConfig$.MODULE$.toConfig(sft, includeUserData, includePrefix);
    }

    public boolean toConfig$default$2() {
        return true;
    }

    public boolean toConfig$default$3() {
        return true;
    }

    public String toConfigString(SimpleFeatureType sft, boolean includeUserData, boolean concise, boolean includePrefix, boolean json) {
        return SimpleFeatureSpecConfig$.MODULE$.toConfigString(sft, includeUserData, concise, includePrefix, json);
    }

    public boolean toConfigString$default$2() {
        return true;
    }

    public boolean toConfigString$default$3() {
        return false;
    }

    public boolean toConfigString$default$4() {
        return true;
    }

    public boolean toConfigString$default$5() {
        return false;
    }

    public String serialize(SimpleFeatureType sft) {
        return StringSerialization$.MODULE$.encodeSeq((scala.collection.immutable.Seq<String>)new .colon.colon((Object)sft.getTypeName(), (List)new .colon.colon((Object)this.encodeType(sft, true), (List)Nil$.MODULE$)));
    }

    public SimpleFeatureType deserialize(String sft) {
        SeqOps seqOps;
        scala.collection.immutable.Seq<String> seq = StringSerialization$.MODULE$.decodeSeq(sft);
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
            throw new MatchError(seq);
        }
        String name = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        String spec = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Tuple2 tuple2 = new Tuple2((Object)name, (Object)spec);
        String name2 = (String)tuple2._1();
        String spec2 = (String)tuple2._2();
        return this.createType(name2, spec2);
    }

    public SimpleFeatureType immutable(SimpleFeatureType sft, Map<?, ?> extraData) {
        SimpleFeatureType simpleFeatureType = sft;
        if (simpleFeatureType instanceof package.ImmutableSimpleFeatureType) {
            package.ImmutableSimpleFeatureType immutableSimpleFeatureType = (package.ImmutableSimpleFeatureType)simpleFeatureType;
            if (extraData == null || extraData.isEmpty()) {
                return immutableSimpleFeatureType;
            }
        }
        ArrayList<AttributeDescriptor> schema = new ArrayList<AttributeDescriptor>(sft.getAttributeCount());
        GeometryDescriptor geom = null;
        for (int i = 0; i < sft.getAttributeCount(); ++i) {
            AttributeDescriptor descriptor = sft.getDescriptor(i);
            AttributeDescriptor im = this.immutable(descriptor);
            AttributeDescriptor attributeDescriptor = descriptor;
            GeometryDescriptor geometryDescriptor = sft.getGeometryDescriptor();
            if (!(attributeDescriptor != null ? !attributeDescriptor.equals(geometryDescriptor) : geometryDescriptor != null)) {
                geom = (GeometryDescriptor)im;
            }
            schema.add(im);
        }
        Option userData2 = Option$.MODULE$.apply(extraData).filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEmpty())).map((Function1 & Serializable)data -> {
            HashMap map = new HashMap(data.size() + sft.getUserData().size());
            map.putAll(sft.getUserData());
            map.putAll(data);
            return map;
        });
        return new package.ImmutableSimpleFeatureType(sft.getName(), schema, geom, sft.isAbstract(), sft.getRestrictions(), sft.getSuper(), sft.getDescription(), (Map)userData2.getOrElse((Function0 & Serializable)() -> sft.getUserData()));
    }

    public AttributeDescriptor immutable(AttributeDescriptor descriptor) {
        AttributeDescriptor attributeDescriptor = descriptor;
        if (attributeDescriptor instanceof package.ImmutableAttributeDescriptor) {
            package.ImmutableAttributeDescriptor immutableAttributeDescriptor = (package.ImmutableAttributeDescriptor)attributeDescriptor;
            return immutableAttributeDescriptor;
        }
        if (attributeDescriptor instanceof package.ImmutableGeometryDescriptor) {
            package.ImmutableGeometryDescriptor immutableGeometryDescriptor = (package.ImmutableGeometryDescriptor)attributeDescriptor;
            return immutableGeometryDescriptor;
        }
        if (attributeDescriptor instanceof GeometryDescriptor) {
            GeometryDescriptor geometryDescriptor = (GeometryDescriptor)attributeDescriptor;
            return new package.ImmutableGeometryDescriptor(geometryDescriptor.getType(), geometryDescriptor.getName(), geometryDescriptor.getMinOccurs(), geometryDescriptor.getMaxOccurs(), geometryDescriptor.isNillable(), geometryDescriptor.getDefaultValue(), geometryDescriptor.getUserData());
        }
        return new package.ImmutableAttributeDescriptor(attributeDescriptor.getType(), attributeDescriptor.getName(), attributeDescriptor.getMinOccurs(), attributeDescriptor.getMaxOccurs(), attributeDescriptor.isNillable(), attributeDescriptor.getDefaultValue(), attributeDescriptor.getUserData());
    }

    public Map<?, ?> immutable$default$2() {
        return null;
    }

    public SimpleFeatureType mutable(SimpleFeatureType sft) {
        if (sft instanceof package.ImmutableSimpleFeatureType || ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.MODULE$.isImmutable(d)))) {
            return this.copy(sft);
        }
        return sft;
    }

    public SimpleFeatureType copy(SimpleFeatureType sft) {
        SimpleFeatureType copy = SimpleFeatureTypeBuilder.copy((SimpleFeatureType)sft);
        copy.getUserData().putAll(sft.getUserData());
        return copy;
    }

    private boolean isImmutable(AttributeDescriptor d) {
        return d instanceof package.ImmutableAttributeDescriptor || d instanceof package.ImmutableGeometryDescriptor;
    }

    public SimpleFeatureType renameSft(SimpleFeatureType sft, String newName) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(sft);
        int n = newName.indexOf(58);
        switch (n) {
            case -1: {
                builder.setName(newName);
                break;
            }
            default: {
                builder.setNamespaceURI(newName.substring(0, n));
                builder.setName(newName.substring(n + 1));
                break;
            }
        }
        SimpleFeatureType renamed = builder.buildFeatureType();
        renamed.getUserData().putAll(sft.getUserData());
        return renamed;
    }

    public AttributeDescriptor renameDescriptor(AttributeDescriptor descriptor, String newName) {
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.init(descriptor);
        return builder.buildDescriptor(newName);
    }

    public int compare(SimpleFeatureType a, SimpleFeatureType b) {
        if (a.getAttributeCount() > b.getAttributeCount()) {
            return -1;
        }
        boolean exact = a.getAttributeCount() == b.getAttributeCount();
        for (int i = 0; i < a.getAttributeCount(); ++i) {
            AttributeDescriptor ad = a.getDescriptor(i);
            AttributeDescriptor bd = b.getDescriptor(i);
            String string = ad.getLocalName();
            String string2 = bd.getLocalName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Class clazz = ad.getType().getBinding();
                Class clazz2 = bd.getType().getBinding();
                if (!(clazz == null ? clazz2 != null : !clazz.equals(clazz2))) continue;
                if (bd.getType().getBinding().isAssignableFrom(ad.getType().getBinding())) {
                    exact = false;
                    continue;
                }
                return -1;
            }
            AttributeDescriptor reorder = b.getDescriptor(ad.getLocalName());
            if (reorder == null || !reorder.getType().getBinding().isAssignableFrom(ad.getType().getBinding())) {
                return -1;
            }
            exact = false;
        }
        if (exact) {
            return 0;
        }
        return 1;
    }

    private SimpleFeatureType createFeatureType(String namespace, String name, SimpleFeatureSpec spec, Option<FeatureTypeFactory> factory) {
        None$ none$;
        scala.collection.immutable.Seq geomAttributes = (scala.collection.immutable.Seq)spec.attributes().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SimpleFeatureSpec.AttributeSpec, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SimpleFeatureSpec.GeomAttributeSpec) {
                    SimpleFeatureSpec.GeomAttributeSpec geomAttributeSpec = (SimpleFeatureSpec.GeomAttributeSpec)A1;
                    return (B1)geomAttributeSpec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SimpleFeatureSpec.AttributeSpec x1) {
                SimpleFeatureSpec.AttributeSpec attributeSpec = x1;
                return attributeSpec instanceof SimpleFeatureSpec.GeomAttributeSpec;
            }
        });
        Option defaultGeom = geomAttributes.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$1(x$7))).orElse((Function0 & Serializable)() -> geomAttributes.headOption()).map((Function1 & Serializable)x$9 -> x$9.name());
        if (spec.options().get((Object)SimpleFeatureTypes$Configs$.MODULE$.IndexIgnoreDtg()).exists((Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.MODULE$.toBoolean(value)))) {
            none$ = None$.MODULE$;
        } else {
            scala.collection.immutable.Seq dateAttributes = (scala.collection.immutable.Seq)spec.attributes().filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$6(a)));
            none$ = spec.options().get((Object)SimpleFeatureTypes$Configs$.MODULE$.DefaultDtgField()).flatMap((Function1 & Serializable)dtg -> dateAttributes.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$8(dtg, x$10)))).orElse((Function0 & Serializable)() -> dateAttributes.find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$10(x$11)))).orElse((Function0 & Serializable)() -> dateAttributes.headOption()).map((Function1 & Serializable)x$13 -> x$13.name());
        }
        None$ defaultDate = none$;
        SimpleFeatureTypeBuilder b = (SimpleFeatureTypeBuilder)factory.map((Function1 & Serializable)x$14 -> new SimpleFeatureTypeBuilder(x$14)).getOrElse((Function0 & Serializable)() -> new SimpleFeatureTypeBuilder());
        b.setNamespaceURI(namespace);
        b.setName(name);
        b.addAll((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)spec.attributes().map((Function1 & Serializable)x$15 -> x$15.toDescriptor())).asJava());
        defaultGeom.foreach((Function1 & Serializable)x$1 -> {
            b.setDefaultGeometry(x$1);
            return BoxedUnit.UNIT;
        });
        SimpleFeatureType sft = b.buildFeatureType();
        sft.getUserData().putAll((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(spec.options()).asJava());
        SimpleFeatureType simpleFeatureType = RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft);
        defaultDate.foreach((Function1 & Serializable)dtg -> {
            RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.setDtgField$extension(simpleFeatureType, dtg);
            return BoxedUnit.UNIT;
        });
        return sft;
    }

    private Option<FeatureTypeFactory> createFeatureType$default$4() {
        return None$.MODULE$;
    }

    private Tuple2<String, String> parseTypeName(String name) {
        Tuple2 tuple2;
        int nsIndex = name.lastIndexOf(58);
        Tuple2 tuple22 = tuple2 = nsIndex == -1 || nsIndex == name.length() - 1 ? new Tuple2(null, (Object)name) : new Tuple2((Object)name.substring(0, nsIndex), (Object)name.substring(nsIndex + 1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String namespace = (String)tuple2._1();
        String local = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)namespace, (Object)local);
        String namespace2 = (String)tuple23._1();
        String local2 = (String)tuple23._2();
        return new Tuple2((Object)namespace2, (Object)local2);
    }

    public boolean toBoolean(Object value) {
        Object object = value;
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return bl;
        }
        if (object instanceof String) {
            String string = (String)object;
            return Boolean.valueOf(string);
        }
        return Boolean.valueOf(object.toString());
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$1(SimpleFeatureSpec.GeomAttributeSpec x$7) {
        return x$7.options().get((Object)SimpleFeatureTypes$AttributeOptions$.MODULE$.OptDefault()).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$8))));
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$6(SimpleFeatureSpec.AttributeSpec a) {
        return Date.class.isAssignableFrom(a.clazz());
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$8(Object dtg$1, SimpleFeatureSpec.AttributeSpec x$10) {
        String string = x$10.name();
        Object object = dtg$1;
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$10(SimpleFeatureSpec.AttributeSpec x$11) {
        return x$11.options().get((Object)SimpleFeatureTypes$AttributeOptions$.MODULE$.OptDefault()).exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$12))));
    }

    private SimpleFeatureTypes$() {
    }

    public static final /* synthetic */ Object $anonfun$encodeUserData$2$adapted(String eta$0$1$1, String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.startsWith(x$1));
    }
}

