/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools.sft;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.Set;
import org.locationtech.geomesa.utils.conf.ConfConversions$;
import org.locationtech.geomesa.utils.conf.ConfConversions$RichConfig$;
import org.locationtech.geomesa.utils.geotools.ConfigSftParsing$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$InternalConfigs$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecConfig$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecParser$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class SimpleFeatureSpecConfig$ {
    public static final SimpleFeatureSpecConfig$ MODULE$ = new SimpleFeatureSpecConfig$();
    private static final String TypeNamePath = "type-name";
    private static final String AttributesPath = "attributes";
    private static final String UserDataPath = "user-data";
    private static final String TypePath = "type";
    private static final String NamePath = "name";
    private static final scala.collection.immutable.Set<String> NonOptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.TypePath(), MODULE$.NamePath()}));

    public String TypeNamePath() {
        return TypeNamePath;
    }

    public String AttributesPath() {
        return AttributesPath;
    }

    public String UserDataPath() {
        return UserDataPath;
    }

    public String TypePath() {
        return TypePath;
    }

    public String NamePath() {
        return NamePath;
    }

    private scala.collection.immutable.Set<String> NonOptions() {
        return NonOptions;
    }

    public Tuple2<Option<String>, SimpleFeatureSpec> parse(Config conf, Option<String> path) {
        Config config;
        Option<String> option = path;
        if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            config = (Config)ConfConversions$RichConfig$.MODULE$.getConfigOpt$extension(ConfConversions$.MODULE$.RichConfig(conf), p).map((Function1 & Serializable)x$1 -> conf.withFallback(x$1)).getOrElse((Function0 & Serializable)() -> conf);
        } else if (None$.MODULE$.equals(option)) {
            config = conf;
        } else {
            throw new MatchError(option);
        }
        Config toParse = config;
        return this.parse(toParse);
    }

    public Config toConfig(SimpleFeatureType sft, boolean includeUserData, boolean includePrefix) {
        Config updated;
        Config config;
        Seq defaults = (Seq)Option$.MODULE$.option2Iterable(RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).toSeq().$plus$plus((IterableOnce)Option$.MODULE$.apply((Object)RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))));
        Buffer attributes = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable)ad -> {
            scala.collection.immutable.Map<String, String> config = SimpleFeatureSpec$.MODULE$.attribute(sft, (AttributeDescriptor)ad).toConfigMap();
            if (defaults.contains((Object)ad.getLocalName())) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)config.updated((Object)"default", (Object)"true")).asJava();
            }
            return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(config).asJava();
        });
        Config base = ConfigFactory.empty().withValue(this.TypeNamePath(), ConfigValueFactory.fromAnyRef((Object)sft.getTypeName())).withValue(this.AttributesPath(), (ConfigValue)ConfigValueFactory.fromIterable((Iterable)((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter(attributes).asJava())));
        if (includeUserData) {
            Seq<String> prefixes = RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getUserDataPrefixes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
            scala.collection.immutable.Map keywords = (scala.collection.immutable.Map)((IterableOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SimpleFeatureTypes$Configs$.MODULE$.Keywords()), JavaConverters$.MODULE$.setAsJavaSetConverter(RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getKeywords$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).asJava())}))).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureSpecConfig$.$anonfun$toConfig$2(x$1)));
            scala.collection.immutable.Map toConvert = (scala.collection.immutable.Map)keywords.$plus$plus((IterableOnce)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(sft.getUserData()).asScala()).collect((PartialFunction)new Serializable(prefixes){
                private static final long serialVersionUID = 0L;
                private final Seq prefixes$1;

                public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String string;
                        Object k = A1._1();
                        Object v = A1._2();
                        if (v != null && this.prefixes$1.exists(arg_0 -> anonfun.1.$anonfun$applyOrElse$1$adapted(string = k.toString(), arg_0))) {
                            Object object = k;
                            String string2 = SimpleFeatureTypes$Configs$.MODULE$.Keywords();
                            if (object == null ? string2 != null : !object.equals(string2)) {
                                return (B1)new Tuple2((Object)k.toString(), v);
                            }
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                    Tuple2<Object, Object> tuple2 = x1;
                    if (tuple2 != null) {
                        String string;
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        if (v != null && this.prefixes$1.exists(arg_0 -> anonfun.1.$anonfun$isDefinedAt$1$adapted(string = k.toString(), arg_0))) {
                            Object object = k;
                            String string2 = SimpleFeatureTypes$Configs$.MODULE$.Keywords();
                            if (object == null ? string2 != null : !object.equals(string2)) {
                                return true;
                            }
                        }
                    }
                    return false;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$1(String eta$0$1$1, String x$1) {
                    return eta$0$1$1.startsWith(x$1);
                }

                public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(String eta$0$1$2, String x$1) {
                    return eta$0$1$2.startsWith(x$1);
                }
                {
                    this.prefixes$1 = prefixes$1;
                }

                public static final /* synthetic */ Object $anonfun$applyOrElse$1$adapted(String eta$0$1$1, String x$1) {
                    return BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$1(eta$0$1$1, x$1));
                }

                public static final /* synthetic */ Object $anonfun$isDefinedAt$1$adapted(String eta$0$1$2, String x$1) {
                    return BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$isDefinedAt$1(eta$0$1$2, x$1));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(java.lang.String java.lang.String ), $anonfun$isDefinedAt$1$adapted(java.lang.String java.lang.String )}, serializedLambda);
                }
            }));
            ConfigObject userData2 = ConfigValueFactory.fromMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)toConvert).asJava()));
            config = base.withValue(this.UserDataPath(), (ConfigValue)userData2);
        } else {
            config = updated = base;
        }
        if (includePrefix) {
            return updated.atPath(new StringBuilder(1).append(ConfigSftParsing$.MODULE$.path()).append(".").append(sft.getTypeName()).toString());
        }
        return updated;
    }

    public String toConfigString(SimpleFeatureType sft, boolean includeUserData, boolean concise, boolean includePrefix, boolean json) {
        ConfigRenderOptions opts = concise ? ConfigRenderOptions.concise().setJson(json) : ConfigRenderOptions.defaults().setFormatted(true).setComments(false).setOriginComments(false).setJson(json);
        return this.toConfig(sft, includeUserData, includePrefix).root().render(opts);
    }

    private Tuple2<Option<String>, SimpleFeatureSpec> parse(Config conf2) {
        String x$1;
        Option<String> name = ConfConversions$RichConfig$.MODULE$.getStringOpt$extension(ConfConversions$.MODULE$.RichConfig(conf2), this.TypeNamePath());
        Seq attributes = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter((List)ConfConversions$RichConfig$.MODULE$.getConfigListOpt$extension(ConfConversions$.MODULE$.RichConfig(conf2), "fields").getOrElse((Function0 & Serializable)() -> conf2.getConfigList(MODULE$.AttributesPath()))).asScala()).map((Function1 & Serializable)conf -> MODULE$.buildField((Config)conf))).toSeq();
        Config userDataConfig = (Config)ConfConversions$RichConfig$.MODULE$.getConfigOpt$extension(ConfConversions$.MODULE$.RichConfig(conf2), this.UserDataPath()).getOrElse((Function0 & Serializable)() -> ConfigFactory.empty());
        Config qual$1 = ConfConversions$.MODULE$.RichConfig(userDataConfig);
        scala.collection.immutable.Map base = ConfConversions$RichConfig$.MODULE$.toStringMap$extension(qual$1, x$1 = ConfConversions$RichConfig$.MODULE$.toStringMap$default$1$extension(qual$1));
        scala.collection.immutable.Map opts = !base.contains((Object)SimpleFeatureTypes$Configs$.MODULE$.Keywords()) ? base : (scala.collection.immutable.Map)base.$plus$plus(ConfConversions$RichConfig$.MODULE$.toStringMap$extension(ConfConversions$.MODULE$.RichConfig(userDataConfig.withOnlyPath(SimpleFeatureTypes$Configs$.MODULE$.Keywords())), SimpleFeatureTypes$InternalConfigs$.MODULE$.KeywordsDelimiter()));
        return new Tuple2(name, (Object)new SimpleFeatureSpec((Seq<SimpleFeatureSpec.AttributeSpec>)attributes, opts));
    }

    private SimpleFeatureSpec.AttributeSpec buildField(Config conf) {
        SimpleFeatureSpec.AttributeSpec attribute = SimpleFeatureSpecParser$.MODULE$.parseAttribute(new StringBuilder(1).append(conf.getString(this.NamePath())).append(":").append(conf.getString(this.TypePath())).toString(), SimpleFeatureSpecParser$.MODULE$.parseAttribute$default$2());
        Config qual$1 = ConfConversions$.MODULE$.RichConfig(conf);
        String x$1 = ConfConversions$RichConfig$.MODULE$.toStringMap$default$1$extension(qual$1);
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)ConfConversions$RichConfig$.MODULE$.toStringMap$extension(qual$1, x$1).filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureSpecConfig$.$anonfun$buildField$1(x0$1)));
        SimpleFeatureSpec.AttributeSpec attributeSpec = attribute;
        if (attributeSpec instanceof SimpleFeatureSpec.SimpleAttributeSpec) {
            SimpleFeatureSpec.SimpleAttributeSpec simpleAttributeSpec = (SimpleFeatureSpec.SimpleAttributeSpec)attributeSpec;
            scala.collection.immutable.Map x$2 = options;
            String x$3 = simpleAttributeSpec.copy$default$1();
            Class<?> x$4 = simpleAttributeSpec.copy$default$2();
            return simpleAttributeSpec.copy(x$3, x$4, (scala.collection.immutable.Map<String, String>)x$2);
        }
        if (attributeSpec instanceof SimpleFeatureSpec.GeomAttributeSpec) {
            SimpleFeatureSpec.GeomAttributeSpec geomAttributeSpec = (SimpleFeatureSpec.GeomAttributeSpec)attributeSpec;
            scala.collection.immutable.Map x$5 = options;
            String x$6 = geomAttributeSpec.copy$default$1();
            Class<? extends Geometry> x$7 = geomAttributeSpec.copy$default$2();
            return geomAttributeSpec.copy(x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5);
        }
        if (attributeSpec instanceof SimpleFeatureSpec.ListAttributeSpec) {
            SimpleFeatureSpec.ListAttributeSpec listAttributeSpec = (SimpleFeatureSpec.ListAttributeSpec)attributeSpec;
            scala.collection.immutable.Map x$8 = options;
            String x$9 = listAttributeSpec.copy$default$1();
            Class<?> x$10 = listAttributeSpec.copy$default$2();
            return listAttributeSpec.copy(x$9, x$10, (scala.collection.immutable.Map<String, String>)x$8);
        }
        if (attributeSpec instanceof SimpleFeatureSpec.MapAttributeSpec) {
            SimpleFeatureSpec.MapAttributeSpec mapAttributeSpec = (SimpleFeatureSpec.MapAttributeSpec)attributeSpec;
            scala.collection.immutable.Map x$11 = options;
            String x$12 = mapAttributeSpec.copy$default$1();
            Class<?> x$13 = mapAttributeSpec.copy$default$2();
            Class<?> x$14 = mapAttributeSpec.copy$default$3();
            return mapAttributeSpec.copy(x$12, x$13, x$14, (scala.collection.immutable.Map<String, String>)x$11);
        }
        throw new MatchError((Object)attributeSpec);
    }

    public static final /* synthetic */ boolean $anonfun$toConfig$2(Tuple2 x$1) {
        return ((Set)x$1._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$buildField$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return MODULE$.NonOptions().contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    private SimpleFeatureSpecConfig$() {
    }
}

