/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public final class MixedGeometryCheck$
implements LazyLogging {
    public static final MixedGeometryCheck$ MODULE$ = new MixedGeometryCheck$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        MixedGeometryCheck$ mixedGeometryCheck$ = this;
        synchronized (mixedGeometryCheck$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public void validateGeometryType(SimpleFeatureType sft) {
        GeometryDescriptor gd = sft.getGeometryDescriptor();
        if (gd != null) {
            Class clazz = gd.getType().getBinding();
            Class<Geometry> clazz2 = Geometry.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                if (!GeoMesaSchemaValidator$.MODULE$.declared(sft, SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries())) {
                    throw new IllegalArgumentException(new StringBuilder(410).append("Trying to create a schema with mixed geometry type ").append("'").append(gd.getLocalName()).append(":Geometry'. Queries may be slower when using mixed geometries. ").append("If this is intentional, you may override this check by putting Boolean.TRUE into the ").append("SimpleFeatureType user data under the key '").append(SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries()).append("' before calling createSchema, or by ").append("setting the system property '").append(SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries()).append("' to 'true'. Otherwise, please specify a single ").append("geometry type (e.g. Point, LineString, Polygon, etc).").toString());
                }
                return;
            }
        }
    }

    private MixedGeometryCheck$() {
    }
}

