/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public final class ReservedWordCheck$
implements LazyLogging {
    public static final ReservedWordCheck$ MODULE$ = new ReservedWordCheck$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        ReservedWordCheck$ reservedWordCheck$ = this;
        synchronized (reservedWordCheck$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public void validateAttributeNames(SimpleFeatureType sft) {
        Seq<String> reservedWords = FeatureUtils$.MODULE$.sftReservedWords(sft);
        if (reservedWords.nonEmpty()) {
            String msg = new StringBuilder(313).append("The simple feature type contains attribute name(s) that are reserved words: ").append(reservedWords.mkString(", ")).append(". You may override this check by putting Boolean.TRUE into the ").append("SimpleFeatureType user data under the key '").append(SimpleFeatureTypes$Configs$.MODULE$.OverrideReservedWords()).append("' before calling createSchema, or by ").append("setting the system property '").append(SimpleFeatureTypes$Configs$.MODULE$.OverrideReservedWords()).append("' to 'true', however it may cause errors with some functionality.").toString();
            if (GeoMesaSchemaValidator$.MODULE$.declared(sft, SimpleFeatureTypes$Configs$.MODULE$.OverrideReservedWords())) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new IllegalArgumentException(msg);
        }
    }

    private ReservedWordCheck$() {
    }
}

