/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.index.SizeSeparatedBucketIndex$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t}g\u0001\u0002$H\u0001IC\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\b\u0001\t\u0005\t\u0015!\u0003\u0002\b!Q\u0011\u0011\u0003\u0001\u0003\u0002\u0003\u0006I!a\u0005\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0005K\u0002\u0001\u0015!\u0003\u00026!9!q\r\u0001\u0005B\t%\u0004b\u0002B>\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u0007\u0003A\u0011\tBC\u0011\u001d\u0011Y\t\u0001C!\u0005\u001bCqAa#\u0001\t\u0003\u00129\nC\u0004\u0002z\u0002!\t%a?\t\u000f\u0005u\b\u0001\"\u0011\u0002\u0000\"9!\u0011\u0014\u0001\u0005\n\tmeABA$\u0001\u0011\tI\u0005\u0003\u0006\u0002LA\u0011)\u0019!C\u0001\u0003\u001bB!\"a\u0014\u0011\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\t\t\u0006\u0005BC\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003'\u0002\"\u0011!Q\u0001\n\u0005\u001d\u0001BCA+!\t\u0005\t\u0015!\u0003\u0002X!Q\u00111\u0011\t\u0003\u0002\u0003\u0006I!!\"\t\u000f\u0005\r\u0002\u0003\"\u0001\u0002\u0012\"I\u00111\u0014\tA\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003K\u0003\u0002\u0019!C\u0001\u0003OC\u0001\"a-\u0011A\u0003&\u0011q\u0014\u0005\n\u0003{\u0003\"\u0019!C\u0005\u0003\u007fC\u0001\"a2\u0011A\u0003%\u0011\u0011\u0019\u0005\n\u0003\u0013\u0004\"\u0019!C\u0005\u0003\u007fC\u0001\"a3\u0011A\u0003%\u0011\u0011\u0019\u0005\b\u0003\u001b\u0004B\u0011AAh\u0011\u001d\ti\r\u0005C\u0001\u00033Dq!a8\u0011\t\u0003\t\t\u000fC\u0004\u0002zB!\t!a?\t\u000f\u0005u\b\u0003\"\u0001\u0002\u0000\"9!\u0011\u0001\t\u0005\n\t\r\u0001b\u0002B\u0004!\u0011%!\u0011\u0002\u0004\u0007\u0005\u001b\u0001\u0002Aa\u0004\t\u0015\u0005-hE!A!\u0002\u0013\t9\u0001\u0003\u0006\u0002p\u001a\u0012\t\u0011)A\u0005\u0003\u000fA!\"a='\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\t9P\nB\u0001B\u0003%\u0011q\u0001\u0005\b\u0003G1C\u0011\u0001B\t\u0011%\u0011yB\nb\u0001\n\u0013\ty\f\u0003\u0005\u0003\"\u0019\u0002\u000b\u0011BAa\u0011%\u0011\u0019C\nb\u0001\n\u0013\ty\f\u0003\u0005\u0003&\u0019\u0002\u000b\u0011BAa\u0011%\u00119C\nb\u0001\n\u0013\ty\f\u0003\u0005\u0003*\u0019\u0002\u000b\u0011BAa\u0011%\u0011YC\na\u0001\n\u0013\ty\fC\u0005\u0003.\u0019\u0002\r\u0011\"\u0003\u00030!A!1\u0007\u0014!B\u0013\t\t\rC\u0005\u00036\u0019\u0002\r\u0011\"\u0003\u0002@\"I!q\u0007\u0014A\u0002\u0013%!\u0011\b\u0005\t\u0005{1\u0003\u0015)\u0003\u0002B\"I!q\b\u0014A\u0002\u0013%!\u0011\t\u0005\n\u0005\u00132\u0003\u0019!C\u0005\u0005\u0017B\u0001Ba\u0014'A\u0003&!1\t\u0005\b\u0005#2CQIAO\u0011\u001d\u0011\tG\nC!\u0005G:qAa(H\u0011\u0003\u0011\tK\u0002\u0004G\u000f\"\u0005!1\u0015\u0005\b\u0003GqD\u0011\u0001BS\u0011%\u00119K\u0010b\u0001\n\u0003\u0011I\u000bC\u0004\u0003,z\u0002\u000b\u0011\u0002;\t\u0013\t5f(%A\u0005\u0002\t=\u0006\"\u0003Bc}E\u0005I\u0011\u0001Bd\u0011%\u0011yMPI\u0001\n\u0003\u0011\t\u000eC\u0005\u0003Vz\n\n\u0011\"\u0001\u0003X\nA2+\u001b>f'\u0016\u0004\u0018M]1uK\u0012\u0014UoY6fi&sG-\u001a=\u000b\u0005!K\u0015!B5oI\u0016D(B\u0001&L\u0003\u0015)H/\u001b7t\u0015\taU*A\u0004hK>lWm]1\u000b\u00059{\u0015\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001)\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005M\u00037\u0003\u0002\u0001U5&\u0004\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a!\u00118z%\u00164\u0007cA.]=6\tq)\u0003\u0002^\u000f\na1\u000b]1uS\u0006d\u0017J\u001c3fqB\u0011q\f\u0019\u0007\u0001\t\u0015\t\u0007A1\u0001c\u0005\u0005!\u0016CA2g!\t)F-\u0003\u0002f-\n9aj\u001c;iS:<\u0007CA+h\u0013\tAgKA\u0002B]f\u0004\"A[9\u000e\u0003-T!\u0001\\7\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u00059|\u0017\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003A\f1aY8n\u0013\t\u00118NA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0006g&TXm\u001d\t\u0005kv\f\tA\u0004\u0002ww:\u0011qO_\u0007\u0002q*\u0011\u00110U\u0001\u0007yI|w\u000e\u001e \n\u0003]K!\u0001 ,\u0002\u000fA\f7m[1hK&\u0011ap \u0002\u0004'\u0016\f(B\u0001?W!\u001d)\u00161AA\u0004\u0003\u000fI1!!\u0002W\u0005\u0019!V\u000f\u001d7feA\u0019Q+!\u0003\n\u0007\u0005-aK\u0001\u0004E_V\u0014G.Z\u0001\u0012q\n+8m[3u\u001bVdG/\u001b9mS\u0016\u0014\u0018!E=Ck\u000e\\W\r^'vYRL\u0007\u000f\\5fe\u00069Q\r\u001f;f]R\u001c\b\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0005O\u0016|WNC\u0002\u0002\u001e5\u000b1A\u001b;t\u0013\u0011\t\t#a\u0006\u0003\u0011\u0015sg/\u001a7pa\u0016\fa\u0001P5oSRtDCCA\u0014\u0003S\tY#!\f\u00020A\u00191\f\u00010\t\u000fM,\u0001\u0013!a\u0001i\"I\u0011QB\u0003\u0011\u0002\u0003\u0007\u0011q\u0001\u0005\n\u0003\u001f)\u0001\u0013!a\u0001\u0003\u000fA\u0011\"!\u0005\u0006!\u0003\u0005\r!a\u0005\u0002\u000bQLWM]:\u0016\u0005\u0005U\u0002CBA\u001c\u0003\u0003\n\u0019%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003%IW.\\;uC\ndWMC\u0002\u0002@Y\u000b!bY8mY\u0016\u001cG/[8o\u0013\rq\u0018\u0011\b\t\u0004\u0003\u000b\u0002R\"\u0001\u0001\u0003\tQKWM]\n\u0003!Q\u000b\u0001\"\\1y'&TX\rW\u000b\u0003\u0003\u000f\t\u0011\"\\1y'&TX\r\u0017\u0011\u0002\u00115\f\u0007pU5{Kf\u000b\u0011\"\\1y'&TX-\u0017\u0011\u0002\u000f\t,8m[3ugB)Q+!\u0017\u0002^%\u0019\u00111\f,\u0003\u000b\u0005\u0013(/Y=\u0011\u000bU\u000bI&a\u0018\u0011\u000f\u0005\u0005\u0014qNA:=6\u0011\u00111\r\u0006\u0005\u0003K\n9'\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u001b\u0002l\u0005!Q\u000f^5m\u0015\t\ti'\u0001\u0003kCZ\f\u0017\u0002BA9\u0003G\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\t)(! \u000f\t\u0005]\u0014\u0011\u0010\t\u0003oZK1!a\u001fW\u0003\u0019\u0001&/\u001a3fM&!\u0011qPAA\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0010,\u0002\u0011\u001d\u0014\u0018\u000eZ*oCB\u0004B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017K\u0015\u0001C4f_R|w\u000e\\:\n\t\u0005=\u0015\u0011\u0012\u0002\t\u000fJLGm\u00158baRQ\u00111IAJ\u0003+\u000b9*!'\t\u000f\u0005-s\u00031\u0001\u0002\b!9\u0011\u0011K\fA\u0002\u0005\u001d\u0001bBA+/\u0001\u0007\u0011q\u000b\u0005\b\u0003\u0007;\u0002\u0019AAC\u0003\u0015)W\u000e\u001d;z+\t\ty\nE\u0002V\u0003CK1!a)W\u0005\u001d\u0011un\u001c7fC:\f\u0011\"Z7qif|F%Z9\u0015\t\u0005%\u0016q\u0016\t\u0004+\u0006-\u0016bAAW-\n!QK\\5u\u0011%\t\t,GA\u0001\u0002\u0004\ty*A\u0002yIE\na!Z7qif\u0004\u0003f\u0001\u000e\u00028B\u0019Q+!/\n\u0007\u0005mfK\u0001\u0005w_2\fG/\u001b7f\u0003\u0011i\u0017\r\u001f-\u0016\u0005\u0005\u0005\u0007cA+\u0002D&\u0019\u0011Q\u0019,\u0003\u0007%sG/A\u0003nCbD\u0006%\u0001\u0003nCbL\u0016!B7bqf\u0003\u0013A\u00022vG.,G\u000f\u0006\u0004\u0002`\u0005E\u0017Q\u001b\u0005\b\u0003'|\u0002\u0019AA\u0004\u0003\u0005A\bbBAl?\u0001\u0007\u0011qA\u0001\u0002sR!\u0011qLAn\u0011\u001d\ti\u000e\ta\u0001\u0003'\t\u0001\"\u001a8wK2|\u0007/Z\u0001\tSR,'/\u0019;peRQ\u00111]Au\u0003[\f\t0!>\u0011\tU\f)OX\u0005\u0004\u0003O|(\u0001C%uKJ\fGo\u001c:\t\u000f\u0005-\u0018\u00051\u0001\u0002\b\u0005!\u00010\\5o\u0011\u001d\ty/\ta\u0001\u0003\u000f\tA!_7j]\"9\u00111_\u0011A\u0002\u0005\u001d\u0011\u0001\u0002=nCbDq!a>\"\u0001\u0004\t9!\u0001\u0003z[\u0006D\u0018\u0001B:ju\u0016$\"!!1\u0002\u000b\rdW-\u0019:\u0015\u0005\u0005%\u0016!B:oCBDF\u0003BAa\u0005\u000bAq!a5%\u0001\u0004\t9!A\u0003t]\u0006\u0004\u0018\f\u0006\u0003\u0002B\n-\u0001bBAlK\u0001\u0007\u0011q\u0001\u0002\r)&,'/\u0013;fe\u0006$xN]\n\u0005MQ\u000b\u0019\u000f\u0006\u0006\u0003\u0014\t]!\u0011\u0004B\u000e\u0005;\u00012A!\u0006'\u001b\u0005\u0001\u0002bBAvW\u0001\u0007\u0011q\u0001\u0005\b\u0003_\\\u0003\u0019AA\u0004\u0011\u001d\t\u0019p\u000ba\u0001\u0003\u000fAq!a>,\u0001\u0004\t9!\u0001\u0003nCbL\u0017!B7bq&\u0004\u0013\u0001B7j]*\fQ!\\5oU\u0002\nA!\\1yU\u0006)Q.\u0019=kA\u0005\t\u0011.A\u0003j?\u0012*\u0017\u000f\u0006\u0003\u0002*\nE\u0002\"CAYg\u0005\u0005\t\u0019AAa\u0003\tI\u0007%A\u0001k\u0003\u0015Qw\fJ3r)\u0011\tIKa\u000f\t\u0013\u0005Ef'!AA\u0002\u0005\u0005\u0017A\u00016!\u0003\u0011IG/\u001a:\u0016\u0005\t\r\u0003#\u0002B#\u0005\u000frVBAA4\u0013\u0011\t9/a\u001a\u0002\u0011%$XM]0%KF$B!!+\u0003N!I\u0011\u0011W\u001d\u0002\u0002\u0003\u0007!1I\u0001\u0006SR,'\u000fI\u0001\bQ\u0006\u001ch*\u001a=uQ\rY$Q\u000b\t\u0005\u0005/\u0012i&\u0004\u0002\u0003Z)\u0019!1\f,\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003`\te#a\u0002;bS2\u0014XmY\u0001\u0005]\u0016DH\u000fF\u0001_\u0003\u0019!\u0018.\u001a:tA\u00051\u0011N\\:feR$\u0002\"!+\u0003l\tM$q\u000f\u0005\b\u00033A\u0001\u0019\u0001B7!\u0011\t)Ba\u001c\n\t\tE\u0014q\u0003\u0002\t\u000f\u0016|W.\u001a;ss\"9!Q\u000f\u0005A\u0002\u0005M\u0014aA6fs\"1!\u0011\u0010\u0005A\u0002y\u000bQA^1mk\u0016\faA]3n_Z,G#\u00020\u0003\u0000\t\u0005\u0005bBA\r\u0013\u0001\u0007!Q\u000e\u0005\b\u0005kJ\u0001\u0019AA:\u0003\r9W\r\u001e\u000b\u0006=\n\u001d%\u0011\u0012\u0005\b\u00033Q\u0001\u0019\u0001B7\u0011\u001d\u0011)H\u0003a\u0001\u0003g\nQ!];fef$\"\"a9\u0003\u0010\nE%1\u0013BK\u0011\u001d\tYo\u0003a\u0001\u0003\u000fAq!a<\f\u0001\u0004\t9\u0001C\u0004\u0002t.\u0001\r!a\u0002\t\u000f\u0005]8\u00021\u0001\u0002\bQ\u0011\u00111]\u0001\u000bg\u0016dWm\u0019;US\u0016\u0014H\u0003BA\"\u0005;Cq!!8\u0010\u0001\u0004\t\u0019\"\u0001\rTSj,7+\u001a9be\u0006$X\r\u001a\"vG.,G/\u00138eKb\u0004\"a\u0017 \u0014\u0005y\"FC\u0001BQ\u00031!UMZ1vYR$\u0016.\u001a:t+\u0005!\u0018!\u0004#fM\u0006,H\u000e\u001e+jKJ\u001c\b%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0005\u0005c\u0013\u0019-\u0006\u0002\u00034*\u001aAO!.,\u0005\t]\u0006\u0003\u0002B]\u0005\u007fk!Aa/\u000b\t\tu&\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012LAA!1\u0003<\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b\u0005\u0014%\u0019\u00012\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u0011IM!4\u0016\u0005\t-'\u0006BA\u0004\u0005k#Q!Y\"C\u0002\t\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT\u0003\u0002Be\u0005'$Q!\u0019#C\u0002\t\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T\u0003\u0002Bm\u0005;,\"Aa7+\t\u0005M!Q\u0017\u0003\u0006C\u0016\u0013\rA\u0019")
public class SizeSeparatedBucketIndex<T>
implements SpatialIndex<T>,
StrictLogging {
    private final Seq<Tuple2<Object, Object>> sizes;
    private final double xBucketMultiplier;
    private final double yBucketMultiplier;
    public final Envelope org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents;
    private final Seq<Tier> tiers;
    private Logger logger;

    public static <T> Envelope $lessinit$greater$default$4() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> double $lessinit$greater$default$3() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> double $lessinit$greater$default$2() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> Seq<Tuple2<Object, Object>> $lessinit$greater$default$1() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$1();
    }

    public static Seq<Tuple2<Object, Object>> DefaultTiers() {
        return SizeSeparatedBucketIndex$.MODULE$.DefaultTiers();
    }

    @Override
    public Iterator<T> query(Envelope bbox) {
        return SpatialIndex.query$(this, bbox);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Seq<Tier> tiers() {
        return this.tiers;
    }

    @Override
    public void insert(Geometry geom, String key, T value) {
        Envelope envelope = geom.getEnvelopeInternal();
        Tier tier = this.selectTier(envelope);
        if (tier.empty()) {
            tier.empty_$eq(false);
        }
        tier.bucket(envelope).put(key, value);
    }

    @Override
    public T remove(Geometry geom, String key) {
        Envelope envelope = geom.getEnvelopeInternal();
        return this.selectTier(envelope).bucket(envelope).remove(key);
    }

    @Override
    public T get(Geometry geom, String key) {
        Envelope envelope = geom.getEnvelopeInternal();
        return this.selectTier(envelope).bucket(envelope).get(key);
    }

    @Override
    public Iterator<T> query(double xmin, double ymin, double xmax, double ymax) {
        return this.tiers().iterator().flatMap((Function1 & Serializable)x$1 -> x$1.iterator(xmin, ymin, xmax, ymax));
    }

    @Override
    public Iterator<T> query() {
        return this.query(this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinX(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinY(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMaxX(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMaxY());
    }

    @Override
    public int size() {
        IntRef size = IntRef.create((int)0);
        this.tiers().foreach((Function1 & Serializable)tier -> {
            SizeSeparatedBucketIndex.$anonfun$size$1(size, tier);
            return BoxedUnit.UNIT;
        });
        return size.elem;
    }

    @Override
    public void clear() {
        this.tiers().foreach((Function1 & Serializable)x$2 -> {
            x$2.clear();
            return BoxedUnit.UNIT;
        });
    }

    private Tier selectTier(Envelope envelope) {
        double width = envelope.getWidth();
        double height = envelope.getHeight();
        return (Tier)this.tiers().find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SizeSeparatedBucketIndex.$anonfun$selectTier$1(width, height, t))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new java.lang.StringBuilder(36).append("Envelope ").append(envelope).append(" exceeds the max tier size ").append($this.sizes.last()).toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$2(Seq x0$1) {
        SeqOps seqOps;
        Seq seq = x0$1;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Tuple2 tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Tuple2 tuple22 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (tuple2 != null) {
                double x1 = tuple2._1$mcD$sp();
                double y1 = tuple2._2$mcD$sp();
                if (tuple22 != null) {
                    double x2 = tuple22._1$mcD$sp();
                    double y2 = tuple22._2$mcD$sp();
                    return x1 <= x2 && y1 <= y2;
                }
            }
        }
        throw new MatchError((Object)seq);
    }

    public static final /* synthetic */ void $anonfun$size$1(IntRef size$1, Tier tier) {
        size$1.elem += tier.size();
    }

    public static final /* synthetic */ boolean $anonfun$selectTier$1(double width$1, double height$1, Tier t) {
        return t.maxSizeX() >= width$1 && t.maxSizeY() >= height$1;
    }

    public SizeSeparatedBucketIndex(Seq<Tuple2<Object, Object>> sizes, double xBucketMultiplier, double yBucketMultiplier, Envelope extents) {
        this.sizes = sizes;
        this.xBucketMultiplier = xBucketMultiplier;
        this.yBucketMultiplier = yBucketMultiplier;
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents = extents;
        SpatialIndex.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        Predef$.MODULE$.require(sizes.nonEmpty(), (Function0 & Serializable)() -> "No valid tier sizes specified");
        Predef$.MODULE$.require(sizes.lengthCompare(1) == 0 || sizes.sliding(2).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SizeSeparatedBucketIndex.$anonfun$new$2(x0$1))), (Function0 & Serializable)() -> "Tiers must be ordered by increasing size");
        this.tiers = (Seq)sizes.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                double width = tuple2._1$mcD$sp();
                double height = tuple2._2$mcD$sp();
                int xSize = (int)scala.math.package$.MODULE$.ceil($this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getWidth() * $this.xBucketMultiplier / width);
                int ySize = (int)scala.math.package$.MODULE$.ceil($this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getHeight() * $this.yBucketMultiplier / height);
                ConcurrentHashMap[][] buckets = (ConcurrentHashMap[][])Array$.MODULE$.fill(xSize, ySize, (Function0 & Serializable)() -> new ConcurrentHashMap(), ClassTag$.MODULE$.apply(ConcurrentHashMap.class));
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Creating tier for size ({} {}) with buckets [{}x{}]", new Object[]{BoxesRunTime.boxToDouble((double)width), BoxesRunTime.boxToDouble((double)height), BoxesRunTime.boxToInteger((int)xSize), BoxesRunTime.boxToInteger((int)ySize)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new Tier(this, width, height, buckets, new GridSnap($this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents, xSize, ySize));
            }
            throw new MatchError((Object)tuple2);
        });
        Statics.releaseFence();
    }

    private class Tier {
        private final double maxSizeX;
        private final double maxSizeY;
        public final ConcurrentHashMap<String, T>[][] org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets;
        private final GridSnap gridSnap;
        private volatile boolean empty;
        private final int maxX;
        private final int maxY;
        public final /* synthetic */ SizeSeparatedBucketIndex $outer;

        public double maxSizeX() {
            return this.maxSizeX;
        }

        public double maxSizeY() {
            return this.maxSizeY;
        }

        public boolean empty() {
            return this.empty;
        }

        public void empty_$eq(boolean x$1) {
            this.empty = x$1;
        }

        private int maxX() {
            return this.maxX;
        }

        private int maxY() {
            return this.maxY;
        }

        public ConcurrentHashMap<String, T> bucket(double x, double y) {
            return this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(x)][this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(y)];
        }

        public ConcurrentHashMap<String, T> bucket(Envelope envelope) {
            return this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX((envelope.getMinX() + envelope.getMaxX()) / 2.0)][this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY((envelope.getMinY() + envelope.getMaxY()) / 2.0)];
        }

        public Iterator<T> iterator(double xmin, double ymin, double xmax, double ymax) {
            if (this.empty()) {
                return package$.MODULE$.Iterator().empty();
            }
            return new TierIterator(xmin, ymin, xmax, ymax);
        }

        public int size() {
            if (this.empty()) {
                return 0;
            }
            int size = 0;
            for (int i = 0; i <= this.maxX(); ++i) {
                for (int j = 0; j <= this.maxY(); ++j) {
                    size += this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[i][j].size();
                }
            }
            return size;
        }

        public void clear() {
            for (int i = 0; i <= this.maxX(); ++i) {
                for (int j = 0; j <= this.maxY(); ++j) {
                    this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[i][j].clear();
                }
            }
        }

        public int org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(double x) {
            int i = this.gridSnap.i(x);
            if (i != -1) {
                return i;
            }
            if (x < this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinX()) {
                return 0;
            }
            return this.maxX();
        }

        public int org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(double y) {
            int j = this.gridSnap.j(y);
            if (j != -1) {
                return j;
            }
            if (y < this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinY()) {
                return 0;
            }
            return this.maxY();
        }

        public /* synthetic */ SizeSeparatedBucketIndex org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer() {
            return this.$outer;
        }

        public Tier(SizeSeparatedBucketIndex $outer, double maxSizeX, double maxSizeY, ConcurrentHashMap<String, T>[][] buckets, GridSnap gridSnap) {
            this.maxSizeX = maxSizeX;
            this.maxSizeY = maxSizeY;
            this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets = buckets;
            this.gridSnap = gridSnap;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.empty = true;
            this.maxX = buckets.length - 1;
            this.maxY = buckets[0].length - 1;
        }

        public class TierIterator
        implements Iterator<T> {
            private final int maxi;
            private final int minj;
            private final int maxj;
            private int i;
            private int j;
            private java.util.Iterator<T> iter;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<T> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<T> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B$> Iterator<B$> scanLeft(B$ z, Function2<B$, T, B$> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B$> Iterator<B$> scanRight(B$ z, Function2<T, B$, B$> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<T, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<T> filterImpl(Function1<T, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<T> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B$> Iterator<T> distinctBy(Function1<T, B$> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<T, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B$> Iterator<B$> flatten(Function1<T, IterableOnce<B$>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<T> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<T> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<T> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B$> Iterator<Tuple2<T, B$>> zip(IterableOnce<B$> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<T> tapEach(Function1<T, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<T> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<T, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<T, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<T> find(Function1<T, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B$> B$ foldLeft(B$ z, Function2<B$, T, B$> op) {
                return (B$)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B$> B$ foldRight(B$ z, Function2<T, B$, B$> op) {
                return (B$)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B$> B$ $div$colon(B$ z, Function2<B$, T, B$> op) {
                return (B$)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B$> B$ $colon$bslash(B$ z, Function2<T, B$, B$> op) {
                return (B$)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public <B> T min(Ordering<B> ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, ord);
            }

            public <B> Option<T> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public <B> T max(Ordering<B> ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, ord);
            }

            public <B> Option<T> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public <B$> T maxBy(Function1<T, B$> f, Ordering<B$> cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, f, cmp);
            }

            public <B$> Option<T> maxByOption(Function1<T, B$> f, Ordering<B$> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B$> T minBy(Function1<T, B$> f, Ordering<B$> cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, f, cmp);
            }

            public <B$> Option<T> minByOption(Function1<T, B$> f, Ordering<B$> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B$> Option<B$> collectFirst(PartialFunction<T, B$> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B$> B$ aggregate(Function0<B$> z, Function2<B$, T, B$> seqop, Function2<B$, B$, B$> combop) {
                return (B$)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B$> boolean corresponds(IterableOnce<B$> that, Function2<T, B$, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<T, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<T> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<T> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<T> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<T, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<T> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<T> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<T> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<T, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private int maxi() {
                return this.maxi;
            }

            private int minj() {
                return this.minj;
            }

            private int maxj() {
                return this.maxj;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            private int j() {
                return this.j;
            }

            private void j_$eq(int x$1) {
                this.j = x$1;
            }

            private java.util.Iterator<T> iter() {
                return this.iter;
            }

            private void iter_$eq(java.util.Iterator<T> x$1) {
                this.iter = x$1;
            }

            public final boolean hasNext() {
                boolean bl;
                block5: {
                    block4: {
                        while (!this.iter().hasNext()) {
                            if (this.i() == this.maxi() && this.j() == this.maxj()) {
                                if (false) break;
                                break block4;
                            }
                            if (this.j() < this.maxj()) {
                                this.j_$eq(this.j() + 1);
                            } else {
                                this.j_$eq(this.minj());
                                this.i_$eq(this.i() + 1);
                            }
                            this.iter_$eq(this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$TierIterator$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.i()][this.j()].values().iterator());
                        }
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                return bl;
            }

            public T next() {
                return this.iter().next();
            }

            public /* synthetic */ Tier org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$TierIterator$$$outer() {
                return Tier.this;
            }

            public TierIterator(double xmin, double ymin, double xmax, double ymax) {
                if (Tier.this == null) {
                    throw null;
                }
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.maxi = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(xmax + Tier.this.maxSizeX());
                this.minj = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(ymin - Tier.this.maxSizeY());
                this.maxj = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(ymax + Tier.this.maxSizeY());
                this.i = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(xmin - Tier.this.maxSizeX());
                this.j = this.minj();
                this.iter = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.i()][this.j()].values().iterator();
            }
        }
    }
}

