/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u001d4A!\u0005\n\u0001;!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!1\u0004A!A!\u0002\u0013\u0019\u0004\"B\u001c\u0001\t\u0003A\u0004b\u0002 \u0001\u0005\u0004%Ia\u0010\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u0018\t\u000f\u0005\u0003\u0001\u0019!C\u0005\u0005\"9a\t\u0001a\u0001\n\u00139\u0005BB'\u0001A\u0003&1\tC\u0004O\u0001\u0001\u0007I\u0011B(\t\u000fM\u0003\u0001\u0019!C\u0005)\"1a\u000b\u0001Q!\nACQ!\u0011\u0001\u0005\u0002]CQA\u0017\u0001\u0005\u0002mCQ\u0001\u0019\u0001\u0005\u0002=CQ!\u0019\u0001\u0005\u0002\t\u0014\u0011CR5mKNK'0Z#ti&l\u0017\r^8s\u0015\t\u0019B#\u0001\u0002j_*\u0011QCF\u0001\u0006kRLGn\u001d\u0006\u0003/a\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u001a5\u0005aAn\\2bi&|g\u000e^3dQ*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013-\u001b\u00051#BA\u0014)\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI#&\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0013aA2p[&\u0011QF\n\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004uCJ<W\r\u001e\t\u0003?AJ!!\r\u0011\u0003\t1{gnZ\u0001\u0006KJ\u0014xN\u001d\t\u0003?QJ!!\u000e\u0011\u0003\u000b\u0019cw.\u0019;\u00021\u0015\u001cH/[7bi\u0016$')\u001f;fgB+'OR3biV\u0014X-\u0001\u0004=S:LGO\u0010\u000b\u0005smbT\b\u0005\u0002;\u00015\t!\u0003C\u0003/\t\u0001\u0007q\u0006C\u00033\t\u0001\u00071\u0007C\u00037\t\u0001\u00071'A\u0005uQJ,7\u000f[8mIV\tq&\u0001\u0006uQJ,7\u000f[8mI\u0002\n\u0001\"Z:uS6\fG/Z\u000b\u0002\u0007B\u0011q\u0004R\u0005\u0003\u000b\u0002\u0012a\u0001R8vE2,\u0017\u0001D3ti&l\u0017\r^3`I\u0015\fHC\u0001%L!\ty\u0012*\u0003\u0002KA\t!QK\\5u\u0011\u001da\u0005\"!AA\u0002\r\u000b1\u0001\u001f\u00132\u0003%)7\u000f^5nCR,\u0007%A\bva\u0012\fG/\u001a3FgRLW.\u0019;f+\u0005\u0001\u0006cA\u0010Rg%\u0011!\u000b\t\u0002\u0007\u001fB$\u0018n\u001c8\u0002'U\u0004H-\u0019;fI\u0016\u001bH/[7bi\u0016|F%Z9\u0015\u0005!+\u0006b\u0002'\f\u0003\u0003\u0005\r\u0001U\u0001\u0011kB$\u0017\r^3e\u000bN$\u0018.\\1uK\u0002\"\"a\f-\t\u000bek\u0001\u0019A\u0018\u0002\u000f]\u0014\u0018\u000e\u001e;f]\u00061Q\u000f\u001d3bi\u0016$2\u0001\u0013/_\u0011\u0015if\u00021\u00010\u0003\u0011\u0019\u0018N_3\t\u000b}s\u0001\u0019A\u0018\u0002\u000b\r|WO\u001c;\u0002%\u001d,GOQ=uKN\u0004VM\u001d$fCR,(/Z\u0001\u0005I>tW\r\u0006\u0002dMB\u0011q\u0004Z\u0005\u0003K\u0002\u0012qAQ8pY\u0016\fg\u000eC\u0003^!\u0001\u0007q\u0006")
public class FileSizeEstimator
implements LazyLogging {
    private final long target;
    private final long threshold;
    private double estimate;
    private Option<Object> updatedEstimate;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        FileSizeEstimator fileSizeEstimator = this;
        synchronized (fileSizeEstimator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private long threshold() {
        return this.threshold;
    }

    private double estimate() {
        return this.estimate;
    }

    private void estimate_$eq(double x$1) {
        this.estimate = x$1;
    }

    private Option<Object> updatedEstimate() {
        return this.updatedEstimate;
    }

    private void updatedEstimate_$eq(Option<Object> x$1) {
        this.updatedEstimate = x$1;
    }

    public long estimate(long written) {
        return package$.MODULE$.max(1L, package$.MODULE$.round((double)(this.target - written) / this.estimate()));
    }

    public void update(long size, long count) {
        BoxedUnit boxedUnit;
        if (size > 0L && count > 0L && package$.MODULE$.abs(size - this.target) > this.threshold()) {
            BoxedUnit boxedUnit2;
            double update = (double)size / (double)count;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Updating bytesPerFeature from {} to {} based on writing {} features in {} bytes", new Object[]{BoxesRunTime.boxToDouble((double)this.estimate()), BoxesRunTime.boxToDouble((double)update), BoxesRunTime.boxToLong((long)count), BoxesRunTime.boxToLong((long)size)});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.estimate_$eq(update);
            this.updatedEstimate_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)((float)this.estimate()))));
            return;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Not updating bytesPerFeature from {} based on writing {} features in {} bytes", new Object[]{BoxesRunTime.boxToDouble((double)this.estimate()), BoxesRunTime.boxToLong((long)count), BoxesRunTime.boxToLong((long)size)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<Object> getBytesPerFeature() {
        return this.updatedEstimate();
    }

    public boolean done(long size) {
        return size > this.target || package$.MODULE$.abs(size - this.target) < this.threshold();
    }

    public FileSizeEstimator(long target, float error, float estimatedBytesPerFeature) {
        this.target = target;
        LazyLogging.$init$((LazyLogging)this);
        Predef$.MODULE$.require(error >= 0.0f && error < 1.0f, (Function0 & Serializable)() -> "Error must be a percentage between [0,1)");
        this.threshold = package$.MODULE$.round((double)target * (double)error);
        this.estimate = estimatedBytesPerFeature;
        this.updatedEstimate = None$.MODULE$;
    }
}

