/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.locationtech.geomesa.utils.io.CompressionUtils;
import org.locationtech.geomesa.utils.io.CompressionUtils$;
import org.locationtech.geomesa.utils.io.PathUtils;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class PathUtils$
implements FileSystemDelegate {
    public static final PathUtils$ MODULE$ = new PathUtils$();
    private static final Pattern uriRegex;
    private static final LocalDelegate localDelegate;
    private static final FileSystemDelegate hadoopDelegate;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        uriRegex = Pattern.compile("\\w+://.*");
        localDelegate = new LocalDelegate();
        hadoopDelegate = (FileSystemDelegate)Try$.MODULE$.apply((Function0 & Serializable)() -> Class.forName("org.locationtech.geomesa.utils.hadoop.HadoopDelegate").newInstance()).getOrElse((Function0 & Serializable)() -> null);
    }

    private Logger logger$lzycompute() {
        PathUtils$ pathUtils$ = this;
        synchronized (pathUtils$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private Pattern uriRegex() {
        return uriRegex;
    }

    private LocalDelegate localDelegate() {
        return localDelegate;
    }

    private FileSystemDelegate hadoopDelegate() {
        return hadoopDelegate;
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        return this.chooseDelegate(path).interpretPath(path);
    }

    @Override
    public FileSystemDelegate.FileHandle getHandle(String path) {
        return this.chooseDelegate(path).getHandle(path);
    }

    @Override
    public URL getUrl(String path) {
        return this.chooseDelegate(path).getUrl(path);
    }

    public boolean isRemote(String path) {
        return this.uriRegex().matcher(path).matches() && !path.toLowerCase().startsWith("file://");
    }

    public String getUncompressedExtension(String path) {
        return FilenameUtils.getExtension((String)CompressionUtils$.MODULE$.getUncompressedFilename(path));
    }

    public Tuple2<String, String> getBaseNameAndExtension(String path, boolean includeDot) {
        int split = FilenameUtils.indexOfExtension((String)path);
        if (split == -1) {
            return new Tuple2((Object)path, (Object)"");
        }
        String withoutExtension = path.substring(0, split);
        int secondSplit = FilenameUtils.indexOfExtension((String)withoutExtension);
        if (secondSplit != -1 && CompressionUtils$.MODULE$.isCompressedFilename(path)) {
            return new Tuple2((Object)path.substring(0, secondSplit), (Object)path.substring(PathUtils$.dotIndex$1(secondSplit, includeDot)));
        }
        return new Tuple2((Object)withoutExtension, (Object)path.substring(PathUtils$.dotIndex$1(split, includeDot)));
    }

    public boolean getBaseNameAndExtension$default$2() {
        return true;
    }

    public InputStream handleCompression(InputStream is, String filename) {
        BufferedInputStream buffered = new BufferedInputStream(is);
        Option option = CompressionUtils$.MODULE$.Utils().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isCompressedFilename(filename)));
        if (None$.MODULE$.equals(option)) {
            return buffered;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            CompressionUtils utils = (CompressionUtils)some.value();
            return utils.compress(buffered);
        }
        throw new MatchError((Object)option);
    }

    public void deleteRecursively(Path path) {
        Files.walkFileTree(path, new PathUtils.DeleteFileVisitor());
    }

    private FileSystemDelegate chooseDelegate(String path) {
        if (this.hadoopDelegate() != null && this.uriRegex().matcher(path).matches()) {
            return this.hadoopDelegate();
        }
        return this.localDelegate();
    }

    private static final int dotIndex$1(int base, boolean includeDot$1) {
        if (includeDot$1) {
            return base;
        }
        return base + 1;
    }

    private PathUtils$() {
    }
}

