/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io.fs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate$CreateMode$;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate$;
import org.locationtech.geomesa.utils.io.fs.package;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001B\u0016-\u0001eBQA\u0014\u0001\u0005\u0002=CQ!\u0015\u0001\u0005BICQa\u001d\u0001\u0005BQDaa \u0001\u0005B\u0005\u0005\u0001bBA\u000b\u0001\u0011%\u0011qC\u0004\b\u0003Oa\u0003\u0012AA\u0015\r\u0019YC\u0006#\u0001\u0002,!1aj\u0002C\u0001\u0003[A\u0011\"a\f\b\u0005\u0004%I!!\r\t\u0011\u0005-s\u0001)A\u0005\u0003g1a!!\u0014\b\u0001\u0005=\u0003BCA\u000e\u0017\t\u0005\t\u0015!\u0003\u0002\u001e!1aj\u0003C\u0001\u0003#BaA[\u0006\u0005B\u0005e\u0003bBA.\u0017\u0011\u0005\u0013Q\f\u0005\b\u0003KZA\u0011IA4\u0011\u001d\tyg\u0003C!\u0003cBq!!%\f\t\u0003\n\u0019\nC\u0004\u0002*.!\t%a+\u0007\r\u0005]v\u0001AA]\u0011)\tY\u0002\u0006B\u0001B\u0003%\u0011Q\u0004\u0005\u0007\u001dR!\t!a/\t\u000f\u0005=D\u0003\"\u0011\u0002r!9\u0011\u0011\u0013\u000b\u0005B\u0005\u0005gABAd\u000f\u0001\tI\r\u0003\u0006\u0002\u001ce\u0011\t\u0011)A\u0005\u0003;AaAT\r\u0005\u0002\u0005-\u0007bBA83\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003#KB\u0011IAi\r\u0019\t9n\u0002\u0001\u0002Z\"1aJ\bC\u0001\u00037DaA\u001b\u0010\u0005B\u0005e\u0003bBA.=\u0011\u0005\u0013Q\f\u0005\b\u0003KrB\u0011IA4\u0011\u001d\tyG\bC!\u0003cBq!!%\u001f\t\u0003\ny\u000eC\u0004\u0002*z!\t%!:\b\u000f\u0005-x\u0001#\u0001\u0002n\u001a9\u0011q[\u0004\t\u0002\u0005=\bB\u0002((\t\u0003\t\t\u0010C\u0004\u0002t\u001e\"\t!!>\t\u000f\u0005ex\u0005\"\u0001\u0002^\tiAj\\2bY\u0012+G.Z4bi\u0016T!!\f\u0018\u0002\u0005\u0019\u001c(BA\u00181\u0003\tIwN\u0003\u00022e\u0005)Q\u000f^5mg*\u00111\u0007N\u0001\bO\u0016|W.Z:b\u0015\t)d'\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u00018\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\b\u0011#\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g!\t\t%)D\u0001-\u0013\t\u0019EF\u0001\nGS2,7+_:uK6$U\r\\3hCR,\u0007CA#M\u001b\u00051%BA$I\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI%*\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0015aA2p[&\u0011QJ\u0012\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002!B\u0011\u0011\tA\u0001\nO\u0016$\b*\u00198eY\u0016$\"aU5\u0011\u0005Q3gBA+e\u001d\t16M\u0004\u0002XE:\u0011\u0001,\u0019\b\u00033\u0002t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005uC\u0014A\u0002\u001fs_>$h(C\u00018\u0013\t)d'\u0003\u00024i%\u0011\u0011GM\u0005\u0003_AJ!!\f\u0018\n\u0005\u0015d\u0013A\u0005$jY\u0016\u001c\u0016p\u001d;f[\u0012+G.Z4bi\u0016L!a\u001a5\u0003\u0015\u0019KG.\u001a%b]\u0012dWM\u0003\u0002fY!)!N\u0001a\u0001W\u0006!\u0001/\u0019;i!\ta\u0007O\u0004\u0002n]B\u00111\fP\u0005\u0003_r\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011q\u000eP\u0001\u000eS:$XM\u001d9sKR\u0004\u0016\r\u001e5\u0015\u0005Ut\bc\u0001<|':\u0011q/\u001f\b\u00037bL\u0011!P\u0005\u0003ur\nq\u0001]1dW\u0006<W-\u0003\u0002}{\n\u00191+Z9\u000b\u0005id\u0004\"\u00026\u0004\u0001\u0004Y\u0017AB4fiV\u0013H\u000e\u0006\u0003\u0002\u0004\u0005M\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0004]\u0016$(BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u0011q\u0001\u0002\u0004+Jc\u0005\"\u00026\u0005\u0001\u0004Y\u0017\u0001D2sK\u0006$X\rS1oI2,GcA*\u0002\u001a!9\u00111D\u0003A\u0002\u0005u\u0011\u0001\u00024jY\u0016\u0004B!a\b\u0002$5\u0011\u0011\u0011\u0005\u0006\u0004_\u0005-\u0011\u0002BA\u0013\u0003C\u0011AAR5mK\u0006iAj\\2bY\u0012+G.Z4bi\u0016\u0004\"!Q\u0004\u0014\u0005\u001dQDCAA\u0015\u0003\u001d1\u0017m\u0019;pef,\"!a\r\u0011\t\u0005U\u0012qI\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005I\u0011M]2iSZ,'o\u001d\u0006\u0005\u0003{\ty$\u0001\u0005d_6\u0004(/Z:t\u0015\u0011\t\t%a\u0011\u0002\u000f\r|W.\\8og*\u0019\u0011Q\t\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\tI%a\u000e\u0003)\u0005\u00138\r[5wKN#(/Z1n\r\u0006\u001cGo\u001c:z\u0003!1\u0017m\u0019;pef\u0004#a\u0004'pG\u0006dg)\u001b7f\u0011\u0006tG\r\\3\u0014\u0007-Q4\u000b\u0006\u0003\u0002T\u0005]\u0003cAA+\u00175\tq\u0001C\u0004\u0002\u001c5\u0001\r!!\b\u0016\u0003-\fa!\u001a=jgR\u001cXCAA0!\rY\u0014\u0011M\u0005\u0004\u0003Gb$a\u0002\"p_2,\u0017M\\\u0001\u0007Y\u0016tw\r\u001e5\u0016\u0005\u0005%\u0004cA\u001e\u0002l%\u0019\u0011Q\u000e\u001f\u0003\t1{gnZ\u0001\u0005_B,g.\u0006\u0002\u0002tA1\u0011QOA>\u0003\u007fj!!a\u001e\u000b\u0007\u0005e\u0004'\u0001\u0006d_2dWm\u0019;j_:LA!! \u0002x\t\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\u000fm\n\t)!\"\u0002\f&\u0019\u00111\u0011\u001f\u0003\rQ+\b\u000f\\33!\u0011Y\u0014qQ6\n\u0007\u0005%EH\u0001\u0004PaRLwN\u001c\t\u0005\u0003?\ti)\u0003\u0003\u0002\u0010\u0006\u0005\"aC%oaV$8\u000b\u001e:fC6\fQa\u001e:ji\u0016$b!!&\u0002\u001c\u0006\u0015\u0006\u0003BA\u0010\u0003/KA!!'\u0002\"\taq*\u001e;qkR\u001cFO]3b[\"9\u0011Q\u0014\nA\u0002\u0005}\u0015\u0001B7pI\u0016\u00042\u0001VAQ\u0013\r\t\u0019\u000b\u001b\u0002\u000b\u0007J,\u0017\r^3N_\u0012,\u0007\"CAT%A\u0005\t\u0019AA0\u00035\u0019'/Z1uKB\u000b'/\u001a8ug\u00061A-\u001a7fi\u0016$B!!,\u00024B\u00191(a,\n\u0007\u0005EFH\u0001\u0003V]&$\b\"CA['A\u0005\t\u0019AA0\u0003%\u0011XmY;sg&4XM\u0001\bM_\u000e\fGNW5q\u0011\u0006tG\r\\3\u0014\u0007Q\t\u0019\u0006\u0006\u0003\u0002>\u0006}\u0006cAA+)!9\u00111\u0004\fA\u0002\u0005uACBAK\u0003\u0007\f)\rC\u0004\u0002\u001eb\u0001\r!a(\t\u0013\u0005\u001d\u0006\u0004%AA\u0002\u0005}#A\u0004'pG\u0006dG+\u0019:IC:$G.Z\n\u00043\u0005MC\u0003BAg\u0003\u001f\u00042!!\u0016\u001a\u0011\u001d\tYb\u0007a\u0001\u0003;!b!!&\u0002T\u0006U\u0007bBAO;\u0001\u0007\u0011q\u0014\u0005\n\u0003Ok\u0002\u0013!a\u0001\u0003?\u00121b\u0015;e\u0013:D\u0015M\u001c3mKN\u0019aDO*\u0015\u0005\u0005u\u0007cAA+=Q1\u0011QSAq\u0003GDq!!(%\u0001\u0004\ty\nC\u0005\u0002(\u0012\u0002\n\u00111\u0001\u0002`Q!\u0011QVAt\u0011%\tI/\nI\u0001\u0002\u0004\ty&\u0001\u0005sK\u000e,8/\u001b<f\u0003-\u0019F\u000fZ%o\u0011\u0006tG\r\\3\u0011\u0007\u0005Use\u0005\u0002(uQ\u0011\u0011Q^\u0001\nCZ\f\u0017\u000e\\1cY\u0016$\"!a>\u0011\tm\n9iU\u0001\fSN\fe/Y5mC\ndW\r")
public class LocalDelegate
implements FileSystemDelegate {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        LocalDelegate localDelegate = this;
        synchronized (localDelegate) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public FileSystemDelegate.FileHandle getHandle(String path) {
        return this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(new File(path));
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        Tuple2 tuple2;
        int firstWildcard = path.indexOf(42);
        if (firstWildcard == -1) {
            File file = new File(path);
            if (file.isDirectory()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Input file is a directory: {}", (Object)file.getAbsolutePath());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return (Seq)package$.MODULE$.Seq().empty();
            }
            return new .colon.colon((Object)this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file), (List)Nil$.MODULE$);
        }
        int lastSep = path.length() - 1 - StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(path)).indexOf(47, path.length() - firstWildcard - 1);
        Tuple2 tuple22 = tuple2 = lastSep == path.length() ? new Tuple2((Object)new File(".").toPath(), (Object)path) : new Tuple2((Object)new File(path.substring(0, lastSep)).toPath(), (Object)path.substring(lastSep + 1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path basepath = (Path)tuple2._1();
        String glob = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)basepath, (Object)glob);
        Path basepath2 = (Path)tuple23._1();
        String glob2 = (String)tuple23._2();
        if (glob2.indexOf(47) == -1 && !glob2.contains("**")) {
            return (Seq)package$WithClose$.MODULE$.apply(Files.newDirectoryStream(basepath2, glob2), (Function1 & Serializable)stream -> ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)stream).asScala()).toList().flatMap((Function1 & Serializable)p -> {
                File file = p.toFile();
                if (file.isDirectory()) {
                    return Nil$.MODULE$;
                }
                return new .colon.colon((Object)this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file), (List)Nil$.MODULE$);
            }), IsCloseable$.MODULE$.closeableIsCloseable());
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(new StringBuilder(5).append("glob:").append(glob2).toString());
        ArrayBuffer result = ArrayBuffer$.MODULE$.empty();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(this, matcher, result){
            private final /* synthetic */ LocalDelegate $outer;
            private final PathMatcher matcher$1;
            private final ArrayBuffer result$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Object object = this.matcher$1.matches(file) && attributes.isRegularFile() && !attributes.isDirectory() ? this.result$1.$plus$eq((Object)this.$outer.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file.toFile())) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.matcher$1 = matcher$1;
                this.result$1 = result$1;
            }
        };
        Files.walkFileTree(basepath2, (FileVisitor<? super Path>)visitor);
        return result.toSeq();
    }

    @Override
    public URL getUrl(String path) {
        return new File(path).toURI().toURL();
    }

    public FileSystemDelegate.FileHandle org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(File file) {
        block8: {
            String string = PathUtils$.MODULE$.getUncompressedExtension(file.getName()).toLowerCase(Locale.US);
            switch (string == null ? 0 : string.hashCode()) {
                case 104987: {
                    if ("jar".equals(string)) {
                        break;
                    }
                    break block8;
                }
                case 114597: {
                    if ("tar".equals(string)) {
                        return new LocalTarHandle(file);
                    }
                    break block8;
                }
                case 120609: {
                    if ("zip".equals(string)) {
                        break;
                    }
                    break block8;
                }
                default: {
                    break block8;
                }
            }
            return new LocalZipHandle(file);
        }
        return new LocalFileHandle(file);
    }

    public LocalDelegate() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class LocalFileHandle
    implements FileSystemDelegate.FileHandle {
        private final File file;
        private String format;
        private volatile boolean bitmap$0;

        @Override
        public boolean write$default$2() {
            return FileSystemDelegate.FileHandle.write$default$2$(this);
        }

        @Override
        public boolean delete$default$1() {
            return FileSystemDelegate.FileHandle.delete$default$1$(this);
        }

        private String format$lzycompute() {
            LocalFileHandle localFileHandle = this;
            synchronized (localFileHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate.FileHandle.format$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.format;
        }

        @Override
        public String format() {
            if (!this.bitmap$0) {
                return this.format$lzycompute();
            }
            return this.format;
        }

        @Override
        public String path() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream is = PathUtils$.MODULE$.handleCompression(new FileInputStream(this.file), this.file.getName());
            return CloseableIterator$.MODULE$.single(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)is), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> is.close());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            FileSystemDelegate$CreateMode$.MODULE$.validate$extension(mode);
            if (this.file.exists()) {
                if (FileSystemDelegate$CreateMode$.MODULE$.append$extension(mode)) {
                    return new FileOutputStream(this.file, true);
                }
                if (FileSystemDelegate$CreateMode$.MODULE$.overwrite$extension(mode)) {
                    return new FileOutputStream(this.file, false);
                }
                throw new FileAlreadyExistsException(new StringBuilder(39).append("File already exists for mode 'create': ").append(this.path()).toString());
            }
            if (!FileSystemDelegate$CreateMode$.MODULE$.create$extension(mode)) {
                throw new FileNotFoundException(new StringBuilder(21).append("File does not exist: ").append(this.path()).toString());
            }
            File parent = this.file.getParentFile();
            if (parent != null && !parent.exists()) {
                if (!createParents) {
                    throw new FileNotFoundException(new StringBuilder(28).append("Parent file does not exist: ").append(this.path()).toString());
                }
                if (!parent.mkdirs()) {
                    throw new IOException(new StringBuilder(53).append("Parent file does not exist and could not be created: ").append(this.path()).toString());
                }
            }
            return new FileOutputStream(this.file);
        }

        @Override
        public void delete(boolean recursive) {
            if (recursive) {
                PathUtils$.MODULE$.deleteRecursively(this.file.toPath());
                return;
            }
            if (!this.file.delete()) {
                throw new IOException(new StringBuilder(23).append("Could not delete file: ").append(this.path()).toString());
            }
        }

        public LocalFileHandle(File file) {
            this.file = file;
            FileSystemDelegate.FileHandle.$init$(this);
        }
    }

    public static class LocalTarHandle
    extends LocalFileHandle {
        private final File file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream uncompressed = PathUtils$.MODULE$.handleCompression(new FileInputStream(this.file), this.file.getName());
            ArchiveInputStream archive = LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveInputStream("tar", uncompressed);
            return new package.ArchiveFileIterator(archive, this.file.getAbsolutePath());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveOutputStream("tar", super.write(mode, createParents));
        }

        public LocalTarHandle(File file) {
            this.file = file;
            super(file);
        }
    }

    public static class LocalZipHandle
    extends LocalFileHandle {
        private final File file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            return new package.ZipFileIterator(new ZipFile(this.file), this.file.getAbsolutePath());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveOutputStream("zip", super.write(mode, createParents));
        }

        public LocalZipHandle(File file) {
            this.file = file;
            super(file);
        }
    }

    public static class StdInHandle
    implements FileSystemDelegate.FileHandle {
        private String format;
        private volatile boolean bitmap$0;

        @Override
        public boolean write$default$2() {
            return FileSystemDelegate.FileHandle.write$default$2$(this);
        }

        @Override
        public boolean delete$default$1() {
            return FileSystemDelegate.FileHandle.delete$default$1$(this);
        }

        private String format$lzycompute() {
            StdInHandle stdInHandle = this;
            synchronized (stdInHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate.FileHandle.format$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.format;
        }

        @Override
        public String format() {
            if (!this.bitmap$0) {
                return this.format$lzycompute();
            }
            return this.format;
        }

        @Override
        public String path() {
            return "<stdin>";
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public long length() {
            return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> System.in.available()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            return CloseableIterator$.MODULE$.single(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)System.in), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> CloseableIterator$.MODULE$.single$default$2());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return System.out;
        }

        @Override
        public void delete(boolean recusive) {
        }

        public StdInHandle() {
            FileSystemDelegate.FileHandle.$init$(this);
        }
    }
}

