/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.iterators;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.iterators.PlaybackIterator$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.temporal.During;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tUe\u0001B\u001e=\u0001\u001dC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tc\u0002\u0011\t\u0011)A\u0005e\"AQ\u0010\u0001B\u0001B\u0003%a\u0010\u0003\u0006\u0002\u0014\u0001\u0011\t\u0011)A\u0005\u0003+A!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\tI\u0003\u0001B\u0001B\u0003%\u00111\u0006\u0005\u000b\u0003c\u0001!\u0011!Q\u0001\n\u0005M\u0002BCA#\u0001\t\u0005\t\u0015!\u0003\u0002H!Q\u0011Q\n\u0001\u0003\u0002\u0003\u0006I!a\u0014\t\u0015\u0005U\u0003A!A!\u0002\u0013\t9\u0006C\u0004\u0002^\u0001!\t!a\u0018\t\u0013\u0005e\u0004A1A\u0005\n\u0005m\u0004\u0002CAB\u0001\u0001\u0006I!! \t\u0013\u0005\u0015\u0005A1A\u0005\n\u0005\u001d\u0005bBAE\u0001\u0001\u0006IA\u001d\u0005\n\u0003\u0017\u0003!\u0019!C\u0005\u0003\u001bC\u0001\"a$\u0001A\u0003%\u00111\u0006\u0005\n\u0003#\u0003!\u0019!C\u0005\u0003'C\u0001\"!&\u0001A\u0003%\u0011q\u000b\u0005\n\u0003/\u0003!\u0019!C\u0005\u00033C\u0001\"a*\u0001A\u0003%\u00111\u0014\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003WC\u0001\"a.\u0001A\u0003%\u0011Q\u0016\u0005\n\u0003s\u0003!\u0019!C\u0005\u0003wC\u0001\"a1\u0001A\u0003%\u0011Q\u0018\u0005\n\u0003\u000b\u0004\u0001\u0019!C\u0005\u0003wC\u0011\"a2\u0001\u0001\u0004%I!!3\t\u0011\u0005U\u0007\u0001)Q\u0005\u0003{C\u0011\"a6\u0001\u0001\u0004%I!a/\t\u0013\u0005e\u0007\u00011A\u0005\n\u0005m\u0007\u0002CAp\u0001\u0001\u0006K!!0\t\u0013\u0005\u0005\bA1A\u0005\n\u0005\r\b\u0002CAx\u0001\u0001\u0006I!!:\t\u0017\u0005E\b\u00011AA\u0002\u0013%\u00111\u001f\u0005\f\u0003k\u0004\u0001\u0019!a\u0001\n\u0013\t9\u0010\u0003\u0006\u0002|\u0002\u0001\r\u0011!Q!\nQC\u0011\"!@\u0001\u0005\u0004%I!a@\t\u0011\t\u001d\u0001\u0001)A\u0005\u0005\u0003AqA!\u0003\u0001\t\u0003\u0012Y\u0001C\u0004\u0003\u000e\u0001!\tEa\u0004\t\u000f\tE\u0001\u0001\"\u0011\u0003\u0014\u00191!Q\u0003\u0001\u0005\u0005/Aq!!\u0018+\t\u0003\u0011Y\u0003C\u0004\u00032)\"\tEa\u0005\b\u000f\tMB\b#\u0001\u00036\u001911\b\u0010E\u0001\u0005oAq!!\u0018/\t\u0003\u0011I\u0004C\u0005\u0003<9\u0012\r\u0011\"\u0003\u0003>!A!Q\t\u0018!\u0002\u0013\u0011y\u0004C\u0005\u0003H9\u0012\r\u0011\"\u0003\u0003J!A!q\u000b\u0018!\u0002\u0013\u0011Y\u0005C\u0005\u0003Z9\n\n\u0011\"\u0001\u0003\\!I!\u0011\u000f\u0018\u0012\u0002\u0013\u0005!1\u000f\u0005\n\u0005or\u0013\u0013!C\u0001\u0005sB\u0011B! /#\u0003%\tAa \t\u0013\t\re&%A\u0005\u0002\t\u0015\u0005\"\u0003BE]E\u0005I\u0011\u0001BF\u0011%\u0011yILI\u0001\n\u0003\u0011\tJ\u0001\tQY\u0006L(-Y2l\u0013R,'/\u0019;pe*\u0011QHP\u0001\nSR,'/\u0019;peNT!a\u0010!\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0005\u0013\u0015aB4f_6,7/\u0019\u0006\u0003\u0007\u0012\u000bA\u0002\\8dCRLwN\u001c;fG\"T\u0011!R\u0001\u0004_J<7\u0001A\n\u0005\u0001!se\f\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0004B]f\u0014VM\u001a\t\u0004\u001fJ#V\"\u0001)\u000b\u0005Es\u0014AC2pY2,7\r^5p]&\u00111\u000b\u0015\u0002\u0012\u00072|7/Z1cY\u0016LE/\u001a:bi>\u0014\bCA+]\u001b\u00051&BA,Y\u0003\u0019\u0019\u0018.\u001c9mK*\u0011\u0011LW\u0001\bM\u0016\fG/\u001e:f\u0015\tYF)A\u0004pa\u0016tw-[:\n\u0005u3&!D*j[BdWMR3biV\u0014X\r\u0005\u0002`M6\t\u0001M\u0003\u0002bE\u0006a1oY1mC2|wmZ5oO*\u00111\rZ\u0001\tif\u0004Xm]1gK*\tQ-A\u0002d_6L!a\u001a1\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\t!7\u000f\u0005\u0002k_6\t1N\u0003\u0002m[\u0006!A-\u0019;b\u0015\tqG)\u0001\u0005hK>$xn\u001c7t\u0013\t\u00018NA\u0005ECR\f7\u000b^8sK\u0006AA/\u001f9f\u001d\u0006lW\r\u0005\u0002tu:\u0011A\u000f\u001f\t\u0003k*k\u0011A\u001e\u0006\u0003o\u001a\u000ba\u0001\u0010:p_Rt\u0014BA=K\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eT\u0015\u0001C5oi\u0016\u0014h/\u00197\u0011\r%{\u00181AA\u0002\u0013\r\t\tA\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!Q\u000f^5m\u0015\t\ti!\u0001\u0003kCZ\f\u0017\u0002BA\t\u0003\u000f\u0011A\u0001R1uK\u0006\u0019A\r^4\u0011\t%\u000b9B]\u0005\u0004\u00033Q%AB(qi&|g.\u0001\u0004gS2$XM\u001d\t\u0006\u0013\u0006]\u0011q\u0004\t\u0005\u0003C\t)#\u0004\u0002\u0002$)\u0019\u00111\u0004.\n\t\u0005\u001d\u00121\u0005\u0002\u0007\r&dG/\u001a:\u0002\u0015Q\u0014\u0018M\\:g_Jl7\u000f\u0005\u0003J\u0003[\u0011\u0018bAA\u0018\u0015\n)\u0011I\u001d:bs\u00061q/\u001b8e_^\u0004R!SA\f\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0005ekJ\fG/[8o\u0015\r\tyDS\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\"\u0003s\u0011\u0001\u0002R;sCRLwN\\\u0001\u0005e\u0006$X\rE\u0002J\u0003\u0013J1!a\u0013K\u0005\u00151En\\1u\u0003\u0011a\u0017N^3\u0011\u0007%\u000b\t&C\u0002\u0002T)\u0013qAQ8pY\u0016\fg.A\u0005sK\u0006$\u0017\t[3bIB\u0019\u0011*!\u0017\n\u0007\u0005m#JA\u0002J]R\fa\u0001P5oSRtDCFA1\u0003K\n9'!\u001b\u0002l\u00055\u0014qNA9\u0003g\n)(a\u001e\u0011\u0007\u0005\r\u0004!D\u0001=\u0011\u0015A7\u00021\u0001j\u0011\u0015\t8\u00021\u0001s\u0011\u0015i8\u00021\u0001\u007f\u0011%\t\u0019b\u0003I\u0001\u0002\u0004\t)\u0002C\u0005\u0002\u001c-\u0001\n\u00111\u0001\u0002\u001e!I\u0011\u0011F\u0006\u0011\u0002\u0003\u0007\u00111\u0006\u0005\n\u0003cY\u0001\u0013!a\u0001\u0003gA\u0011\"!\u0012\f!\u0003\u0005\r!a\u0012\t\u0013\u000553\u0002%AA\u0002\u0005=\u0003\"CA+\u0017A\u0005\t\u0019AA,\u0003\r\u0019h\r^\u000b\u0003\u0003{\u00022!VA@\u0013\r\t\tI\u0016\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\nq\u0001\u001a;h\u001d\u0006lW-F\u0001s\u0003!!Go\u001a(b[\u0016\u0004\u0013!\u0002;eK\u001a\u001cXCAA\u0016\u0003\u0019!H-\u001a4tA\u0005AA\r^4J]\u0012,\u00070\u0006\u0002\u0002X\u0005IA\r^4J]\u0012,\u0007\u0010I\u0001\bIR<\u0007K]8q+\t\tY\n\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+a\t\u0002\u0015\u0015D\bO]3tg&|g.\u0003\u0003\u0002&\u0006}%\u0001\u0004)s_B,'\u000f^=OC6,\u0017\u0001\u00033uOB\u0013x\u000e\u001d\u0011\u0002\tM|'\u000f^\u000b\u0003\u0003[\u0003B!a,\u000246\u0011\u0011\u0011\u0017\u0006\u0005\u0003S\u000b\u0019#\u0003\u0003\u00026\u0006E&AB*peR\u0014\u00150A\u0003t_J$\b%\u0001\u0007xS:$wn^'jY2L7/\u0006\u0002\u0002>B\u0019\u0011*a0\n\u0007\u0005\u0005'J\u0001\u0003M_:<\u0017!D<j]\u0012|w/T5mY&\u001c\b%A\u0003ti\u0006\u0014H/A\u0005ti\u0006\u0014Ho\u0018\u0013fcR!\u00111ZAi!\rI\u0015QZ\u0005\u0004\u0003\u001fT%\u0001B+oSRD\u0011\"a5\u001c\u0003\u0003\u0005\r!!0\u0002\u0007a$\u0013'\u0001\u0004ti\u0006\u0014H\u000fI\u0001\u000bKZ,g\u000e^*uCJ$\u0018AD3wK:$8\u000b^1si~#S-\u001d\u000b\u0005\u0003\u0017\fi\u000eC\u0005\u0002Tz\t\t\u00111\u0001\u0002>\u0006YQM^3oiN#\u0018M\u001d;!\u0003!1W-\u0019;ve\u0016\u001cXCAAs!\u0015\t9/a;U\u001b\t\tIO\u0003\u0003\u0002@\u0005\u001d\u0011\u0002BAw\u0003S\u00141\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\f\u0011BZ3biV\u0014Xm\u001d\u0011\u0002\rM$\u0018mZ3e+\u0005!\u0016AC:uC\u001e,Gm\u0018\u0013fcR!\u00111ZA}\u0011!\t\u0019nIA\u0001\u0002\u0004!\u0016aB:uC\u001e,G\rI\u0001\tKb,7-\u001e;peV\u0011!\u0011\u0001\t\u0005\u0003O\u0014\u0019!\u0003\u0003\u0003\u0006\u0005%(aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013a\u00025bg:+\u0007\u0010^\u000b\u0003\u0003\u001f\nAA\\3yiR\tA+A\u0003dY>\u001cX\r\u0006\u0002\u0002L\ni\u0011+^3ssJ+hN\\1cY\u0016\u001cRA\u000bB\r\u0005K\u0001BAa\u0007\u0003\"5\u0011!Q\u0004\u0006\u0005\u0005?\tY!\u0001\u0003mC:<\u0017\u0002\u0002B\u0012\u0005;\u0011aa\u00142kK\u000e$\b\u0003\u0002B\u000e\u0005OIAA!\u000b\u0003\u001e\tA!+\u001e8oC\ndW\r\u0006\u0002\u0003.A\u0019!q\u0006\u0016\u000e\u0003\u0001\t1A];o\u0003A\u0001F.Y=cC\u000e\\\u0017\n^3sCR|'\u000fE\u0002\u0002d9\u001a\"A\f%\u0015\u0005\tU\u0012A\u00014g+\t\u0011y\u0004\u0005\u0003\u0002\"\t\u0005\u0013\u0002\u0002B\"\u0003G\u0011aBR5mi\u0016\u0014h)Y2u_JL('A\u0002gM\u0002\n\u0001\u0002^3s[&t\u0017\r\\\u000b\u0003\u0005\u0017\u0002BA!\u0014\u0003T5\u0011!q\n\u0006\u0004/\nE#BA-n\u0013\u0011\u0011)Fa\u0014\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u00136\u0004H.A\u0005uKJl\u0017N\\1mA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"A!\u0018+\t\u0005U!qL\u0016\u0003\u0005C\u0002BAa\u0019\u0003n5\u0011!Q\r\u0006\u0005\u0005O\u0012I'A\u0005v]\u000eDWmY6fI*\u0019!1\u000e&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003p\t\u0015$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"A!\u001e+\t\u0005u!qL\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tm$\u0006BA\u0016\u0005?\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001BAU\u0011\t\u0019Da\u0018\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u00119I\u000b\u0003\u0002H\t}\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0003\u000e*\"\u0011q\nB0\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"Aa%+\t\u0005]#q\f")
public class PlaybackIterator
implements CloseableIterator<SimpleFeature>,
StrictLogging {
    public final DataStore org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds;
    public final String org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName;
    public final Tuple2<Date, Date> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval;
    public final Option<Filter> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter;
    private final float rate;
    private final boolean live;
    private final SimpleFeatureType sft;
    private final String dtgName;
    private final String[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs;
    private final int dtgIndex;
    private final PropertyName org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp;
    private final SortBy org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort;
    private final long org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis;
    private long start;
    private long eventStart;
    private final LinkedBlockingQueue<SimpleFeature> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features;
    private SimpleFeature staged;
    private final ExecutorService executor;
    private Logger logger;

    public static int $lessinit$greater$default$10() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$9() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$9();
    }

    public static float $lessinit$greater$default$8() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Duration> $lessinit$greater$default$7() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$7();
    }

    public static String[] $lessinit$greater$default$6() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Filter> $lessinit$greater$default$5() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
        return Iterator.map$((Iterator)this, (Function1)f);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
        return Iterator.filter$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
        return Iterator.filterNot$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
        return Iterator.takeWhile$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$dropWhile(Function1 p) {
        return Iterator.dropWhile$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
        return Iterator.collect$((Iterator)this, (PartialFunction)pf);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$tapEach(Function1 f) {
        return Iterator.tapEach$((Iterator)this, (Function1)f);
    }

    @Override
    public <B$> CloseableIterator<B$> map(Function1<SimpleFeature, B$> f) {
        return CloseableIterator.map$(this, f);
    }

    @Override
    public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
        return CloseableIterator.filter$(this, p);
    }

    @Override
    public CloseableIterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
        return CloseableIterator.withFilter$(this, p);
    }

    @Override
    public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
        return CloseableIterator.filterNot$(this, p);
    }

    @Override
    public CloseableIterator<SimpleFeature> take(int n) {
        return CloseableIterator.take$(this, n);
    }

    @Override
    public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
        return CloseableIterator.takeWhile$(this, p);
    }

    @Override
    public CloseableIterator<SimpleFeature> drop(int n) {
        return CloseableIterator.drop$(this, n);
    }

    @Override
    public CloseableIterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
        return CloseableIterator.dropWhile$(this, p);
    }

    @Override
    public <B$> CloseableIterator<B$> collect(PartialFunction<SimpleFeature, B$> pf) {
        return CloseableIterator.collect$(this, pf);
    }

    @Override
    public <B> CloseableIterator<B> concat(Function0<IterableOnce<B>> xs) {
        return CloseableIterator.concat$(this, xs);
    }

    @Override
    public <B$> CloseableIterator<B$> flatMap(Function1<SimpleFeature, IterableOnce<B$>> f) {
        return CloseableIterator.flatMap$(this, f);
    }

    @Override
    public <U> CloseableIterator<SimpleFeature> tapEach(Function1<SimpleFeature, U> f) {
        return CloseableIterator.tapEach$(this, f);
    }

    public final boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public final Iterator<SimpleFeature> iterator() {
        return Iterator.iterator$((Iterator)this);
    }

    public Option<SimpleFeature> nextOption() {
        return Iterator.nextOption$((Iterator)this);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public BufferedIterator<SimpleFeature> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator<B> padTo(int len, B elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public <B$> Iterator<B$> scanLeft(B$ z, Function2<B$, SimpleFeature, B$> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B$> Iterator<B$> scanRight(B$ z, Function2<SimpleFeature, B$, B$> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public int indexWhere$default$2() {
        return Iterator.indexWhere$default$2$((Iterator)this);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public final int length() {
        return Iterator.length$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public Iterator<SimpleFeature> filterImpl(Function1<SimpleFeature, Object> p, boolean isFlipped) {
        return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
    }

    public Iterator<SimpleFeature> distinct() {
        return Iterator.distinct$((Iterator)this);
    }

    public <B$> Iterator<SimpleFeature> distinctBy(Function1<SimpleFeature, B$> f) {
        return Iterator.distinctBy$((Iterator)this, f);
    }

    public <B$> Iterator<B$> flatten(Function1<SimpleFeature, IterableOnce<B$>> ev) {
        return Iterator.flatten$((Iterator)this, ev);
    }

    public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
        return Iterator.$plus$plus$((Iterator)this, xs);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<SimpleFeature> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<SimpleFeature> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B$> Iterator<Tuple2<SimpleFeature, B$>> zip(IterableOnce<B$> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B> boolean sameElements(IterableOnce<B> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public Iterator<SimpleFeature> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> splitAt(int n) {
        return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
    }

    public boolean isTraversableAgain() {
        return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
    }

    public <U> void foreach(Function1<SimpleFeature, U> f) {
        IterableOnceOps.foreach$((IterableOnceOps)this, f);
    }

    public boolean forall(Function1<SimpleFeature, Object> p) {
        return IterableOnceOps.forall$((IterableOnceOps)this, p);
    }

    public boolean exists(Function1<SimpleFeature, Object> p) {
        return IterableOnceOps.exists$((IterableOnceOps)this, p);
    }

    public int count(Function1<SimpleFeature, Object> p) {
        return IterableOnceOps.count$((IterableOnceOps)this, p);
    }

    public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
        return IterableOnceOps.find$((IterableOnceOps)this, p);
    }

    public <B$> B$ foldLeft(B$ z, Function2<B$, SimpleFeature, B$> op) {
        return (B$)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
    }

    public <B$> B$ foldRight(B$ z, Function2<SimpleFeature, B$, B$> op) {
        return (B$)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
    }

    public final <B$> B$ $div$colon(B$ z, Function2<B$, SimpleFeature, B$> op) {
        return (B$)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
    }

    public final <B$> B$ $colon$bslash(B$ z, Function2<SimpleFeature, B$, B$> op) {
        return (B$)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
    }

    public <B> B reduce(Function2<B, B, B> op) {
        return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceOption(Function2<B, B, B> op) {
        return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
    }

    public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
        return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
    }

    public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
        return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
        return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
        return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
    }

    public boolean nonEmpty() {
        return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
    }

    public int size() {
        return IterableOnceOps.size$((IterableOnceOps)this);
    }

    public final <B> void copyToBuffer(Buffer<B> dest) {
        IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
    }

    public <B> int copyToArray(Object xs) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
    }

    public <B> int copyToArray(Object xs, int start) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
    }

    public <B> int copyToArray(Object xs, int start, int len) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
    }

    public Object min(Ordering ord) {
        return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
    }

    public <B> Option<SimpleFeature> minOption(Ordering<B> ord) {
        return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
    }

    public Object max(Ordering ord) {
        return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
    }

    public <B> Option<SimpleFeature> maxOption(Ordering<B> ord) {
        return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
    }

    public <B$> Option<SimpleFeature> maxByOption(Function1<SimpleFeature, B$> f, Ordering<B$> cmp) {
        return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
    }

    public <B$> Option<SimpleFeature> minByOption(Function1<SimpleFeature, B$> f, Ordering<B$> cmp) {
        return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
    }

    public <B$> Option<B$> collectFirst(PartialFunction<SimpleFeature, B$> pf) {
        return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
    }

    public <B$> B$ aggregate(Function0<B$> z, Function2<B$, SimpleFeature, B$> seqop, Function2<B$, B$, B$> combop) {
        return (B$)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
    }

    public <B$> boolean corresponds(IterableOnce<B$> that, Function2<SimpleFeature, B$, Object> p) {
        return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
    }

    public final String mkString(String start, String sep, String end) {
        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
    }

    public final String mkString(String sep) {
        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
    }

    public final String mkString() {
        return IterableOnceOps.mkString$((IterableOnceOps)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public final StringBuilder addString(StringBuilder b, String sep) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
    }

    public final StringBuilder addString(StringBuilder b) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
    }

    public <C1> C1 to(Factory<SimpleFeature, C1> factory) {
        return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
    }

    public final Iterator<SimpleFeature> toIterator() {
        return IterableOnceOps.toIterator$((IterableOnceOps)this);
    }

    public List<SimpleFeature> toList() {
        return IterableOnceOps.toList$((IterableOnceOps)this);
    }

    public Vector<SimpleFeature> toVector() {
        return IterableOnceOps.toVector$((IterableOnceOps)this);
    }

    public <K, V> Map<K, V> toMap(.less.colon.less<SimpleFeature, Tuple2<K, V>> ev) {
        return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
    }

    public <B> Set<B> toSet() {
        return IterableOnceOps.toSet$((IterableOnceOps)this);
    }

    public Seq<SimpleFeature> toSeq() {
        return IterableOnceOps.toSeq$((IterableOnceOps)this);
    }

    public IndexedSeq<SimpleFeature> toIndexedSeq() {
        return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
    }

    public final Stream<SimpleFeature> toStream() {
        return IterableOnceOps.toStream$((IterableOnceOps)this);
    }

    public final <B> Buffer<B> toBuffer() {
        return IterableOnceOps.toBuffer$((IterableOnceOps)this);
    }

    public <B> Object toArray(ClassTag<B> evidence$2) {
        return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
    }

    public Iterable<SimpleFeature> reversed() {
        return IterableOnceOps.reversed$((IterableOnceOps)this);
    }

    public <S extends Stepper<?>> S stepper(StepperShape<SimpleFeature, S> shape) {
        return (S)IterableOnce.stepper$((IterableOnce)this, shape);
    }

    public int knownSize() {
        return IterableOnce.knownSize$((IterableOnce)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private SimpleFeatureType sft() {
        return this.sft;
    }

    private String dtgName() {
        return this.dtgName;
    }

    public String[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs;
    }

    private int dtgIndex() {
        return this.dtgIndex;
    }

    public PropertyName org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp;
    }

    public SortBy org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort;
    }

    public long org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long eventStart() {
        return this.eventStart;
    }

    private void eventStart_$eq(long x$1) {
        this.eventStart = x$1;
    }

    public LinkedBlockingQueue<SimpleFeature> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features;
    }

    private SimpleFeature staged() {
        return this.staged;
    }

    private void staged_$eq(SimpleFeature x$1) {
        this.staged = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    public boolean hasNext() {
        if (this.staged() != null) {
            return true;
        }
        this.staged_$eq(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().take());
        if (PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$terminal() != this.staged()) {
            return true;
        }
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put(this.staged());
        this.staged_$eq(null);
        return false;
    }

    public SimpleFeature next() {
        SimpleFeature feature;
        block4: {
            long featureRelativeTime;
            long sleep;
            feature = this.staged();
            this.staged_$eq(null);
            long featureTime = ((Date)feature.getAttribute(this.dtgIndex())).getTime();
            if (this.start() == -1L) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Starting replay clock");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.start_$eq(System.currentTimeMillis());
                this.eventStart_$eq(featureTime);
            }
            if ((sleep = (featureRelativeTime = this.start() + (long)((float)(featureTime - this.eventStart()) / this.rate)) - System.currentTimeMillis()) > 0L) {
                Thread.sleep(sleep);
            }
            if (!this.live) break block4;
            feature.setAttribute(this.dtgIndex(), (Object)new Date(featureRelativeTime));
        }
        return feature;
    }

    @Override
    public void close() {
        this.executor().shutdownNow();
    }

    public PlaybackIterator(DataStore ds, String typeName, Tuple2<Date, Date> interval, Option<String> dtg, Option<Filter> filter, String[] transforms, Option<Duration> window, float rate, boolean live, int readAhead) {
        int n;
        int x$2;
        String x$12;
        Object qual$1;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds = ds;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName = typeName;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval = interval;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter = filter;
        this.rate = rate;
        this.live = live;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        CloseableIterator.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        Predef$.MODULE$.require(((Date)interval._2()).after((Date)interval._1()), (Function0 & Serializable)() -> new java.lang.StringBuilder(36).append("Interval is not ordered correctly: ").append($this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1()).append("/").append($this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()).toString());
        this.sft = ds.getSchema(typeName);
        this.dtgName = (String)dtg.orElse((Function0 & Serializable)() -> RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft()))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Schema does not have a default date field");
        });
        String[] stringArray = transforms;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs = stringArray == null ? null : (ArrayOps$.MODULE$.indexOf$extension(qual$1 = Predef$.MODULE$.refArrayOps((Object[])stringArray), (Object)(x$12 = this.dtgName()), x$2 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$1)) == -1 ? (String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])stringArray), (Object)this.dtgName(), ClassTag$.MODULE$.apply(String.class)) : stringArray);
        String[] stringArray2 = this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs();
        if (stringArray2 == null) {
            n = this.sft().indexOf(this.dtgName());
        } else {
            Object qual$2 = Predef$.MODULE$.refArrayOps((Object[])stringArray2);
            String x$3 = this.dtgName();
            int x$4 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$2);
            n = ArrayOps$.MODULE$.indexOf$extension(qual$2, (Object)x$3, x$4);
        }
        this.dtgIndex = n;
        Predef$.MODULE$.require(this.dtgIndex() != -1, (Function0 & Serializable)() -> "Invalid date field");
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp = PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().property(this.dtgName());
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort = PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().sort(this.dtgName(), SortOrder.ASCENDING);
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis = BoxesRunTime.unboxToLong((Object)window.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.toMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> ((Date)$this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()).getTime() - ((Date)$this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1()).getTime() + 1L));
        this.start = -1L;
        this.eventStart = -1L;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features = new LinkedBlockingQueue(readAhead);
        this.executor = Executors.newSingleThreadExecutor();
        this.executor().submit(new QueryRunnable());
        Statics.releaseFence();
    }

    private class QueryRunnable
    implements Runnable {
        @Override
        public void run() {
            block13: {
                try {
                    try {
                        Date from = (Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1();
                        Date to = new Date(from.getTime() + this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis());
                        boolean loop = true;
                        while (loop && !Thread.currentThread().isInterrupted()) {
                            BoxedUnit boxedUnit;
                            BoxedUnit boxedUnit2;
                            if (((Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()).before(to)) {
                                to = (Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2();
                                loop = false;
                            }
                            if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isDebugEnabled()) {
                                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().debug("Running query window {} to {}", new Object[]{from, to});
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            DefaultPeriod period = new DefaultPeriod((Instant)new DefaultInstant((Position)new DefaultPosition(from)), (Instant)new DefaultInstant((Position)new DefaultPosition(to)));
                            During during = PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().during((Expression)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp(), (Expression)PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().literal((Object)period));
                            Query query = new Query(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName, (Filter)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter.map((Function1 & Serializable)x$3 -> PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().and(x$3, (Filter)during)).getOrElse((Function0 & Serializable)() -> during), this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs());
                            query.setSortBy(new SortBy[]{this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort()});
                            query.getHints().put((Object)Hints.MAX_MEMORY_SORT, (Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
                            LongRef count = LongRef.create((long)0L);
                            SelfClosingIterator$.MODULE$.apply(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds.getFeatureReader(query, Transaction.AUTO_COMMIT)).foreach((Function1 & Serializable)f -> {
                                QueryRunnable.$anonfun$run$3(this, count, f);
                                return BoxedUnit.UNIT;
                            });
                            if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isDebugEnabled()) {
                                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().debug("Returned {} features from query window {} to {}", new Object[]{BoxesRunTime.boxToLong((long)count.elem), from, to});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            from = to;
                            to = new Date(from.getTime() + this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis());
                        }
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isErrorEnabled()) {
                                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().error("Error querying playback:", e);
                            }
                            break block13;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put((SimpleFeature)PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$terminal());
                }
            }
        }

        public /* synthetic */ PlaybackIterator org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer() {
            return PlaybackIterator.this;
        }

        public static final /* synthetic */ void $anonfun$run$3(QueryRunnable $this, LongRef count$1, SimpleFeature f) {
            $this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put(f);
            ++count$1.elem;
        }

        public QueryRunnable() {
            if (PlaybackIterator.this == null) {
                throw null;
            }
        }
    }
}

