/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import java.io.Serializable;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.locationtech.geomesa.utils.stats.SimpleMatrixUtils$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.DummyImplicit;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tec\u0001B#G\u0001EC\u0001\u0002\u001b\u0001\u0003\u0006\u0004%\t!\u001b\u0005\ti\u0002\u0011\t\u0011)A\u0005U\"AQ\u000f\u0001BC\u0002\u0013\u0005a\u000fC\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005o\"9\u0011q\u0001\u0001\u0005\u0002\u0005%QABA\t\u0001\u0001\nY\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016!A\u00111\u0005\u0001!\u0002\u0013\t9\u0002C\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011\u0011\u0006\u0001!\u0002\u0013\ti\u0002C\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011Q\u0006\u0001!\u0002\u0013\ti\u0002\u0003\u0006\u00020\u0001\u0001\r\u0011\"\u0001G\u0003cA!\"!\u000f\u0001\u0001\u0004%\tARA\u001e\u0011!\t9\u0005\u0001Q!\n\u0005M\u0002BCA%\u0001\t\u0007I\u0011\u0001$\u0002L!A\u00111\f\u0001!\u0002\u0013\ti\u0005\u0003\u0006\u0002^\u0001\u0011\r\u0011\"\u0001G\u0003\u0017B\u0001\"a\u0018\u0001A\u0003%\u0011Q\n\u0005\u000b\u0003C\u0002!\u0019!C\u0001\r\u0006-\u0003\u0002CA2\u0001\u0001\u0006I!!\u0014\t\u0015\u0005\u0015\u0004A1A\u0005\u0002\u0019\u000bY\u0005\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA'\u0011)\tI\u0007\u0001b\u0001\n\u00031\u00151\n\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002N!Q\u0011Q\u000e\u0001C\u0002\u0013\u0005a)a\u0013\t\u0011\u0005=\u0004\u0001)A\u0005\u0003\u001bB!\"!\u001d\u0001\u0005\u0004%\tARA&\u0011!\t\u0019\b\u0001Q\u0001\n\u00055\u0003BCA;\u0001\t\u0007I\u0011\u0001$\u0002L!A\u0011q\u000f\u0001!\u0002\u0013\ti\u0005C\u0004\u0002z\u0001!Y!a\u001f\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003K\u0003A\u0011AA\u0019\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!a-\u0001\t\u0003\tI\u000bC\u0004\u00026\u0002!\t!a.\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002*\"9\u00111\u0019\u0001\u0005\u0002\u0005%\u0006bBAc\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003\u000f\u0004A\u0011AAU\u0011\u001d\tI\r\u0001C\u0001\u0003SCq!a3\u0001\t\u0003\tI\u000bC\u0004\u0002N\u0002!\t!!+\t\u000f\u0005=\u0007\u0001\"\u0001\u0002*\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005%\u0006bBAj\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003+\u0004A\u0011AAU\u0011\u001d\t9\u000e\u0001C\u0001\u0003SCq!!7\u0001\t\u0003\tI\u000bC\u0004\u0002\\\u0002!\t!!+\t\u000f\u0005u\u0007\u0001\"\u0001\u0002*\"9\u0011q\u001c\u0001\u0005\u0002\u0005%\u0006bBAq\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003G\u0004A\u0011AAU\u0011\u001d\t)\u000f\u0001C\u0001\u0003SCq!a:\u0001\t\u0003\tI\u000bC\u0004\u0002j\u0002!I!a;\t\u0013\u0005}\b!%A\u0005\n\t\u0005\u0001b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0005\b\u0005K\u0001A\u0011\tB\u0014\u0011\u001d\u0011Y\u0003\u0001C!\u0005[AqA!\r\u0001\t\u0003\u0012\u0019\u0004C\u0004\u00038\u0001!\tE!\u000f\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D!9!\u0011\n\u0001\u0005B\t-#\u0001\u0005#fg\u000e\u0014\u0018\u000e\u001d;jm\u0016\u001cF/\u0019;t\u0015\t9\u0005*A\u0003ti\u0006$8O\u0003\u0002J\u0015\u0006)Q\u000f^5mg*\u00111\nT\u0001\bO\u0016|W.Z:b\u0015\tie*\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001P\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\u000b\u0017/\u0011\u0005M3V\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\r\u0005s\u0017PU3g!\tI&,D\u0001G\u0013\tYfI\u0001\u0003Ti\u0006$\bCA/f\u001d\tq6M\u0004\u0002`E6\t\u0001M\u0003\u0002b!\u00061AH]8pizJ\u0011!V\u0005\u0003IR\u000bq\u0001]1dW\u0006<W-\u0003\u0002gO\na1+\u001a:jC2L'0\u00192mK*\u0011A\rV\u0001\u0004g\u001a$X#\u00016\u0011\u0005-\u0014X\"\u00017\u000b\u00055t\u0017AB:j[BdWM\u0003\u0002pa\u00069a-Z1ukJ,'BA9O\u0003\u001dy\u0007/\u001a8hSNL!a\u001d7\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0003tMR\u0004\u0013A\u00039s_B,'\u000f^5fgV\tq\u000fE\u0002^qjL!!_4\u0003\u0007M+\u0017\u000f\u0005\u0002|\u007f:\u0011A0 \t\u0003?RK!A +\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0001\u0003\rM#(/\u001b8h\u0015\tqH+A\u0006qe>\u0004XM\u001d;jKN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004\u0002\f\u00055\u0011q\u0002\t\u00033\u0002AQ\u0001[\u0003A\u0002)DQ!^\u0003A\u0002]\u0014\u0011aU\u0001\bS:$\u0017nY3t+\t\t9\u0002E\u0003T\u00033\ti\"C\u0002\u0002\u001cQ\u0013Q!\u0011:sCf\u00042aUA\u0010\u0013\r\t\t\u0003\u0016\u0002\u0004\u0013:$\u0018\u0001C5oI&\u001cWm\u001d\u0011\u0002\tML'0Z\u000b\u0003\u0003;\tQa]5{K\u0002\nAb]5{K~\u001b\u0018/^1sK\u0012\fQb]5{K~\u001b\u0018/^1sK\u0012\u0004\u0013AB0d_VtG/\u0006\u0002\u00024A\u00191+!\u000e\n\u0007\u0005]BK\u0001\u0003M_:<\u0017AC0d_VtGo\u0018\u0013fcR!\u0011QHA\"!\r\u0019\u0016qH\u0005\u0004\u0003\u0003\"&\u0001B+oSRD\u0011\"!\u0012\u000f\u0003\u0003\u0005\r!a\r\u0002\u0007a$\u0013'A\u0004`G>,h\u000e\u001e\u0011\u0002\t}k\u0017N\\\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002X5\u0011\u0011\u0011\u000b\u0006\u0004[\u0006M#bAA+\u001d\u0006!QM[7m\u0013\u0011\tI&!\u0015\u0003\u0019MKW\u000e\u001d7f\u001b\u0006$(/\u001b=\u0002\u000b}k\u0017N\u001c\u0011\u0002\t}k\u0017\r_\u0001\u0006?6\f\u0007\u0010I\u0001\u0005?N,X.A\u0003`gVl\u0007%A\u0003`[\u0016\fg.\u0001\u0004`[\u0016\fg\u000eI\u0001\u0005?6\u0014d.A\u0003`[Jr\u0007%\u0001\u0003`[Nr\u0017!B0ng9\u0004\u0013\u0001B0ni9\fQaX75]\u0002\n1aX23\u0003\u0011y6M\r\u0011\u0002\u001bQ|G)T1ue&D(+T1k)\u0011\ti(!#\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003SA!a!\u0002T\u0005!A-\u0019;b\u0013\u0011\t9)!!\u0003\u0017\u0011k\u0015\r\u001e:jqJk\u0015M\u001b\u0005\b\u0003\u0017\u0003\u0003\u0019AA'\u0003\t\u0019X.A\u0003dY\u0016\f'\u000f\u0006\u0002\u0002>\u0005A1m\u001c9z\rJ|W\u000e\u0006\u0003\u0002>\u0005U\u0005bBALE\u0001\u0007\u00111B\u0001\u0005i\"\fG/\u0001\u0004d_BLHk\u001c\u000b\u0007\u0003{\ti*!)\t\u000f\u0005}5\u00051\u0001\u0002N\u0005\u0011Ao\u001c\u0005\b\u0003G\u001b\u0003\u0019AA'\u0003\u00111'o\\7\u0002\u000b\r|WO\u001c;\u0002\u000f5Lg.[7v[V\u0011\u00111\u0016\t\u0006'\u0006e\u0011Q\u0016\t\u0004'\u0006=\u0016bAAY)\n1Ai\\;cY\u0016\fq!\\1yS6,X.\u0001\u0004c_VtGm]\u000b\u0003\u0003s\u0003RaUA\r\u0003w\u0003raUA_\u0003[\u000bi+C\u0002\u0002@R\u0013a\u0001V;qY\u0016\u0014\u0014aA:v[\u0006!Q.Z1o\u00039\u0019WM\u001c;sC2lu.\\3oiJ\nabY3oiJ\fG.T8nK:$8'\u0001\bdK:$(/\u00197N_6,g\u000e\u001e\u001b\u0002%A|\u0007/\u001e7bi&|gNV1sS\u0006t7-Z\u0001\u001ca>\u0004X\u000f\\1uS>t7\u000b^1oI\u0006\u0014H\rR3wS\u0006$\u0018n\u001c8\u0002%A|\u0007/\u001e7bi&|gnU6fo:,7o]\u0001\u0013a>\u0004X\u000f\\1uS>t7*\u001e:u_NL7/\u0001\rq_B,H.\u0019;j_:,\u0005pY3tg.+(\u000f^8tSN\fab]1na2,g+\u0019:jC:\u001cW-A\ftC6\u0004H.Z*uC:$\u0017M\u001d3EKZL\u0017\r^5p]\u0006q1/Y7qY\u0016\u001c6.Z<oKN\u001c\u0018AD:b[BdWmS;si>\u001c\u0018n]\u0001\u0015g\u0006l\u0007\u000f\\3Fq\u000e,7o]&veR|7/[:\u0002\u0013\r|Wj\\7f]R\u0014\u0014\u0001\u00069paVd\u0017\r^5p]\u000e{g/\u0019:jC:\u001cW-A\u000bq_B,H.\u0019;j_:\u001cuN\u001d:fY\u0006$\u0018n\u001c8\u0002!M\fW\u000e\u001d7f\u0007>4\u0018M]5b]\u000e,\u0017!E:b[BdWmQ8se\u0016d\u0017\r^5p]\u0006a!/Z9vSJ,7i\\;oiR1\u0011Q^A}\u0003w$B!a+\u0002p\"A\u0011\u0011\u001f\u001f\u0005\u0002\u0004\t\u00190\u0001\u0002paB)1+!>\u0002N%\u0019\u0011q\u001f+\u0003\u0011q\u0012\u0017P\\1nKzBq!!*=\u0001\u0004\ti\u0002C\u0005\u0002~r\u0002\n\u00111\u0001\u0002\u001e\u00051A.\u001a8hi\"\faC]3rk&\u0014XmQ8v]R$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0007QC!!\b\u0003\u0006-\u0012!q\u0001\t\u0005\u0005\u0013\u0011\u0019\"\u0004\u0002\u0003\f)!!Q\u0002B\b\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0012Q\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ba\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0004pEN,'O^3\u0015\t\u0005u\"1\u0004\u0005\b\u0005;q\u0004\u0019\u0001B\u0010\u0003\t\u0019h\rE\u0002l\u0005CI1Aa\tm\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0006IQO\\8cg\u0016\u0014h/\u001a\u000b\u0005\u0003{\u0011I\u0003C\u0004\u0003\u001e}\u0002\rAa\b\u0002\u000b\u0011\u0002H.^:\u0015\t\u0005-!q\u0006\u0005\b\u0003/\u0003\u0005\u0019AA\u0006\u0003!!\u0003\u000f\\;tI\u0015\fH\u0003BA\u001f\u0005kAq!a&B\u0001\u0004\tY!A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\tm\u0002cA*\u0003>%\u0019!q\b+\u0003\u000f\t{w\u000e\\3b]\u0006a\u0011n]#rk&4\u0018\r\\3oiR!!1\bB#\u0011\u0019\u00119e\u0011a\u00011\u0006)q\u000e\u001e5fe\u0006aAo\u001c&t_:|%M[3diV\u0011!Q\n\t\u0007w\n=#Pa\u0015\n\t\tE\u00131\u0001\u0002\u0004\u001b\u0006\u0004\bcA*\u0003V%\u0019!q\u000b+\u0003\u0007\u0005s\u0017\u0010")
public class DescriptiveStats
implements Stat,
Serializable {
    private final SimpleFeatureType sft;
    private final Seq<String> properties;
    private final int[] indices;
    private final int size;
    private final int size_squared;
    private long _count;
    private final SimpleMatrix _min;
    private final SimpleMatrix _max;
    private final SimpleMatrix _sum;
    private final SimpleMatrix _mean;
    private final SimpleMatrix _m2n;
    private final SimpleMatrix _m3n;
    private final SimpleMatrix _m4n;
    private final SimpleMatrix _c2;

    @Override
    public void $plus$eq(Stat other, DummyImplicit d) {
        Stat.$plus$eq$(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, DummyImplicit d) {
        return Stat.$plus$(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat.toJson$(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public Seq<String> properties() {
        return this.properties;
    }

    private int[] indices() {
        return this.indices;
    }

    private int size() {
        return this.size;
    }

    private int size_squared() {
        return this.size_squared;
    }

    public long _count() {
        return this._count;
    }

    public void _count_$eq(long x$1) {
        this._count = x$1;
    }

    public SimpleMatrix _min() {
        return this._min;
    }

    public SimpleMatrix _max() {
        return this._max;
    }

    public SimpleMatrix _sum() {
        return this._sum;
    }

    public SimpleMatrix _mean() {
        return this._mean;
    }

    public SimpleMatrix _m2n() {
        return this._m2n;
    }

    public SimpleMatrix _m3n() {
        return this._m3n;
    }

    public SimpleMatrix _m4n() {
        return this._m4n;
    }

    public SimpleMatrix _c2() {
        return this._c2;
    }

    private DMatrixRMaj toDMatrixRMaj(SimpleMatrix sm) {
        return (DMatrixRMaj)sm.getMatrix();
    }

    @Override
    public void clear() {
        this._count_$eq(0L);
        CommonOps_DDRM.fill((DMatrixD1)this.toDMatrixRMaj(this._min()), (double)Double.MAX_VALUE);
        CommonOps_DDRM.fill((DMatrixD1)this.toDMatrixRMaj(this._max()), (double)-1.7976931348623157E308);
        CommonOps_DDRM.fill((DMatrixD1)this.toDMatrixRMaj(this._sum()), (double)0.0);
        CommonOps_DDRM.fill((DMatrixD1)this.toDMatrixRMaj(this._mean()), (double)1.0);
        CommonOps_DDRM.fill((DMatrixD1)this.toDMatrixRMaj(this._m2n()), (double)0.0);
        CommonOps_DDRM.fill((DMatrixD1)this.toDMatrixRMaj(this._m3n()), (double)0.0);
        CommonOps_DDRM.fill((DMatrixD1)this.toDMatrixRMaj(this._m4n()), (double)0.0);
        CommonOps_DDRM.fill((DMatrixD1)this.toDMatrixRMaj(this._c2()), (double)0.0);
    }

    public void copyFrom(DescriptiveStats that) {
        this._count_$eq(that._count());
        this.copyTo(this._min(), that._min());
        this.copyTo(this._max(), that._max());
        this.copyTo(this._sum(), that._sum());
        this.copyTo(this._mean(), that._mean());
        this.copyTo(this._m2n(), that._m2n());
        this.copyTo(this._m3n(), that._m3n());
        this.copyTo(this._m4n(), that._m4n());
        this.copyTo(this._c2(), that._c2());
    }

    private void copyTo(SimpleMatrix to, SimpleMatrix from) {
        to.reshape(from.numRows(), from.numCols());
        System.arraycopy(this.toDMatrixRMaj((SimpleMatrix)from).data, 0, this.toDMatrixRMaj((SimpleMatrix)to).data, 0, this.toDMatrixRMaj((SimpleMatrix)from).data.length);
    }

    public long count() {
        return this._count();
    }

    public double[] minimum() {
        return (double[])((DMatrixRMaj)(this.isEmpty() ? this._max() : this._min()).getMatrix()).data.clone();
    }

    public double[] maximum() {
        return (double[])((DMatrixRMaj)(this.isEmpty() ? this._min() : this._max()).getMatrix()).data.clone();
    }

    public Tuple2<Object, Object>[] bounds() {
        return ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(this.minimum()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.maximum()));
    }

    public double[] sum() {
        return (double[])((DMatrixRMaj)this._sum().getMatrix()).data.clone();
    }

    public double[] mean() {
        return this.requireCount(1, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> this._mean());
    }

    public double[] centralMoment2() {
        return this.requireCount(1, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$div(this._count()));
    }

    public double[] centralMoment3() {
        return this.requireCount(1, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m3n()).$div(this._count()));
    }

    public double[] centralMoment4() {
        return this.requireCount(1, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m4n()).$div(this._count()));
    }

    public double[] populationVariance() {
        return this.requireCount(1, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$div(this._count()));
    }

    public double[] populationStandardDeviation() {
        return this.requireCount(1, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$div(this._count())).$times$times(0.5));
    }

    public double[] populationSkewness() {
        return this.requireCount(1, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.DoubleOps(Math.sqrt(this._count())).$times(this._m3n())).$div(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$times$times(1.5)));
    }

    public double[] populationKurtosis() {
        return this.requireCount(1, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m4n()).$times(this._count())).$div(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$times$times(2.0)));
    }

    public double[] populationExcessKurtosis() {
        return (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.populationKurtosis()), (Function1)(JFunction1.mcDD.sp & Serializable)x$1 -> x$1 - 3.0, (ClassTag)ClassTag$.MODULE$.Double());
    }

    public double[] sampleVariance() {
        return this.requireCount(2, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$div(this._count() - 1L));
    }

    public double[] sampleStandardDeviation() {
        return this.requireCount(2, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$div(this._count() - 1L)).$times$times(0.5));
    }

    public double[] sampleSkewness() {
        return this.requireCount(3, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m3n()).$times((double)this._count() * Math.sqrt(this._count() - 1L) / (double)(this._count() - 2L))).$div(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$times$times(1.5)));
    }

    public double[] sampleKurtosis() {
        return this.requireCount(4, this.requireCount$default$2(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m4n()).$times(this.count() * (this._count() + 1L) * (this._count() - 1L) / (this._count() - 2L) / (this._count() - 3L))).$div(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$times$times(2.0)));
    }

    public double[] sampleExcessKurtosis() {
        return (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.sampleKurtosis()), (Function1)(JFunction1.mcDD.sp & Serializable)x$2 -> x$2 - 3.0, (ClassTag)ClassTag$.MODULE$.Double());
    }

    public double[] coMoment2() {
        return this.requireCount(2, this.size_squared(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> this._c2());
    }

    public double[] populationCovariance() {
        return this.requireCount(2, this.size_squared(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._c2()).$div(this._count()));
    }

    public double[] populationCorrelation() {
        return this.requireCount(2, this.size_squared(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> {
            SimpleMatrix mn2_sqrt = SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$times$times(0.5);
            return SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._c2()).$div(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(mn2_sqrt).$bar$times$bar(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(mn2_sqrt).T()))).diag(1.0);
        });
    }

    public double[] sampleCovariance() {
        return this.requireCount(2, this.size_squared(), (Function0<SimpleMatrix>)(Function0 & Serializable)() -> SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._c2()).$div(this._count() - 1L));
    }

    public double[] sampleCorrelation() {
        return this.populationCorrelation();
    }

    private double[] requireCount(int count, int length, Function0<SimpleMatrix> op) {
        if (this._count() < (long)count) {
            return (double[])Array$.MODULE$.fill(length, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NaN, (ClassTag)ClassTag$.MODULE$.Double());
        }
        return (double[])((DMatrixRMaj)((SimpleBase)op.apply()).getMatrix()).data.clone();
    }

    private int requireCount$default$2() {
        return this.size();
    }

    @Override
    public void observe(SimpleFeature sf) {
        ArrayBuilder values = Array$.MODULE$.newBuilder((ClassTag)ClassTag$.MODULE$.Double());
        values.sizeHint(this.indices().length);
        for (int i = 0; i < this.indices().length; ++i) {
            double d;
            Object object = sf.getAttribute(this.indices()[i]);
            if (object instanceof Number) {
                Number number = (Number)object;
                d = number.doubleValue();
                if (d != d) {
                    return;
                }
            } else {
                if (object == null) {
                    return;
                }
                throw new IllegalArgumentException(new StringBuilder(14).append("Not a number: ").append(object).toString());
            }
            ArrayBuilder cfr_ignored_0 = (ArrayBuilder)values.$plus$eq((Object)BoxesRunTime.boxToDouble((double)d));
        }
        SimpleMatrix values_v = new SimpleMatrix(this.size(), 1, true, (double[])values.result());
        if (this._count() < 1L) {
            this._count_$eq(1L);
            this._min().insertIntoThis(0, 0, (SimpleBase)values_v);
            this._max().insertIntoThis(0, 0, (SimpleBase)values_v);
            this._sum().insertIntoThis(0, 0, (SimpleBase)values_v);
            this._mean().insertIntoThis(0, 0, (SimpleBase)values_v);
            return;
        }
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._sum()).$plus$eq(values_v);
        long r = this._count();
        this._count_$eq(this._count() + 1L);
        long n = this._count();
        double n_i = 1.0 / (double)n;
        SimpleMatrix delta = SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(values_v).$minus(this._mean());
        SimpleMatrix A = SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(delta).$times(n_i);
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._mean()).$plus$eq(A);
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m4n()).$plus$eq(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(A).$times(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(A).$times(A)).$times(delta)).$times(r)).$times((double)n * ((double)n - 3.0) + 3.0)).$plus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(A).$times(this._m2n())).$times(6.0))).$minus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m3n()).$times(4.0))));
        SimpleMatrix B = SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(values_v).$minus(this._mean());
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m3n()).$plus$eq(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(A).$times(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(B).$times(delta)).$times((double)n - 2.0)).$minus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$times(3.0))));
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$plus$eq(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(delta).$times(B));
        double coef = n_i * (double)r;
        for (int ri = 0; ri < this.size(); ++ri) {
            this._c2().set(ri, ri, this._m2n().get(ri));
            double rd = delta.get(ri);
            for (int ci = ri + 1; ci < this.size(); ++ci) {
                double c2 = this._c2().get(ri, ci) + rd * delta.get(ci) * coef;
                this._c2().set(ri, ci, c2);
                this._c2().set(ci, ri, c2);
            }
        }
        for (int i = 0; i < this.size(); ++i) {
            double v = values_v.get(i);
            if (v > this._max().get(i)) {
                this._max().set(i, v);
                continue;
            }
            if (!(v < this._min().get(i))) continue;
            this._min().set(i, v);
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
    }

    public DescriptiveStats $plus(DescriptiveStats that) {
        DescriptiveStats stats = new DescriptiveStats(this.sft(), this.properties());
        if (that.isEmpty()) {
            stats.copyFrom(this);
        } else if (this.isEmpty()) {
            stats.copyFrom(that);
        } else {
            stats.copyFrom(this);
            stats.$plus$eq(that);
        }
        return stats;
    }

    public void $plus$eq(DescriptiveStats that) {
        DescriptiveStats descriptiveStats = this;
        DescriptiveStats descriptiveStats2 = that;
        if (!(descriptiveStats != null ? !descriptiveStats.equals(descriptiveStats2) : descriptiveStats2 != null)) {
            return;
        }
        if (that.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.copyFrom(that);
            return;
        }
        long n1 = this._count();
        long n2 = that._count();
        long n1_squared = n1 * n1;
        long n2_squared = n2 * n2;
        long n_product = n1 * n2;
        long n = n1 + n2;
        double n_i = 1.0 / (double)n;
        SimpleMatrix delta = SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(that._mean()).$minus(this._mean());
        SimpleMatrix A = SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(delta).$times(n_i);
        SimpleMatrix A_squared = SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(A).$times(A);
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m4n()).$plus$eq(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(that._m4n()).$plus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.DoubleOps(n_product * (n1_squared - n_product + n2_squared)).$times(delta)).$times(A)).$times(A_squared))).$plus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(that._m2n()).$times(n1_squared)).$plus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$times(n2_squared))).$times(A_squared)).$times(6.0))).$plus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(that._m3n()).$times(n1)).$minus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m3n()).$times(n2))).$times(A)).$times(4.0)));
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m3n()).$plus$eq(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(that._m3n()).$plus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.DoubleOps(n_product * (n1 - n2)).$times(delta)).$times(A_squared))).$plus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(that._m2n()).$times(n1)).$minus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$times(n2))).$times(A)).$times(3.0)));
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).$plus$eq(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(that._m2n()).$plus(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(delta).$times(A)).$times(n_product)));
        double coef = (double)n_product * n_i;
        for (int ri = 0; ri < this.size(); ++ri) {
            this._c2().set(ri, ri, this._m2n().get(ri));
            double rd = delta.get(ri);
            for (int ci = ri + 1; ci < this.size(); ++ci) {
                double c2 = this._c2().get(ri, ci) + that._c2().get(ri, ci) + rd * delta.get(ci) * coef;
                this._c2().set(ri, ci, c2);
                this._c2().set(ci, ri, c2);
            }
        }
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._mean()).$plus$eq(SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(A).$times(n2));
        SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._sum()).$plus$eq(that._sum());
        for (int i = 0; i < this.size(); ++i) {
            double min = that._min().get(i);
            double max = that._max().get(i);
            if (min < this._min().get(i)) {
                this._min().set(i, min);
            }
            if (!(max > this._max().get(i))) continue;
            this._max().set(i, max);
        }
        this._count_$eq(this._count() + that._count());
    }

    @Override
    public boolean isEmpty() {
        return this._count() < 1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat = other;
        if (!(stat instanceof DescriptiveStats)) return false;
        DescriptiveStats descriptiveStats = (DescriptiveStats)stat;
        Seq<String> seq = this.properties();
        Seq<String> seq2 = descriptiveStats.properties();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this._count() != descriptiveStats._count()) return false;
        if (!SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._min()).isIdenticalWithinTolerances(descriptiveStats._min(), 1.0E-6, 1.0E-12)) return false;
        if (!SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._max()).isIdenticalWithinTolerances(descriptiveStats._max(), 1.0E-6, 1.0E-12)) return false;
        if (!SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._sum()).isIdenticalWithinTolerances(descriptiveStats._sum(), 1.0E-6, 1.0E-12)) return false;
        if (!SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._mean()).isIdenticalWithinTolerances(descriptiveStats._mean(), 1.0E-6, 1.0E-12)) return false;
        if (!SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m2n()).isIdenticalWithinTolerances(descriptiveStats._m2n(), 1.0E-6, 1.0E-12)) return false;
        if (!SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m3n()).isIdenticalWithinTolerances(descriptiveStats._m3n(), 1.0E-6, 1.0E-12)) return false;
        if (!SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._m4n()).isIdenticalWithinTolerances(descriptiveStats._m4n(), 1.0E-6, 1.0E-12)) return false;
        if (!SimpleMatrixUtils$.MODULE$.SimpleMatrixOps(this._c2()).isIdenticalWithinTolerances(descriptiveStats._c2(), 1.0E-6, 1.0E-12)) return false;
        return true;
    }

    public Map<String, Object> toJsonObject() {
        if (this.isEmpty()) {
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        }
        return (Map)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToLong((long)this.count())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minimum"), (Object)this.minimum()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maximum"), (Object)this.maximum()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mean"), (Object)this.mean()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"population_variance"), (Object)this.populationVariance()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"population_standard_deviation"), (Object)this.populationStandardDeviation()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"population_skewness"), (Object)this.populationSkewness()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"population_kurtosis"), (Object)this.populationKurtosis()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"population_excess_kurtosis"), (Object)this.populationExcessKurtosis()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample_variance"), (Object)this.sampleVariance()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample_standard_deviation"), (Object)this.sampleStandardDeviation()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample_skewness"), (Object)this.sampleSkewness()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample_kurtosis"), (Object)this.sampleKurtosis()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample_excess_kurtosis"), (Object)this.sampleExcessKurtosis()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"population_covariance"), (Object)this.populationCovariance()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"population_correlation"), (Object)this.populationCorrelation()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample_covariance"), (Object)this.sampleCovariance()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample_correlation"), (Object)this.sampleCorrelation())}));
    }

    public static final /* synthetic */ int $anonfun$indices$1(DescriptiveStats $this, String x$1) {
        return $this.sft().indexOf(x$1);
    }

    public DescriptiveStats(SimpleFeatureType sft, Seq<String> properties) {
        this.sft = sft;
        this.properties = properties;
        Stat.$init$(this);
        this.indices = (int[])((IterableOnceOps)properties.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DescriptiveStats.$anonfun$indices$1(this, x$1)))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        this.size = properties.size();
        this.size_squared = this.size() * this.size();
        this._count = 0L;
        this._min = new SimpleMatrix(this.size(), 1);
        this._max = new SimpleMatrix(this.size(), 1);
        this._sum = new SimpleMatrix(this.size(), 1);
        this._mean = new SimpleMatrix(this.size(), 1);
        this._m2n = new SimpleMatrix(this.size(), 1);
        this._m3n = new SimpleMatrix(this.size(), 1);
        this._m4n = new SimpleMatrix(this.size(), 1);
        this._c2 = new SimpleMatrix(this.size(), this.size());
        this.clear();
    }
}

