/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.clearspring.analytics.stream.frequency.IFrequency;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import org.locationtech.geomesa.curve.Z2SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Frequency$ {
    public static final Frequency$ MODULE$ = new Frequency$();
    private static final int Seed = -27;
    private static final short DefaultTimeBin = 0;

    public <T> double $lessinit$greater$default$6() {
        return 0.005;
    }

    public <T> double $lessinit$greater$default$7() {
        return 0.95;
    }

    public int Seed() {
        return Seed;
    }

    public short DefaultTimeBin() {
        return DefaultTimeBin;
    }

    public Iterator<Object> enumerate(Seq<package.IndexRange> ranges, long precision) {
        long shift = 64L - precision;
        return ranges.toIterator().flatMap((Function1 & Serializable)r -> {
            long c = (r.upper() >> (int)shift) - (r.lower() >> (int)shift);
            return new Iterator<Object>(c, r, shift){
                private long i;
                private final long c$1;
                private final package.IndexRange r$1;
                private final long shift$1;

                public final boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public final Iterator<Object> iterator() {
                    return Iterator.iterator$((Iterator)this);
                }

                public Option<Object> nextOption() {
                    return Iterator.nextOption$((Iterator)this);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public BufferedIterator<Object> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator<B> padTo(int len, B elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> partition(Function1<Object, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public <B$> Iterator<B$> scanLeft(B$ z, Function2<B$, Object, B$> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B$> Iterator<B$> scanRight(B$ z, Function2<Object, B$, B$> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public int indexWhere(Function1<Object, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public int indexWhere$default$2() {
                    return Iterator.indexWhere$default$2$((Iterator)this);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public final int length() {
                    return Iterator.length$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public Iterator<Object> filter(Function1<Object, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public Iterator<Object> filterNot(Function1<Object, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public Iterator<Object> filterImpl(Function1<Object, Object> p, boolean isFlipped) {
                    return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
                }

                public Iterator<Object> withFilter(Function1<Object, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Object, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public Iterator<Object> distinct() {
                    return Iterator.distinct$((Iterator)this);
                }

                public <B$> Iterator<Object> distinctBy(Function1<Object, B$> f) {
                    return Iterator.distinctBy$((Iterator)this, f);
                }

                public <B> Iterator<B> map(Function1<Object, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> flatMap(Function1<Object, IterableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public <B$> Iterator<B$> flatten(Function1<Object, IterableOnce<B$>> ev) {
                    return Iterator.flatten$((Iterator)this, ev);
                }

                public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                    return Iterator.concat$((Iterator)this, xs);
                }

                public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                    return Iterator.$plus$plus$((Iterator)this, xs);
                }

                public Iterator<Object> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Object> takeWhile(Function1<Object, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Iterator<Object> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Object> dropWhile(Function1<Object, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> span(Function1<Object, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Object> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Object> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B$> Iterator<Tuple2<Object, B$>> zip(IterableOnce<B$> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public Iterator<Tuple2<Object, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B> boolean sameElements(IterableOnce<B> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <U> Iterator<Object> tapEach(Function1<Object, U> f) {
                    return Iterator.tapEach$((Iterator)this, f);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public Iterator<Object> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> splitAt(int n) {
                    return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
                }

                public boolean isTraversableAgain() {
                    return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
                }

                public <U> void foreach(Function1<Object, U> f) {
                    IterableOnceOps.foreach$((IterableOnceOps)this, f);
                }

                public boolean forall(Function1<Object, Object> p) {
                    return IterableOnceOps.forall$((IterableOnceOps)this, p);
                }

                public boolean exists(Function1<Object, Object> p) {
                    return IterableOnceOps.exists$((IterableOnceOps)this, p);
                }

                public int count(Function1<Object, Object> p) {
                    return IterableOnceOps.count$((IterableOnceOps)this, p);
                }

                public Option<Object> find(Function1<Object, Object> p) {
                    return IterableOnceOps.find$((IterableOnceOps)this, p);
                }

                public <B$> B$ foldLeft(B$ z, Function2<B$, Object, B$> op) {
                    return (B$)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                }

                public <B$> B$ foldRight(B$ z, Function2<Object, B$, B$> op) {
                    return (B$)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                }

                public final <B$> B$ $div$colon(B$ z, Function2<B$, Object, B$> op) {
                    return (B$)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                }

                public final <B$> B$ $colon$bslash(B$ z, Function2<Object, B$, B$> op) {
                    return (B$)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                }

                public <B> B reduce(Function2<B, B, B> op) {
                    return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                    return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                }

                public <B> B reduceLeft(Function2<B, Object, B> op) {
                    return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                }

                public <B> B reduceRight(Function2<Object, B, B> op) {
                    return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Object, B> op) {
                    return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Object, B, B> op) {
                    return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                }

                public boolean nonEmpty() {
                    return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                }

                public int size() {
                    return IterableOnceOps.size$((IterableOnceOps)this);
                }

                public final <B> void copyToBuffer(Buffer<B> dest) {
                    IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                }

                public <B> int copyToArray(Object xs) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                }

                public <B> int copyToArray(Object xs, int start) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                }

                public <B> int copyToArray(Object xs, int start, int len) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                }

                public Object min(Ordering ord) {
                    return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Object> minOption(Ordering<B> ord) {
                    return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                }

                public Object max(Ordering ord) {
                    return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Object> maxOption(Ordering<B> ord) {
                    return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                }

                public <B$> Option<Object> maxByOption(Function1<Object, B$> f, Ordering<B$> cmp) {
                    return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                }

                public <B$> Option<Object> minByOption(Function1<Object, B$> f, Ordering<B$> cmp) {
                    return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
                }

                public <B$> Option<B$> collectFirst(PartialFunction<Object, B$> pf) {
                    return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                }

                public <B$> B$ aggregate(Function0<B$> z, Function2<B$, Object, B$> seqop, Function2<B$, B$, B$> combop) {
                    return (B$)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                }

                public <B$> boolean corresponds(IterableOnce<B$> that, Function2<Object, B$, Object> p) {
                    return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                }

                public final String mkString(String start, String sep, String end) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                }

                public final String mkString(String sep) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                }

                public final String mkString() {
                    return IterableOnceOps.mkString$((IterableOnceOps)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public final StringBuilder addString(StringBuilder b, String sep) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                }

                public final StringBuilder addString(StringBuilder b) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                }

                public <C1> C1 to(Factory<Object, C1> factory) {
                    return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                }

                public final Iterator<Object> toIterator() {
                    return IterableOnceOps.toIterator$((IterableOnceOps)this);
                }

                public List<Object> toList() {
                    return IterableOnceOps.toList$((IterableOnceOps)this);
                }

                public Vector<Object> toVector() {
                    return IterableOnceOps.toVector$((IterableOnceOps)this);
                }

                public <K, V> Map<K, V> toMap(.less.colon.less<Object, Tuple2<K, V>> ev) {
                    return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                }

                public <B> Set<B> toSet() {
                    return IterableOnceOps.toSet$((IterableOnceOps)this);
                }

                public Seq<Object> toSeq() {
                    return IterableOnceOps.toSeq$((IterableOnceOps)this);
                }

                public IndexedSeq<Object> toIndexedSeq() {
                    return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                }

                public final Stream<Object> toStream() {
                    return IterableOnceOps.toStream$((IterableOnceOps)this);
                }

                public final <B> Buffer<B> toBuffer() {
                    return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                }

                public <B> Object toArray(ClassTag<B> evidence$2) {
                    return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                }

                public Iterable<Object> reversed() {
                    return IterableOnceOps.reversed$((IterableOnceOps)this);
                }

                public <S extends Stepper<?>> S stepper(StepperShape<Object, S> shape) {
                    return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                }

                public int knownSize() {
                    return IterableOnce.knownSize$((IterableOnce)this);
                }

                private long i() {
                    return this.i;
                }

                private void i_$eq(long x$1) {
                    this.i = x$1;
                }

                public boolean hasNext() {
                    return this.i() <= this.c$1;
                }

                public long next() {
                    long l;
                    try {
                        l = this.r$1.lower() + (this.i() << (int)this.shift$1);
                    }
                    finally {
                        this.i_$eq(this.i() + 1L);
                    }
                    return l;
                }
                {
                    this.c$1 = c$1;
                    this.r$1 = r$1;
                    this.shift$1 = shift$1;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                    this.i = 0L;
                }
            };
        });
    }

    public <T> Function2<IFrequency, T, BoxedUnit> org$locationtech$geomesa$utils$stats$Frequency$$add(Class<T> clas, int precision) {
        if (Geometry.class.isAssignableFrom(clas)) {
            long mask = this.getMask(precision);
            return (Function2 & Serializable)(sketch, value) -> {
                sketch.add(Frequency$.MODULE$.geomToKey((Geometry)value, mask), 1L);
                return BoxedUnit.UNIT;
            };
        }
        if (Date.class.isAssignableFrom(clas)) {
            return (Function2 & Serializable)(sketch, value) -> {
                sketch.add(Frequency$.MODULE$.dateToKey((Date)value, precision), 1L);
                return BoxedUnit.UNIT;
            };
        }
        Class<T> clazz = clas;
        Class<String> clazz2 = String.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return (Function2 & Serializable)(sketch, value) -> {
                sketch.add(Frequency$.MODULE$.stringToKey((String)value, precision), 1L);
                return BoxedUnit.UNIT;
            };
        }
        Class<T> clazz3 = clas;
        Class<Long> clazz4 = Long.class;
        if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
            return (Function2 & Serializable)(sketch, value) -> {
                sketch.add(Frequency$.MODULE$.longToKey(BoxesRunTime.unboxToLong((Object)value), precision), 1L);
                return BoxedUnit.UNIT;
            };
        }
        Class<T> clazz5 = clas;
        Class<Integer> clazz6 = Integer.class;
        if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
            return (Function2 & Serializable)(sketch, value) -> {
                sketch.add(Frequency$.MODULE$.intToKey(BoxesRunTime.unboxToInt((Object)value), precision), 1L);
                return BoxedUnit.UNIT;
            };
        }
        Class<T> clazz7 = clas;
        Class<Float> clazz8 = Float.class;
        if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
            return (Function2 & Serializable)(sketch, value) -> {
                sketch.add(Frequency$.MODULE$.floatToKey(BoxesRunTime.unboxToFloat((Object)value), precision), 1L);
                return BoxedUnit.UNIT;
            };
        }
        Class<T> clazz9 = clas;
        Class<Double> clazz10 = Double.class;
        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
            return (Function2 & Serializable)(sketch, value) -> {
                sketch.add(Frequency$.MODULE$.doubleToKey(BoxesRunTime.unboxToDouble((Object)value), precision), 1L);
                return BoxedUnit.UNIT;
            };
        }
        throw new IllegalArgumentException(new java.lang.StringBuilder(51).append("No CountMinSketch implementation for class binding ").append(clas.getName()).toString());
    }

    public <T> Function2<IFrequency, T, Object> org$locationtech$geomesa$utils$stats$Frequency$$count(Class<T> clas, int precision) {
        if (Geometry.class.isAssignableFrom(clas)) {
            long mask = this.getMask(precision);
            return (Function2 & Serializable)(sketch, value) -> BoxesRunTime.boxToLong((long)sketch.estimateCount(Frequency$.MODULE$.geomToKey((Geometry)value, mask)));
        }
        if (Date.class.isAssignableFrom(clas)) {
            return (Function2 & Serializable)(sketch, value) -> BoxesRunTime.boxToLong((long)sketch.estimateCount(Frequency$.MODULE$.dateToKey((Date)value, precision)));
        }
        Class<T> clazz = clas;
        Class<String> clazz2 = String.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return (Function2 & Serializable)(sketch, value) -> BoxesRunTime.boxToLong((long)sketch.estimateCount(Frequency$.MODULE$.stringToKey((String)value, precision)));
        }
        Class<T> clazz3 = clas;
        Class<Long> clazz4 = Long.class;
        if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
            return (Function2 & Serializable)(sketch, value) -> BoxesRunTime.boxToLong((long)sketch.estimateCount(Frequency$.MODULE$.longToKey(BoxesRunTime.unboxToLong((Object)value), precision)));
        }
        Class<T> clazz5 = clas;
        Class<Integer> clazz6 = Integer.class;
        if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
            return (Function2 & Serializable)(sketch, value) -> BoxesRunTime.boxToLong((long)sketch.estimateCount(Frequency$.MODULE$.intToKey(BoxesRunTime.unboxToInt((Object)value), precision)));
        }
        Class<T> clazz7 = clas;
        Class<Float> clazz8 = Float.class;
        if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
            return (Function2 & Serializable)(sketch, value) -> BoxesRunTime.boxToLong((long)sketch.estimateCount(Frequency$.MODULE$.floatToKey(BoxesRunTime.unboxToFloat((Object)value), precision)));
        }
        Class<T> clazz9 = clas;
        Class<Double> clazz10 = Double.class;
        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
            return (Function2 & Serializable)(sketch, value) -> BoxesRunTime.boxToLong((long)sketch.estimateCount(Frequency$.MODULE$.doubleToKey(BoxesRunTime.unboxToDouble((Object)value), precision)));
        }
        throw new IllegalArgumentException(new java.lang.StringBuilder(51).append("No CountMinSketch implementation for class binding ").append(clas.getName()).toString());
    }

    public long getMask(int precision) {
        Predef$.MODULE$.require(precision >= 0 && precision <= 64, (Function0 & Serializable)() -> "Precision must be in the range [0, 64]");
        return Long.MAX_VALUE << 64 - precision;
    }

    public long geomToKey(Geometry value, long mask) {
        Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(value));
        return Z2SFC$.MODULE$.index(centroid.getX(), centroid.getY(), Z2SFC$.MODULE$.index$default$3()) & mask;
    }

    public String stringToKey(String value, int precision) {
        if (value.length() > precision) {
            return value.substring(0, precision).toLowerCase(Locale.US);
        }
        return value.toLowerCase(Locale.US);
    }

    public long dateToKey(Date value, int precision) {
        return value.getTime() / (long)precision;
    }

    public long longToKey(long value, int precision) {
        return value / (long)precision;
    }

    public long intToKey(int value, int precision) {
        return value / precision;
    }

    public long floatToKey(float value, int precision) {
        return package$.MODULE$.round(value * (float)precision);
    }

    public long doubleToKey(double value, int precision) {
        return package$.MODULE$.round(value * (double)precision);
    }

    private Frequency$() {
    }
}

