/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import java.io.Serializable;
import java.util.Date;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedArray$;
import org.locationtech.geomesa.utils.stats.BinnedArray$Binning$;
import org.locationtech.geomesa.utils.stats.BinnedArray$StringBinning$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class Histogram$ {
    public static final Histogram$ MODULE$ = new Histogram$();

    public <T> Tuple2<T, T> buffer(T value) {
        Tuple2.mcII.sp sp2;
        T t = value;
        if (t instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(t);
            sp2 = new Tuple2.mcII.sp(n - 100, n + 100);
        } else if (t instanceof Long) {
            long l = BoxesRunTime.unboxToLong(t);
            sp2 = new Tuple2.mcJJ.sp(l - 100L, l + 100L);
        } else if (t instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(t);
            sp2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)(f - (float)100)), (Object)BoxesRunTime.boxToFloat((float)(f + (float)100)));
        } else if (t instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(t);
            sp2 = new Tuple2.mcDD.sp(d - (double)100, d + (double)100);
        } else if (t instanceof String) {
            String string = (String)t;
            sp2 = new Tuple2((Object)new StringBuilder(0).append(string).append(BinnedArray$StringBinning$.MODULE$.Base36Lowest()).toString(), (Object)new StringBuilder(0).append(string).append(BinnedArray$StringBinning$.MODULE$.Base36Highest()).toString());
        } else if (t instanceof Date) {
            Date date = (Date)t;
            sp2 = new Tuple2((Object)new Date(date.getTime() - 60000L), (Object)new Date(date.getTime() + 60000L));
        } else if (t instanceof Geometry) {
            Geometry geometry = (Geometry)t;
            Envelope env = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geometry)).buffer(10.0).getEnvelopeInternal();
            Point min = GeometryUtils$.MODULE$.geoFactory().createPoint(new Coordinate(env.getMinX(), env.getMinY()));
            Point max = GeometryUtils$.MODULE$.geoFactory().createPoint(new Coordinate(env.getMaxX(), env.getMaxY()));
            sp2 = new Tuple2((Object)min, (Object)max);
        } else {
            throw new MatchError(t);
        }
        Tuple2.mcII.sp buf = sp2;
        return buf;
    }

    public <T> boolean equivalent(T o1, T o2, int bins, ClassTag<T> evidence$1) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> BinnedArray$Binning$.MODULE$.apply(bins, new Tuple2(o1, o2), evidence$1)).isFailure();
    }

    public <T> BinnedArray<T> expandBins(T value, BinnedArray<T> old, MinMax.MinMaxDefaults<T> defaults, ClassTag<T> ct) {
        Object min = defaults.min(value, old.bounds()._1());
        Object max = defaults.max(value, old.bounds()._2());
        BinnedArray<T> bins = BinnedArray$.MODULE$.apply(old.length(), new Tuple2(min, max), ct);
        this.copyInto(bins, old);
        return bins;
    }

    public <T> Tuple2<T, T> checkEndpoints(BinnedArray<T> left, BinnedArray<T> right, MinMax.MinMaxDefaults<T> defaults) {
        Tuple2<T, T> tuple2 = this.getActualBounds(left);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object lMin = tuple2._1();
        Object lMax = tuple2._2();
        Tuple2 tuple22 = new Tuple2(lMin, lMax);
        Object lMin2 = tuple22._1();
        Object lMax2 = tuple22._2();
        Tuple2<T, T> tuple23 = this.getActualBounds(right);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Object rMin = tuple23._1();
        Object rMax = tuple23._2();
        Tuple2 tuple24 = new Tuple2(rMin, rMax);
        Object rMin2 = tuple24._1();
        Object rMax2 = tuple24._2();
        return new Tuple2(defaults.min(lMin2, rMin2), defaults.max(lMax2, rMax2));
    }

    private <T> Tuple2<T, T> getActualBounds(BinnedArray<T> bins) {
        Object qual$1 = Predef$.MODULE$.longArrayOps(bins.counts());
        JFunction1.mcZJ.sp & Serializable x$1 = (JFunction1.mcZJ.sp & Serializable)x$4 -> x$4 != 0L;
        int x$2 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$1);
        int minIndex = ArrayOps$.MODULE$.indexWhere$extension(qual$1, (Function1)x$1, x$2);
        Object qual$2 = Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.longArrayOps(bins.counts())));
        JFunction1.mcZJ.sp & Serializable x$3 = (JFunction1.mcZJ.sp & Serializable)x$5 -> x$5 != 0L;
        int x$42 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$2);
        int maxIndex = bins.counts().length - ArrayOps$.MODULE$.indexWhere$extension(qual$2, (Function1)x$3, x$42) - 1;
        Object min = minIndex <= 0 ? bins.bounds()._1() : bins.bounds(minIndex)._1();
        Object max = maxIndex >= bins.counts().length - 1 ? bins.bounds()._2() : bins.bounds(maxIndex)._2();
        return new Tuple2(min, max);
    }

    public <T> void copyInto(BinnedArray<T> to, BinnedArray<T> from) {
        for (int i = 0; i < from.length(); ++i) {
            long count = from.counts()[i];
            if (count <= 0L) continue;
            Tuple2<T, T> tuple2 = from.bounds(i);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Object min = tuple2._1();
            Object max = tuple2._2();
            Tuple2 tuple22 = new Tuple2(min, max);
            Object min2 = tuple22._1();
            Object max2 = tuple22._2();
            int lo = Histogram$.toIndex$1(min2, to);
            int hi = Histogram$.toIndex$1(max2, to);
            if (lo == hi) {
                to.counts()[lo] = to.counts()[lo] + count;
                continue;
            }
            int size = hi - lo + 1;
            Predef$.MODULE$.require(size > 0, (Function0 & Serializable)() -> new StringBuilder(39).append("Error calculating bounds for ").append(min2.getClass().getSimpleName()).append(" from ").append(from.bounds()).append(" to ").append(to.bounds()).toString());
            long avgCount = count / (long)size;
            long remainingCount = count % (long)size;
            int mid = lo + size / 2;
            int j = lo;
            while (j <= hi) {
                int n = j++;
                to.counts()[n] = to.counts()[n] + avgCount;
            }
            to.counts()[mid] = to.counts()[mid] + remainingCount;
        }
    }

    private static final int toIndex$1(Object value, BinnedArray to$1) {
        int i = to$1.indexOf(value);
        if (i != -1) {
            return i;
        }
        if (to$1.isBelow(value)) {
            return 0;
        }
        return to$1.length() - 1;
    }

    private Histogram$() {
    }
}

