/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedArray$;
import org.locationtech.geomesa.utils.stats.Histogram$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.DummyImplicit;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001B\u0017/\u0001eB\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t7\u0002\u0011\t\u0011)A\u0005#\"AA\f\u0001BC\u0002\u0013\u0005Q\f\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003_\u0011!Q\u0007A!A!\u0002\u0013Y\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011u\u0004!Q1A\u0005\u0004yD\u0011\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011B@\t\u0015\u0005=\u0001A!b\u0001\n\u0007\t\t\u0002\u0003\u0006\u0002 \u0001\u0011\t\u0011)A\u0005\u0003'Aq!!\t\u0001\t\u0003\t\u0019#\u0002\u0004\u00026\u0001\u0001\u0013q\u0005\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003sAq!a\u000f\u0001A\u0003%1\u000e\u0003\u0006\u0002>\u0001\u0001\r\u0011\"\u0001/\u0003\u007fA!\"a\u0012\u0001\u0001\u0004%\tALA%\u0011!\t)\u0006\u0001Q!\n\u0005\u0005\u0003bBA,\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005]\u0004\u0001\"\u0001\u0002v!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBA=\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u001e\u0002!\t%a(\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003s\u0003A\u0011IA^\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!a2\u0001\t\u0003\nImB\u0004\u0002N:B\t!a4\u0007\r5r\u0003\u0012AAi\u0011\u001d\t\t#\nC\u0001\u0003'Dq!!6&\t\u0003\t9\u000eC\u0004\u0002d\u0016\"\t!!:\t\u000f\u0005}X\u0005\"\u0001\u0003\u0002!9!1D\u0013\u0005\u0002\tu\u0001b\u0002B\u001cK\u0011%!\u0011\b\u0005\b\u0005\u000f*C\u0011\u0001B%\u0005%A\u0015n\u001d;pOJ\fWN\u0003\u00020a\u0005)1\u000f^1ug*\u0011\u0011GM\u0001\u0006kRLGn\u001d\u0006\u0003gQ\nqaZ3p[\u0016\u001c\u0018M\u0003\u00026m\u0005aAn\\2bi&|g\u000e^3dQ*\tq'A\u0002pe\u001e\u001c\u0001!\u0006\u0002;iN!\u0001aO!F!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fMB\u0011!iQ\u0007\u0002]%\u0011AI\f\u0002\u0005'R\fG\u000f\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u0006a1oY1mC2|wmZ5oO*\u0011!jS\u0001\tif\u0004Xm]1gK*\tA*A\u0002d_6L!AT$\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0004g\u001a$X#A)\u0011\u0005IKV\"A*\u000b\u0005Q+\u0016AB:j[BdWM\u0003\u0002W/\u00069a-Z1ukJ,'B\u0001-7\u0003\u001dy\u0007/\u001a8hSNL!AW*\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0003tMR\u0004\u0013\u0001\u00039s_B,'\u000f^=\u0016\u0003y\u0003\"a\u00184\u000f\u0005\u0001$\u0007CA1>\u001b\u0005\u0011'BA29\u0003\u0019a$o\\8u}%\u0011Q-P\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002f{\u0005I\u0001O]8qKJ$\u0018\u0010I\u0001\fS:LG/[1m\u0005&t7\u000f\u0005\u0002=Y&\u0011Q.\u0010\u0002\u0004\u0013:$\u0018\u0001E5oSRL\u0017\r\\#oIB|\u0017N\u001c;t!\u0011a\u0004O\u001d:\n\u0005El$A\u0002+va2,'\u0007\u0005\u0002ti2\u0001A!B;\u0001\u0005\u00041(!\u0001+\u0012\u0005]T\bC\u0001\u001fy\u0013\tIXHA\u0004O_RD\u0017N\\4\u0011\u0005qZ\u0018B\u0001?>\u0005\r\te._\u0001\tI\u00164\u0017-\u001e7ugV\tq\u0010E\u0003\u0002\u0002\u0005\u001d!OD\u0002C\u0003\u0007I1!!\u0002/\u0003\u0019i\u0015N\\'bq&!\u0011\u0011BA\u0006\u00059i\u0015N\\'bq\u0012+g-Y;miNT1!!\u0002/\u0003%!WMZ1vYR\u001c\b%\u0001\u0002diV\u0011\u00111\u0003\t\u0006\u0003+\tYB]\u0007\u0003\u0003/Q1!!\u0007>\u0003\u001d\u0011XM\u001a7fGRLA!!\b\u0002\u0018\tA1\t\\1tgR\u000bw-A\u0002di\u0002\na\u0001P5oSRtDCCA\u0013\u0003[\ty#!\r\u00024Q1\u0011qEA\u0015\u0003W\u00012A\u0011\u0001s\u0011\u0015i8\u0002q\u0001\u0000\u0011\u001d\tya\u0003a\u0002\u0003'AQaT\u0006A\u0002ECQ\u0001X\u0006A\u0002yCQA[\u0006A\u0002-DQA\\\u0006A\u0002=\u0014\u0011aU\u0001\u0002SV\t1.\u0001\u0002jA\u0005!!-\u001b8t+\t\t\t\u0005\u0005\u0003C\u0003\u0007\u0012\u0018bAA#]\tY!)\u001b8oK\u0012\f%O]1z\u0003!\u0011\u0017N\\:`I\u0015\fH\u0003BA&\u0003#\u00022\u0001PA'\u0013\r\ty%\u0010\u0002\u0005+:LG\u000fC\u0005\u0002TA\t\t\u00111\u0001\u0002B\u0005\u0019\u0001\u0010J\u0019\u0002\u000b\tLgn\u001d\u0011\u0002\r1,gn\u001a;i\u0003-!\u0017N]3di&sG-\u001a=\u0015\u0007-\fi\u0006C\u0004\u0002`M\u0001\r!!\u0019\u0002\u000bY\fG.^3\u0011\u0007q\n\u0019'C\u0002\u0002fu\u0012A\u0001T8oO\u00069\u0011N\u001c3fq>3GcA6\u0002l!1\u0011q\f\u000bA\u0002I\fQaY8v]R$B!!\u0019\u0002r!1\u0011qG\u000bA\u0002-\f1!\\5o+\u0005\u0011\u0018aA7bq\u00061!m\\;oIN,\u0012a\u001c\u000b\u0004_\u0006}\u0004BBA\u001c3\u0001\u00071.A\u0006nK\u0012L\u0017M\u001c,bYV,Gc\u0001:\u0002\u0006\"1\u0011q\u0007\u000eA\u0002-\fQ\"\u00193e\u0007>,h\u000e^:Ge>lG\u0003BA&\u0003\u0017Cq!!$\u001c\u0001\u0004\t9#A\u0003pi\",'/A\u0004pEN,'O^3\u0015\t\u0005-\u00131\u0013\u0005\b\u0003+c\u0002\u0019AAL\u0003\t\u0019h\rE\u0002S\u00033K1!a'T\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0006IQO\\8cg\u0016\u0014h/\u001a\u000b\u0005\u0003\u0017\n\t\u000bC\u0004\u0002\u0016v\u0001\r!a&\u0002\u000b\u0011\u0002H.^:\u0015\t\u0005\u001d\u0012q\u0015\u0005\b\u0003\u001bs\u0002\u0019AA\u0014\u0003!!\u0003\u000f\\;tI\u0015\fH\u0003BA&\u0003[Cq!!$ \u0001\u0004\t9#\u0001\u0007u_*\u001bxN\\(cU\u0016\u001cG/\u0006\u0002\u00024B)q,!._u&\u0019\u0011q\u00175\u0003\u00075\u000b\u0007/A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005u\u0006c\u0001\u001f\u0002@&\u0019\u0011\u0011Y\u001f\u0003\u000f\t{w\u000e\\3b]\u0006)1\r\\3beR\u0011\u00111J\u0001\rSN,\u0015/^5wC2,g\u000e\u001e\u000b\u0005\u0003{\u000bY\r\u0003\u0004\u0002\u000e\u000e\u0002\r!Q\u0001\n\u0011&\u001cHo\\4sC6\u0004\"AQ\u0013\u0014\u0005\u0015ZDCAAh\u0003\u0019\u0011WO\u001a4feV!\u0011\u0011\\Ap)\u0011\tY.!9\u0011\rq\u0002\u0018Q\\Ao!\r\u0019\u0018q\u001c\u0003\u0006k\u001e\u0012\rA\u001e\u0005\b\u0003?:\u0003\u0019AAo\u0003))\u0017/^5wC2,g\u000e^\u000b\u0005\u0003O\f\u0019\u0010\u0006\u0005\u0002j\u0006U\u0018\u0011`A\u007f)\u0011\ti,a;\t\u0013\u00055\b&!AA\u0004\u0005=\u0018AC3wS\u0012,gnY3%cA1\u0011QCA\u000e\u0003c\u00042a]Az\t\u0015)\bF1\u0001w\u0011\u001d\t9\u0010\u000ba\u0001\u0003c\f!a\\\u0019\t\u000f\u0005m\b\u00061\u0001\u0002r\u0006\u0011qN\r\u0005\u0007\u0003{A\u0003\u0019A6\u0002\u0015\u0015D\b/\u00198e\u0005&t7/\u0006\u0003\u0003\u0004\t-AC\u0002B\u0003\u0005+\u00119\u0002\u0006\u0004\u0003\b\t5!\u0011\u0003\t\u0006\u0005\u0006\r#\u0011\u0002\t\u0004g\n-A!B;*\u0005\u00041\bBB?*\u0001\b\u0011y\u0001\u0005\u0004\u0002\u0002\u0005\u001d!\u0011\u0002\u0005\b\u0003\u001fI\u00039\u0001B\n!\u0019\t)\"a\u0007\u0003\n!9\u0011qL\u0015A\u0002\t%\u0001b\u0002B\rS\u0001\u0007!qA\u0001\u0004_2$\u0017AD2iK\u000e\\WI\u001c3q_&tGo]\u000b\u0005\u0005?\u00119\u0003\u0006\u0004\u0003\"\t5\"1\u0007\u000b\u0005\u0005G\u0011I\u0003\u0005\u0004=a\n\u0015\"Q\u0005\t\u0004g\n\u001dB!B;+\u0005\u00041\bBB?+\u0001\b\u0011Y\u0003\u0005\u0004\u0002\u0002\u0005\u001d!Q\u0005\u0005\b\u0005_Q\u0003\u0019\u0001B\u0019\u0003\u0011aWM\u001a;\u0011\u000b\t\u000b\u0019E!\n\t\u000f\tU\"\u00061\u0001\u00032\u0005)!/[4ii\u0006yq-\u001a;BGR,\u0018\r\u001c\"pk:$7/\u0006\u0003\u0003<\t\u0005C\u0003\u0002B\u001f\u0005\u0007\u0002b\u0001\u00109\u0003@\t}\u0002cA:\u0003B\u0011)Qo\u000bb\u0001m\"9\u0011QH\u0016A\u0002\t\u0015\u0003#\u0002\"\u0002D\t}\u0012\u0001C2pafLe\u000e^8\u0016\t\t-#Q\u000b\u000b\u0007\u0003\u0017\u0012iEa\u0016\t\u000f\t=C\u00061\u0001\u0003R\u0005\u0011Ao\u001c\t\u0006\u0005\u0006\r#1\u000b\t\u0004g\nUC!B;-\u0005\u00041\bb\u0002B-Y\u0001\u0007!\u0011K\u0001\u0005MJ|W\u000e")
public class Histogram<T>
implements Stat,
LazyLogging {
    private final SimpleFeatureType sft;
    private final String property;
    private final MinMax.MinMaxDefaults<T> defaults;
    private final ClassTag<T> ct;
    private final int i;
    private BinnedArray<T> bins;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <T> void copyInto(BinnedArray<T> to, BinnedArray<T> from) {
        Histogram$.MODULE$.copyInto(to, from);
    }

    public static <T> Tuple2<T, T> checkEndpoints(BinnedArray<T> left, BinnedArray<T> right, MinMax.MinMaxDefaults<T> defaults) {
        return Histogram$.MODULE$.checkEndpoints(left, right, defaults);
    }

    public static <T> BinnedArray<T> expandBins(T value, BinnedArray<T> old, MinMax.MinMaxDefaults<T> defaults, ClassTag<T> ct) {
        return Histogram$.MODULE$.expandBins(value, old, defaults, ct);
    }

    public static <T> boolean equivalent(T o1, T o2, int bins, ClassTag<T> evidence$1) {
        return Histogram$.MODULE$.equivalent(o1, o2, bins, evidence$1);
    }

    public static <T> Tuple2<T, T> buffer(T value) {
        return Histogram$.MODULE$.buffer(value);
    }

    @Override
    public void $plus$eq(Stat other, DummyImplicit d) {
        Stat.$plus$eq$(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, DummyImplicit d) {
        return Stat.$plus$(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat.toJson$(this);
    }

    private Logger logger$lzycompute() {
        Histogram histogram = this;
        synchronized (histogram) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String property() {
        return this.property;
    }

    public MinMax.MinMaxDefaults<T> defaults() {
        return this.defaults;
    }

    public ClassTag<T> ct() {
        return this.ct;
    }

    private int i() {
        return this.i;
    }

    public BinnedArray<T> bins() {
        return this.bins;
    }

    public void bins_$eq(BinnedArray<T> x$1) {
        this.bins = x$1;
    }

    public int length() {
        return this.bins().length();
    }

    public int directIndex(long value) {
        return this.bins().directIndex(value);
    }

    public int indexOf(T value) {
        return this.bins().indexOf(value);
    }

    public long count(int i) {
        return this.bins().counts()[i];
    }

    public T min() {
        return (T)this.bins().bounds()._1();
    }

    public T max() {
        return (T)this.bins().bounds()._2();
    }

    public Tuple2<T, T> bounds() {
        return this.bins().bounds();
    }

    public Tuple2<T, T> bounds(int i) {
        return this.bins().bounds(i);
    }

    public T medianValue(int i) {
        return this.bins().medianValue(i);
    }

    public void addCountsFrom(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                this.$plus$eq(other);
                return;
            }
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Object value = sf.getAttribute(this.i());
        if (value != null) {
            try {
                int i = this.bins().indexOf(value);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value, this.bins(), this.defaults(), this.ct()));
                    BinnedArray<Object> qual$1 = this.bins();
                    Object x$1 = value;
                    long x$2 = qual$1.add$default$2();
                    qual$1.add(x$1, x$2);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] + 1L;
                }
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing value '{}': {}", new Object[]{value, e.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Object value = sf.getAttribute(this.i());
        if (value != null) {
            try {
                int i = this.bins().indexOf(value);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value, this.bins(), this.defaults(), this.ct()));
                    this.bins().add(value, -1L);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] - 1L;
                }
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error un-observing value '{}': {}", new Object[]{value, e.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Histogram<T> $plus(Histogram<T> other) {
        Histogram<T> plus = new Histogram<T>(this.sft(), this.property(), this.length(), this.bounds(), this.defaults(), this.ct());
        plus.$plus$eq(this);
        plus.$plus$eq(other);
        return plus;
    }

    public void $plus$eq(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                for (int i = 0; i < this.bins().length(); ++i) {
                    long[] lArray = this.bins().counts();
                    int n = i;
                    lArray[n] = lArray[n] + other.bins().counts()[i];
                }
                return;
            }
        }
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.bins_$eq(BinnedArray$.MODULE$.apply(other.length(), other.bounds(), this.ct()));
            for (int i = 0; i < this.bins().length(); ++i) {
                this.bins().counts()[i] = other.bins().counts()[i];
            }
            return;
        }
        Tuple2<T, T> newEndpoints = Histogram$.MODULE$.checkEndpoints(this.bins(), other.bins(), this.defaults());
        int newLength = package$.MODULE$.max(this.length(), other.length());
        Tuple2<T, T> tuple2 = newEndpoints;
        Tuple2<T, T> tuple23 = this.bounds();
        if ((tuple2 != null ? !tuple2.equals(tuple23) : tuple23 != null) || newLength != this.length()) {
            BinnedArray<T> newBins = BinnedArray$.MODULE$.apply(newLength, newEndpoints, this.ct());
            Histogram$.MODULE$.copyInto(newBins, this.bins());
            this.bins_$eq(newBins);
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    public Map<String, Object> toJsonObject() {
        Seq binSeq = (Seq)scala.package$.MODULE$.Seq().tabulate(this.bins().length(), (Function1 & Serializable)bin -> Histogram.$anonfun$toJsonObject$1(this, BoxesRunTime.unboxToInt((Object)bin)));
        return (Map)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.bounds()._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.bounds()._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), (Object)binSeq)}));
    }

    @Override
    public boolean isEmpty() {
        return ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.longArrayOps(this.bins().counts()), (Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 == 0L);
    }

    @Override
    public void clear() {
        this.bins().clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat = other;
        if (!(stat instanceof Histogram)) return false;
        Histogram histogram = (Histogram)stat;
        String string = this.property();
        String string2 = histogram.property();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Tuple2<T, T> tuple2 = this.bounds();
        Tuple2<T, T> tuple22 = histogram.bounds();
        if (tuple2 == null) {
            if (tuple22 != null) {
                return false;
            }
        } else if (!tuple2.equals(tuple22)) return false;
        if (!Arrays.equals(this.bins().counts(), histogram.bins().counts())) return false;
        return true;
    }

    public static final /* synthetic */ ListMap $anonfun$toJsonObject$1(Histogram $this, int bin) {
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)BoxesRunTime.boxToInteger((int)bin)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), $this.bounds(bin)._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), $this.bounds(bin)._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToLong((long)$this.bins().counts()[bin]))}));
    }

    public Histogram(SimpleFeatureType sft, String property, int initialBins, Tuple2<T, T> initialEndpoints, MinMax.MinMaxDefaults<T> defaults, ClassTag<T> ct) {
        this.sft = sft;
        this.property = property;
        this.defaults = defaults;
        this.ct = ct;
        Stat.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.i = sft.indexOf(property);
        this.bins = BinnedArray$.MODULE$.apply(initialBins, initialEndpoints, ct);
    }
}

