/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.commons.text.StringEscapeUtils;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.StatParser$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.DummyImplicit$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Stat$ {
    public static final Stat$ MODULE$ = new Stat$();
    private static final JsonSerializer<Map<Object, Object>> ScalaMapSerializer = new JsonSerializer<Map<Object, Object>>(){

        public JsonElement serialize(Map<Object, Object> s, Type t, JsonSerializationContext jsc) {
            return jsc.serialize(JavaConverters$.MODULE$.mapAsJavaMapConverter(s).asJava());
        }
    };
    private static final JsonSerializer<Seq<Object>> ScalaSeqSerializer = new JsonSerializer<Seq<Object>>(){

        public JsonElement serialize(Seq<Object> s, Type t, JsonSerializationContext jsc) {
            return jsc.serialize(JavaConverters$.MODULE$.seqAsJavaListConverter(s).asJava());
        }
    };
    private static final JsonSerializer<Stat> StatSerializer = new JsonSerializer<Stat>(){

        public JsonElement serialize(Stat s, Type t, JsonSerializationContext jsc) {
            return jsc.serialize(s.toJsonObject());
        }
    };
    private static final JsonSerializer<Geometry> GeometrySerializer = new JsonSerializer<Geometry>(){

        public JsonElement serialize(Geometry g, Type t, JsonSerializationContext jsc) {
            return new JsonPrimitive(WKTUtils$.MODULE$.write(g));
        }
    };
    private static final JsonSerializer<Date> DateSerializer = new JsonSerializer<Date>(){

        public JsonElement serialize(Date d, Type t, JsonSerializationContext jsc) {
            return new JsonPrimitive(package$.MODULE$.GeoToolsDateFormat().format(DateUtils$.MODULE$.toInstant(d)));
        }
    };
    private static final JsonSerializer<Double> DoubleSerializer = new JsonSerializer<Double>(){

        public JsonElement serialize(Double d, Type t, JsonSerializationContext jsc) {
            Double d2 = d;
            if (Double.isNaN(Predef$.MODULE$.Double2double(d2))) {
                return JsonNull.INSTANCE;
            }
            if (BoxesRunTime.equalsNumObject((Number)d2, (Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY))) {
                return new JsonPrimitive("Infinity");
            }
            if (BoxesRunTime.equalsNumObject((Number)d2, (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))) {
                return new JsonPrimitive("+Infinity");
            }
            return new JsonPrimitive((Number)d);
        }
    };
    private static final JsonSerializer<Float> FloatSerializer = new JsonSerializer<Float>(){

        public JsonElement serialize(Float f, Type t, JsonSerializationContext jsc) {
            Float f2 = f;
            if (Float.isNaN(Predef$.MODULE$.Float2float(f2))) {
                return JsonNull.INSTANCE;
            }
            if (BoxesRunTime.equalsNumObject((Number)f2, (Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY))) {
                return new JsonPrimitive("Infinity");
            }
            if (BoxesRunTime.equalsNumObject((Number)f2, (Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY))) {
                return new JsonPrimitive("+Infinity");
            }
            return new JsonPrimitive((Number)f);
        }
    };
    private static final Gson org$locationtech$geomesa$utils$stats$Stat$$JSON = new GsonBuilder().serializeNulls().registerTypeAdapter(Double.TYPE, MODULE$.DoubleSerializer()).registerTypeAdapter(Double.class, MODULE$.DoubleSerializer()).registerTypeAdapter(Float.TYPE, MODULE$.FloatSerializer()).registerTypeAdapter(Float.class, MODULE$.FloatSerializer()).registerTypeHierarchyAdapter(Stat.class, MODULE$.StatSerializer()).registerTypeHierarchyAdapter(Geometry.class, MODULE$.GeometrySerializer()).registerTypeHierarchyAdapter(Date.class, MODULE$.DateSerializer()).registerTypeHierarchyAdapter(Map.class, MODULE$.ScalaMapSerializer()).registerTypeHierarchyAdapter(Seq.class, MODULE$.ScalaSeqSerializer()).create();

    private JsonSerializer<Map<Object, Object>> ScalaMapSerializer() {
        return ScalaMapSerializer;
    }

    private JsonSerializer<Seq<Object>> ScalaSeqSerializer() {
        return ScalaSeqSerializer;
    }

    private JsonSerializer<Stat> StatSerializer() {
        return StatSerializer;
    }

    private JsonSerializer<Geometry> GeometrySerializer() {
        return GeometrySerializer;
    }

    private JsonSerializer<Date> DateSerializer() {
        return DateSerializer;
    }

    private JsonSerializer<Double> DoubleSerializer() {
        return DoubleSerializer;
    }

    private JsonSerializer<Float> FloatSerializer() {
        return FloatSerializer;
    }

    public Gson org$locationtech$geomesa$utils$stats$Stat$$JSON() {
        return org$locationtech$geomesa$utils$stats$Stat$$JSON;
    }

    public Stat apply(SimpleFeatureType sft, String s) {
        return StatParser$.MODULE$.parse(sft, s, StatParser$.MODULE$.parse$default$3());
    }

    public String Count() {
        return "Count()";
    }

    public String MinMax(String attribute) {
        return new StringBuilder(8).append("MinMax(").append(this.safeString(attribute)).append(")").toString();
    }

    public String Enumeration(String attribute) {
        return new StringBuilder(13).append("Enumeration(").append(this.safeString(attribute)).append(")").toString();
    }

    public String TopK(String attribute) {
        return new StringBuilder(6).append("TopK(").append(this.safeString(attribute)).append(")").toString();
    }

    public String Frequency(String attribute, int precision) {
        return new StringBuilder(12).append("Frequency(").append(this.safeString(attribute)).append(",").append(precision).append(")").toString();
    }

    public String Frequency(String attribute, String dtg, Enumeration.Value period, int precision) {
        return new StringBuilder(14).append("Frequency(").append(this.safeString(attribute)).append(",").append(this.safeString(dtg)).append(",").append(period).append(",").append(precision).append(")").toString();
    }

    public String Z3Frequency(String geom, String dtg, Enumeration.Value period, int precision) {
        return new StringBuilder(16).append("Z3Frequency(").append(this.safeString(geom)).append(",").append(this.safeString(dtg)).append(",").append(period).append(",").append(precision).append(")").toString();
    }

    public <T> String Histogram(String attribute, int bins, T min, T max, ClassTag<T> ct) {
        Function1<Object, String> stringify = this.stringifier(ct.runtimeClass(), this.stringifier$default$2());
        return new StringBuilder(14).append("Histogram(").append(this.safeString(attribute)).append(",").append(bins).append(",").append(this.safeString((String)stringify.apply(min))).append(",").append(this.safeString((String)stringify.apply(max))).append(")").toString();
    }

    public String Z3Histogram(String geom, String dtg, Enumeration.Value period, int length) {
        return new StringBuilder(16).append("Z3Histogram(").append(this.safeString(geom)).append(",").append(this.safeString(dtg)).append(",").append(period).append(",").append(length).append(")").toString();
    }

    public String IteratorStackCount() {
        return "IteratorStackCount()";
    }

    public String SeqStat(Seq<String> stats) {
        return stats.mkString(";");
    }

    public String GroupBy(String attribute, String groupedStat) {
        return new StringBuilder(10).append("GroupBy(").append(this.safeString(attribute)).append(",").append(groupedStat).append(")").toString();
    }

    public String DescriptiveStats(Seq<String> attributes) {
        return new StringBuilder(18).append("DescriptiveStats(").append(((IterableOnceOps)attributes.map((Function1 & Serializable)s -> MODULE$.safeString((String)s))).mkString(",")).append(")").toString();
    }

    public <T extends Stat> Option<T> combine(Seq<T> stats) {
        if (stats.length() < 2) {
            return stats.headOption();
        }
        Stat summed = ((Stat)stats.head()).$plus((Stat)((IterableOps)stats.tail()).head(), DummyImplicit$.MODULE$.dummyImplicit());
        ((IterableOnceOps)stats.drop(2)).foreach((Function1 & Serializable)x$1 -> {
            summed.$plus$eq(x$1, DummyImplicit$.MODULE$.dummyImplicit());
            return BoxedUnit.UNIT;
        });
        return new Some((Object)summed);
    }

    private String safeString(String s) {
        return new StringBuilder(2).append("\"").append(StringEscapeUtils.escapeJava((String)s)).append("\"").toString();
    }

    public <T> Function1<Object, String> stringifier(Class<T> clas, boolean json) {
        Function1 & Serializable toString;
        Function1 & Serializable intersect = Geometry.class.isAssignableFrom(clas) ? (Function1 & Serializable)v -> WKTUtils$.MODULE$.write((Geometry)v) : (toString = Date.class.isAssignableFrom(clas) ? (Function1 & Serializable)v -> package$.MODULE$.GeoToolsDateFormat().format(DateUtils$.MODULE$.toInstant((Date)v)) : (Function1 & Serializable)v -> v.toString());
        if (json && !Number.class.isAssignableFrom(clas)) {
            Class<T> clazz = clas;
            Class<Boolean> clazz2 = Boolean.class;
            if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                return (Function1 & Serializable)v -> {
                    if (v == null) {
                        return "null";
                    }
                    return new StringBuilder(2).append("\"").append(toString.apply(v)).append("\"").toString();
                };
            }
        }
        return (Function1 & Serializable)v -> {
            if (v == null) {
                return "null";
            }
            return (String)toString.apply(v);
        };
    }

    public <T> boolean stringifier$default$2() {
        return false;
    }

    public <T> Function1<String, T> destringifier(Class<T> clas) {
        Class<T> clazz = clas;
        Class<String> clazz2 = String.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return (Function1 & Serializable)s -> {
                String string = s;
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                return s;
            };
        }
        Class<T> clazz3 = clas;
        Class<Integer> clazz4 = Integer.class;
        if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
            return (Function1 & Serializable)s -> {
                String string = s;
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)));
            };
        }
        Class<T> clazz5 = clas;
        Class<Long> clazz6 = Long.class;
        if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
            return (Function1 & Serializable)s -> {
                String string = s;
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s)));
            };
        }
        Class<T> clazz7 = clas;
        Class<Float> clazz8 = Float.class;
        if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
            return (Function1 & Serializable)s -> {
                String string = s;
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                return BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s)));
            };
        }
        Class<T> clazz9 = clas;
        Class<Double> clazz10 = Double.class;
        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
            return (Function1 & Serializable)s -> {
                String string = s;
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s)));
            };
        }
        Class<T> clazz11 = clas;
        Class<Boolean> clazz12 = Boolean.class;
        if (!(clazz11 != null ? !clazz11.equals(clazz12) : clazz12 != null)) {
            return (Function1 & Serializable)s -> {
                String string = s;
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s)));
            };
        }
        if (Geometry.class.isAssignableFrom(clas)) {
            return (Function1 & Serializable)s -> {
                String string = s;
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                return WKTUtils$.MODULE$.read((String)s);
            };
        }
        if (Date.class.isAssignableFrom(clas)) {
            return (Function1 & Serializable)s -> {
                String string = s;
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                return Date.from(LocalDateTime.parse(s, package$.MODULE$.GeoToolsDateFormat()).toInstant(ZoneOffset.UTC));
            };
        }
        throw new RuntimeException(new StringBuilder(45).append("Unexpected class binding for stat attribute: ").append(clas).toString());
    }

    private Stat$() {
    }
}

