/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Z3Histogram$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.DummyImplicit;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tme\u0001\u0002\u001d:\u0001\u0011C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\tK\u0002\u0011\t\u0011)A\u00057\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003i\u0011!!\bA!b\u0001\n\u00039\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011Y\u0004!Q1A\u0005\u0002]D\u0011\"a\u0005\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0015\u0005U\u0001A!b\u0001\n\u0003\t9\u0002\u0003\u0006\u0002 \u0001\u0011\t\u0011)A\u0005\u00033Aq!!\t\u0001\t\u0003\t\u0019#\u0002\u0004\u00022\u0001\u0001\u0013Q\u0005\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003/A\u0001\"!\u000e\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003/A\u0001\"!\u000f\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"a\u0012\u0001A\u0003%\u0011q\b\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003\u0017B\u0001\"a\u0017\u0001A\u0003%\u0011Q\n\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003?B\u0001\"a\u001a\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003WB\u0001\"a\u001d\u0001A\u0003%\u0011Q\u000e\u0005\n\u0003k\u0002!\u0019!C\u0005\u0003WB\u0001\"a\u001e\u0001A\u0003%\u0011Q\u000e\u0005\u000b\u0003s\u0002\u0001R1A\u0005\n\u0005m\u0004BCAF\u0001\t\u0007I\u0011A\u001d\u0002\u000e\"A\u0011q\u0016\u0001!\u0002\u0013\ty\t\u0003\u0005\u00022\u0002!\t!OAZ\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!a3\u0001\t\u0003\ti\rC\u0004\u0002X\u0002!\t!!7\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0001b\u0002B\t\u0001\u0011%!1\u0003\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqAa\u000e\u0001\t\u0003\u0012I\u0004C\u0004\u0003L\u0001!\tE!\u0014\t\u000f\tE\u0003\u0001\"\u0011\u0003T!9!\u0011\f\u0001\u0005B\tm\u0003b\u0002B0\u0001\u0011\u0005#\u0011\r\u0005\b\u0005S\u0002A\u0011\tB6\u0011\u001d\u0011i\u0007\u0001C!\u0005_BqA!\u001d\u0001\t\u0003\u0012\u0019hB\u0004\u0003xeB\tA!\u001f\u0007\raJ\u0004\u0012\u0001B>\u0011\u001d\t\t\u0003\rC\u0001\u0005{B\u0011Ba 1\u0005\u0004%IA!!\t\u0011\t%\u0005\u0007)A\u0005\u0005\u0007C\u0011Ba#1\u0005\u0004%\tA!$\t\u0011\tU\u0005\u0007)A\u0005\u0005\u001fC\u0011Ba&1\u0005\u0004%\tA!$\t\u0011\te\u0005\u0007)A\u0005\u0005\u001f\u00131BW\u001aISN$xn\u001a:b[*\u0011!hO\u0001\u0006gR\fGo\u001d\u0006\u0003yu\nQ!\u001e;jYNT!AP \u0002\u000f\u001d,w.\\3tC*\u0011\u0001)Q\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0005\u0006\u0019qN]4\u0004\u0001M!\u0001!R&P!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fMB\u0011A*T\u0007\u0002s%\u0011a*\u000f\u0002\u0005'R\fG\u000f\u0005\u0002Q/6\t\u0011K\u0003\u0002S'\u0006a1oY1mC2|wmZ5oO*\u0011A+V\u0001\tif\u0004Xm]1gK*\ta+A\u0002d_6L!\u0001W)\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0004g\u001a$X#A.\u0011\u0005q\u001bW\"A/\u000b\u0005y{\u0016AB:j[BdWM\u0003\u0002aC\u00069a-Z1ukJ,'B\u00012B\u0003\u001dy\u0007/\u001a8hSNL!\u0001Z/\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0003tMR\u0004\u0013\u0001B4f_6,\u0012\u0001\u001b\t\u0003SBt!A\u001b8\u0011\u0005-<U\"\u00017\u000b\u00055\u001c\u0015A\u0002\u001fs_>$h(\u0003\u0002p\u000f\u00061\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\tyw)A\u0003hK>l\u0007%A\u0002ei\u001e\fA\u0001\u001a;hA\u00051\u0001/\u001a:j_\u0012,\u0012\u0001\u001f\t\u0004s\u00065ab\u0001>\u0002\b9\u001910a\u0001\u000f\u0007q\f\tA\u0004\u0002~\u007f:\u00111N`\u0005\u0002\u0005&\u0011\u0001)Q\u0005\u0003}}J1!!\u0002>\u0003\u0015\u0019WO\u001d<f\u0013\u0011\tI!a\u0003\u0002\u0015QKW.\u001a)fe&|GMC\u0002\u0002\u0006uJA!a\u0004\u0002\u0012\tQA+[7f!\u0016\u0014\u0018n\u001c3\u000b\t\u0005%\u00111B\u0001\ba\u0016\u0014\u0018n\u001c3!\u0003\u0019aWM\\4uQV\u0011\u0011\u0011\u0004\t\u0004\r\u0006m\u0011bAA\u000f\u000f\n\u0019\u0011J\u001c;\u0002\u000f1,gn\u001a;iA\u00051A(\u001b8jiz\"B\"!\n\u0002(\u0005%\u00121FA\u0017\u0003_\u0001\"\u0001\u0014\u0001\t\u000be[\u0001\u0019A.\t\u000b\u0019\\\u0001\u0019\u00015\t\u000bQ\\\u0001\u0019\u00015\t\u000bY\\\u0001\u0019\u0001=\t\u000f\u0005U1\u00021\u0001\u0002\u001a\t\t1+A\u0001h\u0003\t9\u0007%A\u0001e\u0003\t!\u0007%A\u0002tM\u000e,\"!a\u0010\u0011\t\u0005\u0005\u00131I\u0007\u0003\u0003\u0017IA!!\u0012\u0002\f\t)!lM*G\u0007\u0006!1OZ2!\u0003%!\u0018.\\3U_\nKg.\u0006\u0002\u0002NA!\u0011qJA+\u001d\u0011\t\t%!\u0015\n\t\u0005M\u00131B\u0001\u000b\u0005&tg.\u001a3US6,\u0017\u0002BA,\u00033\u0012\u0001\u0003V5nKR{')\u001b8oK\u0012$\u0016.\\3\u000b\t\u0005M\u00131B\u0001\u000bi&lW\rV8CS:\u0004\u0013!\u00032j]R{G)\u0019;f+\t\t\t\u0007\u0005\u0003\u0002P\u0005\r\u0014\u0002BA3\u00033\u0012\u0001CQ5o]\u0016$G+[7f)>$\u0015\r^3\u0002\u0015\tLg\u000eV8ECR,\u0007%\u0001\u0003nS:TVCAA7!\r1\u0015qN\u0005\u0004\u0003c:%\u0001\u0002'p]\u001e\fQ!\\5o5\u0002\nA!\\1y5\u0006)Q.\u0019=[A\u0005Q!n]8o\r>\u0014X.\u0019;\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0005Y\u0006twM\u0003\u0002\u0002\b\u0006!!.\u0019<b\u0013\r\t\u0018\u0011Q\u0001\u0007E&tW*\u00199\u0016\u0005\u0005=\u0005\u0003CAI\u00037\u000by*!*\u000e\u0005\u0005M%\u0002BAK\u0003/\u000bq!\\;uC\ndWMC\u0002\u0002\u001a\u001e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti*a%\u0003\u00075\u000b\u0007\u000fE\u0002G\u0003CK1!a)H\u0005\u0015\u0019\u0006n\u001c:u!\u0015a\u0015qUAV\u0013\r\tI+\u000f\u0002\f\u0005&tg.\u001a3BeJ\f\u0017\u0010\u0005\u0003\u0002\u0000\u00055\u0016\u0002BA9\u0003\u0003\u000bqAY5o\u001b\u0006\u0004\b%A\u0004oK^\u0014\u0015N\\:\u0016\u0005\u0005\u0015\u0016\u0001\u0003;j[\u0016\u0014\u0015N\\:\u0016\u0005\u0005e\u0006CBA^\u0003\u000b\fyJ\u0004\u0003\u0002>\u0006\u0005gbA6\u0002@&\t\u0001*C\u0002\u0002D\u001e\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002H\u0006%'aA*fc*\u0019\u00111Y$\u0002\u000b\r|WO\u001c;\u0015\r\u00055\u0014qZAj\u0011\u001d\t\t\u000e\ta\u0001\u0003?\u000bq\u0001^5nK\nKg\u000eC\u0004\u0002V\u0002\u0002\r!!\u0007\u0002\u0003%\f1\u0002Z5sK\u000e$\u0018J\u001c3fqR1\u0011\u0011DAn\u0003;Dq!!5\"\u0001\u0004\ty\nC\u0004\u0002`\u0006\u0002\r!!\u001c\u0002\u000bY\fG.^3\u0002\u000f%tG-\u001a=PMR!\u0011Q]Av!\u001d1\u0015q]AP\u00033I1!!;H\u0005\u0019!V\u000f\u001d7fe!9\u0011q\u001c\u0012A\u0002\u00055\bc\u0002$\u0002h\u0006=\u0018Q \t\u0005\u0003c\fI0\u0004\u0002\u0002t*\u0019a-!>\u000b\u0007\u0005]x(A\u0002kiNLA!a?\u0002t\nAq)Z8nKR\u0014\u0018\u0010\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\u0011\u0011\u0019!!\"\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0003ECR,\u0017aC7fI&\fgNV1mk\u0016$b!!<\u0003\u000e\t=\u0001bBAiG\u0001\u0007\u0011q\u0014\u0005\b\u0003+\u001c\u0003\u0019AA\r\u0003\u0015!xnS3z)!\u0011)Ba\u0006\u0003\u001a\tm\u0001c\u0002$\u0002h\u0006}\u0015Q\u000e\u0005\u0007M\u0012\u0002\r!a<\t\rQ$\u0003\u0019AA\u007f\u0011\u001d\u0011i\u0002\na\u0001\u0005?\tq\u0001\\3oS\u0016tG\u000fE\u0002G\u0005CI1Aa\tH\u0005\u001d\u0011un\u001c7fC:\fqA\u001a:p[.+\u0017\u0010\u0006\u0004\u0002n\n%\"1\u0006\u0005\b\u0003#,\u0003\u0019AAP\u0011\u001d\u0011i#\na\u0001\u0003[\n\u0011A_\u0001\fgBd\u0017\u000e\u001e\"z)&lW-\u0006\u0002\u00034A1\u00111XAc\u0005k\u0001rARAt\u0003?\u000b)#A\u0004pEN,'O^3\u0015\t\tm\"\u0011\t\t\u0004\r\nu\u0012b\u0001B \u000f\n!QK\\5u\u0011\u001d\u0011\u0019e\na\u0001\u0005\u000b\n!a\u001d4\u0011\u0007q\u00139%C\u0002\u0003Ju\u0013QbU5na2,g)Z1ukJ,\u0017!C;o_\n\u001cXM\u001d<f)\u0011\u0011YDa\u0014\t\u000f\t\r\u0003\u00061\u0001\u0003F\u0005)A\u0005\u001d7vgR!\u0011Q\u0005B+\u0011\u001d\u00119&\u000ba\u0001\u0003K\tQa\u001c;iKJ\f\u0001\u0002\n9mkN$S-\u001d\u000b\u0005\u0005w\u0011i\u0006C\u0004\u0003X)\u0002\r!!\n\u0002\u0019Q|'j]8o\u001f\nTWm\u0019;\u0016\u0005\t\r\u0004c\u0001$\u0003f%\u0019!qM$\u0003\u0007\u0005s\u00170A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\t}\u0011!B2mK\u0006\u0014HC\u0001B\u001e\u00031I7/R9vSZ\fG.\u001a8u)\u0011\u0011yB!\u001e\t\r\t]c\u00061\u0001L\u0003-Q6\u0007S5ti><'/Y7\u0011\u00051\u00034C\u0001\u0019F)\t\u0011I(\u0001\u0002hMV\u0011!1\u0011\t\u0005\u0003c\u0014))\u0003\u0003\u0003\b\u0006M(aD$f_6,GO]=GC\u000e$xN]=\u0002\u0007\u001d4\u0007%A\u0004nS:<Um\\7\u0016\u0005\t=\u0005\u0003BAy\u0005#KAAa%\u0002t\n)\u0001k\\5oi\u0006AQ.\u001b8HK>l\u0007%A\u0004nCb<Um\\7\u0002\u00115\f\u0007pR3p[\u0002\u0002")
public class Z3Histogram
implements Stat,
LazyLogging {
    private String jsonFormat;
    private final SimpleFeatureType sft;
    private final String geom;
    private final String dtg;
    private final Enumeration.Value period;
    private final int length;
    private final int g;
    private final int d;
    private final Z3SFC sfc;
    private final Function1<Object, BinnedTime> timeToBin;
    private final Function1<BinnedTime, ZonedDateTime> binToDate;
    private final long minZ;
    private final long maxZ;
    private final Map<Object, BinnedArray<Long>> binMap;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Point maxGeom() {
        return Z3Histogram$.MODULE$.maxGeom();
    }

    public static Point minGeom() {
        return Z3Histogram$.MODULE$.minGeom();
    }

    @Override
    public void $plus$eq(Stat other, DummyImplicit d) {
        Stat.$plus$eq$(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, DummyImplicit d) {
        return Stat.$plus$(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat.toJson$(this);
    }

    private Logger logger$lzycompute() {
        Z3Histogram z3Histogram = this;
        synchronized (z3Histogram) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String geom() {
        return this.geom;
    }

    public String dtg() {
        return this.dtg;
    }

    public Enumeration.Value period() {
        return this.period;
    }

    public int length() {
        return this.length;
    }

    private int g() {
        return this.g;
    }

    private int d() {
        return this.d;
    }

    private Z3SFC sfc() {
        return this.sfc;
    }

    private Function1<Object, BinnedTime> timeToBin() {
        return this.timeToBin;
    }

    private Function1<BinnedTime, ZonedDateTime> binToDate() {
        return this.binToDate;
    }

    private long minZ() {
        return this.minZ;
    }

    private long maxZ() {
        return this.maxZ;
    }

    private String jsonFormat$lzycompute() {
        Z3Histogram z3Histogram = this;
        synchronized (z3Histogram) {
            if (!this.bitmap$0) {
                String string;
                Enumeration.Value value = this.period();
                Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    string = new StringBuilder(5).append(this.period()).append("-%05d").toString();
                } else {
                    Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        string = new StringBuilder(5).append(this.period()).append("-%04d").toString();
                    } else {
                        Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            string = new StringBuilder(5).append(this.period()).append("-%03d").toString();
                        } else {
                            Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                string = new StringBuilder(5).append(this.period()).append("-%02d").toString();
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
                this.jsonFormat = string;
                this.bitmap$0 = true;
            }
        }
        return this.jsonFormat;
    }

    private String jsonFormat() {
        if (!this.bitmap$0) {
            return this.jsonFormat$lzycompute();
        }
        return this.jsonFormat;
    }

    public Map<Object, BinnedArray<Long>> binMap() {
        return this.binMap;
    }

    public BinnedArray<Long> newBins() {
        return new BinnedArray<Long>(new BinnedArray.LongBinning(this.length(), (Tuple2<Long, Long>)new Tuple2((Object)Predef$.MODULE$.long2Long(this.minZ()), (Object)Predef$.MODULE$.long2Long(this.maxZ()))));
    }

    public Seq<Object> timeBins() {
        return (Seq)this.binMap().keys().toSeq().sorted((Ordering)Ordering.Short$.MODULE$);
    }

    public long count(short timeBin, int i) {
        return BoxesRunTime.unboxToLong((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)Z3Histogram.$anonfun$count$1(i, x$1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public int directIndex(short timeBin, long value) {
        return BoxesRunTime.unboxToInt((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.indexOf(Predef$.MODULE$.long2Long(value)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
    }

    public Tuple2<Object, Object> indexOf(Tuple2<Geometry, Date> value) {
        Tuple2<Object, Object> tuple2 = this.toKey((Geometry)value._1(), (Date)value._2(), false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long z = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z));
        short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long z2 = tuple22._2$mcJ$sp();
        return new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin2), (Object)BoxesRunTime.boxToInteger((int)this.directIndex(timeBin2, z2)));
    }

    public Tuple2<Geometry, Date> medianValue(short timeBin, int i) {
        return this.fromKey(timeBin, Predef$.MODULE$.Long2long((Long)((BinnedArray)this.binMap().apply((Object)BoxesRunTime.boxToShort((short)timeBin))).medianValue(i)));
    }

    private Tuple2<Object, Object> toKey(Geometry geom, Date dtg, boolean lenient) {
        BinnedTime binnedTime = (BinnedTime)this.timeToBin().apply((Object)BoxesRunTime.boxToLong((long)dtg.getTime()));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short bin = binnedTime.bin();
        long offset = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)offset));
        short bin2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long offset2 = tuple2._2$mcJ$sp();
        Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
        long z = this.sfc().index(centroid.getX(), centroid.getY(), offset2, lenient);
        return new Tuple2((Object)BoxesRunTime.boxToShort((short)bin2), (Object)BoxesRunTime.boxToLong((long)z));
    }

    private Tuple2<Geometry, Date> fromKey(short timeBin, long z) {
        Tuple3 tuple3 = this.sfc().invert(z);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double x = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double y = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        long t = BoxesRunTime.unboxToLong((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToLong((long)t));
        double x2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        double y2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        long t2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
        Date dtg = Date.from(((ChronoZonedDateTime)this.binToDate().apply((Object)new BinnedTime(timeBin, t2))).toInstant());
        Point geom = Z3Histogram$.MODULE$.org$locationtech$geomesa$utils$stats$Z3Histogram$$gf().createPoint(new Coordinate(x2, y2));
        return new Tuple2((Object)geom, (Object)dtg);
    }

    public Seq<Tuple2<Object, Z3Histogram>> splitByTime() {
        return (Seq)this.binMap().toSeq().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                BinnedArray bins = (BinnedArray)tuple2._2();
                Z3Histogram hist = new Z3Histogram(this.sft(), this.geom(), this.dtg(), this.period(), this.length());
                hist.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                return new Tuple2((Object)BoxesRunTime.boxToShort((short)w), (Object)hist);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public void observe(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.g());
        Date dtg = (Date)sf.getAttribute(this.d());
        if (geom != null && dtg != null) {
            try {
                Tuple2<Object, Object> tuple2 = this.toKey(geom, dtg, false);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                long z3 = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z32 = tuple22._2$mcJ$sp();
                ((BinnedArray)this.binMap().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)timeBin2), (Function0 & Serializable)() -> this.newBins())).add(Predef$.MODULE$.long2Long(z32), 1L);
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, e.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.g());
        Date dtg = (Date)sf.getAttribute(this.d());
        if (geom != null && dtg != null) {
            try {
                Tuple2<Object, Object> tuple2 = this.toKey(geom, dtg, true);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                long z3 = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z32 = tuple22._2$mcJ$sp();
                this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin2)).foreach((Function1 & Serializable)x$8 -> {
                    x$8.add(Predef$.MODULE$.long2Long(z32), -1L);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error un-observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, e.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Z3Histogram $plus(Z3Histogram other) {
        Z3Histogram plus = new Z3Histogram(this.sft(), this.geom(), this.dtg(), this.period(), this.length());
        plus.$plus$eq(this);
        plus.$plus$eq(other);
        return plus;
    }

    public void $plus$eq(Z3Histogram other) {
        if (this.length() != other.length()) {
            throw new NotImplementedError("Can only add z3 histograms with the same length");
        }
        other.binMap().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                BinnedArray bins = (BinnedArray)tuple2._2();
                Option option = this.binMap().get((Object)BoxesRunTime.boxToShort((short)w));
                if (None$.MODULE$.equals(option)) {
                    return this.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BinnedArray b = (BinnedArray)some.value();
                    for (int i = 0; i < b.length(); ++i) {
                        int n = i;
                        b.counts()[n] = b.counts()[n] + bins.counts()[i];
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public Object toJsonObject() {
        return ((IterableOps)((IterableOps)this.binMap().toSeq().sortBy((Function1 & Serializable)x$9 -> BoxesRunTime.boxToShort((short)Z3Histogram.$anonfun$toJsonObject$1(x$9)), (Ordering)Ordering.Short$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short p = BoxesRunTime.unboxToShort((Object)tuple2._1());
                BinnedArray bins = (BinnedArray)tuple2._2();
                return new Tuple2((Object)String.format(this.jsonFormat(), BoxesRunTime.boxToShort((short)p)), (Object)bins);
            }
            throw new MatchError((Object)tuple2);
        })).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                BinnedArray bins = (BinnedArray)tuple2._2();
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), (Object)bins.counts())})))}));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public boolean isEmpty() {
        return this.binMap().values().forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.longArrayOps(x$10.counts()), (Function1)(JFunction1.mcZJ.sp & Serializable)x$11 -> x$11 == 0L)));
    }

    @Override
    public void clear() {
        this.binMap().values().foreach((Function1 & Serializable)x$12 -> {
            x$12.clear();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat = other;
        if (!(stat instanceof Z3Histogram)) return false;
        Z3Histogram z3Histogram = (Z3Histogram)stat;
        if (this.g() != z3Histogram.g()) return false;
        if (this.d() != z3Histogram.d()) return false;
        Enumeration.Value value = this.period();
        Enumeration.Value value2 = z3Histogram.period();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (this.length() != z3Histogram.length()) return false;
        Set set = this.binMap().keySet();
        Set set2 = z3Histogram.binMap().keySet();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        if (!this.binMap().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Z3Histogram.$anonfun$isEquivalent$1(z3Histogram, x0$1)))) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$count$1(int i$1, BinnedArray x$1) {
        return x$1.counts()[i$1];
    }

    public static final /* synthetic */ short $anonfun$toJsonObject$1(Tuple2 x$9) {
        return BoxesRunTime.unboxToShort((Object)x$9._1());
    }

    public static final /* synthetic */ boolean $anonfun$isEquivalent$1(Z3Histogram x2$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
            BinnedArray bins = (BinnedArray)tuple2._2();
            return Arrays.equals(bins.counts(), ((BinnedArray)x2$1.binMap().apply((Object)BoxesRunTime.boxToShort((short)w))).counts());
        }
        throw new MatchError((Object)tuple2);
    }

    public Z3Histogram(SimpleFeatureType sft, String geom, String dtg, Enumeration.Value period, int length) {
        this.sft = sft;
        this.geom = geom;
        this.dtg = dtg;
        this.period = period;
        this.length = length;
        Stat.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.g = sft.indexOf(geom);
        this.d = sft.indexOf(dtg);
        this.sfc = Z3SFC$.MODULE$.apply(period);
        this.timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(period);
        this.binToDate = BinnedTime$.MODULE$.binnedTimeToDate(period);
        this.minZ = this.sfc().index(Z3Histogram$.MODULE$.minGeom().getX(), Z3Histogram$.MODULE$.minGeom().getY(), (long)this.sfc().time().min(), this.sfc().index$default$4());
        this.maxZ = this.sfc().index(Z3Histogram$.MODULE$.maxGeom().getX(), Z3Histogram$.MODULE$.maxGeom().getY(), (long)this.sfc().time().max(), this.sfc().index$default$4());
        this.binMap = (Map)Map$.MODULE$.empty();
    }
}

