/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.text;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.text.DateParsing$TemporalQueries$;
import scala.MatchError;

public final class DateParsing$ {
    public static final DateParsing$ MODULE$ = new DateParsing$();
    private static final DateTimeFormatter format = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseLenient().optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalEnd().optionalEnd().optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
    private static final ZonedDateTime Epoch = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);

    private DateTimeFormatter format() {
        return format;
    }

    public ZonedDateTime Epoch() {
        return Epoch;
    }

    public ZonedDateTime parse(String value, DateTimeFormatter format) {
        TemporalAccessor temporalAccessor = format.parseBest(value, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery(), DateParsing$TemporalQueries$.MODULE$.YearMonthQuery(), DateParsing$TemporalQueries$.MODULE$.YearQuery());
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
            return zonedDateTime;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
            return localDateTime.atZone(ZoneOffset.UTC);
        }
        if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            return localDate.atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        }
        if (temporalAccessor instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)temporalAccessor;
            return yearMonth.atDay(1).atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        }
        if (temporalAccessor instanceof Year) {
            Year year = (Year)temporalAccessor;
            return year.atMonth(1).atDay(1).atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        }
        throw new MatchError((Object)temporalAccessor);
    }

    public DateTimeFormatter parse$default$2() {
        return this.format();
    }

    public Instant parseInstant(String value, DateTimeFormatter format) {
        TemporalAccessor temporalAccessor = format.parseBest(value, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
            return zonedDateTime.toInstant();
        }
        if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
            return localDateTime.toInstant(ZoneOffset.UTC);
        }
        if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            return localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC);
        }
        throw new MatchError((Object)temporalAccessor);
    }

    public DateTimeFormatter parseInstant$default$2() {
        return this.format();
    }

    public Date parseDate(String value, DateTimeFormatter format) {
        TemporalAccessor temporalAccessor = format.parseBest(value, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
            return Date.from(zonedDateTime.toInstant());
        }
        if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
            return Date.from(localDateTime.toInstant(ZoneOffset.UTC));
        }
        if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            return Date.from(localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC));
        }
        throw new MatchError((Object)temporalAccessor);
    }

    public DateTimeFormatter parseDate$default$2() {
        return this.format();
    }

    public long parseMillis(String value, DateTimeFormatter format) {
        TemporalAccessor temporalAccessor = format.parseBest(value, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
            return zonedDateTime.toInstant().toEpochMilli();
        }
        if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
            return localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            return localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        throw new MatchError((Object)temporalAccessor);
    }

    public DateTimeFormatter parseMillis$default$2() {
        return this.format();
    }

    public String format(ZonedDateTime value, DateTimeFormatter format) {
        return value.format(format);
    }

    public DateTimeFormatter format$default$2() {
        return this.format();
    }

    public String formatDate(Date value, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(value), ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatDate$default$2() {
        return this.format();
    }

    public String formatInstant(Instant value, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(value, ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatInstant$default$2() {
        return this.format();
    }

    public String formatMillis(long value, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatMillis$default$2() {
        return this.format();
    }

    private DateParsing$() {
    }
}

