/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.text;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;

public final class StringSerialization$
implements LazyLogging {
    public static final StringSerialization$ MODULE$ = new StringSerialization$();
    private static final DateTimeFormatter dateFormat;
    private static final Pattern AlphaNumericPattern;
    private static final IndexedSeq<Object> AlphaNumeric;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        dateFormat = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);
        AlphaNumericPattern = Pattern.compile("^[a-zA-Z0-9]+$");
        AlphaNumeric = (IndexedSeq)((IterableOps)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')));
    }

    private Logger logger$lzycompute() {
        StringSerialization$ stringSerialization$ = this;
        synchronized (stringSerialization$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private DateTimeFormatter dateFormat() {
        return dateFormat;
    }

    private Pattern AlphaNumericPattern() {
        return AlphaNumericPattern;
    }

    private IndexedSeq<Object> AlphaNumeric() {
        return AlphaNumeric;
    }

    public String encodeSeq(Seq<String> values) {
        if (values.isEmpty()) {
            return "";
        }
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        CSVPrinter printer = new CSVPrinter((Appendable)sb, CSVFormat.DEFAULT);
        values.foreach((Function1 & Serializable)x$1 -> {
            printer.print(x$1);
            return BoxedUnit.UNIT;
        });
        return sb.toString();
    }

    public Seq<String> decodeSeq(String values) {
        if (values.isEmpty()) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        return (Seq)package$WithClose$.MODULE$.apply(CSVParser.parse((String)values, (CSVFormat)CSVFormat.DEFAULT), (Function1 & Serializable)x$1 -> ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(((CSVRecord)x$1.iterator().next()).iterator()).asScala()).toList(), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public String encodeMap(Map<String, String> values) {
        return this.encodeSeq((Seq<String>)((Seq)values.toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new .colon.colon((Object)k, (List)new .colon.colon((Object)v, (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    public scala.collection.immutable.Map<String, String> decodeMap(String values) {
        return this.decodeSeq(values).grouped(2).map((Function1 & Serializable)x0$1 -> {
            SeqOps seqOps;
            Seq seq = x0$1;
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                String k = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                String v = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError((Object)seq);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String encodeSeqMap(scala.collection.immutable.Map<String, Seq<Object>> map) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        CSVPrinter printer = new CSVPrinter((Appendable)sb, CSVFormat.DEFAULT);
        map.foreach((Function1 & Serializable)x0$1 -> {
            StringSerialization$.$anonfun$encodeSeqMap$1(printer, x0$1);
            return BoxedUnit.UNIT;
        });
        return sb.toString();
    }

    public scala.collection.immutable.Map<String, Object[]> decodeSeqMap(SimpleFeatureType sft, String encoded) {
        Buffer bindings = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.getLocalName()), (Object)d.getType().getBinding()));
        return this.decodeSeqMap(encoded, bindings.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public scala.collection.immutable.Map<String, Object[]> decodeSeqMap(String encoded, scala.collection.immutable.Map<String, Class<?>> bindings) {
        return (scala.collection.immutable.Map)package$WithClose$.MODULE$.apply(CSVParser.parse((String)encoded, (CSVFormat)CSVFormat.DEFAULT), (Function1 & Serializable)parser -> ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(parser.iterator()).asScala()).map(arg_0 -> StringSerialization$.$anonfun$decodeSeqMap$3(bindings, arg_0)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public String alphaNumericSafeString(String input) {
        if (this.AlphaNumericPattern().matcher(input).matches()) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(input), (Function1 & Serializable)c -> StringSerialization$.$anonfun$alphaNumericSafeString$1(sb, BoxesRunTime.unboxToChar((Object)c)));
        return sb.toString();
    }

    public String decodeAlphaNumericSafeString(String input) {
        if (this.AlphaNumericPattern().matcher(input).matches()) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            StringBuilder stringBuilder = c != '_' ? sb.append(c) : sb.append(new String(Hex.decodeHex((char[])new char[]{input.charAt((i += 2) - 1), input.charAt(i)}), StandardCharsets.UTF_8));
        }
        return sb.toString();
    }

    public static final /* synthetic */ void $anonfun$encodeSeqMap$1(CSVPrinter printer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Some some;
            String k = (String)tuple2._1();
            Seq v = (Seq)tuple2._2();
            Option option = v.headOption();
            Seq strings = option instanceof Some && (some = (Some)option).value() instanceof Date ? (Seq)v.map((Function1 & Serializable)d -> ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant((Date)d), ZoneOffset.UTC).format(MODULE$.dateFormat())) : v;
            printer$2.print((Object)k);
            strings.foreach((Function1 & Serializable)x$1 -> {
                printer$2.print(x$1);
                return BoxedUnit.UNIT;
            });
            printer$2.println();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Integer $anonfun$decodeSeqMap$4(String x$1) {
        return Integer.valueOf(x$1);
    }

    public static final /* synthetic */ Long $anonfun$decodeSeqMap$5(String x$1) {
        return Long.valueOf(x$1);
    }

    public static final /* synthetic */ Float $anonfun$decodeSeqMap$6(String x$1) {
        return Float.valueOf(x$1);
    }

    public static final /* synthetic */ Double $anonfun$decodeSeqMap$7(String x$1) {
        return Double.valueOf(x$1);
    }

    public static final /* synthetic */ Date $anonfun$decodeSeqMap$8(String v) {
        return Date.from(ZonedDateTime.parse(v, MODULE$.dateFormat()).toInstant());
    }

    public static final /* synthetic */ Boolean $anonfun$decodeSeqMap$9(String x$1) {
        return Boolean.valueOf(x$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$decodeSeqMap$3(scala.collection.immutable.Map bindings$1, CSVRecord record) {
        block5: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    iter = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(record.iterator()).asScala();
                                    key = (String)iter.next();
                                    var6_4 = false;
                                    var7_5 = null;
                                    var8_6 = bindings$1.get((Object)key);
                                    if (!(var8_6 instanceof Some)) break block4;
                                    var6_4 = true;
                                    var7_5 = (Some)var8_6;
                                    v0 = c = (Class)var7_5.value();
                                    var10_8 = String.class;
                                    if (v0 != null ? v0.equals(var10_8) == false : var10_8 != null) break block4;
                                    v1 = (Object[])iter.toArray(ClassTag$.MODULE$.AnyRef());
                                    break block5;
                                }
                                if (!var6_4) break block6;
                                v2 = c = (Class)var7_5.value();
                                var12_10 = Integer.class;
                                if (v2 != null ? v2.equals(var12_10) == false : var12_10 != null) break block6;
                                v1 = (Object[])iter.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$4(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Integer;)()).toArray(ClassTag$.MODULE$.AnyRef());
                                break block5;
                            }
                            if (!var6_4) break block7;
                            v3 = c = (Class)var7_5.value();
                            var14_12 = Long.class;
                            if (v3 != null ? v3.equals(var14_12) == false : var14_12 != null) break block7;
                            v1 = (Object[])iter.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$5(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Long;)()).toArray(ClassTag$.MODULE$.AnyRef());
                            break block5;
                        }
                        if (!var6_4) break block8;
                        v4 = c = (Class)var7_5.value();
                        var16_14 = Float.class;
                        if (v4 != null ? v4.equals(var16_14) == false : var16_14 != null) break block8;
                        v1 = (Object[])iter.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$6(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Float;)()).toArray(ClassTag$.MODULE$.AnyRef());
                        break block5;
                    }
                    if (!var6_4) break block9;
                    v5 = c = (Class)var7_5.value();
                    var18_16 = Double.class;
                    if (v5 != null ? v5.equals(var18_16) == false : var18_16 != null) break block9;
                    v1 = (Object[])iter.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$7(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Double;)()).toArray(ClassTag$.MODULE$.AnyRef());
                    break block5;
                }
                if (!var6_4 || !Date.class.isAssignableFrom(c = (Class)var7_5.value())) break block10;
                v1 = (Object[])iter.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$8(java.lang.String ), (Ljava/lang/String;)Ljava/util/Date;)()).toArray(ClassTag$.MODULE$.AnyRef());
                break block5;
            }
            if (!var6_4) ** GOTO lbl-1000
            v6 = c = (Class)var7_5.value();
            var21_19 = Boolean.class;
            if (!(v6 != null ? v6.equals(var21_19) == false : var21_19 != null)) {
                v1 = (Object[])iter.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$9(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)()).toArray(ClassTag$.MODULE$.AnyRef());
            } else lbl-1000:
            // 2 sources

            {
                if (StringSerialization$.MODULE$.logger().underlying().isWarnEnabled()) {
                    StringSerialization$.MODULE$.logger().underlying().warn("No conversion defined for encoded attribute '{}' of type {}", new Object[]{key, var8_6.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())});
                    v7 = BoxedUnit.UNIT;
                } else {
                    v7 = BoxedUnit.UNIT;
                }
                v1 = (Object[])iter.toArray(ClassTag$.MODULE$.AnyRef());
            }
        }
        values = v1;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)values);
    }

    public static final /* synthetic */ StringBuilder $anonfun$alphaNumericSafeString$1(StringBuilder sb$1, char c) {
        if (MODULE$.AlphaNumeric().contains((Object)BoxesRunTime.boxToCharacter((char)c))) {
            return sb$1.append(c);
        }
        char[] hex = Hex.encodeHex((byte[])Character.toString(c).getBytes(StandardCharsets.UTF_8));
        String encoded = ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.charArrayOps(hex), 2).map((Function1 & Serializable)arr -> new java.lang.StringBuilder(1).append("_").append(arr[0]).append(arr[1]).toString()).mkString().toLowerCase(Locale.US);
        return sb$1.append(encoded);
    }

    private StringSerialization$() {
    }
}

