/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.text;

import java.io.Serializable;
import java.time.Duration;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class TextTools$ {
    public static final TextTools$ MODULE$ = new TextTools$();

    public String getPlural(long i, String base) {
        return this.getPlural(i, base, new java.lang.StringBuilder(1).append(base).append("s").toString());
    }

    public String getPlural(long i, String base, String pluralBase) {
        if (i == 1L) {
            return new java.lang.StringBuilder(1).append(i).append(" ").append(base).toString();
        }
        return new java.lang.StringBuilder(1).append(i).append(" ").append(pluralBase).toString();
    }

    public String prefixSpace(String base) {
        if (base.isEmpty()) {
            return base;
        }
        return new java.lang.StringBuilder(1).append(" ").append(base).toString();
    }

    public String getTime(long start) {
        Duration duration = Duration.ofMillis(System.currentTimeMillis() - start);
        long hours = duration.toHours();
        Duration minusHours = duration.minusHours(hours);
        long minutes = minusHours.toMinutes();
        long seconds = minusHours.minusMinutes(minutes).getSeconds();
        return StringOps$.MODULE$.format$extension("%02d:%02d:%02d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)hours), BoxesRunTime.boxToLong((long)minutes), BoxesRunTime.boxToLong((long)seconds)}));
    }

    public String buildString(char c, int length) {
        if (length < 0) {
            return "";
        }
        return new String((char[])Array$.MODULE$.fill(length, (Function0)(JFunction0.mcC.sp & Serializable)() -> c, (ClassTag)ClassTag$.MODULE$.Char()));
    }

    public String wordList(Iterable<String> words) {
        if (words.isEmpty()) {
            return "";
        }
        Iterator iter = words.iterator();
        String word = (String)iter.next();
        if (iter.hasNext()) {
            StringBuilder builder = new StringBuilder(word);
            word = (String)iter.next();
            while (iter.hasNext()) {
                builder.append(", ").append(word);
                word = (String)iter.next();
            }
            builder.append(" and ").append(word);
            return builder.result();
        }
        return word;
    }

    public boolean isWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(string.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private TextTools$() {
    }
}

