/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.uuid;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.security.SecureRandom;
import java.util.Date;
import java.util.UUID;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.uuid.RandomLsbUuidGenerator;
import org.locationtech.geomesa.utils.uuid.Version4UuidGenerator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.hashing.MurmurHash3$;

public final class Z3UuidGenerator$
implements RandomLsbUuidGenerator,
LazyLogging {
    public static final Z3UuidGenerator$ MODULE$ = new Z3UuidGenerator$();
    private static final String NullGeom;
    private static transient Logger logger;
    private static SecureRandom org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r;
    private static SoftThreadLocal<byte[]> org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Version4UuidGenerator.$init$(MODULE$);
        RandomLsbUuidGenerator.$init$(MODULE$);
        LazyLogging.$init$((LazyLogging)MODULE$);
        NullGeom = "Cannot meaningfully index a feature with a NULL geometry";
    }

    @Override
    public long createRandomLsb() {
        return RandomLsbUuidGenerator.createRandomLsb$(this);
    }

    @Override
    public byte[] getTempByteArray() {
        return Version4UuidGenerator.getTempByteArray$(this);
    }

    @Override
    public void setVariant(byte[] bytes2) {
        Version4UuidGenerator.setVariant$(this, bytes2);
    }

    @Override
    public void setVersion(byte[] bytes2) {
        Version4UuidGenerator.setVersion$(this, bytes2);
    }

    private Logger logger$lzycompute() {
        Z3UuidGenerator$ z3UuidGenerator$ = this;
        synchronized (z3UuidGenerator$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public SecureRandom org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r() {
        return org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r;
    }

    @Override
    public final void org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$_setter_$org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r_$eq(SecureRandom x$1) {
        org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r = x$1;
    }

    @Override
    public SoftThreadLocal<byte[]> org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache() {
        return org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache;
    }

    @Override
    public final void org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$_setter_$org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache_$eq(SoftThreadLocal<byte[]> x$1) {
        org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache = x$1;
    }

    private String NullGeom() {
        return NullGeom;
    }

    /*
     * Unable to fully structure code
     */
    public UUID createUuid(SimpleFeatureType sft, SimpleFeature sf) {
        var7_3 = false;
        var8_4 = null;
        var9_5 = sf.getAttribute(RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        if (var9_5 == null) {
            throw new IllegalArgumentException(this.NullGeom());
        }
        if (!(var9_5 instanceof Geometry)) ** GOTO lbl-1000
        var7_3 = true;
        var8_4 = (Geometry)var9_5;
        if (var8_4.isEmpty()) {
            v0 = new Tuple2.mcDD.sp(0.0, 0.0);
        } else if (var9_5 instanceof Point) {
            var10_6 = (Point)var9_5;
            v0 = new Tuple2.mcDD.sp(var10_6.getX(), var10_6.getY());
        } else if (var7_3) {
            p = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(var8_4));
            v0 = new Tuple2.mcDD.sp(p.getX(), p.getY());
        } else {
            throw new MatchError(var9_5);
        }
        var6_8 = v0;
        if (var6_8 == null) {
            throw new MatchError((Object)var6_8);
        }
        x = var6_8._1$mcD$sp();
        y = var6_8._2$mcD$sp();
        var5_11 = new Tuple2.mcDD.sp(x, y);
        x = var5_11._1$mcD$sp();
        y = var5_11._2$mcD$sp();
        time = BoxesRunTime.unboxToLong((Object)RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createUuid$1$adapted(org.opengis.feature.simple.SimpleFeature java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)((SimpleFeature)sf)).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createUuid$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()J, $anonfun$createUuid$3(), ()J)()));
        return this.createUuid(x, y, time, RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
    }

    public UUID createUuid(Geometry geom, long time, Enumeration.Value period) {
        if (geom == null) {
            throw new IllegalArgumentException(this.NullGeom());
        }
        if (geom.isEmpty()) {
            return this.createUuid(0.0, 0.0, time, period);
        }
        Point pt = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
        return this.createUuid(pt.getX(), pt.getY(), time, period);
    }

    public UUID createUuid(Point pt, long time, Enumeration.Value period) {
        if (pt == null) {
            throw new IllegalArgumentException(this.NullGeom());
        }
        if (pt.isEmpty()) {
            return this.createUuid(0.0, 0.0, time, period);
        }
        return this.createUuid(pt.getX(), pt.getY(), time, period);
    }

    public UUID createUuid(double x, double y, long time, Enumeration.Value period) {
        long leastSigBits = this.createRandomLsb();
        BinnedTime binnedTime = (BinnedTime)BinnedTime$.MODULE$.timeToBinnedTime(period).apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long t2 = tuple2._2$mcJ$sp();
        Z3SFC qual$1 = Z3SFC$.MODULE$.apply(period);
        double x$1 = x;
        double x$2 = y;
        long x$3 = t2;
        boolean x$4 = qual$1.index$default$4();
        long z = qual$1.index(x$1, x$2, x$3, x$4);
        byte[] z3 = ByteArrays$.MODULE$.toBytes(b2, z);
        byte shard = (byte)package$.MODULE$.abs(MurmurHash3$.MODULE$.bytesHash(z3, 1007110753) % 16);
        byte[] msb = this.getTempByteArray();
        msb[0] = this.lohi(shard, z3[0]);
        msb[1] = this.lohi(z3[0], z3[1]);
        msb[2] = this.lohi(z3[1], z3[2]);
        msb[3] = this.lohi(z3[2], z3[3]);
        msb[4] = this.lohi(z3[3], z3[4]);
        msb[5] = this.lohi(z3[4], z3[5]);
        msb[6] = this.lohi((byte)0, (byte)(z3[5] << 4));
        msb[7] = z3[6];
        this.setVersion(msb);
        long mostSigBits = ByteArrays$.MODULE$.readLong(msb, ByteArrays$.MODULE$.readLong$default$2());
        return new UUID(mostSigBits, leastSigBits);
    }

    public short timeBin(byte[] uuid, int offset) {
        return this.timeBin(uuid[offset], uuid[offset + 1], uuid[offset + 2]);
    }

    public short timeBin(byte b0, byte b1, byte b2) {
        return ByteArrays$.MODULE$.readShort(new byte[]{this.lohi(b0, b1), this.lohi(b1, b2)}, ByteArrays$.MODULE$.readShort$default$2());
    }

    public int timeBin$default$2() {
        return 0;
    }

    private byte lohi(byte b1, byte b2) {
        return (byte)(Byte.toUnsignedInt(b1) << 4 | Byte.toUnsignedInt(b2) >>> 4);
    }

    public static final /* synthetic */ long $anonfun$createUuid$2(Object x$2) {
        return ((Date)x$2).getTime();
    }

    public static final /* synthetic */ long $anonfun$createUuid$3() {
        return System.currentTimeMillis();
    }

    private Z3UuidGenerator$() {
    }

    public static final /* synthetic */ Option $anonfun$createUuid$1$adapted(SimpleFeature sf$1, Object i) {
        return Option$.MODULE$.apply(sf$1.getAttribute(BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Object $anonfun$createUuid$2$adapted(Object x$2) {
        return BoxesRunTime.boxToLong((long)Z3UuidGenerator$.$anonfun$createUuid$2(x$2));
    }
}

