/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.curve;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.curve.XZSFC$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.locationtech.geomesa.zorder.sfcurve.package$IndexRange$;
import org.locationtech.geomesa.zorder.sfcurve.package$IndexRange$IndexRangeIsOrdered$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rue\u0001\u00027n\u0001YD\u0001\" \u0001\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001BCA\t\u0001\t\u0005\t\u0015!\u0003\u0002\u0006!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001\"CA\u0011\u0001\t\u0007I\u0011BA\u0012\u0011!\t)\u0003\u0001Q\u0001\n\u0005-\u0001\"CA\u0014\u0001\t\u0007I\u0011BA\u0012\u0011!\tI\u0003\u0001Q\u0001\n\u0005-\u0001\"CA\u0016\u0001\t\u0007I\u0011BA\u0012\u0011!\ti\u0003\u0001Q\u0001\n\u0005-\u0001\"CA\u0018\u0001\t\u0007I\u0011BA\u0012\u0011!\t\t\u0004\u0001Q\u0001\n\u0005-\u0001\"CA\u001a\u0001\t\u0007I\u0011BA\u0012\u0011!\t)\u0004\u0001Q\u0001\n\u0005-\u0001\"CA\u001c\u0001\t\u0007I\u0011BA\u0012\u0011!\tI\u0004\u0001Q\u0001\n\u0005-\u0001bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003w\u0001A\u0011AA(\u0011%\tY\u0007AI\u0001\n\u0003\ti\u0007C\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002L\"9\u00111\u0011\u0001\u0005\u0002\u0005}\u0007bBAB\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003\u0007\u0003A\u0011AA{\u0011%\ty\u0010AI\u0001\n\u0003\u0011\t\u0001C\u0004\u0002\u0004\u0002!IA!\u0002\t\u000f\rE\u0004\u0001\"\u0003\u0004t!91q\u0010\u0001\u0005\n\r\u0005\u0005bBBH\u0001\u0011%1\u0011S\u0004\b\u0005/i\u0007\u0012\u0001B\r\r\u0019aW\u000e#\u0001\u0003\u001c!9\u00111C\u0010\u0005\u0002\tu\u0001\"\u0003B\u0010?\t\u0007I\u0011\u0002B\u0011\u0011!\u0011\tp\bQ\u0001\n\t\r\u0002\"\u0003Bz?\t\u0007I\u0011\u0002B{\u0011!\u00119p\bQ\u0001\n\t\u0015\u0002\"\u0003B}?\t\u0007I\u0011\u0002B~\u0011!\u0019ia\bQ\u0001\n\tu\bbBB\b?\u0011\u00051\u0011\u0003\u0004\u0007\u0005?zBI!\u0019\t\u0015\u0005M\u0003F!f\u0001\n\u0003\t\u0019\u0003\u0003\u0006\u0003:!\u0012\t\u0012)A\u0005\u0003\u0017A!\"a\u0016)\u0005+\u0007I\u0011AA\u0012\u0011)\u0011Y\u0004\u000bB\tB\u0003%\u00111\u0002\u0005\u000b\u00037B#Q3A\u0005\u0002\u0005\r\u0002B\u0003B\u001fQ\tE\t\u0015!\u0003\u0002\f!Q\u0011q\f\u0015\u0003\u0016\u0004%\t!a\t\t\u0015\t}\u0002F!E!\u0002\u0013\tY\u0001C\u0004\u0002\u0014!\"\tAa\u0019\t\u0013\t5\u0004&!A\u0005\u0002\t=\u0004\"\u0003B=QE\u0005I\u0011\u0001B>\u0011%\u0011y\bKI\u0001\n\u0003\u0011Y\bC\u0005\u0003\u0002\"\n\n\u0011\"\u0001\u0003|!I!1\u0011\u0015\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0005\u000bC\u0013\u0011!C!\u0005\u000fC\u0011B!')\u0003\u0003%\tAa'\t\u0013\tu\u0005&!A\u0005\u0002\t}\u0005\"\u0003BVQ\u0005\u0005I\u0011\tBW\u0011%\u0011Y\fKA\u0001\n\u0003\u0011i\fC\u0005\u0003B\"\n\t\u0011\"\u0011\u0003D\"I!Q\u0019\u0015\u0002\u0002\u0013\u0005#q\u0019\u0005\n\u0005\u0013D\u0013\u0011!C!\u0005\u0017<\u0011b!\u0006 \u0003\u0003EIaa\u0006\u0007\u0013\t}s$!A\t\n\re\u0001bBA\n\u0001\u0012\u00051q\u0005\u0005\n\u0005\u000b\u0004\u0015\u0011!C#\u0005\u000fD\u0011ba\u0004A\u0003\u0003%\ti!\u000b\t\u0013\rM\u0002)!A\u0005\u0002\u000eU\u0002\"CB\u001f\u0001\u0006\u0005I\u0011BB \r\u0019\u0011Ic\b#\u0003,!Q\u00111\u000b$\u0003\u0016\u0004%\t!a\t\t\u0015\tebI!E!\u0002\u0013\tY\u0001\u0003\u0006\u0002X\u0019\u0013)\u001a!C\u0001\u0003GA!Ba\u000fG\u0005#\u0005\u000b\u0011BA\u0006\u0011)\tYF\u0012BK\u0002\u0013\u0005\u00111\u0005\u0005\u000b\u0005{1%\u0011#Q\u0001\n\u0005-\u0001BCA0\r\nU\r\u0011\"\u0001\u0002$!Q!q\b$\u0003\u0012\u0003\u0006I!a\u0003\t\u0015\t\u0005cI!f\u0001\n\u0003\t\u0019\u0003\u0003\u0006\u0003D\u0019\u0013\t\u0012)A\u0005\u0003\u0017Aq!a\u0005G\t\u0003\u0011)\u0005\u0003\u0006\u0003R\u0019C)\u0019!C\u0001\u0003GA!Ba\u0015G\u0011\u000b\u0007I\u0011AA\u0012\u0011\u001d\u0011)F\u0012C\u0001\u0005/BqAa4G\t\u0003\u0011\t\u000eC\u0004\u0003V\u001a#\tA!\t\t\u0013\t5d)!A\u0005\u0002\t]\u0007\"\u0003B=\rF\u0005I\u0011\u0001B>\u0011%\u0011yHRI\u0001\n\u0003\u0011Y\bC\u0005\u0003\u0002\u001a\u000b\n\u0011\"\u0001\u0003|!I!1\u0011$\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0005G4\u0015\u0013!C\u0001\u0005wB\u0011B!\"G\u0003\u0003%\tEa\"\t\u0013\tee)!A\u0005\u0002\tm\u0005\"\u0003BO\r\u0006\u0005I\u0011\u0001Bs\u0011%\u0011YKRA\u0001\n\u0003\u0012i\u000bC\u0005\u0003<\u001a\u000b\t\u0011\"\u0001\u0003j\"I!\u0011\u0019$\u0002\u0002\u0013\u0005#1\u0019\u0005\n\u0005\u000b4\u0015\u0011!C!\u0005\u000fD\u0011B!3G\u0003\u0003%\tE!<\b\u0013\r\u001ds$!A\t\n\r%c!\u0003B\u0015?\u0005\u0005\t\u0012BB&\u0011\u001d\t\u0019B\u001aC\u0001\u0007'B\u0011B!2g\u0003\u0003%)Ea2\t\u0013\r=a-!A\u0005\u0002\u000eU\u0003\"CB\u001aM\u0006\u0005I\u0011QB1\u0011%\u0019iDZA\u0001\n\u0013\u0019yD\u0001\u0004Y5J\u001afi\u0011\u0006\u0003]>\fQaY;sm\u0016T!\u0001]9\u0002\u000f\u001d,w.\\3tC*\u0011!o]\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002i\u0006\u0019qN]4\u0004\u0001M\u0011\u0001a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0002u\u0006)1oY1mC&\u0011A0\u001f\u0002\u0007\u0003:L(+\u001a4\u0002\u0003\u001d\u0004\"\u0001_@\n\u0007\u0005\u0005\u0011PA\u0003TQ>\u0014H/A\u0004y\u0005>,h\u000eZ:\u0011\u000fa\f9!a\u0003\u0002\f%\u0019\u0011\u0011B=\u0003\rQ+\b\u000f\\33!\rA\u0018QB\u0005\u0004\u0003\u001fI(A\u0002#pk\ndW-A\u0004z\u0005>,h\u000eZ:\u0002\rqJg.\u001b;?)!\t9\"a\u0007\u0002\u001e\u0005}\u0001cAA\r\u00015\tQ\u000eC\u0003~\t\u0001\u0007a\u0010C\u0004\u0002\u0004\u0011\u0001\r!!\u0002\t\u000f\u0005EA\u00011\u0001\u0002\u0006\u0005\u0019\u0001\u0010T8\u0016\u0005\u0005-\u0011\u0001\u0002=M_\u0002\n1\u0001\u001f%j\u0003\u0011A\b*\u001b\u0011\u0002\u0007edu.\u0001\u0003z\u0019>\u0004\u0013aA=IS\u0006!\u0011\u0010S5!\u0003\u0015A8+\u001b>f\u0003\u0019A8+\u001b>fA\u0005)\u0011pU5{K\u00061\u0011pU5{K\u0002\nQ!\u001b8eKb$B!a\u0010\u0002FA\u0019\u00010!\u0011\n\u0007\u0005\r\u0013P\u0001\u0003M_:<\u0007bBA$#\u0001\u0007\u0011\u0011J\u0001\u0007E>,h\u000eZ:\u0011\u0017a\fY%a\u0003\u0002\f\u0005-\u00111B\u0005\u0004\u0003\u001bJ(A\u0002+va2,G\u0007\u0006\u0007\u0002@\u0005E\u0013QKA-\u0003;\n\t\u0007C\u0004\u0002TI\u0001\r!a\u0003\u0002\tal\u0017N\u001c\u0005\b\u0003/\u0012\u0002\u0019AA\u0006\u0003\u0011IX.\u001b8\t\u000f\u0005m#\u00031\u0001\u0002\f\u0005!\u00010\\1y\u0011\u001d\tyF\u0005a\u0001\u0003\u0017\tA!_7bq\"I\u00111\r\n\u0011\u0002\u0003\u0007\u0011QM\u0001\bY\u0016t\u0017.\u001a8u!\rA\u0018qM\u0005\u0004\u0003SJ(a\u0002\"p_2,\u0017M\\\u0001\u0010S:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u000e\u0016\u0005\u0003K\n\th\u000b\u0002\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!C;oG\",7m[3e\u0015\r\ti(_\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAA\u0003o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0019\u0011\u0018M\\4fgR!\u0011qQAd!\u0019\tI)!'\u0002 :!\u00111RAK\u001d\u0011\ti)a%\u000e\u0005\u0005=%bAAIk\u00061AH]8pizJ\u0011A_\u0005\u0004\u0003/K\u0018a\u00029bG.\fw-Z\u0005\u0005\u00037\u000biJA\u0002TKFT1!a&z!\u0011\t\t+!1\u000f\t\u0005\r\u0016Q\u0018\b\u0005\u0003K\u000b9L\u0004\u0003\u0002(\u0006Mf\u0002BAU\u0003csA!a+\u00020:!\u0011QRAW\u0013\u0005!\u0018B\u0001:t\u0013\t\u0001\u0018/C\u0002\u00026>\faA_8sI\u0016\u0014\u0018\u0002BA]\u0003w\u000bqa\u001d4dkJ4XMC\u0002\u00026>LA!a&\u0002@*!\u0011\u0011XA^\u0013\u0011\t\u0019-!2\u0003\u0015%sG-\u001a=SC:<WM\u0003\u0003\u0002\u0018\u0006}\u0006bBAe)\u0001\u0007\u0011\u0011J\u0001\u0006cV,'/\u001f\u000b\u0007\u0003\u000f\u000bi-a4\t\u000f\u0005%W\u00031\u0001\u0002J!9\u0011\u0011[\u000bA\u0002\u0005M\u0017!C7bqJ\u000bgnZ3t!\u0015A\u0018Q[Am\u0013\r\t9.\u001f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007a\fY.C\u0002\u0002^f\u00141!\u00138u))\t9)!9\u0002d\u0006\u0015\u0018q\u001d\u0005\b\u0003'2\u0002\u0019AA\u0006\u0011\u001d\t9F\u0006a\u0001\u0003\u0017Aq!a\u0017\u0017\u0001\u0004\tY\u0001C\u0004\u0002`Y\u0001\r!a\u0003\u0015\u0019\u0005\u001d\u00151^Aw\u0003_\f\t0a=\t\u000f\u0005Ms\u00031\u0001\u0002\f!9\u0011qK\fA\u0002\u0005-\u0001bBA./\u0001\u0007\u00111\u0002\u0005\b\u0003?:\u0002\u0019AA\u0006\u0011\u001d\t\tn\u0006a\u0001\u0003'$b!a\"\u0002x\u0006u\bbBA}1\u0001\u0007\u00111`\u0001\bcV,'/[3t!\u0019\tI)!'\u0002J!I\u0011\u0011\u001b\r\u0011\u0002\u0003\u0007\u00111[\u0001\u0011e\u0006tw-Z:%I\u00164\u0017-\u001e7uII*\"Aa\u0001+\t\u0005M\u0017\u0011\u000f\u000b\u0007\u0003\u000f\u00139a!\u001c\t\u000f\u0005%'\u00041\u0001\u0003\nA)\u0001Pa\u0003\u0003\u0010%\u0019!QB=\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\tE\u0001FD\u0002\u0003\u0014yqA!a*\u0003\u0016%\u0011an\\\u0001\u00071j\u00134KR\"\u0011\u0007\u0005eqd\u0005\u0002 oR\u0011!\u0011D\u0001\u0011\u0019\u00164X\r\\(oK\u0016cW-\\3oiN,\"Aa\t\u0011\r\u0005%\u0015\u0011\u0014B\u0013!\r\u00119CR\u0007\u0002?\tA\u0001,\u00127f[\u0016tGo\u0005\u0004Go\n5\"1\u0007\t\u0004q\n=\u0012b\u0001B\u0019s\n9\u0001K]8ek\u000e$\bc\u0001=\u00036%\u0019!qG=\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000bal\u0017N\u001c\u0011\u0002\u000bel\u0017N\u001c\u0011\u0002\u000bal\u0017\r\u001f\u0011\u0002\u000bel\u0017\r\u001f\u0011\u0002\r1,gn\u001a;i\u0003\u001daWM\\4uQ\u0002\"BB!\n\u0003H\t%#1\nB'\u0005\u001fBq!a\u0015R\u0001\u0004\tY\u0001C\u0004\u0002XE\u0003\r!a\u0003\t\u000f\u0005m\u0013\u000b1\u0001\u0002\f!9\u0011qL)A\u0002\u0005-\u0001b\u0002B!#\u0002\u0007\u00111B\u0001\u0005q\u0016DH/\u0001\u0003zKb$\u0018aC5t\u0007>tG/Y5oK\u0012$B!!\u001a\u0003Z!9!1\f+A\u0002\tu\u0013AB<j]\u0012|w\u000fE\u0002\u0003(!\u00121\"U;fef<\u0016N\u001c3poN1\u0001f\u001eB\u0017\u0005g!\"B!\u0018\u0003f\t\u001d$\u0011\u000eB6\u0011\u001d\t\u0019&\ra\u0001\u0003\u0017Aq!a\u00162\u0001\u0004\tY\u0001C\u0004\u0002\\E\u0002\r!a\u0003\t\u000f\u0005}\u0013\u00071\u0001\u0002\f\u0005!1m\u001c9z))\u0011iF!\u001d\u0003t\tU$q\u000f\u0005\n\u0003'\u0012\u0004\u0013!a\u0001\u0003\u0017A\u0011\"a\u00163!\u0003\u0005\r!a\u0003\t\u0013\u0005m#\u0007%AA\u0002\u0005-\u0001\"CA0eA\u0005\t\u0019AA\u0006\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A! +\t\u0005-\u0011\u0011O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0013\u0003BAa#\u0003\u00166\u0011!Q\u0012\u0006\u0005\u0005\u001f\u0013\t*\u0001\u0003mC:<'B\u0001BJ\u0003\u0011Q\u0017M^1\n\t\t]%Q\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005e\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005C\u00139\u000bE\u0002y\u0005GK1A!*z\u0005\r\te.\u001f\u0005\n\u0005SK\u0014\u0011!a\u0001\u00033\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BX!\u0019\u0011\tLa.\u0003\"6\u0011!1\u0017\u0006\u0004\u0005kK\u0018AC2pY2,7\r^5p]&!!\u0011\u0018BZ\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015$q\u0018\u0005\n\u0005S[\u0014\u0011!a\u0001\u0005C\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00033\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0013\u000ba!Z9vC2\u001cH\u0003BA3\u0005\u001bD\u0011B!+?\u0003\u0003\u0005\rA!)\u0002\u0011=4XM\u001d7baN$B!!\u001a\u0003T\"9!1L+A\u0002\tu\u0013\u0001C2iS2$'/\u001a8\u0015\u0019\t\u0015\"\u0011\u001cBn\u0005;\u0014yN!9\t\u0013\u0005Ms\u000b%AA\u0002\u0005-\u0001\"CA,/B\u0005\t\u0019AA\u0006\u0011%\tYf\u0016I\u0001\u0002\u0004\tY\u0001C\u0005\u0002`]\u0003\n\u00111\u0001\u0002\f!I!\u0011I,\u0011\u0002\u0003\u0007\u00111B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136)\u0011\u0011\tKa:\t\u0013\t%v,!AA\u0002\u0005eG\u0003BA3\u0005WD\u0011B!+b\u0003\u0003\u0005\rA!)\u0015\t\u0005\u0015$q\u001e\u0005\n\u0005S#\u0017\u0011!a\u0001\u0005C\u000b\u0011\u0003T3wK2|e.Z#mK6,g\u000e^:!\u0003=aUM^3m)\u0016\u0014X.\u001b8bi>\u0014XC\u0001B\u0013\u0003AaUM^3m)\u0016\u0014X.\u001b8bi>\u0014\b%A\u0003dC\u000eDW-\u0006\u0002\u0003~B9!q`B\u0005}\u0006]QBAB\u0001\u0015\u0011\u0019\u0019a!\u0002\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0004\b\tE\u0015\u0001B;uS2LAaa\u0003\u0004\u0002\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0002\r\r\f7\r[3!\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\t9ba\u0005\t\u000bu<\u0003\u0019\u0001@\u0002\u0017E+XM]=XS:$wn\u001e\t\u0004\u0005O\u00015#\u0002!\u0004\u001c\tM\u0002CDB\u000f\u0007G\tY!a\u0003\u0002\f\u0005-!QL\u0007\u0003\u0007?Q1a!\tz\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\n\u0004 \t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\r]AC\u0003B/\u0007W\u0019ica\f\u00042!9\u00111K\"A\u0002\u0005-\u0001bBA,\u0007\u0002\u0007\u00111\u0002\u0005\b\u00037\u001a\u0005\u0019AA\u0006\u0011\u001d\tyf\u0011a\u0001\u0003\u0017\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u00048\re\u0002#\u0002=\u0002V\u0006%\u0003\"CB\u001e\t\u0006\u0005\t\u0019\u0001B/\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004BA!!1RB\"\u0013\u0011\u0019)E!$\u0003\r=\u0013'.Z2u\u0003!AV\t\\3nK:$\bc\u0001B\u0014MN)am!\u0014\u00034A\u00012QDB(\u0003\u0017\tY!a\u0003\u0002\f\u0005-!QE\u0005\u0005\u0007#\u001ayBA\tBEN$(/Y2u\rVt7\r^5p]V\"\"a!\u0013\u0015\u0019\t\u00152qKB-\u00077\u001aifa\u0018\t\u000f\u0005M\u0013\u000e1\u0001\u0002\f!9\u0011qK5A\u0002\u0005-\u0001bBA.S\u0002\u0007\u00111\u0002\u0005\b\u0003?J\u0007\u0019AA\u0006\u0011\u001d\u0011\t%\u001ba\u0001\u0003\u0017!Baa\u0019\u0004lA)\u00010!6\u0004fAi\u0001pa\u001a\u0002\f\u0005-\u00111BA\u0006\u0003\u0017I1a!\u001bz\u0005\u0019!V\u000f\u001d7fk!I11\b6\u0002\u0002\u0003\u0007!Q\u0005\u0005\b\u0007_R\u0002\u0019AAm\u0003%\u0011\u0018M\\4f'R|\u0007/\u0001\u0007tKF,XM\\2f\u0007>$W\r\u0006\u0005\u0002@\rU4\u0011PB?\u0011\u001d\u00199h\u0007a\u0001\u0003\u0017\t\u0011\u0001\u001f\u0005\b\u0007wZ\u0002\u0019AA\u0006\u0003\u0005I\bb\u0002B!7\u0001\u0007\u0011\u0011\\\u0001\u0011g\u0016\fX/\u001a8dK&sG/\u001a:wC2$\"ba!\u0004\u0006\u000e\u001d5\u0011RBF!\u001dA\u0018qAA \u0003\u007fAqaa\u001e\u001d\u0001\u0004\tY\u0001C\u0004\u0004|q\u0001\r!a\u0003\t\r\t\u0005C\u00041\u0001\u007f\u0011\u001d\u0019i\t\ba\u0001\u0003K\nq\u0001]1si&\fG.A\u0005o_Jl\u0017\r\\5{KRa\u0011\u0011JBJ\u0007+\u001b9j!'\u0004\u001c\"9\u00111K\u000fA\u0002\u0005-\u0001bBA,;\u0001\u0007\u00111\u0002\u0005\b\u00037j\u0002\u0019AA\u0006\u0011\u001d\ty&\ba\u0001\u0003\u0017Aq!a\u0019\u001e\u0001\u0004\t)\u0007")
public class XZ2SFC {
    private final short g;
    private final double xLo;
    private final double xHi;
    private final double yLo;
    private final double yHi;
    private final double xSize;
    private final double ySize;

    public static XZ2SFC apply(short s) {
        return XZ2SFC$.MODULE$.apply(s);
    }

    private double xLo() {
        return this.xLo;
    }

    private double xHi() {
        return this.xHi;
    }

    private double yLo() {
        return this.yLo;
    }

    private double yHi() {
        return this.yHi;
    }

    private double xSize() {
        return this.xSize;
    }

    private double ySize() {
        return this.ySize;
    }

    public long index(Tuple4<Object, Object, Object, Object> bounds) {
        return this.index(BoxesRunTime.unboxToDouble((Object)bounds._1()), BoxesRunTime.unboxToDouble((Object)bounds._2()), BoxesRunTime.unboxToDouble((Object)bounds._3()), BoxesRunTime.unboxToDouble((Object)bounds._4()), this.index$default$5());
    }

    public long index(double xmin, double ymin, double xmax, double ymax, boolean lenient) {
        double w2;
        Tuple4<Object, Object, Object, Object> tuple4 = this.normalize(xmin, ymin, xmax, ymax, lenient);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        double nxmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double nymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double nxmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double nymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)nxmin), (Object)BoxesRunTime.boxToDouble((double)nymin), (Object)BoxesRunTime.boxToDouble((double)nxmax), (Object)BoxesRunTime.boxToDouble((double)nymax));
        double nxmin2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
        double nymin2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
        double nxmax2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
        double nymax2 = BoxesRunTime.unboxToDouble((Object)tuple42._4());
        double maxDim = package$.MODULE$.max(nxmax2 - nxmin2, nymax2 - nymin2);
        int l1 = (int)package$.MODULE$.floor(package$.MODULE$.log(maxDim) / XZSFC$.MODULE$.LogPointFive());
        int length = l1 >= this.g ? this.g : (XZ2SFC.predicate$1(nxmin2, nxmax2, w2 = package$.MODULE$.pow(0.5, (double)(l1 + 1))) && XZ2SFC.predicate$1(nymin2, nymax2, w2) ? l1 + 1 : l1);
        return this.sequenceCode(nxmin2, nymin2, length);
    }

    public boolean index$default$5() {
        return false;
    }

    public Seq<package.IndexRange> ranges(Tuple4<Object, Object, Object, Object> query) {
        return this.ranges((Seq<Tuple4<Object, Object, Object, Object>>)((Seq)new .colon.colon(query, (List)Nil$.MODULE$)), this.ranges$default$2());
    }

    public Seq<package.IndexRange> ranges(Tuple4<Object, Object, Object, Object> query, Option<Object> maxRanges) {
        return this.ranges((Seq<Tuple4<Object, Object, Object, Object>>)((Seq)new .colon.colon(query, (List)Nil$.MODULE$)), maxRanges);
    }

    public Seq<package.IndexRange> ranges(double xmin, double ymin, double xmax, double ymax) {
        return this.ranges((Seq<Tuple4<Object, Object, Object, Object>>)((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax)), (List)Nil$.MODULE$)), this.ranges$default$2());
    }

    public Seq<package.IndexRange> ranges(double xmin, double ymin, double xmax, double ymax, Option<Object> maxRanges) {
        return this.ranges((Seq<Tuple4<Object, Object, Object, Object>>)((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax)), (List)Nil$.MODULE$)), maxRanges);
    }

    public Seq<package.IndexRange> ranges(Seq<Tuple4<Object, Object, Object, Object>> queries, Option<Object> maxRanges) {
        Seq windows = (Seq)queries.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double ymax;
                double xmax;
                double ymin;
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                Tuple4<Object, Object, Object, Object> tuple42 = this.normalize(xmin, ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2()), xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3()), ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4()), false);
                if (tuple42 == null) {
                    throw new MatchError(tuple42);
                }
                double nxmin = BoxesRunTime.unboxToDouble((Object)tuple42._1());
                double nymin = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                double nxmax = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                double nymax = BoxesRunTime.unboxToDouble((Object)tuple42._4());
                Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)nxmin), (Object)BoxesRunTime.boxToDouble((double)nymin), (Object)BoxesRunTime.boxToDouble((double)nxmax), (Object)BoxesRunTime.boxToDouble((double)nymax));
                double nxmin2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
                double nymin2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                double nxmax2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
                double nymax2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
                return new QueryWindow(nxmin2, nymin2, nxmax2, nymax2);
            }
            throw new MatchError((Object)tuple4);
        }, Seq$.MODULE$.canBuildFrom());
        return this.ranges((QueryWindow[])windows.toArray(ClassTag$.MODULE$.apply(QueryWindow.class)), BoxesRunTime.unboxToInt((Object)maxRanges.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)));
    }

    private Seq<package.IndexRange> ranges(QueryWindow[] query, int rangeStop) {
        ArrayList<package.IndexRange> ranges = new ArrayList<package.IndexRange>(100);
        ArrayDeque<XElement> remaining = new ArrayDeque<XElement>(100);
        XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelOneElements().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)remaining.add(x$1)));
        remaining.add(XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelTerminator());
        short level = 1;
        while (level < this.g && !remaining.isEmpty() && ranges.size() < rangeStop) {
            Object object;
            XElement next = (XElement)remaining.poll();
            if (next == XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelTerminator()) {
                if (!remaining.isEmpty()) {
                    level = (short)(level + 1);
                    object = BoxesRunTime.boxToBoolean((boolean)remaining.add(XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelTerminator()));
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            this.checkValue$1(next, level, ranges, remaining, query);
            object = BoxedUnit.UNIT;
        }
        while (!remaining.isEmpty()) {
            Object object;
            XElement quad = (XElement)remaining.poll();
            if (quad == XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelTerminator()) {
                level = (short)(level + 1);
                object = BoxedUnit.UNIT;
                continue;
            }
            Tuple2<Object, Object> tuple2 = this.sequenceInterval(quad.xmin(), quad.ymin(), level, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long min = tuple2._1$mcJ$sp();
            long max = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(min, max);
            long min2 = sp2._1$mcJ$sp();
            long max2 = sp2._2$mcJ$sp();
            object = BoxesRunTime.boxToBoolean((boolean)ranges.add(package$IndexRange$.MODULE$.apply(min2, max2, false)));
        }
        ranges.sort((Comparator<package.IndexRange>)((Object)package$IndexRange$IndexRangeIsOrdered$.MODULE$));
        package.IndexRange current = (package.IndexRange)ranges.get(0);
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        for (int i = 1; i < ranges.size(); ++i) {
            package.IndexRange range = (package.IndexRange)ranges.get(i);
            if (range.lower() <= current.upper() + 1L) {
                current = package$IndexRange$.MODULE$.apply(current.lower(), package$.MODULE$.max(current.upper(), range.upper()), current.contained() && range.contained());
                continue;
            }
            result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.IndexRange[]{current}));
            current = range;
        }
        result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.IndexRange[]{current}));
        return result.toSeq();
    }

    public Option<Object> ranges$default$2() {
        return None$.MODULE$;
    }

    private long sequenceCode(double x, double y, int length) {
        double xmin = 0.0;
        double ymin = 0.0;
        double xmax = 1.0;
        double ymax = 1.0;
        long cs = 0L;
        for (int i = 0; i < length; ++i) {
            double yCenter;
            double xCenter = (xmin + xmax) / 2.0;
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(x < xCenter, y < (yCenter = (ymin + ymax) / 2.0));
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl2 = sp2._2$mcZ$sp();
                if (bl && bl2) {
                    ++cs;
                    xmax = xCenter;
                    ymax = yCenter;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl3 = sp2._2$mcZ$sp();
                if (!bl && bl3) {
                    cs += 1L + 1L * ((long)package$.MODULE$.pow(4.0, (double)(this.g - i)) - 1L) / 3L;
                    xmin = xCenter;
                    ymax = yCenter;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl4 = sp2._2$mcZ$sp();
                if (bl && !bl4) {
                    cs += 1L + 2L * ((long)package$.MODULE$.pow(4.0, (double)(this.g - i)) - 1L) / 3L;
                    xmax = xCenter;
                    ymin = yCenter;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl5 = sp2._2$mcZ$sp();
                if (!bl && !bl5) {
                    cs += 1L + 3L * ((long)package$.MODULE$.pow(4.0, (double)(this.g - i)) - 1L) / 3L;
                    xmin = xCenter;
                    ymin = yCenter;
                    continue;
                }
            }
            throw new MatchError((Object)sp2);
        }
        return cs;
    }

    private Tuple2<Object, Object> sequenceInterval(double x, double y, short length, boolean partial) {
        long min = this.sequenceCode(x, y, length);
        long max = partial ? min : min + ((long)package$.MODULE$.pow(4.0, (double)(this.g - length + 1)) - 1L) / 3L;
        return new Tuple2.mcJJ.sp(min, max);
    }

    private Tuple4<Object, Object, Object, Object> normalize(double xmin, double ymin, double xmax, double ymax, boolean lenient) {
        Tuple4 tuple4;
        Predef$.MODULE$.require(xmin <= xmax && ymin <= ymax, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Bounds must be ordered: [").append(xmin).append(" ").append(xmax).append("] [").append(ymin).append(" ").append(ymax).append("]").toString());
        try {
            Predef$.MODULE$.require(xmin >= this.xLo() && xmax <= this.xHi() && ymin >= this.yLo() && ymax <= this.yHi(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Values out of bounds ([").append(this.xLo()).append(" ").append(this.xHi()).append("] [").append(this.yLo()).append(" ").append(this.yHi()).append("]): [").append(xmin).append(" ").append(xmax).append("] [").append(ymin).append(" ").append(ymax).append("]").toString());
            double nxmin = (xmin - this.xLo()) / this.xSize();
            double nymin = (ymin - this.yLo()) / this.ySize();
            double nxmax = (xmax - this.xLo()) / this.xSize();
            double nymax = (ymax - this.yLo()) / this.ySize();
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)nxmin), (Object)BoxesRunTime.boxToDouble((double)nymin), (Object)BoxesRunTime.boxToDouble((double)nxmax), (Object)BoxesRunTime.boxToDouble((double)nymax));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException && lenient) {
                double bxmax;
                double bymin;
                double bxmin;
                double d = xmin < this.xLo() ? this.xLo() : (bxmin = xmin > this.xHi() ? this.xHi() : xmin);
                double d2 = ymin < this.yLo() ? this.yLo() : (bymin = ymin > this.yHi() ? this.yHi() : ymin);
                double d3 = xmax < this.xLo() ? this.xLo() : (bxmax = xmax > this.xHi() ? this.xHi() : xmax);
                double bymax = ymax < this.yLo() ? this.yLo() : (ymax > this.yHi() ? this.yHi() : ymax);
                double nxmin = (bxmin - this.xLo()) / this.xSize();
                double nymin = (bymin - this.yLo()) / this.ySize();
                double nxmax = (bxmax - this.xLo()) / this.xSize();
                double nymax = (bymax - this.yLo()) / this.ySize();
                tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)nxmin), (Object)BoxesRunTime.boxToDouble((double)nymin), (Object)BoxesRunTime.boxToDouble((double)nxmax), (Object)BoxesRunTime.boxToDouble((double)nymax));
            }
            throw throwable;
        }
        return tuple4;
    }

    private static final boolean predicate$1(double min, double max, double w2$1) {
        return max <= package$.MODULE$.floor(min / w2$1) * w2$1 + (double)2 * w2$1;
    }

    private static final boolean isContained$1(XElement quad, QueryWindow[] query$1) {
        for (int i = 0; i < query$1.length; ++i) {
            if (!quad.isContained(query$1[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isOverlapped$1(XElement quad, QueryWindow[] query$1) {
        for (int i = 0; i < query$1.length; ++i) {
            if (!quad.overlaps(query$1[i])) continue;
            return true;
        }
        return false;
    }

    private final void checkValue$1(XElement quad, short level, ArrayList ranges$1, ArrayDeque remaining$1, QueryWindow[] query$1) {
        if (XZ2SFC.isContained$1(quad, query$1)) {
            Tuple2<Object, Object> tuple2 = this.sequenceInterval(quad.xmin(), quad.ymin(), level, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long min = tuple2._1$mcJ$sp();
            long max = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(min, max);
            long min2 = sp2._1$mcJ$sp();
            long max2 = sp2._2$mcJ$sp();
            ranges$1.add(package$IndexRange$.MODULE$.apply(min2, max2, true));
            return;
        }
        if (XZ2SFC.isOverlapped$1(quad, query$1)) {
            Tuple2<Object, Object> tuple2 = this.sequenceInterval(quad.xmin(), quad.ymin(), level, true);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long min = tuple2._1$mcJ$sp();
            long max = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(min, max);
            long min3 = sp3._1$mcJ$sp();
            long max3 = sp3._2$mcJ$sp();
            ranges$1.add(package$IndexRange$.MODULE$.apply(min3, max3, false));
            quad.children().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)remaining$1.add(x$1)));
            return;
        }
    }

    public XZ2SFC(short g, Tuple2<Object, Object> xBounds, Tuple2<Object, Object> yBounds) {
        this.g = g;
        this.xLo = xBounds._1$mcD$sp();
        this.xHi = xBounds._2$mcD$sp();
        this.yLo = yBounds._1$mcD$sp();
        this.yHi = yBounds._2$mcD$sp();
        this.xSize = this.xHi() - this.xLo();
        this.ySize = this.yHi() - this.yLo();
    }

    private static class QueryWindow
    implements Product,
    scala.Serializable {
        private final double xmin;
        private final double ymin;
        private final double xmax;
        private final double ymax;

        public double xmin() {
            return this.xmin;
        }

        public double ymin() {
            return this.ymin;
        }

        public double xmax() {
            return this.xmax;
        }

        public double ymax() {
            return this.ymax;
        }

        public QueryWindow copy(double xmin, double ymin, double xmax, double ymax) {
            return new QueryWindow(xmin, ymin, xmax, ymax);
        }

        public double copy$default$1() {
            return this.xmin();
        }

        public double copy$default$2() {
            return this.ymin();
        }

        public double copy$default$3() {
            return this.xmax();
        }

        public double copy$default$4() {
            return this.ymax();
        }

        public String productPrefix() {
            return "QueryWindow";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this.xmin());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this.ymin());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this.xmax());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this.ymax());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof QueryWindow;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymax()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof QueryWindow)) return false;
            boolean bl = true;
            if (!bl) return false;
            QueryWindow queryWindow = (QueryWindow)x$1;
            if (this.xmin() != queryWindow.xmin()) return false;
            if (this.ymin() != queryWindow.ymin()) return false;
            if (this.xmax() != queryWindow.xmax()) return false;
            if (this.ymax() != queryWindow.ymax()) return false;
            if (!queryWindow.canEqual(this)) return false;
            return true;
        }

        public QueryWindow(double xmin, double ymin, double xmax, double ymax) {
            this.xmin = xmin;
            this.ymin = ymin;
            this.xmax = xmax;
            this.ymax = ymax;
            Product.$init$((Product)this);
        }
    }

    private static class XElement
    implements Product,
    scala.Serializable {
        private double xext;
        private double yext;
        private final double xmin;
        private final double ymin;
        private final double xmax;
        private final double ymax;
        private final double length;
        private volatile byte bitmap$0;

        public double xmin() {
            return this.xmin;
        }

        public double ymin() {
            return this.ymin;
        }

        public double xmax() {
            return this.xmax;
        }

        public double ymax() {
            return this.ymax;
        }

        public double length() {
            return this.length;
        }

        private double xext$lzycompute() {
            XElement xElement = this;
            synchronized (xElement) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.xext = this.xmax() + this.length();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.xext;
        }

        public double xext() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.xext$lzycompute();
            }
            return this.xext;
        }

        private double yext$lzycompute() {
            XElement xElement = this;
            synchronized (xElement) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.yext = this.ymax() + this.length();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.yext;
        }

        public double yext() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.yext$lzycompute();
            }
            return this.yext;
        }

        public boolean isContained(QueryWindow window) {
            return window.xmin() <= this.xmin() && window.ymin() <= this.ymin() && window.xmax() >= this.xext() && window.ymax() >= this.yext();
        }

        public boolean overlaps(QueryWindow window) {
            return window.xmax() >= this.xmin() && window.ymax() >= this.ymin() && window.xmin() <= this.xext() && window.ymin() <= this.yext();
        }

        public Seq<XElement> children() {
            double xCenter = (this.xmin() + this.xmax()) / 2.0;
            double yCenter = (this.ymin() + this.ymax()) / 2.0;
            double len = this.length() / 2.0;
            double x$1 = xCenter;
            double x$2 = yCenter;
            double x$3 = len;
            double x$4 = this.copy$default$1();
            double x$5 = this.copy$default$2();
            XElement c0 = this.copy(x$4, x$5, x$1, x$2, x$3);
            double x$6 = xCenter;
            double x$7 = yCenter;
            double x$8 = len;
            double x$9 = this.copy$default$2();
            double x$10 = this.copy$default$3();
            XElement c1 = this.copy(x$6, x$9, x$10, x$7, x$8);
            double x$11 = xCenter;
            double x$12 = yCenter;
            double x$13 = len;
            double x$14 = this.copy$default$1();
            double x$15 = this.copy$default$4();
            XElement c2 = this.copy(x$14, x$12, x$11, x$15, x$13);
            double x$16 = xCenter;
            double x$17 = yCenter;
            double x$18 = len;
            double x$19 = this.copy$default$3();
            double x$20 = this.copy$default$4();
            XElement c3 = this.copy(x$16, x$17, x$19, x$20, x$18);
            return (Seq)new .colon.colon((Object)c0, (List)new .colon.colon((Object)c1, (List)new .colon.colon((Object)c2, (List)new .colon.colon((Object)c3, (List)Nil$.MODULE$))));
        }

        public XElement copy(double xmin, double ymin, double xmax, double ymax, double length) {
            return new XElement(xmin, ymin, xmax, ymax, length);
        }

        public double copy$default$1() {
            return this.xmin();
        }

        public double copy$default$2() {
            return this.ymin();
        }

        public double copy$default$3() {
            return this.xmax();
        }

        public double copy$default$4() {
            return this.ymax();
        }

        public double copy$default$5() {
            return this.length();
        }

        public String productPrefix() {
            return "XElement";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this.xmin());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this.ymin());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this.xmax());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this.ymax());
                }
                case 4: {
                    return BoxesRunTime.boxToDouble((double)this.length());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof XElement;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.length()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof XElement)) return false;
            boolean bl = true;
            if (!bl) return false;
            XElement xElement = (XElement)x$1;
            if (this.xmin() != xElement.xmin()) return false;
            if (this.ymin() != xElement.ymin()) return false;
            if (this.xmax() != xElement.xmax()) return false;
            if (this.ymax() != xElement.ymax()) return false;
            if (this.length() != xElement.length()) return false;
            if (!xElement.canEqual(this)) return false;
            return true;
        }

        public XElement(double xmin, double ymin, double xmax, double ymax, double length) {
            this.xmin = xmin;
            this.ymin = ymin;
            this.xmax = xmax;
            this.ymax = ymax;
            this.length = length;
            Product.$init$((Product)this);
        }
    }
}

