/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.curve;

import java.io.Serializable;
import org.locationtech.geomesa.curve.NormalizedDimension;
import org.locationtech.geomesa.curve.SpaceFillingCurve;
import org.locationtech.geomesa.zorder.sfcurve.Z2$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uq!B\b\u0011\u0011\u0003Ib!B\u000e\u0011\u0011\u0003a\u0002B\u0002\u0017\u0002\t\u0003\tYB\u0002\u0003\u001c!\u0001q\u0002\u0002\u0003\u0015\u0004\u0005\u0003\u0005\u000b\u0011B\u0015\t\u000b1\u001aA\u0011A\u0017\t\u000f=\u001a!\u0019!C\u0001a!1Ag\u0001Q\u0001\nEBq!N\u0002C\u0002\u0013\u0005\u0001\u0007\u0003\u00047\u0007\u0001\u0006I!\r\u0005\u0006o\r!\t\u0005\u000f\u0005\b\u0011\u000e\t\n\u0011\"\u0001J\u0011\u0015!6\u0001\"\u0005V\u0011\u0015A6\u0001\"\u0011Z\u0011\u0015y6\u0001\"\u0011a\u0003\u0015Q&g\u0015$D\u0015\t\t\"#A\u0003dkJ4XM\u0003\u0002\u0014)\u00059q-Z8nKN\f'BA\u000b\u0017\u00031awnY1uS>tG/Z2i\u0015\u00059\u0012aA8sO\u000e\u0001\u0001C\u0001\u000e\u0002\u001b\u0005\u0001\"!\u0002.3'\u001a\u001b5CA\u0001\u001e!\tQ2aE\u0002\u0004?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u000e'\u0013\t9\u0003CA\tTa\u0006\u001cWMR5mY&twmQ;sm\u0016\f\u0011\u0002\u001d:fG&\u001c\u0018n\u001c8\u0011\u0005\u0001R\u0013BA\u0016\"\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uq\u0003\"\u0002\u0015\u0006\u0001\u0004I\u0013a\u00017p]V\t\u0011\u0007\u0005\u0002\u001be%\u00111\u0007\u0005\u0002\u0014\u001d>\u0014X.\u00197ju\u0016$G)[7f]NLwN\\\u0001\u0005Y>t\u0007%A\u0002mCR\fA\u0001\\1uA\u0005)\u0011N\u001c3fqR!\u0011\bP!D!\t\u0001#(\u0003\u0002<C\t!Aj\u001c8h\u0011\u0015i$\u00021\u0001?\u0003\u0005A\bC\u0001\u0011@\u0013\t\u0001\u0015E\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0005*\u0001\rAP\u0001\u0002s\"9AI\u0003I\u0001\u0002\u0004)\u0015a\u00027f]&,g\u000e\u001e\t\u0003A\u0019K!aR\u0011\u0003\u000f\t{w\u000e\\3b]\u0006y\u0011N\u001c3fq\u0012\"WMZ1vYR$3'F\u0001KU\t)5jK\u0001M!\ti%+D\u0001O\u0015\ty\u0005+A\u0005v]\u000eDWmY6fI*\u0011\u0011+I\u0001\u000bC:tw\u000e^1uS>t\u0017BA*O\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\rY\u0016t\u0017.\u001a8u\u0013:$W\r\u001f\u000b\u0004sY;\u0006\"B\u001f\r\u0001\u0004q\u0004\"\u0002\"\r\u0001\u0004q\u0014AB5om\u0016\u0014H\u000f\u0006\u0002[;B!\u0001e\u0017 ?\u0013\ta\u0016E\u0001\u0004UkBdWM\r\u0005\u0006=6\u0001\r!O\u0001\u0002u\u00061!/\u00198hKN$r!YA\u0002\u0003\u001f\t\t\u0002E\u0002cU6t!a\u00195\u000f\u0005\u0011<W\"A3\u000b\u0005\u0019D\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\tI\u0017%A\u0004qC\u000e\\\u0017mZ3\n\u0005-d'aA*fc*\u0011\u0011.\t\t\u0003]zt!a\u001c?\u000f\u0005ALhBA9x\u001d\t\u0011hO\u0004\u0002tk:\u0011A\r^\u0005\u0002/%\u0011QCF\u0005\u0003'QI!\u0001\u001f\n\u0002\ri|'\u000fZ3s\u0013\tQ80A\u0004tM\u000e,(O^3\u000b\u0005a\u0014\u0012BA5~\u0015\tQ80C\u0002\u0000\u0003\u0003\u0011!\"\u00138eKb\u0014\u0016M\\4f\u0015\tIW\u0010C\u0004\u0002\u00069\u0001\r!a\u0002\u0002\u0005aL\b\u0003\u00022k\u0003\u0013\u0001r\u0001IA\u0006}yrd(C\u0002\u0002\u000e\u0005\u0012a\u0001V;qY\u0016$\u0004b\u0002\u0015\u000f!\u0003\u0005\r!\u000b\u0005\n\u0003'q\u0001\u0013!a\u0001\u0003+\t\u0011\"\\1y%\u0006tw-Z:\u0011\t\u0001\n9\"K\u0005\u0004\u00033\t#AB(qi&|g\u000eF\u0001\u001a\u0001")
public class Z2SFC
implements SpaceFillingCurve {
    private final NormalizedDimension lon;
    private final NormalizedDimension lat;

    @Override
    public Seq<package.IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y) {
        return SpaceFillingCurve.ranges$(this, x, y);
    }

    @Override
    public Seq<package.IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y, int precision) {
        return SpaceFillingCurve.ranges$(this, x, y, precision);
    }

    @Override
    public Seq<package.IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y, int precision, Option<Object> maxRanges) {
        return SpaceFillingCurve.ranges$(this, x, y, precision, maxRanges);
    }

    @Override
    public int ranges$default$2() {
        return SpaceFillingCurve.ranges$default$2$(this);
    }

    @Override
    public Option<Object> ranges$default$3() {
        return SpaceFillingCurve.ranges$default$3$(this);
    }

    public NormalizedDimension lon() {
        return this.lon;
    }

    public NormalizedDimension lat() {
        return this.lat;
    }

    @Override
    public long index(double x, double y, boolean lenient) {
        long l;
        try {
            Predef$.MODULE$.require(x >= this.lon().min() && x <= this.lon().max() && y >= this.lat().min() && y <= this.lat().max(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Value(s) out of bounds ([").append(this.lon().min()).append(",").append(this.lon().max()).append("], [").append(this.lat().min()).append(",").append(this.lat().max()).append("]): ").append(x).append(", ").append(y).toString());
            l = Z2$.MODULE$.apply(this.lon().normalize(x), this.lat().normalize(y));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException && lenient) {
                l = this.lenientIndex(x, y);
            }
            throw throwable;
        }
        return l;
    }

    @Override
    public boolean index$default$3() {
        return false;
    }

    public long lenientIndex(double x, double y) {
        double bx;
        double d = x < this.lon().min() ? this.lon().min() : (bx = x > this.lon().max() ? this.lon().max() : x);
        double by = y < this.lat().min() ? this.lat().min() : (y > this.lat().max() ? this.lat().max() : y);
        return Z2$.MODULE$.apply(this.lon().normalize(bx), this.lat().normalize(by));
    }

    @Override
    public Tuple2<Object, Object> invert(long z) {
        Tuple2<Object, Object> tuple2 = Z2$.MODULE$.decode$extension(Z2$.MODULE$.apply(z));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int x = tuple2._1$mcI$sp();
        int y = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x, y);
        int x2 = sp2._1$mcI$sp();
        int y2 = sp2._2$mcI$sp();
        return new Tuple2.mcDD.sp(this.lon().denormalize(x2), this.lat().denormalize(y2));
    }

    @Override
    public Seq<package.IndexRange> ranges(Seq<Tuple4<Object, Object, Object, Object>> xy, int precision, Option<Object> maxRanges) {
        Seq zbounds = (Seq)xy.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                return new package.ZRange(this.index(xmin, ymin, this.index$default$3()), this.index(xmax, ymax, this.index$default$3()));
            }
            throw new MatchError((Object)tuple4);
        }, Seq$.MODULE$.canBuildFrom());
        return Z2$.MODULE$.zranges((package.ZRange[])zbounds.toArray(ClassTag$.MODULE$.apply(package.ZRange.class)), precision, maxRanges, Z2$.MODULE$.zranges$default$4());
    }

    public Z2SFC(int precision) {
        SpaceFillingCurve.$init$(this);
        this.lon = new NormalizedDimension.NormalizedLon(precision);
        this.lat = new NormalizedDimension.NormalizedLat(precision);
    }
}

