/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.accumulo;

import com.github.blemale.scaffeine.Cache;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeCaching;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.COGLayerAttributes;
import geotrellis.spark.io.DiscreteLayerAttributeStore;
import geotrellis.spark.io.LayerAttributes;
import geotrellis.spark.io.LayerType;
import geotrellis.spark.io.accumulo.AccumuloAttributeStore$;
import geotrellis.spark.io.accumulo.AccumuloInstance;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.spark.io.package$;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.avro.Schema;
import org.apache.hadoop.io.Text;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spray.json.DefaultJsonProtocol$;
import spray.json.JsValue;
import spray.json.JsonFormat;
import spray.json.JsonReader;
import spray.json.JsonWriter;

@ScalaSignature(bytes="\u0006\u0001\u0005Ux!B\u0001\u0003\u0011\u0003Y\u0011AF!dGVlW\u000f\\8BiR\u0014\u0018NY;uKN#xN]3\u000b\u0005\r!\u0011\u0001C1dGVlW\u000f\\8\u000b\u0005\u00151\u0011AA5p\u0015\t9\u0001\"A\u0003ta\u0006\u00148NC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005Y\t5mY;nk2|\u0017\t\u001e;sS\n,H/Z*u_J,7cA\u0007\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"!E\f\n\u0005a\u0011\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u000e\u000e\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u0015iR\u0002\"\u0001\u001f\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y\u0012\u0011ZAf!\ta\u0001E\u0002\u0003\u000f\u0005\u0001\t3c\u0001\u0011\u0011EA\u00111\u0005J\u0007\u0002\t%\u0011Q\u0005\u0002\u0002\u001c\t&\u001c8M]3uK2\u000b\u00170\u001a:BiR\u0014\u0018NY;uKN#xN]3\t\u0011\u001d\u0002#Q1A\u0005\u0002!\n\u0011bY8o]\u0016\u001cGo\u001c:\u0016\u0003%\u0002\"A\u000b\u001b\u000e\u0003-R!\u0001L\u0017\u0002\r\rd\u0017.\u001a8u\u0015\tqs&\u0001\u0003d_J,'BA\u00021\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\n\u0005UZ#!C\"p]:,7\r^8s\u0011!9\u0004E!A!\u0002\u0013I\u0013AC2p]:,7\r^8sA!A\u0011\b\tBC\u0002\u0013\u0005!(\u0001\bbiR\u0014\u0018NY;uKR\u000b'\r\\3\u0016\u0003m\u0002\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 \u0013\u001b\u0005y$B\u0001!\u000b\u0003\u0019a$o\\8u}%\u0011!IE\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C%!Aq\t\tB\u0001B\u0003%1(A\bbiR\u0014\u0018NY;uKR\u000b'\r\\3!\u0011\u0015Q\u0002\u0005\"\u0001J)\ry\"j\u0013\u0005\u0006O!\u0003\r!\u000b\u0005\u0006s!\u0003\ra\u000f\u0005\b\u001b\u0002\u0012\r\u0011\"\u0001O\u0003\r\u0019V\tU\u000b\u0002\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0005Y\u0006twMC\u0001U\u0003\u0011Q\u0017M^1\n\u0005\u0011\u000b\u0006BB,!A\u0003%q*\u0001\u0003T\u000bB\u0003\u0003\"B-!\t\u0003Q\u0016a\u00037bs\u0016\u0014\u0018\n\u001a+fqR$\"a\u00172\u0011\u0005q\u0003W\"A/\u000b\u0005\u0015q&BA01\u0003\u0019A\u0017\rZ8pa&\u0011\u0011-\u0018\u0002\u0005)\u0016DH\u000fC\u0003d1\u0002\u0007A-A\u0004mCf,'/\u00133\u0011\u0005\u00154W\"\u0001\u0004\n\u0005\u001d4!a\u0002'bs\u0016\u0014\u0018\n\u001a\u0005\u0006S\u0002\"IA[\u0001\u0006M\u0016$8\r\u001b\u000b\u0004Wjt\bc\u00017ri:\u0011Qn\u001c\b\u0003}9L\u0011aE\u0005\u0003aJ\tq\u0001]1dW\u0006<W-\u0003\u0002sg\nA\u0011\n^3sCR|'O\u0003\u0002q%A\u0011Q\u000f_\u0007\u0002m*\u0011q/L\u0001\u0005I\u0006$\u0018-\u0003\u0002zm\n)a+\u00197vK\")1\r\u001ba\u0001wB\u0019\u0011\u0003 3\n\u0005u\u0014\"AB(qi&|g\u000eC\u0003\u0000Q\u0002\u00071(A\u0007biR\u0014\u0018NY;uK:\u000bW.\u001a\u0005\b\u0003\u0007\u0001C\u0011BA\u0003\u0003\u0019!W\r\\3uKR1\u0011qAA\u0007\u0003\u001f\u00012!EA\u0005\u0013\r\tYA\u0005\u0002\u0005+:LG\u000f\u0003\u0004d\u0003\u0003\u0001\r\u0001\u001a\u0005\b\u007f\u0006\u0005\u0001\u0019AA\t!\r\tBp\u000f\u0005\b\u0003+\u0001C\u0011AA\f\u0003\u0011\u0011X-\u00193\u0016\t\u0005e\u0011\u0011\u0005\u000b\u0007\u00037\t9%!\u0013\u0015\t\u0005u\u00111\u0007\t\u0005\u0003?\t\t\u0003\u0004\u0001\u0005\u0011\u0005\r\u00121\u0003b\u0001\u0003K\u0011\u0011\u0001V\t\u0005\u0003O\ti\u0003E\u0002\u0012\u0003SI1!a\u000b\u0013\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!EA\u0018\u0013\r\t\tD\u0005\u0002\u0004\u0003:L\bBCA\u001b\u0003'\t\t\u0011q\u0001\u00028\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\u0005e\u00121IA\u000f\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012\u0001\u00026t_:T!!!\u0011\u0002\u000bM\u0004(/Y=\n\t\u0005\u0015\u00131\b\u0002\u000b\u0015N|gNR8s[\u0006$\bBB2\u0002\u0014\u0001\u0007A\r\u0003\u0004\u0000\u0003'\u0001\ra\u000f\u0005\b\u0003\u001b\u0002C\u0011AA(\u0003\u001d\u0011X-\u00193BY2,B!!\u0015\u0002^Q!\u00111KA3)\u0011\t)&a\u0018\u0011\rq\n9\u0006ZA.\u0013\r\tI&\u0012\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0010\u0003;\"\u0001\"a\t\u0002L\t\u0007\u0011Q\u0005\u0005\u000b\u0003C\nY%!AA\u0004\u0005\r\u0014AC3wS\u0012,gnY3%eA1\u0011\u0011HA\"\u00037Baa`A&\u0001\u0004Y\u0004bBA5A\u0011\u0005\u00111N\u0001\u0006oJLG/Z\u000b\u0005\u0003[\nI\b\u0006\u0005\u0002p\u0005m\u0014QPA@)\u0011\t9!!\u001d\t\u0015\u0005M\u0014qMA\u0001\u0002\b\t)(\u0001\u0006fm&$WM\\2fIM\u0002b!!\u000f\u0002D\u0005]\u0004\u0003BA\u0010\u0003s\"\u0001\"a\t\u0002h\t\u0007\u0011Q\u0005\u0005\u0007G\u0006\u001d\u0004\u0019\u00013\t\r}\f9\u00071\u0001<\u0011!\t\t)a\u001aA\u0002\u0005]\u0014!\u0002<bYV,\u0007bBACA\u0011\u0005\u0011qQ\u0001\fY\u0006LXM]#ySN$8\u000f\u0006\u0003\u0002\n\u0006=\u0005cA\t\u0002\f&\u0019\u0011Q\u0012\n\u0003\u000f\t{w\u000e\\3b]\"11-a!A\u0002\u0011Dq!a\u0001!\t\u0003\t\u0019\n\u0006\u0003\u0002\b\u0005U\u0005BB2\u0002\u0012\u0002\u0007A\rC\u0004\u0002\u0004\u0001\"\t!!'\u0015\r\u0005\u001d\u00111TAO\u0011\u0019\u0019\u0017q\u0013a\u0001I\"1q0a&A\u0002mBq!!)!\t\u0003\t\u0019+\u0001\u0005mCf,'/\u00133t+\t\t)\u000b\u0005\u0003m\u0003O#\u0017bAAUg\n\u00191+Z9\t\u000f\u00055\u0006\u0005\"\u0001\u00020\u0006\u0019\u0012M^1jY\u0006\u0014G.Z!uiJL'-\u001e;fgR!\u0011\u0011WAZ!\u0011a\u0017qU\u001e\t\u000f\u0005U\u00161\u0016a\u0001I\u0006\u0011\u0011\u000e\u001a\u0005\b\u0003s\u0003C\u0011IA^\u0003M\tg/Y5mC\ndWMW8p[2+g/\u001a7t)\u0011\ti,!2\u0011\u000b1\f9+a0\u0011\u0007E\t\t-C\u0002\u0002DJ\u00111!\u00138u\u0011\u001d\t9-a.A\u0002m\n\u0011\u0002\\1zKJt\u0015-\\3\t\u000b\u001db\u0002\u0019A\u0015\t\u000beb\u0002\u0019A\u001e\t\ruiA\u0011AAh)\ry\u0012\u0011\u001b\u0005\u0007O\u00055\u0007\u0019A\u0015\t\ruiA\u0011AAk)\u0015y\u0012q[Aq\u0011!\tI.a5A\u0002\u0005m\u0017\u0001C5ogR\fgnY3\u0011\u00071\ti.C\u0002\u0002`\n\u0011\u0001#Q2dk6,Hn\\%ogR\fgnY3\t\re\n\u0019\u000e1\u0001<\u0011\u0019iR\u0002\"\u0001\u0002fR\u0019q$a:\t\u0011\u0005e\u00171\u001da\u0001\u00037D\u0011\"a;\u000e\u0003\u0003%I!!<\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003_\u00042\u0001UAy\u0013\r\t\u00190\u0015\u0002\u0007\u001f\nTWm\u0019;")
public class AccumuloAttributeStore
implements DiscreteLayerAttributeStore {
    private final Connector connector;
    private final String attributeTable;
    private final String SEP;
    private transient Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache;
    private volatile transient boolean bitmap$trans$0;

    public static AccumuloAttributeStore apply(AccumuloInstance accumuloInstance) {
        return AccumuloAttributeStore$.MODULE$.apply(accumuloInstance);
    }

    public static AccumuloAttributeStore apply(AccumuloInstance accumuloInstance, String string) {
        return AccumuloAttributeStore$.MODULE$.apply(accumuloInstance, string);
    }

    public static AccumuloAttributeStore apply(Connector connector) {
        return AccumuloAttributeStore$.MODULE$.apply(connector);
    }

    public static AccumuloAttributeStore apply(Connector connector, String string) {
        return AccumuloAttributeStore$.MODULE$.apply(connector, string);
    }

    public <K> Map<ZoomRange, KeyIndex<K>> readKeyIndexes(LayerId id, ClassTag<K> evidence$32) {
        return DiscreteLayerAttributeStore.readKeyIndexes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$32);
    }

    public <H> H readHeader(LayerId id, JsonFormat<H> evidence$33) {
        return (H)DiscreteLayerAttributeStore.readHeader$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$33);
    }

    public <M> M readMetadata(LayerId id, JsonFormat<M> evidence$34) {
        return (M)DiscreteLayerAttributeStore.readMetadata$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$34);
    }

    public <K> KeyIndex<K> readKeyIndex(LayerId id, ClassTag<K> evidence$35) {
        return DiscreteLayerAttributeStore.readKeyIndex$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$35);
    }

    public Schema readSchema(LayerId id) {
        return DiscreteLayerAttributeStore.readSchema$((DiscreteLayerAttributeStore)this, (LayerId)id);
    }

    public <H, M, K> LayerAttributes<H, M, K> readLayerAttributes(LayerId id, JsonFormat<H> evidence$36, JsonFormat<M> evidence$37, ClassTag<K> evidence$38) {
        return DiscreteLayerAttributeStore.readLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$36, evidence$37, evidence$38);
    }

    public <H, M, K> void writeLayerAttributes(LayerId id, H header, M metadata, KeyIndex<K> keyIndex, Schema schema, JsonFormat<H> evidence$39, JsonFormat<M> evidence$40, ClassTag<K> evidence$41) {
        DiscreteLayerAttributeStore.writeLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, header, metadata, keyIndex, (Schema)schema, evidence$39, evidence$40, evidence$41);
    }

    public <H, M> COGLayerAttributes<H, M> readCOGLayerAttributes(LayerId id, JsonFormat<H> evidence$42, JsonFormat<M> evidence$43) {
        return DiscreteLayerAttributeStore.readCOGLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$42, evidence$43);
    }

    public <H, M> void writeCOGLayerAttributes(LayerId id, H header, M metadata, JsonFormat<H> evidence$44, JsonFormat<M> evidence$45) {
        DiscreteLayerAttributeStore.writeCOGLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, header, metadata, evidence$44, evidence$45);
    }

    public boolean isCOGLayer(LayerId id) {
        return AttributeStore.isCOGLayer$((AttributeStore)this, (LayerId)id);
    }

    public LayerType layerType(LayerId id) {
        return AttributeStore.layerType$((AttributeStore)this, (LayerId)id);
    }

    public Map<String, Seq<Object>> layersWithZoomLevels() {
        return AttributeStore.layersWithZoomLevels$((AttributeStore)this);
    }

    public void copy(LayerId from, LayerId to) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to);
    }

    public void copy(LayerId from, LayerId to, Seq<String> attributes) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to, attributes);
    }

    public <T> T cacheRead(LayerId layerId, String attributeName, JsonFormat<T> evidence$1) {
        return (T)AttributeCaching.cacheRead$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, evidence$1);
    }

    public LayerType cacheLayerType(LayerId layerId, LayerType layerType) {
        return AttributeCaching.cacheLayerType$((AttributeCaching)this, (LayerId)layerId, (LayerType)layerType);
    }

    public <T> void cacheWrite(LayerId layerId, String attributeName, T value, JsonFormat<T> evidence$2) {
        AttributeCaching.cacheWrite$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, value, evidence$2);
    }

    public void clearCache() {
        AttributeCaching.clearCache$((AttributeCaching)this);
    }

    public void clearCache(LayerId id) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id);
    }

    public void clearCache(LayerId id, String attribute) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id, (String)attribute);
    }

    private Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache$lzycompute() {
        AccumuloAttributeStore accumuloAttributeStore = this;
        synchronized (accumuloAttributeStore) {
            if (!this.bitmap$trans$0) {
                this.geotrellis$spark$io$AttributeCaching$$cache = AttributeCaching.geotrellis$spark$io$AttributeCaching$$cache$((AttributeCaching)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.geotrellis$spark$io$AttributeCaching$$cache;
    }

    public Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache() {
        return !this.bitmap$trans$0 ? this.geotrellis$spark$io$AttributeCaching$$cache$lzycompute() : this.geotrellis$spark$io$AttributeCaching$$cache;
    }

    public Connector connector() {
        return this.connector;
    }

    public String attributeTable() {
        return this.attributeTable;
    }

    public String SEP() {
        return this.SEP;
    }

    public Text layerIdText(LayerId layerId) {
        return geotrellis.spark.io.accumulo.package$.MODULE$.stringToText(new StringBuilder(0).append(layerId.name()).append(this.SEP()).append(layerId.zoom()).toString());
    }

    private Iterator<Value> fetch(Option<LayerId> layerId, String attributeName) {
        Iterator iterator;
        try (Scanner scanner = this.connector().createScanner(this.attributeTable(), new Authorizations());){
            layerId.foreach((Function1 & Serializable & scala.Serializable)id -> {
                scanner.setRange(new Range(this.layerIdText(id)));
                return BoxedUnit.UNIT;
            });
            scanner.fetchColumnFamily(new Text(attributeName));
            iterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Value)x$1.getValue());
        }
        return iterator;
    }

    private void delete(LayerId layerId, Option<String> attributeName) {
        block5: {
            int numThreads = 1;
            BatchWriterConfig config = new BatchWriterConfig();
            config.setMaxWriteThreads(numThreads);
            try (BatchDeleter deleter = this.connector().createBatchDeleter(this.attributeTable(), new Authorizations(), numThreads, config);){
                deleter.setRanges((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Range(this.layerIdText(layerId)), (List)Nil$.MODULE$)).asJava());
                attributeName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                    deleter.fetchColumnFamily(new Text(name));
                    return BoxedUnit.UNIT;
                });
                deleter.delete();
                Option<String> option = attributeName;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String attribute = (String)some.value();
                    this.clearCache(layerId, attribute);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    this.clearCache(layerId);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError(option);
            }
        }
    }

    public <T> T read(LayerId layerId, String attributeName, JsonFormat<T> evidence$1) {
        Vector values = this.fetch((Option<LayerId>)new Some((Object)layerId), attributeName).toVector();
        if (values.isEmpty()) {
            throw new package.AttributeNotFoundError(attributeName, layerId);
        }
        if (values.size() > 1) {
            throw new package.LayerIOError(new StringBuilder(41).append("Multiple attributes found for ").append(attributeName).append(" for layer ").append(layerId).toString());
        }
        return (T)((Tuple2)spray.json.package$.MODULE$.enrichString(((Value)values.head()).toString()).parseJson().convertTo((JsonReader)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$1)))._2();
    }

    public <T> Map<LayerId, T> readAll(String attributeName, JsonFormat<T> evidence$2) {
        return this.fetch((Option<LayerId>)None$.MODULE$, attributeName).map((Function1 & Serializable & scala.Serializable)x$2 -> (Tuple2)spray.json.package$.MODULE$.enrichString(x$2.toString()).parseJson().convertTo((JsonReader)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$2))).toMap(Predef$.MODULE$.$conforms());
    }

    public <T> void write(LayerId layerId, String attributeName, T value, JsonFormat<T> evidence$3) {
        Mutation mutation = new Mutation(this.layerIdText(layerId));
        mutation.put(new Text(attributeName), new Text(), System.currentTimeMillis(), new Value(spray.json.package$.MODULE$.enrichAny((Object)new Tuple2((Object)layerId, value)).toJson((JsonWriter)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$3)).compactPrint().getBytes()));
        geotrellis.spark.io.accumulo.package$.MODULE$.connectorWriter(this.connector()).write(this.attributeTable(), mutation);
    }

    public boolean layerExists(LayerId layerId) {
        return this.fetch((Option<LayerId>)new Some((Object)layerId), AttributeStore.Fields$.MODULE$.metadata()).nonEmpty();
    }

    public void delete(LayerId layerId) {
        this.delete(layerId, (Option<String>)None$.MODULE$);
    }

    public void delete(LayerId layerId, String attributeName) {
        this.delete(layerId, (Option<String>)new Some((Object)attributeName));
    }

    public Seq<LayerId> layerIds() {
        Seq seq;
        try (Scanner scanner = this.connector().createScanner(this.attributeTable(), new Authorizations());){
            seq = (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> {
                String[] stringArray = ((Key)kv.getKey()).getRow().toString().split(this.SEP());
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String name = (String)((SeqLike)option.get()).apply(0);
                String zoomStr = (String)((SeqLike)option.get()).apply(1);
                Tuple2 tuple2 = new Tuple2((Object)name, (Object)zoomStr);
                Tuple2 tuple22 = tuple2;
                String name2 = (String)tuple22._1();
                String zoomStr2 = (String)tuple22._2();
                return new LayerId(name2, new StringOps(Predef$.MODULE$.augmentString(zoomStr2)).toInt());
            }).toList().distinct();
        }
        return seq;
    }

    public Seq<String> availableAttributes(LayerId id) {
        Vector vector;
        try (Scanner scanner = this.connector().createScanner(this.attributeTable(), new Authorizations());){
            scanner.setRange(new Range(this.layerIdText(id)));
            vector = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((Key)x$4.getKey()).getColumnFamily().toString()).toVector();
        }
        return vector;
    }

    public Seq<Object> availableZoomLevels(String layerName) {
        Seq seq;
        try (Scanner scanner = this.connector().createScanner(this.attributeTable(), new Authorizations());){
            IteratorSetting iter = new IteratorSetting(15, "AttributeStoreLayerNameFilter", RegExFilter.class);
            RegExFilter.setRegexs((IteratorSetting)iter, (String)new StringBuilder(2).append(layerName).append(this.SEP()).append(".*").toString(), null, null, null, (boolean)false);
            scanner.addScanIterator(iter);
            seq = (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToInteger((int)AccumuloAttributeStore.$anonfun$availableZoomLevels$1(this, kv))).toList().distinct();
        }
        return seq;
    }

    public static final /* synthetic */ int $anonfun$availableZoomLevels$1(AccumuloAttributeStore $this, Map.Entry kv) {
        String zoomStr;
        String[] stringArray = ((Key)kv.getKey()).getRow().toString().split($this.SEP());
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String string = zoomStr = (String)((SeqLike)option.get()).apply(1);
        String zoomStr2 = string;
        return new StringOps(Predef$.MODULE$.augmentString(zoomStr2)).toInt();
    }

    public AccumuloAttributeStore(Connector connector, String attributeTable) {
        this.connector = connector;
        this.attributeTable = attributeTable;
        AttributeCaching.$init$((AttributeCaching)this);
        AttributeStore.$init$((AttributeStore)this);
        DiscreteLayerAttributeStore.$init$((DiscreteLayerAttributeStore)this);
        TableOperations ops = connector.tableOperations();
        if (!ops.exists(attributeTable)) {
            ops.create(attributeTable);
        }
        this.SEP = "__.__";
    }
}

