/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.accumulo;

import cats.Apply;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import geotrellis.spark.Boundable;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.KeyBounds$;
import geotrellis.spark.io.accumulo.AccumuloInstance;
import geotrellis.spark.io.accumulo.conf.AccumuloConfig$;
import geotrellis.spark.io.avro.AvroEncoder$;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec$;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.avro.Schema;
import org.apache.hadoop.io.Text;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class AccumuloCollectionReader$ {
    public static AccumuloCollectionReader$ MODULE$;
    private final int defaultThreadCount;

    static {
        new AccumuloCollectionReader$();
    }

    public int defaultThreadCount() {
        return this.defaultThreadCount;
    }

    public <K, V> Seq<Tuple2<K, V>> read(String table, Text columnFamily, Seq<KeyBounds<K>> queryKeyBounds, Function1<KeyBounds<K>, Seq<Range>> decomposeBounds, boolean filterIndexOnly, Option<Schema> writerSchema, int threads, Boundable<K> evidence$1, AvroRecordCodec<K> evidence$2, ClassTag<K> evidence$3, AvroRecordCodec<V> evidence$4, ClassTag<V> evidence$5, AccumuloInstance instance) {
        Seq seq;
        if (queryKeyBounds.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        KeyValueRecordCodec codec = KeyValueRecordCodec$.MODULE$.apply(evidence$2, evidence$4);
        Function1 & Serializable & scala.Serializable includeKey = (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)AccumuloCollectionReader$.$anonfun$read$1(queryKeyBounds, evidence$1, key));
        Iterator ranges = ((IterableLike)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom())).toIterator();
        ExecutorService pool = Executors.newFixedThreadPool(threads);
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)pool);
        ContextShift cs = IO$.MODULE$.contextShift((ExecutionContext)ec);
        FreeC range2 = Stream$.MODULE$.fromIterator(ranges, (Sync)IO$.MODULE$.ioConcurrentEffect(cs));
        Function1 & Serializable & scala.Serializable read = (Function1 & Serializable & scala.Serializable)range -> new Stream(Stream$.MODULE$.eval(package.apply$.MODULE$.catsSyntaxApply((Object)IO$.MODULE$.shift((ExecutionContext)ec), (Apply)IO$.MODULE$.ioConcurrentEffect(cs)).$times$greater((Object)IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Scanner scanner = instance$1.connector().createScanner(table$1, new Authorizations());
            scanner.setRange(range);
            scanner.fetchColumnFamily(columnFamily$1);
            Vector result = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> (Vector)AvroEncoder$.MODULE$.fromBinary((Schema)writerSchema$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> codec$1.schema()), ((Value)entry.getValue()).get(), (AvroRecordCodec)codec$1)).flatMap((Function1 & Serializable & scala.Serializable)pairs -> filterIndexOnly$1 ? pairs : (Vector)pairs.filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)AccumuloCollectionReader$.$anonfun$read$7(includeKey$1, pair)))).toVector();
            scanner.close();
            return result;
        }))));
        try {
            seq = (Seq)((IO)Stream$.MODULE$.compile$extension(Stream$.MODULE$.parJoin$extension(Stream$.MODULE$.map$extension(range2, (Function1)read), threads, Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (Concurrent)IO$.MODULE$.ioConcurrentEffect(cs)), Stream.Compiler$.MODULE$.syncInstance((Sync)IO$.MODULE$.ioConcurrentEffect(cs))).toVector()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Vector)x$1.flatten((Function1)Predef$.MODULE$.$conforms())).unsafeRunSync();
        }
        finally {
            pool.shutdown();
        }
        return seq;
    }

    public <K, V> Option<Schema> read$default$6() {
        return None$.MODULE$;
    }

    public <K, V> int read$default$7() {
        return this.defaultThreadCount();
    }

    public static final /* synthetic */ boolean $anonfun$read$1(Seq queryKeyBounds$1, Boundable evidence$1$1, Object key) {
        return KeyBounds$.MODULE$.KeyBoundsSeqMethods(queryKeyBounds$1, evidence$1$1).includeKey(key);
    }

    public static final /* synthetic */ boolean $anonfun$read$7(Function1 includeKey$1, Tuple2 pair) {
        return BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply(pair._1()));
    }

    private AccumuloCollectionReader$() {
        MODULE$ = this;
        this.defaultThreadCount = AccumuloConfig$.MODULE$.accumuloConfigToClass(AccumuloConfig$.MODULE$).threads().collection().readThreads();
    }
}

