/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.accumulo;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.LayerDeleter;
import geotrellis.spark.io.accumulo.AccumuloAttributeStore;
import geotrellis.spark.io.accumulo.AccumuloInstance;
import geotrellis.spark.io.accumulo.AccumuloLayerDeleter$;
import geotrellis.spark.io.accumulo.AccumuloLayerHeader;
import geotrellis.spark.io.accumulo.AccumuloLayerHeader$AccumuloLayerMetadataFormat$;
import geotrellis.spark.io.accumulo.package$;
import geotrellis.spark.io.package;
import java.util.Collection;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import spray.json.JsonFormat;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u0017\t!\u0012iY2v[Vdw\u000eT1zKJ$U\r\\3uKJT!a\u0001\u0003\u0002\u0011\u0005\u001c7-^7vY>T!!\u0002\u0004\u0002\u0005%|'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u00042a\u0005\u000b\u0017\u001b\u0005!\u0011BA\u000b\u0005\u00051a\u0015-_3s\t\u0016dW\r^3s!\t9\u0002$D\u0001\u0007\u0013\tIbAA\u0004MCf,'/\u00133\t\u0011m\u0001!Q1A\u0005\u0002q\ta\"\u0019;ue&\u0014W\u000f^3Ti>\u0014X-F\u0001\u001e!\t\u0019b$\u0003\u0002 \t\tq\u0011\t\u001e;sS\n,H/Z*u_J,\u0007\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u001f\u0005$HO]5ckR,7\u000b^8sK\u0002B\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\nG>tg.Z2u_J\u0004\"!J\u0018\u000e\u0003\u0019R!a\n\u0015\u0002\r\rd\u0017.\u001a8u\u0015\tI#&\u0001\u0003d_J,'BA\u0002,\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\n\u0005A2#!C\"p]:,7\r^8s\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q\u0019AGN\u001c\u0011\u0005U\u0002Q\"\u0001\u0002\t\u000bm\t\u0004\u0019A\u000f\t\u000b\r\n\u0004\u0019\u0001\u0013\t\u000be\u0002A\u0011\u0001\u001e\u0002\r\u0011,G.\u001a;f)\tYd\b\u0005\u0002\u000ey%\u0011QH\u0004\u0002\u0005+:LG\u000fC\u0003@q\u0001\u0007a#\u0001\u0002jI\"A\u0011\t\u0001EC\u0002\u0013E!)\u0001\u0004m_\u001e<WM]\u000b\u0002\u0007B\u0011AiS\u0007\u0002\u000b*\u0011aiR\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0011&\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0015\u0006\u00191m\\7\n\u00051+%A\u0002'pO\u001e,'\u000f\u000b\u0002A\u001dB\u0011QbT\u0005\u0003!:\u0011\u0011\u0002\u001e:b]NLWM\u001c;\b\u000bI\u0013\u0001\u0012A*\u0002)\u0005\u001b7-^7vY>d\u0015-_3s\t\u0016dW\r^3s!\t)DKB\u0003\u0002\u0005!\u0005Qk\u0005\u0002U\u0019!)!\u0007\u0016C\u0001/R\t1\u000bC\u0003Z)\u0012\u0005!,A\u0003baBd\u0017\u0010F\u000257rCQa\u0007-A\u0002uAQa\t-A\u0002\u0011BQ!\u0017+\u0005\u0002y#2\u0001N0a\u0011\u0015YR\f1\u0001\u001e\u0011\u0015\tW\f1\u0001c\u0003!Ign\u001d;b]\u000e,\u0007CA\u001bd\u0013\t!'A\u0001\tBG\u000e,X.\u001e7p\u0013:\u001cH/\u00198dK\")\u0011\f\u0016C\u0001MR\u0011Ag\u001a\u0005\u00067\u0015\u0004\r\u0001\u001b\t\u0003k%L!A\u001b\u0002\u0003-\u0005\u001b7-^7vY>\fE\u000f\u001e:jEV$Xm\u0015;pe\u0016DQ!\u0017+\u0005\u00021$\"\u0001N7\t\u000b\u0005\\\u0007\u0019\u00012")
public class AccumuloLayerDeleter
implements LayerDeleter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final Connector connector;
    private volatile transient boolean bitmap$trans$0;

    public static AccumuloLayerDeleter apply(AccumuloInstance accumuloInstance) {
        return AccumuloLayerDeleter$.MODULE$.apply(accumuloInstance);
    }

    public static AccumuloLayerDeleter apply(AccumuloAttributeStore accumuloAttributeStore) {
        return AccumuloLayerDeleter$.MODULE$.apply(accumuloAttributeStore);
    }

    public static AccumuloLayerDeleter apply(AttributeStore attributeStore, AccumuloInstance accumuloInstance) {
        return AccumuloLayerDeleter$.MODULE$.apply(attributeStore, accumuloInstance);
    }

    public static AccumuloLayerDeleter apply(AttributeStore attributeStore, Connector connector) {
        return AccumuloLayerDeleter$.MODULE$.apply(attributeStore, connector);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        AccumuloLayerDeleter accumuloLayerDeleter = this;
        synchronized (accumuloLayerDeleter) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void delete(LayerId id) {
        try {
            try {
                AccumuloLayerHeader header = (AccumuloLayerHeader)this.attributeStore().readHeader(id, (JsonFormat)AccumuloLayerHeader$AccumuloLayerMetadataFormat$.MODULE$);
                int numThreads = 1;
                BatchWriterConfig config = new BatchWriterConfig();
                config.setMaxWriteThreads(numThreads);
                try (BatchDeleter deleter = this.connector.createBatchDeleter(header.tileTable(), new Authorizations(), numThreads, config);){
                    deleter.fetchColumnFamily(package$.MODULE$.stringToText(package$.MODULE$.columnFamily(id)));
                    deleter.setRanges((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Range(), (List)Nil$.MODULE$)).asJava());
                    deleter.delete();
                }
            }
            catch (package.AttributeNotFoundError e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Metadata for {} was not found. Any associated layer data (if any) will require manual deletion", new Object[]{id});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new package.LayerDeleteError(id).initCause((Throwable)e);
            }
        }
        finally {
            this.attributeStore().delete(id);
        }
    }

    public AccumuloLayerDeleter(AttributeStore attributeStore, Connector connector) {
        this.attributeStore = attributeStore;
        this.connector = connector;
    }
}

