/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.accumulo;

import geotrellis.spark.Boundable;
import geotrellis.spark.Bounds;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.LayerReindexer;
import geotrellis.spark.io.accumulo.AccumuloInstance;
import geotrellis.spark.io.accumulo.AccumuloLayerCopier;
import geotrellis.spark.io.accumulo.AccumuloLayerCopier$;
import geotrellis.spark.io.accumulo.AccumuloLayerDeleter;
import geotrellis.spark.io.accumulo.AccumuloLayerDeleter$;
import geotrellis.spark.io.accumulo.AccumuloLayerHeader;
import geotrellis.spark.io.accumulo.AccumuloLayerHeader$AccumuloLayerMetadataFormat$;
import geotrellis.spark.io.accumulo.AccumuloLayerReader;
import geotrellis.spark.io.accumulo.AccumuloLayerReader$;
import geotrellis.spark.io.accumulo.AccumuloLayerReindexer$;
import geotrellis.spark.io.accumulo.AccumuloLayerWriter;
import geotrellis.spark.io.accumulo.AccumuloLayerWriter$;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.index.KeyIndexMethod;
import geotrellis.spark.io.package;
import geotrellis.util.Component;
import java.time.ZonedDateTime;
import org.apache.spark.SparkContext;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import spray.json.JsonFormat;

@ScalaSignature(bytes="\u0006\u0001\u0005}v!B\u0001\u0003\u0011\u0003Y\u0011AF!dGVlW\u000f\\8MCf,'OU3j]\u0012,\u00070\u001a:\u000b\u0005\r!\u0011\u0001C1dGVlW\u000f\\8\u000b\u0005\u00151\u0011AA5p\u0015\t9\u0001\"A\u0003ta\u0006\u00148NC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005Y\t5mY;nk2|G*Y=feJ+\u0017N\u001c3fq\u0016\u00148CA\u0007\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\")q#\u0004C\u00011\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u000655!\taG\u0001\u0006CB\u0004H.\u001f\u000b\b9\u0005\r\u0016QUAT)\ri\u0012\u0011\u0015\t\u0003\u0019y1AA\u0004\u0002\u0001?M\u0019a\u0004\u0005\u0011\u0011\u0007\u0005\u0012C%D\u0001\u0005\u0013\t\u0019CA\u0001\bMCf,'OU3j]\u0012,\u00070\u001a:\u0011\u0005\u00152S\"\u0001\u0004\n\u0005\u001d2!a\u0002'bs\u0016\u0014\u0018\n\u001a\u0005\tSy\u0011\t\u0011)A\u0005U\u0005A\u0011N\\:uC:\u001cW\r\u0005\u0002\rW%\u0011AF\u0001\u0002\u0011\u0003\u000e\u001cW/\\;m_&s7\u000f^1oG\u0016D\u0001B\f\u0010\u0003\u0002\u0003\u0006IaL\u0001\u000fCR$(/\u001b2vi\u0016\u001cFo\u001c:f!\t\t\u0003'\u0003\u00022\t\tq\u0011\t\u001e;sS\n,H/Z*u_J,\u0007\u0002C\u001a\u001f\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u000f=\u0004H/[8ogB\u0011Q\u0007\u000f\b\u0003\u0019YJ!a\u000e\u0002\u0002'\u0005\u001b7-^7vY>d\u0015-_3s/JLG/\u001a:\n\u0005eR$aB(qi&|gn\u001d\u0006\u0003o\tA\u0001\u0002\u0010\u0010\u0003\u0002\u0003\u0006Y!P\u0001\u0003g\u000e\u0004\"A\u0010#\u000e\u0003}R!a\u0002!\u000b\u0005\u0005\u0013\u0015AB1qC\u000eDWMC\u0001D\u0003\ry'oZ\u0005\u0003\u000b~\u0012Ab\u00159be.\u001cuN\u001c;fqRDQa\u0006\u0010\u0005\u0002\u001d#B\u0001\u0013&L\u0019R\u0011Q$\u0013\u0005\u0006y\u0019\u0003\u001d!\u0010\u0005\u0006S\u0019\u0003\rA\u000b\u0005\u0006]\u0019\u0003\ra\f\u0005\u0006g\u0019\u0003\r\u0001\u000e\u0005\u0006\u001dz!\taT\u0001\tO\u0016$H+\u001c9JIR\u0011A\u0005\u0015\u0005\u0006#6\u0003\r\u0001J\u0001\u0003S\u0012DQa\u0015\u0010\u0005\u0002Q\u000bqA]3j]\u0012,\u00070\u0006\u0004VI\u0006E\u00111\u0005\u000b\u0006-\u0006u\u0012q\b\u000b\u000e/jk'\u000f`A\u0005\u0003+\tY\"a\n\u0011\u0005EA\u0016BA-\u0013\u0005\u0011)f.\u001b;\t\u000fm\u0013\u0016\u0011!a\u00029\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007u\u0003'-D\u0001_\u0015\tyF!\u0001\u0003bmJ|\u0017BA1_\u0005=\teO]8SK\u000e|'\u000fZ\"pI\u0016\u001c\u0007CA2e\u0019\u0001!Q!\u001a*C\u0002\u0019\u0014\u0011aS\t\u0003O*\u0004\"!\u00055\n\u0005%\u0014\"a\u0002(pi\"Lgn\u001a\t\u0003#-L!\u0001\u001c\n\u0003\u0007\u0005s\u0017\u0010C\u0004o%\u0006\u0005\t9A8\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002&a\nL!!\u001d\u0004\u0003\u0013\t{WO\u001c3bE2,\u0007bB:S\u0003\u0003\u0005\u001d\u0001^\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004cA;{E6\taO\u0003\u0002xq\u0006!!n]8o\u0015\u0005I\u0018!B:qe\u0006L\u0018BA>w\u0005)Q5o\u001c8G_Jl\u0017\r\u001e\u0005\b{J\u000b\t\u0011q\u0001\u007f\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0005\u007f\u0006\u0015!-\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\n\u0002\u000fI,g\r\\3di&!\u0011qAA\u0001\u0005!\u0019E.Y:t)\u0006<\u0007\"CA\u0006%\u0006\u0005\t9AA\u0007\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0005;\u0002\fy\u0001E\u0002d\u0003#!a!a\u0005S\u0005\u00041'!\u0001,\t\u0013\u0005]!+!AA\u0004\u0005e\u0011AC3wS\u0012,gnY3%mA)q0!\u0002\u0002\u0010!I\u0011Q\u0004*\u0002\u0002\u0003\u000f\u0011qD\u0001\u000bKZLG-\u001a8dK\u0012:\u0004\u0003B;{\u0003C\u00012aYA\u0012\t\u0019\t)C\u0015b\u0001M\n\tQ\nC\u0005\u0002*I\u000b\t\u0011q\u0001\u0002,\u0005QQM^5eK:\u001cW\r\n\u001d\u0011\u0011\u00055\u00121GA\u0011\u0003oi!!a\f\u000b\u0007\u0005E\u0002\"\u0001\u0003vi&d\u0017\u0002BA\u001b\u0003_\u0011\u0011bQ8na>tWM\u001c;\u0011\t\u0015\nIDY\u0005\u0004\u0003w1!A\u0002\"pk:$7\u000fC\u0003R%\u0002\u0007A\u0005C\u0004\u0002BI\u0003\r!a\u0011\u0002\u0011-,\u00170\u00138eKb\u0004R!!\u0012\u0002L\tl!!a\u0012\u000b\u0007\u0005%C!A\u0003j]\u0012,\u00070\u0003\u0003\u0002N\u0005\u001d#\u0001C&fs&sG-\u001a=\t\rMsB\u0011AA)+!\t\u0019&a\u0018\u0002|\u0005-ECBA+\u0003+\u000b9\nF\tX\u0003/\n\t'a\u001a\u0002n\u0005M\u0014QPAB\u0003\u001bC!\"!\u0017\u0002P\u0005\u0005\t9AA.\u0003))g/\u001b3f]\u000e,G%\u000f\t\u0005;\u0002\fi\u0006E\u0002d\u0003?\"a!ZA(\u0005\u00041\u0007BCA2\u0003\u001f\n\t\u0011q\u0001\u0002f\u0005YQM^5eK:\u001cW\rJ\u00191!\u0011)\u0003/!\u0018\t\u0015\u0005%\u0014qJA\u0001\u0002\b\tY'A\u0006fm&$WM\\2fIE\n\u0004\u0003B;{\u0003;B!\"a\u001c\u0002P\u0005\u0005\t9AA9\u0003-)g/\u001b3f]\u000e,G%\r\u001a\u0011\u000b}\f)!!\u0018\t\u0015\u0005U\u0014qJA\u0001\u0002\b\t9(A\u0006fm&$WM\\2fIE\u001a\u0004\u0003B/a\u0003s\u00022aYA>\t\u001d\t\u0019\"a\u0014C\u0002\u0019D!\"a \u0002P\u0005\u0005\t9AAA\u0003-)g/\u001b3f]\u000e,G%\r\u001b\u0011\u000b}\f)!!\u001f\t\u0015\u0005\u0015\u0015qJA\u0001\u0002\b\t9)A\u0006fm&$WM\\2fIE*\u0004\u0003B;{\u0003\u0013\u00032aYAF\t\u001d\t)#a\u0014C\u0002\u0019D!\"a$\u0002P\u0005\u0005\t9AAI\u0003-)g/\u001b3f]\u000e,G%\r\u001c\u0011\u0011\u00055\u00121GAE\u0003'\u0003R!JA\u001d\u0003;Ba!UA(\u0001\u0004!\u0003\u0002CAM\u0003\u001f\u0002\r!a'\u0002\u001d-,\u00170\u00138eKblU\r\u001e5pIB1\u0011QIAO\u0003;JA!a(\u0002H\tq1*Z=J]\u0012,\u00070T3uQ>$\u0007\"\u0002\u001f\u001a\u0001\bi\u0004\"B\u0015\u001a\u0001\u0004Q\u0003\"\u0002\u0018\u001a\u0001\u0004y\u0003\"B\u001a\u001a\u0001\u0004!\u0004B\u0002\u000e\u000e\t\u0003\tY\u000b\u0006\u0004\u0002.\u0006E\u00161\u0017\u000b\u0004;\u0005=\u0006B\u0002\u001f\u0002*\u0002\u000fQ\b\u0003\u0004*\u0003S\u0003\rA\u000b\u0005\u0007g\u0005%\u0006\u0019\u0001\u001b\t\riiA\u0011AA\\)\u0011\tI,!0\u0015\u0007u\tY\f\u0003\u0004=\u0003k\u0003\u001d!\u0010\u0005\u0007S\u0005U\u0006\u0019\u0001\u0016")
public class AccumuloLayerReindexer
implements LayerReindexer<LayerId> {
    private final AccumuloInstance instance;
    private final AttributeStore attributeStore;
    private final AccumuloLayerWriter.Options options;
    private final SparkContext sc;

    public static AccumuloLayerReindexer apply(AccumuloInstance accumuloInstance, SparkContext sparkContext) {
        return AccumuloLayerReindexer$.MODULE$.apply(accumuloInstance, sparkContext);
    }

    public static AccumuloLayerReindexer apply(AccumuloInstance accumuloInstance, AccumuloLayerWriter.Options options, SparkContext sparkContext) {
        return AccumuloLayerReindexer$.MODULE$.apply(accumuloInstance, options, sparkContext);
    }

    public static AccumuloLayerReindexer apply(AccumuloInstance accumuloInstance, AttributeStore attributeStore, AccumuloLayerWriter.Options options, SparkContext sparkContext) {
        return AccumuloLayerReindexer$.MODULE$.apply(accumuloInstance, attributeStore, options, sparkContext);
    }

    public LayerId getTmpId(LayerId id) {
        return id.copy(new StringBuilder(1).append(id.name()).append("-").append(ZonedDateTime.now().toInstant().toEpochMilli()).toString(), id.copy$default$2());
    }

    public <K, V, M> void reindex(LayerId id, KeyIndex<K> keyIndex, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, JsonFormat<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, JsonFormat<M> evidence$7, Component<M, Bounds<K>> evidence$8) {
        if (!this.attributeStore.layerExists(id)) {
            throw new package.LayerNotFoundError(id);
        }
        LayerId tmpId = this.getTmpId(id);
        AccumuloLayerHeader header = (AccumuloLayerHeader)this.attributeStore.readHeader(id, (JsonFormat)AccumuloLayerHeader$AccumuloLayerMetadataFormat$.MODULE$);
        String table = header.tileTable();
        AccumuloLayerReader layerReader = AccumuloLayerReader$.MODULE$.apply(this.instance, this.sc);
        AccumuloLayerWriter layerWriter = AccumuloLayerWriter$.MODULE$.apply(this.instance, table, this.options);
        AccumuloLayerDeleter layerDeleter = AccumuloLayerDeleter$.MODULE$.apply(this.instance);
        AccumuloLayerCopier layerCopier = AccumuloLayerCopier$.MODULE$.apply(this.attributeStore, layerReader, layerWriter, this.sc);
        layerWriter.write((Object)tmpId, layerReader.read(id, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8), keyIndex, evidence$1, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8);
        layerDeleter.delete(id);
        layerCopier.copy(tmpId, id, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8);
        layerDeleter.delete(tmpId);
    }

    public <K, V, M> void reindex(LayerId id, KeyIndexMethod<K> keyIndexMethod, AvroRecordCodec<K> evidence$9, Boundable<K> evidence$10, JsonFormat<K> evidence$11, ClassTag<K> evidence$12, AvroRecordCodec<V> evidence$13, ClassTag<V> evidence$14, JsonFormat<M> evidence$15, Component<M, Bounds<K>> evidence$16) {
        if (!this.attributeStore.layerExists(id)) {
            throw new package.LayerNotFoundError(id);
        }
        LayerId tmpId = this.getTmpId(id);
        AccumuloLayerHeader header = (AccumuloLayerHeader)this.attributeStore.readHeader(id, (JsonFormat)AccumuloLayerHeader$AccumuloLayerMetadataFormat$.MODULE$);
        KeyIndex existingKeyIndex = this.attributeStore.readKeyIndex(id, evidence$12);
        String table = header.tileTable();
        AccumuloLayerReader layerReader = AccumuloLayerReader$.MODULE$.apply(this.instance, this.sc);
        AccumuloLayerWriter layerWriter = AccumuloLayerWriter$.MODULE$.apply(this.instance, table, this.options);
        AccumuloLayerDeleter layerDeleter = AccumuloLayerDeleter$.MODULE$.apply(this.instance);
        AccumuloLayerCopier layerCopier = AccumuloLayerCopier$.MODULE$.apply(this.attributeStore, layerReader, layerWriter, this.sc);
        layerWriter.write((Object)tmpId, layerReader.read(id, evidence$9, evidence$10, evidence$11, evidence$12, evidence$13, evidence$14, evidence$15, evidence$16), keyIndexMethod.createIndex(existingKeyIndex.keyBounds()), evidence$9, evidence$11, evidence$12, evidence$13, evidence$14, evidence$15, evidence$16);
        layerDeleter.delete(id);
        layerCopier.copy(tmpId, id, evidence$9, evidence$10, evidence$11, evidence$12, evidence$13, evidence$14, evidence$15, evidence$16);
        layerDeleter.delete(tmpId);
    }

    public AccumuloLayerReindexer(AccumuloInstance instance, AttributeStore attributeStore, AccumuloLayerWriter.Options options, SparkContext sc) {
        this.instance = instance;
        this.attributeStore = attributeStore;
        this.options = options;
        this.sc = sc;
    }
}

