/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.accumulo;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.Boundable;
import geotrellis.spark.Bounds;
import geotrellis.spark.LayerId;
import geotrellis.spark.Metadata;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.LayerAttributes;
import geotrellis.spark.io.LayerWriter;
import geotrellis.spark.io.Writer;
import geotrellis.spark.io.accumulo.AccumuloInstance;
import geotrellis.spark.io.accumulo.AccumuloKeyEncoder$;
import geotrellis.spark.io.accumulo.AccumuloLayerHeader;
import geotrellis.spark.io.accumulo.AccumuloLayerHeader$;
import geotrellis.spark.io.accumulo.AccumuloLayerHeader$AccumuloLayerMetadataFormat$;
import geotrellis.spark.io.accumulo.AccumuloLayerWriter$;
import geotrellis.spark.io.accumulo.AccumuloRDDWriter$;
import geotrellis.spark.io.accumulo.AccumuloUtils$;
import geotrellis.spark.io.accumulo.AccumuloWriteStrategy;
import geotrellis.spark.io.accumulo.HdfsWriteStrategy;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.index.KeyIndexMethod;
import geotrellis.spark.io.package;
import geotrellis.spark.merge.Mergable;
import geotrellis.util.Component;
import java.io.Serializable;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.avro.Schema;
import org.apache.spark.rdd.RDD;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import spray.json.JsonFormat;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001B\u0001\u0003\u0001-\u00111#Q2dk6,Hn\u001c'bs\u0016\u0014xK]5uKJT!a\u0001\u0003\u0002\u0011\u0005\u001c7-^7vY>T!!\u0002\u0004\u0002\u0005%|'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u00042a\u0005\u000b\u0017\u001b\u0005!\u0011BA\u000b\u0005\u0005-a\u0015-_3s/JLG/\u001a:\u0011\u0005]AR\"\u0001\u0004\n\u0005e1!a\u0002'bs\u0016\u0014\u0018\n\u001a\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005q\u0011\r\u001e;sS\n,H/Z*u_J,W#A\u000f\u0011\u0005Mq\u0012BA\u0010\u0005\u00059\tE\u000f\u001e:jEV$Xm\u0015;pe\u0016D\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0010CR$(/\u001b2vi\u0016\u001cFo\u001c:fA!A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0005j]N$\u0018M\\2f!\t)c%D\u0001\u0003\u0013\t9#A\u0001\tBG\u000e,X.\u001e7p\u0013:\u001cH/\u00198dK\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0003uC\ndW\r\u0005\u0002,e9\u0011A\u0006\r\t\u0003[9i\u0011A\f\u0006\u0003_)\ta\u0001\u0010:p_Rt\u0014BA\u0019\u000f\u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Er\u0001\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u000f=\u0004H/[8ogB\u0011\u0001(\u0011\b\u0003Ke:QA\u000f\u0002\t\u0002m\n1#Q2dk6,Hn\u001c'bs\u0016\u0014xK]5uKJ\u0004\"!\n\u001f\u0007\u000b\u0005\u0011\u0001\u0012A\u001f\u0014\u0005qb\u0001\"B =\t\u0003\u0001\u0015A\u0002\u001fj]&$h\bF\u0001<\r\u0011\u0011E\bQ\"\u0003\u000f=\u0003H/[8ogN!\u0011\t\u0004#H!\tiQ)\u0003\u0002G\u001d\t9\u0001K]8ek\u000e$\bCA\u0007I\u0013\tIeB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005L\u0003\nU\r\u0011\"\u0001M\u000359(/\u001b;f'R\u0014\u0018\r^3hsV\tQ\n\u0005\u0002&\u001d&\u0011qJ\u0001\u0002\u0016\u0003\u000e\u001cW/\\;m_^\u0013\u0018\u000e^3TiJ\fG/Z4z\u0011!\t\u0016I!E!\u0002\u0013i\u0015AD<sSR,7\u000b\u001e:bi\u0016<\u0017\u0010\t\u0005\u0006\u007f\u0005#\ta\u0015\u000b\u0003)Z\u0003\"!V!\u000e\u0003qBqa\u0013*\u0011\u0002\u0003\u0007Q\nC\u0004Y\u0003\u0006\u0005I\u0011A-\u0002\t\r|\u0007/\u001f\u000b\u0003)jCqaS,\u0011\u0002\u0003\u0007Q\nC\u0004]\u0003F\u0005I\u0011A/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\taL\u000b\u0002N?.\n\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003K:\t!\"\u00198o_R\fG/[8o\u0013\t9'MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq![!\u0002\u0002\u0013\u0005#.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0005Y\u0006twMC\u0001q\u0003\u0011Q\u0017M^1\n\u0005Mj\u0007bB:B\u0003\u0003%\t\u0001^\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002kB\u0011QB^\u0005\u0003o:\u00111!\u00138u\u0011\u001dI\u0018)!A\u0005\u0002i\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002|}B\u0011Q\u0002`\u0005\u0003{:\u00111!\u00118z\u0011\u001dy\b0!AA\u0002U\f1\u0001\u001f\u00132\u0011%\t\u0019!QA\u0001\n\u0003\n)!A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0001E\u0003\u0002\n\u0005=10\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0012\u0005-!\u0001C%uKJ\fGo\u001c:\t\u0013\u0005U\u0011)!A\u0005\u0002\u0005]\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e\u0011q\u0004\t\u0004\u001b\u0005m\u0011bAA\u000f\u001d\t9!i\\8mK\u0006t\u0007\u0002C@\u0002\u0014\u0005\u0005\t\u0019A>\t\u0013\u0005\r\u0012)!A\u0005B\u0005\u0015\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003UD\u0011\"!\u000bB\u0003\u0003%\t%a\u000b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u001b\u0005\n\u0003_\t\u0015\u0011!C!\u0003c\ta!Z9vC2\u001cH\u0003BA\r\u0003gA\u0001b`A\u0017\u0003\u0003\u0005\ra_\u0004\b\u0003oa\u0004\u0012AA\u001d\u0003\u001dy\u0005\u000f^5p]N\u00042!VA\u001e\r\u0019\u0011E\b#\u0001\u0002>M!\u00111\b\u0007H\u0011\u001dy\u00141\bC\u0001\u0003\u0003\"\"!!\u000f\t\u0011\u0005\u0015\u00131\bC\u0001\u0003\u000f\nq\u0001R#G\u0003VcE+F\u0001U\u0011!\tY%a\u000f\u0005\u0004\u00055\u0013AF<sSR,7\u000b\u001e:bi\u0016<\u0017\u0010V8PaRLwN\\:\u0015\u0007Q\u000by\u0005C\u0004\u0002R\u0005%\u0003\u0019A'\u0002\u0005]\u001c\bBCA+\u0003w\t\t\u0011\"!\u0002X\u0005)\u0011\r\u001d9msR\u0019A+!\u0017\t\u0011-\u000b\u0019\u0006%AA\u00025C!\"!\u0018\u0002<\u0005\u0005I\u0011QA0\u0003\u001d)h.\u00199qYf$B!!\u0019\u0002hA!Q\"a\u0019N\u0013\r\t)G\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005%\u00141LA\u0001\u0002\u0004!\u0016a\u0001=%a!I\u0011QNA\u001e#\u0003%\t!X\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\t\u0013\u0005E\u00141HI\u0001\n\u0003i\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\t\u0015\u0005U\u00141HA\u0001\n\u0013\t9(A\u0006sK\u0006$'+Z:pYZ,GCAA=!\ra\u00171P\u0005\u0004\u0003{j'AB(cU\u0016\u001cG\u000fC\u0004\u0002Vq\"\t!!!\u0015\u0011\u0005\r\u0015QQAD\u0003\u0013\u0003\"!\n\u0001\t\r\r\ny\b1\u0001%\u0011\u0019I\u0013q\u0010a\u0001U!1a'a A\u0002QCq!!\u0016=\t\u0003\ti\t\u0006\u0004\u0002\u0004\u0006=\u0015\u0011\u0013\u0005\u0007G\u0005-\u0005\u0019\u0001\u0013\t\r%\nY\t1\u0001+\u0011\u001d\t)\u0006\u0010C\u0001\u0003+#\"\"a!\u0002\u0018\u0006e\u00151TAO\u0011\u0019\u0019\u00131\u0013a\u0001I!11$a%A\u0002uAa!KAJ\u0001\u0004Q\u0003B\u0002\u001c\u0002\u0014\u0002\u0007A\u000bC\u0004\u0002Vq\"\t!!)\u0015\u0011\u0005\r\u00151UAS\u0003OCaaIAP\u0001\u0004!\u0003BB\u000e\u0002 \u0002\u0007Q\u0004\u0003\u0004*\u0003?\u0003\rA\u000b\u0005\u0007\u007f\u0001!\t!a+\u0015\u0015\u0005\r\u0015QVAX\u0003c\u000b\u0019\f\u0003\u0004\u001c\u0003S\u0003\r!\b\u0005\u0007G\u0005%\u0006\u0019\u0001\u0013\t\r%\nI\u000b1\u0001+\u0011\u00191\u0014\u0011\u0016a\u0001o!9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0016!C8wKJ<(/\u001b;f+!\tY,!7\u0003\u001c\t5BCBA_\u0005/\u0012Y\u0006\u0006\u000b\u0002@\u0006\u0015\u0017Q]Ax\u0005\u0007\u0011\u0019Ba\b\u0003&\tE\"q\t\t\u0004\u001b\u0005\u0005\u0017bAAb\u001d\t!QK\\5u\u0011)\t9-!.\u0002\u0002\u0003\u000f\u0011\u0011Z\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBAf\u0003#\f).\u0004\u0002\u0002N*\u0019\u0011q\u001a\u0003\u0002\t\u00054(o\\\u0005\u0005\u0003'\fiMA\bBmJ|'+Z2pe\u0012\u001cu\u000eZ3d!\u0011\t9.!7\r\u0001\u0011A\u00111\\A[\u0005\u0004\tiNA\u0001L#\r\tyn\u001f\t\u0004\u001b\u0005\u0005\u0018bAAr\u001d\t9aj\u001c;iS:<\u0007BCAt\u0003k\u000b\t\u0011q\u0001\u0002j\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\u000b]\tY/!6\n\u0007\u00055hAA\u0005C_VtG-\u00192mK\"Q\u0011\u0011_A[\u0003\u0003\u0005\u001d!a=\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0004\u0002v\u0006}\u0018Q[\u0007\u0003\u0003oTA!!?\u0002|\u0006!!n]8o\u0015\t\ti0A\u0003taJ\f\u00170\u0003\u0003\u0003\u0002\u0005](A\u0003&t_:4uN]7bi\"Q!QAA[\u0003\u0003\u0005\u001dAa\u0002\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007\u0005\u0004\u0003\n\t=\u0011Q[\u0007\u0003\u0005\u0017Q1A!\u0004\u000f\u0003\u001d\u0011XM\u001a7fGRLAA!\u0005\u0003\f\tA1\t\\1tgR\u000bw\r\u0003\u0006\u0003\u0016\u0005U\u0016\u0011!a\u0002\u0005/\t!\"\u001a<jI\u0016t7-\u001a\u00136!\u0019\tY-!5\u0003\u001aA!\u0011q\u001bB\u000e\t!\u0011i\"!.C\u0002\u0005u'!\u0001,\t\u0015\t\u0005\u0012QWA\u0001\u0002\b\u0011\u0019#\u0001\u0006fm&$WM\\2fIY\u0002bA!\u0003\u0003\u0010\te\u0001B\u0003B\u0014\u0003k\u000b\t\u0011q\u0001\u0003*\u0005QQM^5eK:\u001cW\rJ\u001c\u0011\r\u0005U\u0018q B\u0016!\u0011\t9N!\f\u0005\u0011\t=\u0012Q\u0017b\u0001\u0003;\u0014\u0011!\u0014\u0005\u000b\u0005g\t),!AA\u0004\tU\u0012AC3wS\u0012,gnY3%qAA!q\u0007B\u001f\u0005W\u0011\t%\u0004\u0002\u0003:)\u0019!1\b\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u007f\u0011IDA\u0005D_6\u0004xN\\3oiB)qCa\u0011\u0002V&\u0019!Q\t\u0004\u0003\r\t{WO\u001c3t\u0011)\u0011I%!.\u0002\u0002\u0003\u000f!1J\u0001\u000bKZLG-\u001a8dK\u0012J\u0004C\u0002B'\u0005'\u0012Y#\u0004\u0002\u0003P)\u0019!\u0011\u000b\u0004\u0002\u000b5,'oZ3\n\t\tU#q\n\u0002\t\u001b\u0016\u0014x-\u00192mK\"9!\u0011LA[\u0001\u00041\u0012AA5e\u0011!\u0011i&!.A\u0002\t}\u0013a\u0001:eIJ1!\u0011\rB3\u0005\u007f2aAa\u0019\u0001\u0001\t}#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004C\u0002B4\u0005k\u0012I(\u0004\u0002\u0003j)!!Q\fB6\u0015\r9!Q\u000e\u0006\u0005\u0005_\u0012\t(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0005g\n1a\u001c:h\u0013\u0011\u00119H!\u001b\u0003\u0007I#E\tE\u0004\u000e\u0005w\n)N!\u0007\n\u0007\tudB\u0001\u0004UkBdWM\r\t\u0006/\t\u0005%1F\u0005\u0004\u0005\u00073!\u0001C'fi\u0006$\u0017\r^1\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\u00061Q\u000f\u001d3bi\u0016,\u0002Ba#\u0003\u0018\nM&1\u0019\u000b\t\u0005\u001b\u0013\u0019N!6\u0003bR!\u0012q\u0018BH\u00053\u0013yJ!*\u0003,\nU&1\u0018Bc\u0005\u001bD!B!%\u0003\u0006\u0006\u0005\t9\u0001BJ\u0003-)g/\u001b3f]\u000e,G%\r\u0019\u0011\r\u0005-\u0017\u0011\u001bBK!\u0011\t9Na&\u0005\u0011\u0005m'Q\u0011b\u0001\u0003;D!Ba'\u0003\u0006\u0006\u0005\t9\u0001BO\u0003-)g/\u001b3f]\u000e,G%M\u0019\u0011\u000b]\tYO!&\t\u0015\t\u0005&QQA\u0001\u0002\b\u0011\u0019+A\u0006fm&$WM\\2fIE\u0012\u0004CBA{\u0003\u007f\u0014)\n\u0003\u0006\u0003(\n\u0015\u0015\u0011!a\u0002\u0005S\u000b1\"\u001a<jI\u0016t7-\u001a\u00132gA1!\u0011\u0002B\b\u0005+C!B!,\u0003\u0006\u0006\u0005\t9\u0001BX\u0003-)g/\u001b3f]\u000e,G%\r\u001b\u0011\r\u0005-\u0017\u0011\u001bBY!\u0011\t9Na-\u0005\u0011\tu!Q\u0011b\u0001\u0003;D!Ba.\u0003\u0006\u0006\u0005\t9\u0001B]\u0003-)g/\u001b3f]\u000e,G%M\u001b\u0011\r\t%!q\u0002BY\u0011)\u0011iL!\"\u0002\u0002\u0003\u000f!qX\u0001\fKZLG-\u001a8dK\u0012\nd\u0007\u0005\u0004\u0002v\u0006}(\u0011\u0019\t\u0005\u0003/\u0014\u0019\r\u0002\u0005\u00030\t\u0015%\u0019AAo\u0011)\u00119M!\"\u0002\u0002\u0003\u000f!\u0011Z\u0001\fKZLG-\u001a8dK\u0012\nt\u0007\u0005\u0005\u00038\tu\"\u0011\u0019Bf!\u00159\"1\tBK\u0011)\u0011yM!\"\u0002\u0002\u0003\u000f!\u0011[\u0001\fKZLG-\u001a8dK\u0012\n\u0004\b\u0005\u0004\u0003N\tM#\u0011\u0019\u0005\b\u00053\u0012)\t1\u0001\u0017\u0011!\u0011iF!\"A\u0002\t]'C\u0002Bm\u00057\u0014yN\u0002\u0004\u0003d\u0001\u0001!q\u001b\t\u0007\u0005O\u0012)H!8\u0011\u000f5\u0011YH!&\u00032B)qC!!\u0003B\"Q!1\u001dBC!\u0003\u0005\rA!:\u0002\u00135,'oZ3Gk:\u001c\u0007#C\u0007\u0003h\nE&\u0011\u0017BY\u0013\r\u0011IO\u0004\u0002\n\rVt7\r^5p]JBqAa\"\u0001\t\u0013\u0011i/\u0006\u0005\u0003p\nm8qCB\u0014)!\u0011\tpa\u000e\u0004:\r\u0015C\u0003FA`\u0005g\u0014ipa\u0001\u0004\n\r=1\u0011DB\u0010\u0007S\u0019\t\u0004\u0003\u0006\u0003v\n-\u0018\u0011!a\u0002\u0005o\f1\"\u001a<jI\u0016t7-\u001a\u00132sA1\u00111ZAi\u0005s\u0004B!a6\u0003|\u0012A\u00111\u001cBv\u0005\u0004\ti\u000e\u0003\u0006\u0003\u0000\n-\u0018\u0011!a\u0002\u0007\u0003\t1\"\u001a<jI\u0016t7-\u001a\u00133aA)q#a;\u0003z\"Q1Q\u0001Bv\u0003\u0003\u0005\u001daa\u0002\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$#'\r\t\u0007\u0003k\fyP!?\t\u0015\r-!1^A\u0001\u0002\b\u0019i!A\u0006fm&$WM\\2fII\u0012\u0004C\u0002B\u0005\u0005\u001f\u0011I\u0010\u0003\u0006\u0004\u0012\t-\u0018\u0011!a\u0002\u0007'\t1\"\u001a<jI\u0016t7-\u001a\u00133gA1\u00111ZAi\u0007+\u0001B!a6\u0004\u0018\u0011A!Q\u0004Bv\u0005\u0004\ti\u000e\u0003\u0006\u0004\u001c\t-\u0018\u0011!a\u0002\u0007;\t1\"\u001a<jI\u0016t7-\u001a\u00133iA1!\u0011\u0002B\b\u0007+A!b!\t\u0003l\u0006\u0005\t9AB\u0012\u0003-)g/\u001b3f]\u000e,GEM\u001b\u0011\r\u0005U\u0018q`B\u0013!\u0011\t9na\n\u0005\u0011\t=\"1\u001eb\u0001\u0003;D!ba\u000b\u0003l\u0006\u0005\t9AB\u0017\u0003-)g/\u001b3f]\u000e,GE\r\u001c\u0011\u0011\t]\"QHB\u0013\u0007_\u0001Ra\u0006B\"\u0005sD!ba\r\u0003l\u0006\u0005\t9AB\u001b\u0003-)g/\u001b3f]\u000e,GEM\u001c\u0011\r\t5#1KB\u0013\u0011\u001d\u0011IFa;A\u0002YA\u0001B!\u0018\u0003l\u0002\u000711\b\n\u0007\u0007{\u0019yda\u0011\u0007\r\t\r\u0004\u0001AB\u001e!\u0019\u00119G!\u001e\u0004BA9QBa\u001f\u0003z\u000eU\u0001#B\f\u0003\u0002\u000e\u0015\u0002\u0002\u0003Br\u0005W\u0004\raa\u0012\u0011\u000b5\t\u0019g!\u0013\u0011\u00135\u00119o!\u0006\u0004\u0016\rU\u0001bBB'\u0001\u0011E1qJ\u0001\u0007?^\u0014\u0018\u000e^3\u0016\u0011\rE3QLB:\u0007\u0007#\u0002ba\u0015\u0004\u000e\u000e=51\u0014\u000b\u0011\u0003\u007f\u001b)fa\u0018\u0004f\r-4QOB>\u0007\u000bC!ba\u0016\u0004L\u0005\u0005\t9AB-\u0003-)g/\u001b3f]\u000e,GE\r\u001d\u0011\r\u0005-\u0017\u0011[B.!\u0011\t9n!\u0018\u0005\u0011\u0005m71\nb\u0001\u0003;D!b!\u0019\u0004L\u0005\u0005\t9AB2\u0003-)g/\u001b3f]\u000e,GEM\u001d\u0011\r\u0005U\u0018q`B.\u0011)\u00199ga\u0013\u0002\u0002\u0003\u000f1\u0011N\u0001\fKZLG-\u001a8dK\u0012\u001a\u0004\u0007\u0005\u0004\u0003\n\t=11\f\u0005\u000b\u0007[\u001aY%!AA\u0004\r=\u0014aC3wS\u0012,gnY3%gE\u0002b!a3\u0002R\u000eE\u0004\u0003BAl\u0007g\"\u0001B!\b\u0004L\t\u0007\u0011Q\u001c\u0005\u000b\u0007o\u001aY%!AA\u0004\re\u0014aC3wS\u0012,gnY3%gI\u0002bA!\u0003\u0003\u0010\rE\u0004BCB?\u0007\u0017\n\t\u0011q\u0001\u0004\u0000\u0005YQM^5eK:\u001cW\rJ\u001a4!\u0019\t)0a@\u0004\u0002B!\u0011q[BB\t!\u0011yca\u0013C\u0002\u0005u\u0007BCBD\u0007\u0017\n\t\u0011q\u0001\u0004\n\u0006YQM^5eK:\u001cW\rJ\u001a5!!\u00119D!\u0010\u0004\u0002\u000e-\u0005#B\f\u0003D\rm\u0003b\u0002B-\u0007\u0017\u0002\rA\u0006\u0005\t\u0005;\u001aY\u00051\u0001\u0004\u0012J111SBK\u000733aAa\u0019\u0001\u0001\rE\u0005C\u0002B4\u0005k\u001a9\nE\u0004\u000e\u0005w\u001aYf!\u001d\u0011\u000b]\u0011\ti!!\t\u0011\ru51\na\u0001\u0007?\u000b\u0001b[3z\u0013:$W\r\u001f\t\u0007\u0007C\u001b9ka\u0017\u000e\u0005\r\r&bABS\t\u0005)\u0011N\u001c3fq&!1\u0011VBR\u0005!YU-_%oI\u0016D\bBCBW\u0001!\u0015\r\u0011\"\u0005\u00040\u00061An\\4hKJ,\"a!-\u0011\t\rM6\u0011Y\u0007\u0003\u0007kSAaa.\u0004:\u0006a1oY1mC2|wmZ5oO*!11XB_\u0003!!\u0018\u0010]3tC\u001a,'BAB`\u0003\r\u0019w.\\\u0005\u0005\u0007\u0007\u001c)L\u0001\u0004M_\u001e<WM\u001d\u0015\u0005\u0007W\u001b9\rE\u0002\u000e\u0007\u0013L1aa3\u000f\u0005%!(/\u00198tS\u0016tG\u000f")
public class AccumuloLayerWriter
implements LayerWriter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final AccumuloInstance instance;
    private final String table;
    private final Options options;
    private volatile transient boolean bitmap$trans$0;

    public static AccumuloLayerWriter apply(AccumuloInstance accumuloInstance, AttributeStore attributeStore, String string) {
        return AccumuloLayerWriter$.MODULE$.apply(accumuloInstance, attributeStore, string);
    }

    public static AccumuloLayerWriter apply(AccumuloInstance accumuloInstance, AttributeStore attributeStore, String string, Options options) {
        return AccumuloLayerWriter$.MODULE$.apply(accumuloInstance, attributeStore, string, options);
    }

    public static AccumuloLayerWriter apply(AccumuloInstance accumuloInstance, String string) {
        return AccumuloLayerWriter$.MODULE$.apply(accumuloInstance, string);
    }

    public static AccumuloLayerWriter apply(AccumuloInstance accumuloInstance, String string, Options options) {
        return AccumuloLayerWriter$.MODULE$.apply(accumuloInstance, string, options);
    }

    public <H, K, V, M> Option<LayerAttributes<H, M, K>> validateUpdate(LayerId id, M updateMetadata, JsonFormat<H> evidence$1, AvroRecordCodec<K> evidence$2, Boundable<K> evidence$3, JsonFormat<K> evidence$4, ClassTag<K> evidence$5, AvroRecordCodec<V> evidence$6, Component<M, Bounds<K>> evidence$7, Mergable<M> evidence$8, JsonFormat<M> evidence$9) {
        return LayerWriter.validateUpdate$((LayerWriter)this, (LayerId)id, updateMetadata, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9);
    }

    public void write(Object id, RDD layer, KeyIndex keyIndex, AvroRecordCodec evidence$35, JsonFormat evidence$36, ClassTag evidence$37, AvroRecordCodec evidence$38, ClassTag evidence$39, JsonFormat evidence$40, Component evidence$41) {
        LayerWriter.write$((LayerWriter)this, (Object)id, (RDD)layer, (KeyIndex)keyIndex, (AvroRecordCodec)evidence$35, (JsonFormat)evidence$36, (ClassTag)evidence$37, (AvroRecordCodec)evidence$38, (ClassTag)evidence$39, (JsonFormat)evidence$40, (Component)evidence$41);
    }

    public void write(Object id, RDD layer, KeyIndexMethod keyIndexMethod, AvroRecordCodec evidence$42, JsonFormat evidence$43, ClassTag evidence$44, AvroRecordCodec evidence$45, ClassTag evidence$46, JsonFormat evidence$47, Component evidence$48) {
        LayerWriter.write$((LayerWriter)this, (Object)id, (RDD)layer, (KeyIndexMethod)keyIndexMethod, (AvroRecordCodec)evidence$42, (JsonFormat)evidence$43, (ClassTag)evidence$44, (AvroRecordCodec)evidence$45, (ClassTag)evidence$46, (JsonFormat)evidence$47, (Component)evidence$48);
    }

    public <K, V, M> Writer<LayerId, RDD<Tuple2<K, V>>> writer(KeyIndexMethod<K> keyIndexMethod, AvroRecordCodec<K> evidence$49, JsonFormat<K> evidence$50, ClassTag<K> evidence$51, AvroRecordCodec<V> evidence$52, ClassTag<V> evidence$53, JsonFormat<M> evidence$54, Component<M, Bounds<K>> evidence$55) {
        return LayerWriter.writer$((LayerWriter)this, keyIndexMethod, evidence$49, evidence$50, evidence$51, evidence$52, evidence$53, evidence$54, evidence$55);
    }

    public <K, V, M> Writer<LayerId, RDD<Tuple2<K, V>>> writer(KeyIndex<K> keyIndex, AvroRecordCodec<K> evidence$56, JsonFormat<K> evidence$57, ClassTag<K> evidence$58, AvroRecordCodec<V> evidence$59, ClassTag<V> evidence$60, JsonFormat<M> evidence$61, Component<M, Bounds<K>> evidence$62) {
        return LayerWriter.writer$((LayerWriter)this, keyIndex, evidence$56, evidence$57, evidence$58, evidence$59, evidence$60, evidence$61, evidence$62);
    }

    public <K, V, M> Function2<V, V, V> update$default$3() {
        return LayerWriter.update$default$3$((LayerWriter)this);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        AccumuloLayerWriter accumuloLayerWriter = this;
        synchronized (accumuloLayerWriter) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public <K, V, M> void overwrite(LayerId id, RDD<Tuple2<K, V>> rdd, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, JsonFormat<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, JsonFormat<M> evidence$7, Component<M, Bounds<K>> evidence$8, Mergable<M> evidence$9) {
        this.update(id, rdd, (Option<Function2<V, V, V>>)None$.MODULE$, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9);
    }

    public <K, V, M> void update(LayerId id, RDD<Tuple2<K, V>> rdd, Function2<V, V, V> mergeFunc, AvroRecordCodec<K> evidence$10, Boundable<K> evidence$11, JsonFormat<K> evidence$12, ClassTag<K> evidence$13, AvroRecordCodec<V> evidence$14, ClassTag<V> evidence$15, JsonFormat<M> evidence$16, Component<M, Bounds<K>> evidence$17, Mergable<M> evidence$18) {
        this.update(id, rdd, (Option<Function2<V, V, V>>)new Some(mergeFunc), evidence$10, evidence$11, evidence$12, evidence$13, evidence$14, evidence$15, evidence$16, evidence$17, evidence$18);
    }

    private <K, V, M> void update(LayerId id, RDD<Tuple2<K, V>> rdd, Option<Function2<V, V, V>> mergeFunc, AvroRecordCodec<K> evidence$19, Boundable<K> evidence$20, JsonFormat<K> evidence$21, ClassTag<K> evidence$22, AvroRecordCodec<V> evidence$23, ClassTag<V> evidence$24, JsonFormat<M> evidence$25, Component<M, Bounds<K>> evidence$26, Mergable<M> evidence$27) {
        Some some;
        LayerAttributes layerAttributes;
        Option option = this.validateUpdate(id, (M)((Metadata)rdd).metadata(), (JsonFormat)AccumuloLayerHeader$AccumuloLayerMetadataFormat$.MODULE$, evidence$19, evidence$20, evidence$21, evidence$22, evidence$23, evidence$26, evidence$27, evidence$25);
        if (option instanceof Some && (layerAttributes = (LayerAttributes)(some = (Some)option).value()) != null) {
            BoxedUnit boxedUnit;
            AccumuloLayerHeader header = (AccumuloLayerHeader)layerAttributes.header();
            Object metadata = layerAttributes.metadata();
            KeyIndex keyIndex = layerAttributes.keyIndex();
            Schema writerSchema = layerAttributes.schema();
            String table = header.tileTable();
            Function1 & Serializable & scala.Serializable encodeKey = (Function1 & Serializable & scala.Serializable)key -> AccumuloKeyEncoder$.MODULE$.encode(id, key, keyIndex.toIndex(key));
            AccumuloWriteStrategy accumuloWriteStrategy = this.options.writeStrategy();
            if (accumuloWriteStrategy instanceof HdfsWriteStrategy) {
                throw new IllegalArgumentException("HDFS Write strategy not supported in updates");
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Writing updated for layer {} to table {}", new Object[]{id, table});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.attributeStore().writeLayerAttributes(id, (Object)header, metadata, keyIndex, writerSchema, (JsonFormat)AccumuloLayerHeader$AccumuloLayerMetadataFormat$.MODULE$, evidence$25, evidence$22);
            AccumuloRDDWriter$.MODULE$.update(rdd, this.instance, encodeKey, accumuloWriteStrategy, table, (Option<Schema>)new Some((Object)writerSchema), mergeFunc, evidence$19, evidence$23);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Skipping update with empty bounds for {}.", new Object[]{id});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
    }

    public <K, V, M> void _write(LayerId id, RDD<Tuple2<K, V>> rdd, KeyIndex<K> keyIndex, AvroRecordCodec<K> evidence$28, JsonFormat<K> evidence$29, ClassTag<K> evidence$30, AvroRecordCodec<V> evidence$31, ClassTag<V> evidence$32, JsonFormat<M> evidence$33, Component<M, Bounds<K>> evidence$34) {
        KeyValueRecordCodec codec = KeyValueRecordCodec$.MODULE$.apply(evidence$28, evidence$31);
        Schema schema = codec.schema();
        AccumuloLayerHeader header = new AccumuloLayerHeader(package$.MODULE$.classTag(evidence$30).toString(), package$.MODULE$.classTag(evidence$32).toString(), this.table, AccumuloLayerHeader$.MODULE$.apply$default$4());
        Object metadata = ((Metadata)rdd).metadata();
        Function1 & Serializable & scala.Serializable encodeKey = (Function1 & Serializable & scala.Serializable)key -> AccumuloKeyEncoder$.MODULE$.encode(id, key, keyIndex.toIndex(key));
        TableOperations ops = this.instance.connector().tableOperations();
        if (!ops.exists(this.table)) {
            ops.create(this.table);
            AccumuloUtils$.MODULE$.addSplits(this.table, this.instance, keyIndex.keyBounds(), keyIndex, rdd.partitions().length);
        }
        try {
            this.attributeStore().writeLayerAttributes(id, (Object)header, metadata, keyIndex, schema, (JsonFormat)AccumuloLayerHeader$AccumuloLayerMetadataFormat$.MODULE$, evidence$33, evidence$30);
            AccumuloRDDWriter$.MODULE$.write(rdd, this.instance, encodeKey, this.options.writeStrategy(), this.table, evidence$28, evidence$31);
            AccumuloKeyEncoder$.MODULE$.getLocalityGroups(id).foreach((Function1 & Serializable & scala.Serializable)lg -> {
                this.instance.makeLocalityGroup(this.table, lg);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new package.LayerWriteError(id, package.LayerWriteError$.MODULE$.$lessinit$greater$default$2()).initCause((Throwable)e);
        }
    }

    public AccumuloLayerWriter(AttributeStore attributeStore, AccumuloInstance instance, String table, Options options) {
        this.attributeStore = attributeStore;
        this.instance = instance;
        this.table = table;
        this.options = options;
        LayerWriter.$init$((LayerWriter)this);
    }

    public static class Options
    implements Product,
    scala.Serializable {
        private final AccumuloWriteStrategy writeStrategy;

        public AccumuloWriteStrategy writeStrategy() {
            return this.writeStrategy;
        }

        public Options copy(AccumuloWriteStrategy writeStrategy) {
            return new Options(writeStrategy);
        }

        public AccumuloWriteStrategy copy$default$1() {
            return this.writeStrategy();
        }

        public String productPrefix() {
            return "Options";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.writeStrategy();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Options;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Options)) return false;
            boolean bl = true;
            if (!bl) return false;
            Options options = (Options)x$1;
            AccumuloWriteStrategy accumuloWriteStrategy = this.writeStrategy();
            AccumuloWriteStrategy accumuloWriteStrategy2 = options.writeStrategy();
            if (accumuloWriteStrategy == null) {
                if (accumuloWriteStrategy2 != null) {
                    return false;
                }
            } else if (!accumuloWriteStrategy.equals(accumuloWriteStrategy2)) return false;
            if (!options.canEqual(this)) return false;
            return true;
        }

        public Options(AccumuloWriteStrategy writeStrategy) {
            this.writeStrategy = writeStrategy;
            Product.$init$((Product)this);
        }
    }
}

