/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.accumulo;

import geotrellis.spark.io.LayerWriter$;
import geotrellis.spark.io.accumulo.AccumuloInstance;
import geotrellis.spark.io.accumulo.AccumuloWriteStrategy;
import geotrellis.spark.io.avro.AvroEncoder$;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import java.io.Serializable;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.avro.Schema;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassTag$;

public final class AccumuloRDDWriter$ {
    public static AccumuloRDDWriter$ MODULE$;

    static {
        new AccumuloRDDWriter$();
    }

    public <K, V> void write(RDD<Tuple2<K, V>> raster, AccumuloInstance instance, Function1<K, Key> encodeKey, AccumuloWriteStrategy writeStrategy, String table, AvroRecordCodec<K> evidence$1, AvroRecordCodec<V> evidence$2) {
        this.update(raster, instance, encodeKey, writeStrategy, table, (Option<Schema>)None$.MODULE$, (Option<Function2<V, V, V>>)None$.MODULE$, evidence$1, evidence$2);
    }

    public <K, V> void update(RDD<Tuple2<K, V>> raster, AccumuloInstance instance, Function1<K, Key> encodeKey, AccumuloWriteStrategy writeStrategy, String table, Option<Schema> writerSchema, Option<Function2<V, V, V>> mergeFunc, AvroRecordCodec<K> evidence$3, AvroRecordCodec<V> evidence$4) {
        SparkContext sc = raster.sparkContext();
        KeyValueRecordCodec codec = KeyValueRecordCodec$.MODULE$.apply(evidence$3, evidence$4);
        Schema schema = codec.schema();
        instance.ensureTableExists(table);
        KryoWrapper kwWriterSchema = KryoWrapper$.MODULE$.apply(writerSchema, ClassTag$.MODULE$.apply(Option.class));
        RDD qual$1 = raster.groupBy((Function1 & Serializable & scala.Serializable)row -> (Key)encodeKey.apply(row._1()), raster.partitions().length, ClassTag$.MODULE$.apply(Key.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)it -> {
            Scanner scanner = instance.connector().createScanner(table, Authorizations.EMPTY);
            return it.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Key key = (Key)tuple2._1();
                Iterable _kvs1 = (Iterable)tuple2._2();
                Vector current = _kvs1.toVector();
                Vector updated = LayerWriter$.MODULE$.updateRecords(mergeFunc, current, (Function0 & Serializable & scala.Serializable)() -> {
                    scanner.setRange(new Range(key.getRow()));
                    scanner.fetchColumnFamily(key.getColumnFamily());
                    return (Vector)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).toVector().flatMap((Function1 & Serializable & scala.Serializable)entry -> {
                        Value value = (Value)entry.getValue();
                        return (Vector)AvroEncoder$.MODULE$.fromBinary((Schema)((Option)kwWriterSchema.value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> codec.schema()), value.get(), (AvroRecordCodec)codec);
                    }, Vector$.MODULE$.canBuildFrom());
                });
                Tuple2 tuple22 = new Tuple2((Object)key, (Object)new Value(AvroEncoder$.MODULE$.toBinary((Object)updated, (AvroRecordCodec)codec)));
                return tuple22;
            }).$plus$plus((Function0 & Serializable & scala.Serializable)() -> {
                scanner.close();
                return package$.MODULE$.Iterator().empty();
            });
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD kvPairs = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        writeStrategy.write((RDD<Tuple2<Key, Value>>)kvPairs, instance, table);
    }

    private AccumuloRDDWriter$() {
        MODULE$ = this;
    }
}

