/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.accumulo;

import geotrellis.spark.io.accumulo.AccumuloInstance;
import geotrellis.spark.io.accumulo.AccumuloWriteStrategy;
import geotrellis.spark.io.accumulo.HdfsWriteStrategy$;
import geotrellis.spark.io.hadoop.HdfsUtils$;
import java.io.IOException;
import java.util.UUID;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.mapreduce.AccumuloFileOutputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u0001.\u0011\u0011\u0003\u00133gg^\u0013\u0018\u000e^3TiJ\fG/Z4z\u0015\t\u0019A!\u0001\u0005bG\u000e,X.\u001e7p\u0015\t)a!\u0001\u0002j_*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0002\u0013\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M)\u0001\u0001\u0004\n\u00173A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003+\u0005\u001b7-^7vY><&/\u001b;f'R\u0014\u0018\r^3hsB\u0011QbF\u0005\u000319\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u000e5%\u00111D\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t;\u0001\u0011)\u001a!C\u0001=\u0005Q\u0011N\\4fgR\u0004\u0016\r\u001e5\u0016\u0003}\u0001\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u0005\u0019\u001c(B\u0001\u0013&\u0003\u0019A\u0017\rZ8pa*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0013\tQ\u0013E\u0001\u0003QCRD\u0007\u0002\u0003\u0017\u0001\u0005#\u0005\u000b\u0011B\u0010\u0002\u0017%tw-Z:u!\u0006$\b\u000e\t\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\n\u0004CA\n\u0001\u0011\u0015iR\u00061\u0001 \u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u00159(/\u001b;f)\u0011)\u0004\bU+\u0011\u000551\u0014BA\u001c\u000f\u0005\u0011)f.\u001b;\t\u000be\u0012\u0004\u0019\u0001\u001e\u0002\u000f-4\b+Y5sgB\u00191hP!\u000e\u0003qR!!\u0010 \u0002\u0007I$GM\u0003\u0002\bK%\u0011\u0001\t\u0010\u0002\u0004%\u0012#\u0005\u0003B\u0007C\t6K!a\u0011\b\u0003\rQ+\b\u000f\\33!\t)5*D\u0001G\u0015\t9\u0005*\u0001\u0003eCR\f'BA%K\u0003\u0011\u0019wN]3\u000b\u0005\r)\u0013B\u0001'G\u0005\rYU-\u001f\t\u0003\u000b:K!a\u0014$\u0003\u000bY\u000bG.^3\t\u000bE\u0013\u0004\u0019\u0001*\u0002\u0011%t7\u000f^1oG\u0016\u0004\"aE*\n\u0005Q\u0013!\u0001E!dGVlW\u000f\\8J]N$\u0018M\\2f\u0011\u00151&\u00071\u0001X\u0003\u0015!\u0018M\u00197f!\tAvL\u0004\u0002Z;B\u0011!LD\u0007\u00027*\u0011ALC\u0001\u0007yI|w\u000e\u001e \n\u0005ys\u0011A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!A\u0018\b\t\u000f\r\u0004\u0011\u0011!C\u0001I\u0006!1m\u001c9z)\t\u0001T\rC\u0004\u001eEB\u0005\t\u0019A\u0010\t\u000f\u001d\u0004\u0011\u0013!C\u0001Q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A5+\u0005}Q7&A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017!C;oG\",7m[3e\u0015\t\u0001h\"\u0001\u0006b]:|G/\u0019;j_:L!A]7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004u\u0001\u0005\u0005I\u0011I;\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u00051\bCA<}\u001b\u0005A(BA={\u0003\u0011a\u0017M\\4\u000b\u0003m\fAA[1wC&\u0011\u0001\r\u001f\u0005\b}\u0002\t\t\u0011\"\u0001\u0000\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0001E\u0002\u000e\u0003\u0007I1!!\u0002\u000f\u0005\rIe\u000e\u001e\u0005\n\u0003\u0013\u0001\u0011\u0011!C\u0001\u0003\u0017\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA\u0007\u0002\u0010%\u0019\u0011\u0011\u0003\b\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002\u0016\u0005\u001d\u0011\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00132\u0011%\tI\u0002AA\u0001\n\u0003\nY\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0002\u0005\u0004\u0002 \u0005\u0015\u0012QB\u0007\u0003\u0003CQ1!a\t\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\t\tC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tY\u0003AA\u0001\n\u0003\ti#\u0001\u0005dC:,\u0015/^1m)\u0011\ty#!\u000e\u0011\u00075\t\t$C\u0002\u000249\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002\u0016\u0005%\u0012\u0011!a\u0001\u0003\u001bA\u0011\"!\u000f\u0001\u0003\u0003%\t%a\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0001\t\u0013\u0005}\u0002!!A\u0005B\u0005\u0005\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003YD\u0011\"!\u0012\u0001\u0003\u0003%\t%a\u0012\u0002\r\u0015\fX/\u00197t)\u0011\ty#!\u0013\t\u0015\u0005U\u00111IA\u0001\u0002\u0004\tiaB\u0004\u0002N\tA\t!a\u0014\u0002#!#gm],sSR,7\u000b\u001e:bi\u0016<\u0017\u0010E\u0002\u0014\u0003#2a!\u0001\u0002\t\u0002\u0005M3\u0003BA)\u0019eAqALA)\t\u0003\t9\u0006\u0006\u0002\u0002P!A\u00111LA)\t\u0003\ti&A\u0003baBd\u0017\u0010F\u00021\u0003?Ba!HA-\u0001\u00049\u0006BCA.\u0003#\n\t\u0011\"!\u0002dQ\u0019\u0001'!\u001a\t\ru\t\t\u00071\u0001 \u0011)\tI'!\u0015\u0002\u0002\u0013\u0005\u00151N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti'a\u001d\u0011\t5\tygH\u0005\u0004\u0003cr!AB(qi&|g\u000eC\u0005\u0002v\u0005\u001d\u0014\u0011!a\u0001a\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005e\u0014\u0011KA\u0001\n\u0013\tY(A\u0006sK\u0006$'+Z:pYZ,GCAA?!\r9\u0018qP\u0005\u0004\u0003\u0003C(AB(cU\u0016\u001cG\u000f")
public class HdfsWriteStrategy
implements AccumuloWriteStrategy,
Product,
Serializable {
    private final Path ingestPath;

    public static Option<Path> unapply(HdfsWriteStrategy hdfsWriteStrategy) {
        return HdfsWriteStrategy$.MODULE$.unapply(hdfsWriteStrategy);
    }

    public static HdfsWriteStrategy apply(Path path) {
        return HdfsWriteStrategy$.MODULE$.apply(path);
    }

    public static HdfsWriteStrategy apply(String string) {
        return HdfsWriteStrategy$.MODULE$.apply(string);
    }

    public Path ingestPath() {
        return this.ingestPath;
    }

    @Override
    public void write(RDD<Tuple2<Key, Value>> kvPairs, AccumuloInstance instance, String table) {
        SparkContext sc = kvPairs.sparkContext();
        Job job = Job.getInstance((Configuration)sc.hadoopConfiguration());
        instance.setAccumuloConfig(job);
        Configuration conf = job.getConfiguration();
        Path outPath = HdfsUtils$.MODULE$.tmpPath(this.ingestPath(), UUID.randomUUID().toString(), conf);
        Path failuresPath = outPath.suffix("-failures");
        HdfsUtils$.MODULE$.ensurePathExists(failuresPath, conf);
        OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(kvPairs, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(Key.class), ClassTag$.MODULE$.apply(Value.class));
        boolean x$1 = qual$1.sortByKey$default$1();
        int x$2 = qual$1.sortByKey$default$2();
        RDD$.MODULE$.rddToPairRDDFunctions(qual$1.sortByKey(x$1, x$2), ClassTag$.MODULE$.apply(Key.class), ClassTag$.MODULE$.apply(Value.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsNewAPIHadoopFile(outPath.toString(), Key.class, Value.class, AccumuloFileOutputFormat.class, conf);
        TableOperations ops = instance.connector().tableOperations();
        ops.importDirectory(table, outPath.toString(), failuresPath.toString(), true);
        FileSystem fs = this.ingestPath().getFileSystem(conf);
        if (!fs.exists(new Path(outPath, "_SUCCESS"))) {
            throw new IOException(new StringBuilder(31).append("Accumulo bulk ingest failed at ").append(this.ingestPath()).toString());
        }
        fs.delete(outPath, true);
        fs.delete(failuresPath, true);
    }

    public HdfsWriteStrategy copy(Path ingestPath) {
        return new HdfsWriteStrategy(ingestPath);
    }

    public Path copy$default$1() {
        return this.ingestPath();
    }

    public String productPrefix() {
        return "HdfsWriteStrategy";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.ingestPath();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HdfsWriteStrategy;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HdfsWriteStrategy)) return false;
        boolean bl = true;
        if (!bl) return false;
        HdfsWriteStrategy hdfsWriteStrategy = (HdfsWriteStrategy)x$1;
        Path path = this.ingestPath();
        Path path2 = hdfsWriteStrategy.ingestPath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        if (!hdfsWriteStrategy.canEqual(this)) return false;
        return true;
    }

    public HdfsWriteStrategy(Path ingestPath) {
        this.ingestPath = ingestPath;
        Product.$init$((Product)this);
    }
}

