/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.accumulo;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import com.github.blemale.scaffeine.Cache;
import geotrellis.store.AttributeCaching;
import geotrellis.store.AttributeStore;
import geotrellis.store.COGLayerAttributes;
import geotrellis.store.DiscreteLayerAttributeStore;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.LayerId$;
import geotrellis.store.LayerType;
import geotrellis.store.accumulo.AccumuloAttributeStore$;
import geotrellis.store.accumulo.AccumuloInstance;
import geotrellis.store.accumulo.package$;
import geotrellis.store.cog.ZoomRange;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.avro.Schema;
import org.apache.hadoop.io.Text;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mx!\u0002\u000f\u001e\u0011\u0003!c!\u0002\u0014\u001e\u0011\u00039\u0003\"B\u0019\u0002\t\u0003\u0011\u0004\"B\u001a\u0002\t\u0003!\u0004BB\u001a\u0002\t\u0003\t\u0019\u000e\u0003\u00044\u0003\u0011\u0005\u0011q\u001b\u0005\u0007g\u0005!\t!!:\t\u0013\u0005%\u0018!!A\u0005\n\u0005-h\u0001\u0002\u0014\u001e\u0001YB\u0001b\u000f\u0005\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0015\"\u0011\t\u0011)A\u0005{!A1\n\u0003BC\u0002\u0013\u0005A\n\u0003\u0005Y\u0011\t\u0005\t\u0015!\u0003N\u0011\u0015\t\u0004\u0002\"\u0001Z\u0011\u001da\u0006B1A\u0005\u0002uCa!\u001a\u0005!\u0002\u0013q\u0006\"\u00024\t\t\u00039\u0007\"B;\t\t\u00131\bbBA\r\u0011\u0011%\u00111\u0004\u0005\b\u0003SAA\u0011AA\u0016\u0011\u001d\ti\u0006\u0003C\u0001\u0003?Bq!a\u001e\t\t\u0003\tI\bC\u0004\u0002\u0016\"!\t!a&\t\u000f\u0005e\u0001\u0002\"\u0001\u0002\"\"9\u0011\u0011\u0004\u0005\u0005\u0002\u0005\u0015\u0006bBAV\u0011\u0011\u0005\u0011Q\u0016\u0005\b\u0003kCA\u0011AA\\\u0011\u001d\ty\f\u0003C!\u0003\u0003\fa#Q2dk6,Hn\\!uiJL'-\u001e;f'R|'/\u001a\u0006\u0003=}\t\u0001\"Y2dk6,Hn\u001c\u0006\u0003A\u0005\nQa\u001d;pe\u0016T\u0011AI\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003K\u0005i\u0011!\b\u0002\u0017\u0003\u000e\u001cW/\\;m_\u0006#HO]5ckR,7\u000b^8sKN\u0019\u0011\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\tIs&\u0003\u00021U\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012\u0001J\u0001\u0006CB\u0004H.\u001f\u000b\u0006k\u0005=\u0017\u0011\u001b\t\u0003K!\u00192\u0001\u0003\u00158!\tA\u0014(D\u0001 \u0013\tQtDA\u000eESN\u001c'/\u001a;f\u0019\u0006LXM]!uiJL'-\u001e;f'R|'/Z\u0001\nG>tg.Z2u_J,\u0012!\u0010\t\u0003}!k\u0011a\u0010\u0006\u0003\u0001\u0006\u000baa\u00197jK:$(B\u0001\"D\u0003\u0011\u0019wN]3\u000b\u0005y!%BA#G\u0003\u0019\t\u0007/Y2iK*\tq)A\u0002pe\u001eL!!S \u0003\u0013\r{gN\\3di>\u0014\u0018AC2p]:,7\r^8sA\u0005q\u0011\r\u001e;sS\n,H/\u001a+bE2,W#A'\u0011\u00059+fBA(T!\t\u0001&&D\u0001R\u0015\t\u00116%\u0001\u0004=e>|GOP\u0005\u0003)*\na\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011AKK\u0001\u0010CR$(/\u001b2vi\u0016$\u0016M\u00197fAQ\u0019QGW.\t\u000bmj\u0001\u0019A\u001f\t\u000b-k\u0001\u0019A'\u0002\u0007M+\u0005+F\u0001_!\tyF-D\u0001a\u0015\t\t'-\u0001\u0003mC:<'\"A2\u0002\t)\fg/Y\u0005\u0003-\u0002\fAaU#QA\u0005YA.Y=fe&#G+\u001a=u)\tA\u0007\u000f\u0005\u0002j]6\t!N\u0003\u0002lY\u0006\u0011\u0011n\u001c\u0006\u0003[\u0012\u000ba\u0001[1e_>\u0004\u0018BA8k\u0005\u0011!V\r\u001f;\t\u000bE\u0004\u0002\u0019\u0001:\u0002\u000f1\f\u00170\u001a:JIB\u0011\u0001h]\u0005\u0003i~\u0011q\u0001T1zKJLE-A\u0003gKR\u001c\u0007\u000eF\u0003x\u0003\u001b\t)\u0002\u0005\u0003y{\u0006\u0005aBA=|\u001d\t\u0001&0C\u0001,\u0013\ta(&A\u0004qC\u000e\\\u0017mZ3\n\u0005y|(\u0001C%uKJ\fGo\u001c:\u000b\u0005qT\u0003\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0011)\u0001\u0003eCR\f\u0017\u0002BA\u0006\u0003\u000b\u0011QAV1mk\u0016Da!]\tA\u0002\u0005=\u0001\u0003B\u0015\u0002\u0012IL1!a\u0005+\u0005\u0019y\u0005\u000f^5p]\"1\u0011qC\tA\u00025\u000bQ\"\u0019;ue&\u0014W\u000f^3OC6,\u0017A\u00023fY\u0016$X\r\u0006\u0004\u0002\u001e\u0005\r\u0012Q\u0005\t\u0004S\u0005}\u0011bAA\u0011U\t!QK\\5u\u0011\u0015\t(\u00031\u0001s\u0011\u001d\t9B\u0005a\u0001\u0003O\u0001B!KA\t\u001b\u0006!!/Z1e+\u0011\ti#!\u000e\u0015\r\u0005=\u0012\u0011LA.)\u0011\t\t$a\u0012\u0011\t\u0005M\u0012Q\u0007\u0007\u0001\t\u001d\t9d\u0005b\u0001\u0003s\u0011\u0011\u0001V\t\u0005\u0003w\t\t\u0005E\u0002*\u0003{I1!a\u0010+\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!KA\"\u0013\r\t)E\u000b\u0002\u0004\u0003:L\b\"CA%'\u0005\u0005\t9AA&\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003\u001b\n)&!\r\u000e\u0005\u0005=#\u0002BA)\u0003'\nQaY5sG\u0016T\u0011a[\u0005\u0005\u0003/\nyEA\u0004EK\u000e|G-\u001a:\t\u000bE\u001c\u0002\u0019\u0001:\t\r\u0005]1\u00031\u0001N\u0003\u001d\u0011X-\u00193BY2,B!!\u0019\u0002nQ!\u00111MA;)\u0011\t)'a\u001c\u0011\r9\u000b9G]A6\u0013\r\tIg\u0016\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u001a\u0003[\"q!a\u000e\u0015\u0005\u0004\tI\u0004C\u0005\u0002rQ\t\t\u0011q\u0001\u0002t\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\u00055\u0013QKA6\u0011\u0019\t9\u0002\u0006a\u0001\u001b\u0006)qO]5uKV!\u00111PAF)!\ti(!$\u0002\u0010\u0006EE\u0003BA\u000f\u0003\u007fB\u0011\"!!\u0016\u0003\u0003\u0005\u001d!a!\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0004\u0002N\u0005\u0015\u0015\u0011R\u0005\u0005\u0003\u000f\u000byEA\u0004F]\u000e|G-\u001a:\u0011\t\u0005M\u00121\u0012\u0003\b\u0003o)\"\u0019AA\u001d\u0011\u0015\tX\u00031\u0001s\u0011\u0019\t9\"\u0006a\u0001\u001b\"9\u00111S\u000bA\u0002\u0005%\u0015!\u0002<bYV,\u0017a\u00037bs\u0016\u0014X\t_5tiN$B!!'\u0002 B\u0019\u0011&a'\n\u0007\u0005u%FA\u0004C_>dW-\u00198\t\u000bE4\u0002\u0019\u0001:\u0015\t\u0005u\u00111\u0015\u0005\u0006c^\u0001\rA\u001d\u000b\u0007\u0003;\t9+!+\t\u000bED\u0002\u0019\u0001:\t\r\u0005]\u0001\u00041\u0001N\u0003!a\u0017-_3s\u0013\u0012\u001cXCAAX!\u0011A\u0018\u0011\u0017:\n\u0007\u0005MvPA\u0002TKF\f1#\u0019<bS2\f'\r\\3BiR\u0014\u0018NY;uKN$B!!/\u0002<B!\u00010!-N\u0011\u0019\tiL\u0007a\u0001e\u0006\u0011\u0011\u000eZ\u0001\u0014CZ\f\u0017\u000e\\1cY\u0016Tvn\\7MKZ,Gn\u001d\u000b\u0005\u0003\u0007\fY\rE\u0003y\u0003c\u000b)\rE\u0002*\u0003\u000fL1!!3+\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u001b\\\u0002\u0019A'\u0002\u00131\f\u00170\u001a:OC6,\u0007\"B\u001e\u0004\u0001\u0004i\u0004\"B&\u0004\u0001\u0004iEcA\u001b\u0002V\")1\b\u0002a\u0001{Q)Q'!7\u0002d\"9\u00111\\\u0003A\u0002\u0005u\u0017\u0001C5ogR\fgnY3\u0011\u0007\u0015\ny.C\u0002\u0002bv\u0011\u0001#Q2dk6,Hn\\%ogR\fgnY3\t\u000b-+\u0001\u0019A'\u0015\u0007U\n9\u000fC\u0004\u0002\\\u001a\u0001\r!!8\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u00042aXAx\u0013\r\t\t\u0010\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class AccumuloAttributeStore
implements DiscreteLayerAttributeStore {
    private final Connector connector;
    private final String attributeTable;
    private final String SEP;
    private transient Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache;
    private volatile transient boolean bitmap$trans$0;

    public static AccumuloAttributeStore apply(AccumuloInstance accumuloInstance) {
        return AccumuloAttributeStore$.MODULE$.apply(accumuloInstance);
    }

    public static AccumuloAttributeStore apply(AccumuloInstance accumuloInstance, String string) {
        return AccumuloAttributeStore$.MODULE$.apply(accumuloInstance, string);
    }

    public static AccumuloAttributeStore apply(Connector connector) {
        return AccumuloAttributeStore$.MODULE$.apply(connector);
    }

    public static AccumuloAttributeStore apply(Connector connector, String string) {
        return AccumuloAttributeStore$.MODULE$.apply(connector, string);
    }

    public <K> Map<ZoomRange, KeyIndex<K>> readKeyIndexes(LayerId id, ClassTag<K> evidence$32) {
        return DiscreteLayerAttributeStore.readKeyIndexes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$32);
    }

    public <H> H readHeader(LayerId id, Decoder<H> evidence$33) {
        return (H)DiscreteLayerAttributeStore.readHeader$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$33);
    }

    public <M> M readMetadata(LayerId id, Decoder<M> evidence$34) {
        return (M)DiscreteLayerAttributeStore.readMetadata$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$34);
    }

    public <K> KeyIndex<K> readKeyIndex(LayerId id, ClassTag<K> evidence$35) {
        return DiscreteLayerAttributeStore.readKeyIndex$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$35);
    }

    public Schema readSchema(LayerId id) {
        return DiscreteLayerAttributeStore.readSchema$((DiscreteLayerAttributeStore)this, (LayerId)id);
    }

    public <H, M, K> LayerAttributes<H, M, K> readLayerAttributes(LayerId id, Decoder<H> evidence$36, Decoder<M> evidence$37, ClassTag<K> evidence$38) {
        return DiscreteLayerAttributeStore.readLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$36, evidence$37, evidence$38);
    }

    public <H, M, K> void writeLayerAttributes(LayerId id, H header, M metadata, KeyIndex<K> keyIndex, Schema schema, Encoder<H> evidence$39, Encoder<M> evidence$40, ClassTag<K> evidence$41) {
        DiscreteLayerAttributeStore.writeLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, header, metadata, keyIndex, (Schema)schema, evidence$39, evidence$40, evidence$41);
    }

    public <H, M> COGLayerAttributes<H, M> readCOGLayerAttributes(LayerId id, Decoder<H> evidence$42, Decoder<M> evidence$43) {
        return DiscreteLayerAttributeStore.readCOGLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$42, evidence$43);
    }

    public <H, M> void writeCOGLayerAttributes(LayerId id, H header, M metadata, Encoder<H> evidence$44, Encoder<M> evidence$45) {
        DiscreteLayerAttributeStore.writeCOGLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, header, metadata, evidence$44, evidence$45);
    }

    public boolean isCOGLayer(LayerId id) {
        return AttributeStore.isCOGLayer$((AttributeStore)this, (LayerId)id);
    }

    public LayerType layerType(LayerId id) {
        return AttributeStore.layerType$((AttributeStore)this, (LayerId)id);
    }

    public Map<String, Seq<Object>> layersWithZoomLevels() {
        return AttributeStore.layersWithZoomLevels$((AttributeStore)this);
    }

    public void copy(LayerId from, LayerId to) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to);
    }

    public void copy(LayerId from, LayerId to, Seq<String> attributes) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to, attributes);
    }

    public <T> T cacheRead(LayerId layerId, String attributeName, Decoder<T> evidence$1) {
        return (T)AttributeCaching.cacheRead$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, evidence$1);
    }

    public LayerType cacheLayerType(LayerId layerId, LayerType layerType) {
        return AttributeCaching.cacheLayerType$((AttributeCaching)this, (LayerId)layerId, (LayerType)layerType);
    }

    public <T> void cacheWrite(LayerId layerId, String attributeName, T value, Encoder<T> evidence$2) {
        AttributeCaching.cacheWrite$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, value, evidence$2);
    }

    public void clearCache() {
        AttributeCaching.clearCache$((AttributeCaching)this);
    }

    public void clearCache(LayerId id) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id);
    }

    public void clearCache(LayerId id, String attribute) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id, (String)attribute);
    }

    private Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache$lzycompute() {
        AccumuloAttributeStore accumuloAttributeStore = this;
        synchronized (accumuloAttributeStore) {
            if (!this.bitmap$trans$0) {
                this.geotrellis$store$AttributeCaching$$cache = AttributeCaching.geotrellis$store$AttributeCaching$$cache$((AttributeCaching)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.geotrellis$store$AttributeCaching$$cache;
    }

    public Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache() {
        if (!this.bitmap$trans$0) {
            return this.geotrellis$store$AttributeCaching$$cache$lzycompute();
        }
        return this.geotrellis$store$AttributeCaching$$cache;
    }

    public Connector connector() {
        return this.connector;
    }

    public String attributeTable() {
        return this.attributeTable;
    }

    public String SEP() {
        return this.SEP;
    }

    public Text layerIdText(LayerId layerId) {
        return package$.MODULE$.stringToText(new StringBuilder(0).append(layerId.name()).append(this.SEP()).append(layerId.zoom()).toString());
    }

    private Iterator<Value> fetch(Option<LayerId> layerId, String attributeName) {
        Iterator iterator;
        try (Scanner scanner = this.connector().createScanner(this.attributeTable(), new Authorizations());){
            layerId.foreach((Function1 & Serializable & scala.Serializable)id -> {
                scanner.setRange(new Range(this.layerIdText(id)));
                return BoxedUnit.UNIT;
            });
            scanner.fetchColumnFamily(new Text(attributeName));
            iterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Value)x$1.getValue());
        }
        return iterator;
    }

    private void delete(LayerId layerId, Option<String> attributeName) {
        block5: {
            int numThreads = 1;
            BatchWriterConfig config = new BatchWriterConfig();
            config.setMaxWriteThreads(numThreads);
            try (BatchDeleter deleter = this.connector().createBatchDeleter(this.attributeTable(), new Authorizations(), numThreads, config);){
                deleter.setRanges((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Range(this.layerIdText(layerId)), (List)Nil$.MODULE$)).asJava());
                attributeName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                    deleter.fetchColumnFamily(new Text(name));
                    return BoxedUnit.UNIT;
                });
                deleter.delete();
                Option<String> option = attributeName;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String attribute = (String)some.value();
                    this.clearCache(layerId, attribute);
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    this.clearCache(layerId);
                    break block5;
                }
                throw new MatchError(option);
            }
        }
    }

    public <T> T read(LayerId layerId, String attributeName, Decoder<T> evidence$1) {
        Vector values = this.fetch((Option<LayerId>)new Some((Object)layerId), attributeName).toVector();
        if (values.isEmpty()) {
            throw new package.AttributeNotFoundError(attributeName, layerId);
        }
        if (values.size() > 1) {
            throw new package.LayerIOError(new StringBuilder(41).append("Multiple attributes found for ").append(attributeName).append(" for layer ").append(layerId).toString());
        }
        return (T)((Tuple2)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(((Value)values.head()).toString()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.as(Decoder$.MODULE$.decodeTuple2((Decoder)LayerId$.MODULE$.codecForLayerId(), evidence$1)))), (Function1 & Serializable & scala.Serializable)x$3 -> {
            throw x$3;
        }))._2();
    }

    public <T> Map<LayerId, T> readAll(String attributeName, Decoder<T> evidence$2) {
        return this.fetch((Option<LayerId>)None$.MODULE$, attributeName).map((Function1 & Serializable & scala.Serializable)r -> (Tuple2)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(r.toString()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.as(Decoder$.MODULE$.decodeTuple2((Decoder)LayerId$.MODULE$.codecForLayerId(), evidence$2)))), (Function1 & Serializable & scala.Serializable)x$5 -> {
            throw x$5;
        })).toMap(Predef$.MODULE$.$conforms());
    }

    public <T> void write(LayerId layerId, String attributeName, T value, Encoder<T> evidence$3) {
        Mutation mutation = new Mutation(this.layerIdText(layerId));
        mutation.put(new Text(attributeName), new Text(), System.currentTimeMillis(), new Value(package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)new Tuple2((Object)layerId, value)), (Encoder)Encoder$.MODULE$.encodeTuple2((Encoder)LayerId$.MODULE$.codecForLayerId(), evidence$3)).noSpaces().getBytes()));
        package$.MODULE$.connectorWriter(this.connector()).write(this.attributeTable(), mutation);
    }

    public boolean layerExists(LayerId layerId) {
        return this.fetch((Option<LayerId>)new Some((Object)layerId), AttributeStore.Fields$.MODULE$.metadata()).nonEmpty();
    }

    public void delete(LayerId layerId) {
        this.delete(layerId, (Option<String>)None$.MODULE$);
    }

    public void delete(LayerId layerId, String attributeName) {
        this.delete(layerId, (Option<String>)new Some((Object)attributeName));
    }

    public Seq<LayerId> layerIds() {
        Seq seq;
        try (Scanner scanner = this.connector().createScanner(this.attributeTable(), new Authorizations());){
            seq = (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> {
                String[] stringArray = ((Key)kv.getKey()).getRow().toString().split(this.SEP());
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String name = (String)((SeqLike)option.get()).apply(0);
                String zoomStr = (String)((SeqLike)option.get()).apply(1);
                Tuple2 tuple2 = new Tuple2((Object)name, (Object)zoomStr);
                String name2 = (String)tuple2._1();
                String zoomStr2 = (String)tuple2._2();
                return new LayerId(name2, new StringOps(Predef$.MODULE$.augmentString(zoomStr2)).toInt());
            }).toList().distinct();
        }
        return seq;
    }

    public Seq<String> availableAttributes(LayerId id) {
        Vector vector;
        try (Scanner scanner = this.connector().createScanner(this.attributeTable(), new Authorizations());){
            scanner.setRange(new Range(this.layerIdText(id)));
            vector = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> ((Key)x$7.getKey()).getColumnFamily().toString()).toVector();
        }
        return vector;
    }

    public Seq<Object> availableZoomLevels(String layerName) {
        Seq seq;
        try (Scanner scanner = this.connector().createScanner(this.attributeTable(), new Authorizations());){
            IteratorSetting iter = new IteratorSetting(15, "AttributeStoreLayerNameFilter", RegExFilter.class);
            RegExFilter.setRegexs((IteratorSetting)iter, (String)new StringBuilder(2).append(layerName).append(this.SEP()).append(".*").toString(), null, null, null, (boolean)false);
            scanner.addScanIterator(iter);
            seq = (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToInteger((int)AccumuloAttributeStore.$anonfun$availableZoomLevels$1(this, kv))).toList().distinct();
        }
        return seq;
    }

    public static final /* synthetic */ int $anonfun$availableZoomLevels$1(AccumuloAttributeStore $this, Map.Entry kv) {
        String[] stringArray = ((Key)kv.getKey()).getRow().toString().split($this.SEP());
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String zoomStr = (String)((SeqLike)option.get()).apply(1);
        String zoomStr2 = zoomStr;
        return new StringOps(Predef$.MODULE$.augmentString(zoomStr2)).toInt();
    }

    public AccumuloAttributeStore(Connector connector, String attributeTable) {
        this.connector = connector;
        this.attributeTable = attributeTable;
        AttributeCaching.$init$((AttributeCaching)this);
        AttributeStore.$init$((AttributeStore)this);
        DiscreteLayerAttributeStore.$init$((DiscreteLayerAttributeStore)this);
        TableOperations ops = connector.tableOperations();
        if (!ops.exists(attributeTable)) {
            ops.create(attributeTable);
        }
        this.SEP = "__.__";
    }
}

