/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.accumulo;

import geotrellis.store.AttributeStore;
import geotrellis.store.LayerDeleter;
import geotrellis.store.LayerId;
import geotrellis.store.accumulo.AccumuloAttributeStore;
import geotrellis.store.accumulo.AccumuloInstance;
import geotrellis.store.accumulo.AccumuloLayerDeleter$;
import geotrellis.store.accumulo.AccumuloLayerHeader;
import geotrellis.store.accumulo.AccumuloLayerHeader$;
import geotrellis.store.accumulo.package$;
import geotrellis.store.package;
import java.util.Collection;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4AAD\b\u0001-!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003'\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\"\u0002\u001d\u0001\t\u0003I\u0004\"\u0002 \u0001\t\u0003y\u0004\u0002C#\u0001\u0011\u000b\u0007K\u0011\u0002$\b\u000bE{\u0001\u0012\u0001*\u0007\u000b9y\u0001\u0012A*\t\u000baBA\u0011\u0001+\t\u000bUCA\u0011\u0001,\t\u000bUCA\u0011A-\t\u000bUCA\u0011\u00011\t\u000bUCA\u0011A3\u0003)\u0005\u001b7-^7vY>d\u0015-_3s\t\u0016dW\r^3s\u0015\t\u0001\u0012#\u0001\u0005bG\u000e,X.\u001e7p\u0015\t\u00112#A\u0003ti>\u0014XMC\u0001\u0015\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0007yy\u0012%D\u0001\u0012\u0013\t\u0001\u0013C\u0001\u0007MCf,'\u000fR3mKR,'\u000f\u0005\u0002\u001fE%\u00111%\u0005\u0002\b\u0019\u0006LXM]%e\u00039\tG\u000f\u001e:jEV$Xm\u0015;pe\u0016,\u0012A\n\t\u0003=\u001dJ!\u0001K\t\u0003\u001d\u0005#HO]5ckR,7\u000b^8sK\u0006y\u0011\r\u001e;sS\n,H/Z*u_J,\u0007%A\u0005d_:tWm\u0019;peB\u0011AFN\u0007\u0002[)\u0011afL\u0001\u0007G2LWM\u001c;\u000b\u0005A\n\u0014\u0001B2pe\u0016T!\u0001\u0005\u001a\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0005\u0003o5\u0012\u0011bQ8o]\u0016\u001cGo\u001c:\u0002\rqJg.\u001b;?)\rQD(\u0010\t\u0003w\u0001i\u0011a\u0004\u0005\u0006I\u0011\u0001\rA\n\u0005\u0006U\u0011\u0001\raK\u0001\u0007I\u0016dW\r^3\u0015\u0005\u0001\u001b\u0005C\u0001\rB\u0013\t\u0011\u0015D\u0001\u0003V]&$\b\"\u0002#\u0006\u0001\u0004\t\u0013AA5e\u0003\u0019awnZ4feV\tq\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002Ki\u0005)An\\45g&\u0011A*\u0013\u0002\u0007\u0019><w-\u001a:)\u0005\u0019q\u0005C\u0001\rP\u0013\t\u0001\u0016DA\u0005ue\u0006t7/[3oi\u0006!\u0012iY2v[Vdw\u000eT1zKJ$U\r\\3uKJ\u0004\"a\u000f\u0005\u0014\u0005!9B#\u0001*\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007i:\u0006\fC\u0003%\u0015\u0001\u0007a\u0005C\u0003+\u0015\u0001\u00071\u0006F\u0002;5nCQ\u0001J\u0006A\u0002\u0019BQ\u0001X\u0006A\u0002u\u000b\u0001\"\u001b8ti\u0006t7-\u001a\t\u0003wyK!aX\b\u0003!\u0005\u001b7-^7vY>Len\u001d;b]\u000e,GC\u0001\u001eb\u0011\u0015!C\u00021\u0001c!\tY4-\u0003\u0002e\u001f\t1\u0012iY2v[Vdw.\u0011;ue&\u0014W\u000f^3Ti>\u0014X\r\u0006\u0002;M\")A,\u0004a\u0001;\u0002")
public class AccumuloLayerDeleter
implements LayerDeleter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final Connector connector;
    private volatile transient boolean bitmap$trans$0;

    public static AccumuloLayerDeleter apply(AccumuloInstance accumuloInstance) {
        return AccumuloLayerDeleter$.MODULE$.apply(accumuloInstance);
    }

    public static AccumuloLayerDeleter apply(AccumuloAttributeStore accumuloAttributeStore) {
        return AccumuloLayerDeleter$.MODULE$.apply(accumuloAttributeStore);
    }

    public static AccumuloLayerDeleter apply(AttributeStore attributeStore, AccumuloInstance accumuloInstance) {
        return AccumuloLayerDeleter$.MODULE$.apply(attributeStore, accumuloInstance);
    }

    public static AccumuloLayerDeleter apply(AttributeStore attributeStore, Connector connector) {
        return AccumuloLayerDeleter$.MODULE$.apply(attributeStore, connector);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        AccumuloLayerDeleter accumuloLayerDeleter = this;
        synchronized (accumuloLayerDeleter) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(AccumuloLayerDeleter.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void delete(LayerId id) {
        try {
            try {
                AccumuloLayerHeader header = (AccumuloLayerHeader)this.attributeStore().readHeader(id, AccumuloLayerHeader$.MODULE$.accumuloLayerHeaderDecoder());
                int numThreads = 1;
                BatchWriterConfig config = new BatchWriterConfig();
                config.setMaxWriteThreads(numThreads);
                try (BatchDeleter deleter = this.connector.createBatchDeleter(header.tileTable(), new Authorizations(), numThreads, config);){
                    deleter.fetchColumnFamily(package$.MODULE$.stringToText(package$.MODULE$.columnFamily(id)));
                    deleter.setRanges((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Range(), (List)Nil$.MODULE$)).asJava());
                    deleter.delete();
                }
            }
            catch (package.AttributeNotFoundError e) {
                if (this.logger().isInfoEnabled()) {
                    this.logger().info(new StringBuilder(92).append("Metadata for ").append(id).append(" was not found. Any associated layer data (if any) will require manual deletion").toString());
                }
                throw new package.LayerDeleteError(id).initCause((Throwable)e);
            }
        }
        finally {
            this.attributeStore().delete(id);
        }
    }

    public AccumuloLayerDeleter(AttributeStore attributeStore, Connector connector) {
        this.attributeStore = attributeStore;
        this.connector = connector;
    }
}

