/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import geotrellis.store.cassandra.BaseCassandraInstance;
import geotrellis.store.cassandra.conf.CassandraConfig;
import geotrellis.store.cassandra.conf.CassandraConfig$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class BaseCassandraInstance$
implements Serializable {
    public static BaseCassandraInstance$ MODULE$;

    static {
        new BaseCassandraInstance$();
    }

    public BaseCassandraInstance apply(Function0<Cluster> getCluster) {
        return new BaseCassandraInstance(getCluster, CassandraConfig$.MODULE$.cassandraConfigToClass(CassandraConfig$.MODULE$));
    }

    public BaseCassandraInstance apply(Seq<String> hosts, String username, String password, CassandraConfig cassandraConfig) {
        return new BaseCassandraInstance((Function0<Cluster>)BaseCassandraInstance$.getCluster$1(hosts, cassandraConfig, username, password), cassandraConfig);
    }

    public BaseCassandraInstance apply(Seq<String> hosts, String username, String password) {
        return this.apply(hosts, username, password, CassandraConfig$.MODULE$.cassandraConfigToClass(CassandraConfig$.MODULE$));
    }

    public BaseCassandraInstance apply(Seq<String> hosts, CassandraConfig cassandraConfig) {
        return this.apply(hosts, "", "", cassandraConfig);
    }

    public BaseCassandraInstance apply(Seq<String> hosts) {
        return this.apply(hosts, CassandraConfig$.MODULE$.cassandraConfigToClass(CassandraConfig$.MODULE$));
    }

    public BaseCassandraInstance apply(Function0<Cluster> getCluster, CassandraConfig cassandraConfig) {
        return new BaseCassandraInstance(getCluster, cassandraConfig);
    }

    public Option<Tuple2<Function0<Cluster>, CassandraConfig>> unapply(BaseCassandraInstance x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.getCluster(), (Object)x$0.cassandraConfig()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final TokenAwarePolicy getLoadBalancingPolicy$1(CassandraConfig cassandraConfig$1) {
        DCAwareRoundRobinPolicy.Builder builder = DCAwareRoundRobinPolicy.builder();
        Object object = new StringOps(Predef$.MODULE$.augmentString(cassandraConfig$1.localDc())).nonEmpty() ? builder.withLocalDc(cassandraConfig$1.localDc()) : BoxedUnit.UNIT;
        Object object2 = cassandraConfig$1.usedHostsPerRemoteDc() > 0 ? builder.withUsedHostsPerRemoteDc(cassandraConfig$1.usedHostsPerRemoteDc()) : BoxedUnit.UNIT;
        Object object3 = cassandraConfig$1.allowRemoteDcsForLocalConsistencyLevel() ? builder.allowRemoteDCsForLocalConsistencyLevel() : BoxedUnit.UNIT;
        return new TokenAwarePolicy((LoadBalancingPolicy)builder.build());
    }

    private static final Function0 getCluster$1(Seq hosts$1, CassandraConfig cassandraConfig$1, String username$1, String password$1) {
        return (Function0 & java.io.Serializable & Serializable)() -> {
            Cluster.Builder builder = Cluster.builder().withoutJMXReporting().withLoadBalancingPolicy((LoadBalancingPolicy)BaseCassandraInstance$.getLoadBalancingPolicy$1(cassandraConfig$1)).addContactPoints((String[])hosts$1.toArray(ClassTag$.MODULE$.apply(String.class))).withPort(cassandraConfig$1.port()).withCredentials(username$1, password$1);
            Cluster.Builder authedBuilder = new StringOps(Predef$.MODULE$.augmentString(username$1)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(password$1)).nonEmpty() ? builder.withCredentials(username$1, password$1) : builder;
            return authedBuilder.build();
        };
    }

    private BaseCassandraInstance$() {
        MODULE$ = this;
    }
}

