/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.cassandra;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.github.blemale.scaffeine.Cache;
import geotrellis.store.AttributeCaching;
import geotrellis.store.AttributeStore;
import geotrellis.store.COGLayerAttributes;
import geotrellis.store.DiscreteLayerAttributeStore;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.LayerId$;
import geotrellis.store.LayerType;
import geotrellis.store.cassandra.CassandraAttributeStore$;
import geotrellis.store.cassandra.CassandraInstance;
import geotrellis.store.cog.ZoomRange;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.Serializable;
import org.apache.avro.Schema;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uv!B\r\u001b\u0011\u0003\tc!B\u0012\u001b\u0011\u0003!\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004B\u0002\u0019\u0002\t\u0003\ti\nC\u0005\u0002\"\u0006\t\t\u0011\"\u0003\u0002$\u001a!1E\u0007\u00014\u0011!AdA!b\u0001\n\u0003I\u0004\u0002C\u001f\u0007\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y2!Q1A\u0005\u0002}B\u0001b\u0013\u0004\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0019\u001a\u0011)\u0019!C\u0001\u007f!AQJ\u0002B\u0001B\u0003%\u0001\tC\u0003/\r\u0011\u0005a\nC\u0003S\r\u0011%1\u000bC\u0003k\r\u0011%1\u000eC\u0003s\r\u0011\u00051\u000fC\u0004\u0002\u001c\u0019!\t!!\b\t\u000f\u0005Ub\u0001\"\u0001\u00028!9\u00111\u000b\u0004\u0005\u0002\u0005U\u0003B\u00026\u0007\t\u0003\ty\u0006\u0003\u0004k\r\u0011\u0005\u00111\r\u0005\b\u0003S2A\u0011AA6\u0011\u001d\tyH\u0002C\u0001\u0003\u0003Cq!a\"\u0007\t\u0003\nI)A\fDCN\u001c\u0018M\u001c3sC\u0006#HO]5ckR,7\u000b^8sK*\u00111\u0004H\u0001\nG\u0006\u001c8/\u00198ee\u0006T!!\b\u0010\u0002\u000bM$xN]3\u000b\u0003}\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0001\"AI\u0001\u000e\u0003i\u0011qcQ1tg\u0006tGM]1BiR\u0014\u0018NY;uKN#xN]3\u0014\u0007\u0005)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003M1J!!L\u0014\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005\t\u0013!B1qa2LHc\u0002\u001a\u0002\u0018\u0006e\u00151\u0014\t\u0003E\u0019\u00192AB\u00135!\t)d'D\u0001\u001d\u0013\t9DDA\u000eESN\u001c'/\u001a;f\u0019\u0006LXM]!uiJL'-\u001e;f'R|'/Z\u0001\tS:\u001cH/\u00198dKV\t!\b\u0005\u0002#w%\u0011AH\u0007\u0002\u0012\u0007\u0006\u001c8/\u00198ee\u0006Len\u001d;b]\u000e,\u0017!C5ogR\fgnY3!\u0003E\tG\u000f\u001e:jEV$XmS3zgB\f7-Z\u000b\u0002\u0001B\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"aQ\u0014\u000e\u0003\u0011S!!\u0012\u0011\u0002\rq\u0012xn\u001c;?\u0013\t9u%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$(\u0003I\tG\u000f\u001e:jEV$XmS3zgB\f7-\u001a\u0011\u0002\u001d\u0005$HO]5ckR,G+\u00192mK\u0006y\u0011\r\u001e;sS\n,H/\u001a+bE2,\u0007\u0005\u0006\u00033\u001fB\u000b\u0006\"\u0002\u001d\u000e\u0001\u0004Q\u0004\"\u0002 \u000e\u0001\u0004\u0001\u0005\"\u0002'\u000e\u0001\u0004\u0001\u0015!\u00024fi\u000eDGc\u0001+aQB\u0011QKX\u0007\u0002-*\u0011q\u000bW\u0001\u0005G>\u0014XM\u0003\u0002Z5\u00061AM]5wKJT!a\u0017/\u0002\u0011\u0011\fG/Y:uCbT\u0011!X\u0001\u0004G>l\u0017BA0W\u0005%\u0011Vm];miN+G\u000fC\u0003b\u001d\u0001\u0007!-A\u0004mCf,'/\u00133\u0011\u0007\u0019\u001aW-\u0003\u0002eO\t1q\n\u001d;j_:\u0004\"!\u000e4\n\u0005\u001dd\"a\u0002'bs\u0016\u0014\u0018\n\u001a\u0005\u0006S:\u0001\r\u0001Q\u0001\u000eCR$(/\u001b2vi\u0016t\u0015-\\3\u0002\r\u0011,G.\u001a;f)\raw\u000e\u001d\t\u0003M5L!A\\\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006C>\u0001\r!\u001a\u0005\u0006S>\u0001\r!\u001d\t\u0004M\r\u0004\u0015\u0001\u0002:fC\u0012,\"\u0001\u001e=\u0015\u000bU\f9\"!\u0007\u0015\u0007Y\f\u0019\u0001\u0005\u0002xq2\u0001A!B=\u0011\u0005\u0004Q(!\u0001+\u0012\u0005mt\bC\u0001\u0014}\u0013\tixEA\u0004O_RD\u0017N\\4\u0011\u0005\u0019z\u0018bAA\u0001O\t\u0019\u0011I\\=\t\u0013\u0005\u0015\u0001#!AA\u0004\u0005\u001d\u0011AC3wS\u0012,gnY3%cA)\u0011\u0011BA\nm6\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0003dSJ\u001cWM\u0003\u0002\u0002\u0012\u0005\u0011\u0011n\\\u0005\u0005\u0003+\tYAA\u0004EK\u000e|G-\u001a:\t\u000b\u0005\u0004\u0002\u0019A3\t\u000b%\u0004\u0002\u0019\u0001!\u0002\u000fI,\u0017\rZ!mYV!\u0011qDA\u0016)\u0011\t\t#a\r\u0015\t\u0005\r\u0012Q\u0006\t\u0007\u0003\u0006\u0015R-!\u000b\n\u0007\u0005\u001d\"JA\u0002NCB\u00042a^A\u0016\t\u0015I\u0018C1\u0001{\u0011%\ty#EA\u0001\u0002\b\t\t$\u0001\u0006fm&$WM\\2fII\u0002b!!\u0003\u0002\u0014\u0005%\u0002\"B5\u0012\u0001\u0004\u0001\u0015!B<sSR,W\u0003BA\u001d\u0003\u0013\"\u0002\"a\u000f\u0002L\u00055\u0013q\n\u000b\u0004Y\u0006u\u0002\"CA %\u0005\u0005\t9AA!\u0003))g/\u001b3f]\u000e,Ge\r\t\u0007\u0003\u0013\t\u0019%a\u0012\n\t\u0005\u0015\u00131\u0002\u0002\b\u000b:\u001cw\u000eZ3s!\r9\u0018\u0011\n\u0003\u0006sJ\u0011\rA\u001f\u0005\u0006CJ\u0001\r!\u001a\u0005\u0006SJ\u0001\r\u0001\u0011\u0005\b\u0003#\u0012\u0002\u0019AA$\u0003\u00151\u0018\r\\;f\u0003-a\u0017-_3s\u000bbL7\u000f^:\u0015\t\u0005]\u0013Q\f\t\u0004M\u0005e\u0013bAA.O\t9!i\\8mK\u0006t\u0007\"B1\u0014\u0001\u0004)Gc\u00017\u0002b!)\u0011\r\u0006a\u0001KR)A.!\u001a\u0002h!)\u0011-\u0006a\u0001K\")\u0011.\u0006a\u0001\u0001\u0006AA.Y=fe&#7/\u0006\u0002\u0002nA)\u0011qNA=K:!\u0011\u0011OA;\u001d\r\u0019\u00151O\u0005\u0002Q%\u0019\u0011qO\u0014\u0002\u000fA\f7m[1hK&!\u00111PA?\u0005\r\u0019V-\u001d\u0006\u0004\u0003o:\u0013aE1wC&d\u0017M\u00197f\u0003R$(/\u001b2vi\u0016\u001cH\u0003BAB\u0003\u000b\u0003R!a\u001c\u0002z\u0001CQ!Y\fA\u0002\u0015\f1#\u0019<bS2\f'\r\\3[_>lG*\u001a<fYN$B!a#\u0002\u0014B1\u0011qNA=\u0003\u001b\u00032AJAH\u0013\r\t\tj\n\u0002\u0004\u0013:$\bBBAK1\u0001\u0007\u0001)A\u0005mCf,'OT1nK\")\u0001h\u0001a\u0001u!)ah\u0001a\u0001\u0001\")Aj\u0001a\u0001\u0001R\u0019!'a(\t\u000ba\"\u0001\u0019\u0001\u001e\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003K\u0003B!a*\u000226\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+\u0001\u0003mC:<'BAAX\u0003\u0011Q\u0017M^1\n\t\u0005M\u0016\u0011\u0016\u0002\u0007\u001f\nTWm\u0019;")
public class CassandraAttributeStore
implements DiscreteLayerAttributeStore {
    private final CassandraInstance instance;
    private final String attributeKeyspace;
    private final String attributeTable;
    private transient Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache;
    private volatile transient boolean bitmap$trans$0;

    public static CassandraAttributeStore apply(CassandraInstance cassandraInstance) {
        return CassandraAttributeStore$.MODULE$.apply(cassandraInstance);
    }

    public static CassandraAttributeStore apply(CassandraInstance cassandraInstance, String string, String string2) {
        return CassandraAttributeStore$.MODULE$.apply(cassandraInstance, string, string2);
    }

    public <K> Map<ZoomRange, KeyIndex<K>> readKeyIndexes(LayerId id, ClassTag<K> evidence$32) {
        return DiscreteLayerAttributeStore.readKeyIndexes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$32);
    }

    public <H> H readHeader(LayerId id, Decoder<H> evidence$33) {
        return (H)DiscreteLayerAttributeStore.readHeader$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$33);
    }

    public <M> M readMetadata(LayerId id, Decoder<M> evidence$34) {
        return (M)DiscreteLayerAttributeStore.readMetadata$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$34);
    }

    public <K> KeyIndex<K> readKeyIndex(LayerId id, ClassTag<K> evidence$35) {
        return DiscreteLayerAttributeStore.readKeyIndex$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$35);
    }

    public Schema readSchema(LayerId id) {
        return DiscreteLayerAttributeStore.readSchema$((DiscreteLayerAttributeStore)this, (LayerId)id);
    }

    public <H, M, K> LayerAttributes<H, M, K> readLayerAttributes(LayerId id, Decoder<H> evidence$36, Decoder<M> evidence$37, ClassTag<K> evidence$38) {
        return DiscreteLayerAttributeStore.readLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$36, evidence$37, evidence$38);
    }

    public <H, M, K> void writeLayerAttributes(LayerId id, H header, M metadata, KeyIndex<K> keyIndex, Schema schema, Encoder<H> evidence$39, Encoder<M> evidence$40, ClassTag<K> evidence$41) {
        DiscreteLayerAttributeStore.writeLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, header, metadata, keyIndex, (Schema)schema, evidence$39, evidence$40, evidence$41);
    }

    public <H, M> COGLayerAttributes<H, M> readCOGLayerAttributes(LayerId id, Decoder<H> evidence$42, Decoder<M> evidence$43) {
        return DiscreteLayerAttributeStore.readCOGLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$42, evidence$43);
    }

    public <H, M> void writeCOGLayerAttributes(LayerId id, H header, M metadata, Encoder<H> evidence$44, Encoder<M> evidence$45) {
        DiscreteLayerAttributeStore.writeCOGLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, header, metadata, evidence$44, evidence$45);
    }

    public boolean isCOGLayer(LayerId id) {
        return AttributeStore.isCOGLayer$((AttributeStore)this, (LayerId)id);
    }

    public LayerType layerType(LayerId id) {
        return AttributeStore.layerType$((AttributeStore)this, (LayerId)id);
    }

    public Map<String, Seq<Object>> layersWithZoomLevels() {
        return AttributeStore.layersWithZoomLevels$((AttributeStore)this);
    }

    public void copy(LayerId from, LayerId to) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to);
    }

    public void copy(LayerId from, LayerId to, Seq<String> attributes) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to, attributes);
    }

    public <T> T cacheRead(LayerId layerId, String attributeName, Decoder<T> evidence$1) {
        return (T)AttributeCaching.cacheRead$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, evidence$1);
    }

    public LayerType cacheLayerType(LayerId layerId, LayerType layerType) {
        return AttributeCaching.cacheLayerType$((AttributeCaching)this, (LayerId)layerId, (LayerType)layerType);
    }

    public <T> void cacheWrite(LayerId layerId, String attributeName, T value, Encoder<T> evidence$2) {
        AttributeCaching.cacheWrite$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, value, evidence$2);
    }

    public void clearCache() {
        AttributeCaching.clearCache$((AttributeCaching)this);
    }

    public void clearCache(LayerId id) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id);
    }

    public void clearCache(LayerId id, String attribute) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id, (String)attribute);
    }

    private Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache$lzycompute() {
        CassandraAttributeStore cassandraAttributeStore = this;
        synchronized (cassandraAttributeStore) {
            if (!this.bitmap$trans$0) {
                this.geotrellis$store$AttributeCaching$$cache = AttributeCaching.geotrellis$store$AttributeCaching$$cache$((AttributeCaching)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.geotrellis$store$AttributeCaching$$cache;
    }

    public Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache() {
        return !this.bitmap$trans$0 ? this.geotrellis$store$AttributeCaching$$cache$lzycompute() : this.geotrellis$store$AttributeCaching$$cache;
    }

    public CassandraInstance instance() {
        return this.instance;
    }

    public String attributeKeyspace() {
        return this.attributeKeyspace;
    }

    public String attributeTable() {
        return this.attributeTable;
    }

    private ResultSet fetch(Option<LayerId> layerId, String attributeName) {
        return (ResultSet)this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            Select.Where where;
            Option option = layerId;
            if (option instanceof Some) {
                Some some = (Some)option;
                LayerId id = (LayerId)some.value();
                where = QueryBuilder.select().column("value").from(this.attributeKeyspace(), this.attributeTable()).where(QueryBuilder.eq((String)"layerName", (Object)id.name())).and(QueryBuilder.eq((String)"layerZoom", (Object)BoxesRunTime.boxToInteger((int)id.zoom()))).and(QueryBuilder.eq((String)"name", (Object)attributeName));
            } else if (None$.MODULE$.equals(option)) {
                where = QueryBuilder.select().column("value").from(this.attributeKeyspace(), this.attributeTable()).where(QueryBuilder.eq((String)"name", (Object)attributeName));
            } else {
                throw new MatchError((Object)option);
            }
            Select.Where query = where;
            return session.execute((Statement)query);
        });
    }

    private void delete(LayerId layerId, Option<String> attributeName) {
        this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            CassandraAttributeStore.$anonfun$delete$1(this, attributeName, layerId, session);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T read(LayerId layerId, String attributeName, Decoder<T> evidence$1) {
        return this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            Object result;
            Select.Where query = QueryBuilder.select().column("value").from(this.attributeKeyspace(), this.attributeTable()).where(QueryBuilder.eq((String)"layerName", (Object)layerId.name())).and(QueryBuilder.eq((String)"layerZoom", (Object)BoxesRunTime.boxToInteger((int)layerId.zoom()))).and(QueryBuilder.eq((String)"name", (Object)attributeName));
            ResultSet values = session.execute((Statement)query);
            int size = values.getAvailableWithoutFetching();
            if (size == 0) {
                throw new package.AttributeNotFoundError(attributeName, layerId);
            }
            if (size > 1) {
                throw new package.LayerIOError(new StringBuilder(41).append("Multiple attributes found for ").append(attributeName).append(" for layer ").append(layerId).toString());
            }
            Tuple2 tuple2 = (Tuple2)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(package$.MODULE$.parse(values.one().getString("value")).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.as(Decoder$.MODULE$.decodeTuple2((Decoder)LayerId$.MODULE$.codecForLayerId(), evidence$1)))), (Function1 & Serializable & scala.Serializable)x$2 -> {
                throw x$2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object object = result = tuple2._2();
            Object result2 = object;
            return result2;
        });
    }

    public <T> Map<LayerId, T> readAll(String attributeName, Decoder<T> evidence$2) {
        return (Map)this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            Select.Where query = QueryBuilder.select().column("value").from(this.attributeKeyspace(), this.attributeTable()).allowFiltering().where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker()));
            PreparedStatement preparedStatement = session.prepare((RegularStatement)query);
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(session.execute((Statement)preparedStatement.bind(new Object[]{attributeName})).all()).asScala()).map((Function1 & Serializable & scala.Serializable)row -> (Tuple2)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(package$.MODULE$.parse(row.getString("value")).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.as(Decoder$.MODULE$.decodeTuple2((Decoder)LayerId$.MODULE$.codecForLayerId(), evidence$2)))), (Function1 & Serializable & scala.Serializable)x$4 -> {
                throw x$4;
            }), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        });
    }

    public <T> void write(LayerId layerId, String attributeName, T value, Encoder<T> evidence$3) {
        this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            Update.Where update = QueryBuilder.update((String)this.attributeKeyspace(), (String)this.attributeTable()).with(QueryBuilder.set((String)"value", (Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)new Tuple2((Object)layerId, value)), (Encoder)Encoder$.MODULE$.encodeTuple2((Encoder)LayerId$.MODULE$.codecForLayerId(), evidence$3)).noSpaces())).where(QueryBuilder.eq((String)"layerName", (Object)layerId.name())).and(QueryBuilder.eq((String)"layerZoom", (Object)BoxesRunTime.boxToInteger((int)layerId.zoom()))).and(QueryBuilder.eq((String)"name", (Object)attributeName));
            return session.execute((Statement)update);
        });
    }

    public boolean layerExists(LayerId layerId) {
        return BoxesRunTime.unboxToBoolean(this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)CassandraAttributeStore.$anonfun$layerExists$1(this, layerId, session))));
    }

    public void delete(LayerId layerId) {
        this.delete(layerId, (Option<String>)None$.MODULE$);
    }

    public void delete(LayerId layerId, String attributeName) {
        this.delete(layerId, (Option<String>)new Some((Object)attributeName));
    }

    public Seq<LayerId> layerIds() {
        return (Seq)this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            Select query = QueryBuilder.select((String[])new String[]{"layerName", "layerZoom"}).from(this.attributeKeyspace(), this.attributeTable());
            return (List)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)session.execute((Statement)query)).asScala()).map((Function1 & Serializable & scala.Serializable)key -> {
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.getString("layerName")), (Object)BoxesRunTime.boxToInteger((int)key.getInt("layerZoom")));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                int zoom = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)zoom));
                Tuple2 tuple23 = tuple22;
                String name2 = (String)tuple23._1();
                int zoom2 = tuple23._2$mcI$sp();
                return new LayerId(name2, zoom2);
            }, Iterable$.MODULE$.canBuildFrom())).toList().distinct();
        });
    }

    public Seq<String> availableAttributes(LayerId layerId) {
        return (Seq)this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            Select.Where query = QueryBuilder.select().column("name").from(this.attributeKeyspace(), this.attributeTable()).where(QueryBuilder.eq((String)"layerName", (Object)layerId.name())).and(QueryBuilder.eq((String)"layerZoom", (Object)BoxesRunTime.boxToInteger((int)layerId.zoom())));
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)session.execute((Statement)query)).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getString("name"), Iterable$.MODULE$.canBuildFrom())).toVector();
        });
    }

    public Seq<Object> availableZoomLevels(String layerName) {
        return (Seq)this.instance().withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            Select.Where query = QueryBuilder.select().column("layerZoom").from(this.attributeKeyspace(), this.attributeTable()).where(QueryBuilder.eq((String)"layerName", (Object)layerName));
            return (List)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)session.execute((Statement)query)).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.getInt("layerZoom")), Iterable$.MODULE$.canBuildFrom())).toList().distinct();
        });
    }

    public static final /* synthetic */ void $anonfun$delete$1(CassandraAttributeStore $this, Option attributeName$2, LayerId layerId$2, Session session) {
        Delete.Where where;
        Option option = attributeName$2;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            where = QueryBuilder.delete().from($this.attributeKeyspace(), $this.attributeTable()).where(QueryBuilder.eq((String)"layerName", (Object)layerId$2.name())).and(QueryBuilder.eq((String)"layerZoom", (Object)BoxesRunTime.boxToInteger((int)layerId$2.zoom()))).and(QueryBuilder.eq((String)"name", (Object)name));
        } else if (None$.MODULE$.equals(option)) {
            where = QueryBuilder.delete().from($this.attributeKeyspace(), $this.attributeTable()).where(QueryBuilder.eq((String)"layerName", (Object)layerId$2.name())).and(QueryBuilder.eq((String)"layerZoom", (Object)BoxesRunTime.boxToInteger((int)layerId$2.zoom())));
        } else {
            throw new MatchError((Object)option);
        }
        Delete.Where query = where;
        session.execute((Statement)query);
        Option option2 = attributeName$2;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String attribute = (String)some.value();
            $this.clearCache(layerId$2, attribute);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            $this.clearCache(layerId$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$layerExists$2(LayerId layerId$5, Row key) {
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.getString("layerName")), (Object)BoxesRunTime.boxToInteger((int)key.getInt("layerZoom")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        int zoom = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)zoom));
        Tuple2 tuple23 = tuple22;
        String name2 = (String)tuple23._1();
        int zoom2 = tuple23._2$mcI$sp();
        LayerId layerId = layerId$5;
        LayerId layerId2 = new LayerId(name2, zoom2);
        return !(layerId != null ? !layerId.equals(layerId2) : layerId2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$layerExists$1(CassandraAttributeStore $this, LayerId layerId$5, Session session) {
        Select.Where query = QueryBuilder.select((String[])new String[]{"layerName", "layerZoom"}).from($this.attributeKeyspace(), $this.attributeTable()).where(QueryBuilder.eq((String)"layerName", (Object)layerId$5.name())).and(QueryBuilder.eq((String)"layerZoom", (Object)BoxesRunTime.boxToInteger((int)layerId$5.zoom()))).and(QueryBuilder.eq((String)"name", (Object)AttributeStore.Fields$.MODULE$.metadata()));
        return ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)session.execute((Statement)query)).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)CassandraAttributeStore.$anonfun$layerExists$2(layerId$5, key)));
    }

    public CassandraAttributeStore(CassandraInstance instance, String attributeKeyspace, String attributeTable) {
        this.instance = instance;
        this.attributeKeyspace = attributeKeyspace;
        this.attributeTable = attributeTable;
        AttributeCaching.$init$((AttributeCaching)this);
        AttributeStore.$init$((AttributeStore)this);
        DiscreteLayerAttributeStore.$init$((DiscreteLayerAttributeStore)this);
        instance.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            this.instance().ensureKeyspaceExists(this.attributeKeyspace(), (Session)session);
            return session.execute((Statement)((Create)SchemaBuilder.createTable((String)this.attributeKeyspace(), (String)this.attributeTable()).ifNotExists()).addPartitionKey("layerName", DataType.text()).addClusteringColumn("layerZoom", DataType.cint()).addClusteringColumn("name", DataType.text()).addColumn("value", DataType.text()));
        });
    }
}

