/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.cassandra;

import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.ContextCollection;
import geotrellis.layer.EmptyBounds$;
import geotrellis.layer.KeyBounds$;
import geotrellis.store.AttributeStore;
import geotrellis.store.CollectionLayerReader;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.LayerQuery;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.cassandra.CassandraAttributeStore;
import geotrellis.store.cassandra.CassandraCollectionLayerReader$;
import geotrellis.store.cassandra.CassandraCollectionReader$;
import geotrellis.store.cassandra.CassandraInstance;
import geotrellis.store.cassandra.CassandraLayerHeader;
import geotrellis.store.cassandra.CassandraLayerHeader$;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import geotrellis.util.Component;
import geotrellis.util.package$;
import io.circe.Decoder;
import java.io.Serializable;
import org.apache.avro.Schema;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0006\r\u0001MA\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001\b\u0005\tA\u0001\u0011\t\u0011)A\u0005;!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0003,\u0001\u0011\u0005AfB\u0004\u0002\u00121A\t!a\u0005\u0007\r-a\u0001\u0012AA\u000b\u0011\u00191s\u0001\"\u0001\u0002\u001e!9\u0011qD\u0004\u0005\u0002\u0005\u0005\u0002bBA\u0010\u000f\u0011\u0005\u0011Q\u0005\u0002\u001f\u0007\u0006\u001c8/\u00198ee\u0006\u001cu\u000e\u001c7fGRLwN\u001c'bs\u0016\u0014(+Z1eKJT!!\u0004\b\u0002\u0013\r\f7o]1oIJ\f'BA\b\u0011\u0003\u0015\u0019Ho\u001c:f\u0015\u0005\t\u0012AC4f_R\u0014X\r\u001c7jg\u000e\u00011C\u0001\u0001\u0015!\r)b\u0003G\u0007\u0002\u001d%\u0011qC\u0004\u0002\u0016\u0007>dG.Z2uS>tG*Y=feJ+\u0017\rZ3s!\t)\u0012$\u0003\u0002\u001b\u001d\t9A*Y=fe&#\u0017AD1uiJL'-\u001e;f'R|'/Z\u000b\u0002;A\u0011QCH\u0005\u0003?9\u0011a\"\u0011;ue&\u0014W\u000f^3Ti>\u0014X-A\bbiR\u0014\u0018NY;uKN#xN]3!\u0003!Ign\u001d;b]\u000e,\u0007CA\u0012%\u001b\u0005a\u0011BA\u0013\r\u0005E\u0019\u0015m]:b]\u0012\u0014\u0018-\u00138ti\u0006t7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!J#\u0006\u0005\u0002$\u0001!)1\u0004\u0002a\u0001;!)\u0011\u0005\u0002a\u0001E\u0005!!/Z1e+\u0011is\u0007R$\u0015\u000b9bh0a\u0002\u0015\u0013=J\u0015K\u00161iW:\f\b#\u0002\u00194k\r3U\"A\u0019\u000b\u0005I\u0002\u0012!\u00027bs\u0016\u0014\u0018B\u0001\u001b2\u0005E\u0019uN\u001c;fqR\u001cu\u000e\u001c7fGRLwN\u001c\t\u0003m]b\u0001\u0001B\u00039\u000b\t\u0007\u0011HA\u0001L#\tQ\u0004\t\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDHA\u0004O_RD\u0017N\\4\u0011\u0005m\n\u0015B\u0001\"=\u0005\r\te.\u001f\t\u0003m\u0011#Q!R\u0003C\u0002e\u0012\u0011A\u0016\t\u0003m\u001d#Q\u0001S\u0003C\u0002e\u0012\u0011!\u0014\u0005\b\u0015\u0016\t\t\u0011q\u0001L\u0003))g/\u001b3f]\u000e,G%\r\t\u0004\u0019>+T\"A'\u000b\u00059s\u0011\u0001B1we>L!\u0001U'\u0003\u001f\u00053(o\u001c*fG>\u0014HmQ8eK\u000eDqAU\u0003\u0002\u0002\u0003\u000f1+\u0001\u0006fm&$WM\\2fII\u00022\u0001\r+6\u0013\t)\u0016GA\u0005C_VtG-\u00192mK\"9q+BA\u0001\u0002\bA\u0016AC3wS\u0012,gnY3%gA\u0019\u0011LX\u001b\u000e\u0003iS!a\u0017/\u0002\u000b\rL'oY3\u000b\u0003u\u000b!![8\n\u0005}S&a\u0002#fG>$WM\u001d\u0005\bC\u0016\t\t\u0011q\u0001c\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0004G\u001a,T\"\u00013\u000b\u0005\u0015d\u0014a\u0002:fM2,7\r^\u0005\u0003O\u0012\u0014\u0001b\u00117bgN$\u0016m\u001a\u0005\bS\u0016\t\t\u0011q\u0001k\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0004\u0019>\u001b\u0005b\u00027\u0006\u0003\u0003\u0005\u001d!\\\u0001\u000bKZLG-\u001a8dK\u00122\u0004cA2g\u0007\"9q.BA\u0001\u0002\b\u0001\u0018AC3wS\u0012,gnY3%oA\u0019\u0011L\u0018$\t\u000fI,\u0011\u0011!a\u0002g\u0006QQM^5eK:\u001cW\r\n\u001d\u0011\tQ<h)_\u0007\u0002k*\u0011a\u000fE\u0001\u0005kRLG.\u0003\u0002yk\nI1i\\7q_:,g\u000e\u001e\t\u0004ai,\u0014BA>2\u0005\u0019\u0011u.\u001e8eg\")Q0\u0002a\u00011\u0005\u0011\u0011\u000e\u001a\u0005\u0007\u007f\u0016\u0001\r!!\u0001\u0002\u0017I\f7\u000f^3s#V,'/\u001f\t\u0006+\u0005\rQGR\u0005\u0004\u0003\u000bq!A\u0003'bs\u0016\u0014\u0018+^3ss\"9\u0011\u0011B\u0003A\u0002\u0005-\u0011a\u00044jYR,'/\u00138eKb|e\u000e\\=\u0011\u0007m\ni!C\u0002\u0002\u0010q\u0012qAQ8pY\u0016\fg.\u0001\u0010DCN\u001c\u0018M\u001c3sC\u000e{G\u000e\\3di&|g\u000eT1zKJ\u0014V-\u00193feB\u00111eB\n\u0004\u000f\u0005]\u0001cA\u001e\u0002\u001a%\u0019\u00111\u0004\u001f\u0003\r\u0005s\u0017PU3g)\t\t\u0019\"A\u0003baBd\u0017\u0010F\u0002)\u0003GAQ!I\u0005A\u0002\t\"2\u0001KA\u0014\u0011\u0019Y\"\u00021\u0001\u0002*A\u00191%a\u000b\n\u0007\u00055BBA\fDCN\u001c\u0018M\u001c3sC\u0006#HO]5ckR,7\u000b^8sK\u0002")
public class CassandraCollectionLayerReader
extends CollectionLayerReader<LayerId> {
    private final AttributeStore attributeStore;
    private final CassandraInstance instance;

    public static CassandraCollectionLayerReader apply(CassandraAttributeStore cassandraAttributeStore) {
        return CassandraCollectionLayerReader$.MODULE$.apply(cassandraAttributeStore);
    }

    public static CassandraCollectionLayerReader apply(CassandraInstance cassandraInstance) {
        return CassandraCollectionLayerReader$.MODULE$.apply(cassandraInstance);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    public <K, V, M> ContextCollection<K, V, M> read(LayerId id, LayerQuery<K, M> rasterQuery, boolean filterIndexOnly, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, Decoder<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, Decoder<M> evidence$7, Component<M, Bounds<K>> evidence$8) {
        if (!this.attributeStore().layerExists(id)) {
            throw new package.LayerNotFoundError(id);
        }
        LayerAttributes layerAttributes = this.liftedTree1$1(id, evidence$7, evidence$4);
        if (layerAttributes == null) {
            throw new MatchError((Object)layerAttributes);
        }
        CassandraLayerHeader header = (CassandraLayerHeader)layerAttributes.header();
        Object metadata = layerAttributes.metadata();
        KeyIndex keyIndex = layerAttributes.keyIndex();
        Schema writerSchema = layerAttributes.schema();
        Tuple4 tuple4 = new Tuple4((Object)header, metadata, (Object)keyIndex, (Object)writerSchema);
        Tuple4 tuple42 = tuple4;
        CassandraLayerHeader header2 = (CassandraLayerHeader)tuple42._1();
        Object metadata2 = tuple42._2();
        KeyIndex keyIndex2 = (KeyIndex)tuple42._3();
        Schema writerSchema2 = (Schema)tuple42._4();
        Seq queryKeyBounds = rasterQuery.apply(metadata2);
        Object layerMetadata = package$.MODULE$.withSetComponentMethods(metadata2).setComponent(queryKeyBounds.foldLeft((Object)EmptyBounds$.MODULE$, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.combine((Bounds)x$3, evidence$2)), evidence$8);
        Function1 & Serializable & scala.Serializable decompose = (Function1 & Serializable & scala.Serializable)bounds -> keyIndex2.indexRanges(KeyBounds$.MODULE$.keyBoundsToTuple(bounds));
        Seq<Tuple2<K, V>> seq = CassandraCollectionReader$.MODULE$.read(this.instance, header2.keyspace(), header2.tileTable(), id, queryKeyBounds, decompose, filterIndexOnly, (Option<Schema>)new Some((Object)writerSchema2), CassandraCollectionReader$.MODULE$.read$default$9(), evidence$2, evidence$1, evidence$4, evidence$5, evidence$6);
        return new ContextCollection(seq, layerMetadata);
    }

    private final /* synthetic */ LayerAttributes liftedTree1$1(LayerId id$1, Decoder evidence$7$1, ClassTag evidence$4$1) {
        LayerAttributes layerAttributes;
        try {
            layerAttributes = this.attributeStore().readLayerAttributes(id$1, CassandraLayerHeader$.MODULE$.cassandraLayerHeaderDecoder(), evidence$7$1, evidence$4$1);
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerReadError(id$1).initCause((Throwable)e);
        }
        return layerAttributes;
    }

    public CassandraCollectionLayerReader(AttributeStore attributeStore, CassandraInstance instance) {
        this.attributeStore = attributeStore;
        this.instance = instance;
    }
}

