/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import geotrellis.layer.Boundable;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.store.LayerId;
import geotrellis.store.avro.AvroEncoder$;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec$;
import geotrellis.store.cassandra.CassandraInstance;
import geotrellis.store.cassandra.package$;
import geotrellis.store.index.MergeQueue$;
import geotrellis.store.util.BlockingThreadPool$;
import geotrellis.store.util.IOUtils$;
import java.io.Serializable;
import org.apache.avro.Schema;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class CassandraCollectionReader$ {
    public static CassandraCollectionReader$ MODULE$;

    static {
        new CassandraCollectionReader$();
    }

    public <K, V> Seq<Tuple2<K, V>> read(CassandraInstance instance, String keyspace, String table, LayerId layerId, Seq<KeyBounds<K>> queryKeyBounds, Function1<KeyBounds<K>, Seq<Tuple2<BigInt, BigInt>>> decomposeBounds, boolean filterIndexOnly, Option<Schema> writerSchema, ExecutionContext executionContext, Boundable<K> evidence$1, AvroRecordCodec<K> evidence$2, ClassTag<K> evidence$3, AvroRecordCodec<V> evidence$4, ClassTag<V> evidence$5) {
        if (queryKeyBounds.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        Function1 & Serializable & scala.Serializable includeKey = (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)CassandraCollectionReader$.$anonfun$read$1(queryKeyBounds, evidence$1, key));
        KeyValueRecordCodec _recordCodec = KeyValueRecordCodec$.MODULE$.apply(evidence$2, evidence$4);
        Seq ranges = queryKeyBounds.length() > 1 ? MergeQueue$.MODULE$.apply((TraversableOnce)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom())) : (Seq)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom());
        ExecutionContext ec = executionContext;
        String query = QueryBuilder.select((String[])new String[]{"value"}).from(keyspace, table).where(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"name", (Object)layerId.name())).and(QueryBuilder.eq((String)"zoom", (Object)BoxesRunTime.boxToInteger((int)layerId.zoom()))).toString();
        return (Seq)instance.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            PreparedStatement statement = session.prepare(query);
            return IOUtils$.MODULE$.parJoin(ranges.iterator(), (Function1 & Serializable & scala.Serializable)index -> {
                Vector vector;
                ResultSet row2 = session.execute((Statement)statement.bind(new Object[]{package$.MODULE$.bigToBig((BigInt)index)}));
                if (((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)row2).asScala()).nonEmpty()) {
                    byte[] bytes = row2.one().getBytes("value").array();
                    Vector recs = (Vector)AvroEncoder$.MODULE$.fromBinary((Schema)writerSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> _recordCodec.schema()), bytes, (AvroRecordCodec)_recordCodec);
                    vector = filterIndexOnly ? recs : (Vector)recs.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)CassandraCollectionReader$.$anonfun$read$5(includeKey, row)));
                } else {
                    vector = scala.package$.MODULE$.Vector().empty();
                }
                return vector;
            }, ec);
        });
    }

    public <K, V> Option<Schema> read$default$8() {
        return None$.MODULE$;
    }

    public <K, V> ExecutionContext read$default$9() {
        return BlockingThreadPool$.MODULE$.executionContext();
    }

    public static final /* synthetic */ boolean $anonfun$read$1(Seq queryKeyBounds$1, Boundable evidence$1$1, Object key) {
        return KeyBounds$.MODULE$.KeyBoundsSeqMethods(queryKeyBounds$1, evidence$1$1).includeKey(key);
    }

    public static final /* synthetic */ boolean $anonfun$read$5(Function1 includeKey$1, Tuple2 row) {
        return BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply(row._1()));
    }

    private CassandraCollectionReader$() {
        MODULE$ = this;
    }
}

