/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerDeleter;
import geotrellis.store.LayerId;
import geotrellis.store.cassandra.CassandraAttributeStore;
import geotrellis.store.cassandra.CassandraInstance;
import geotrellis.store.cassandra.CassandraLayerDeleter$;
import geotrellis.store.cassandra.CassandraLayerHeader;
import geotrellis.store.cassandra.CassandraLayerHeader$;
import geotrellis.store.package;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0004\b\u0001+!A1\u0005\u0001BC\u0002\u0013\u0005A\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003&\u0011!I\u0003A!A!\u0002\u0013Q\u0003\"\u0002\u0018\u0001\t\u0003y\u0003\"B\u001a\u0001\t\u0003!\u0004\u0002\u0003\u001e\u0001\u0011\u000b\u0007K\u0011B\u001e\b\u000b!s\u0001\u0012A%\u0007\u000b5q\u0001\u0012\u0001&\t\u000b9BA\u0011A&\t\u000b1CA\u0011A'\t\u000b1CA\u0011A*\t\u000b1CA\u0011A+\u0003+\r\u000b7o]1oIJ\fG*Y=fe\u0012+G.\u001a;fe*\u0011q\u0002E\u0001\nG\u0006\u001c8/\u00198ee\u0006T!!\u0005\n\u0002\u000bM$xN]3\u000b\u0003M\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0019QD\b\u0011\u000e\u0003AI!a\b\t\u0003\u00191\u000b\u00170\u001a:EK2,G/\u001a:\u0011\u0005u\t\u0013B\u0001\u0012\u0011\u0005\u001da\u0015-_3s\u0013\u0012\fa\"\u0019;ue&\u0014W\u000f^3Ti>\u0014X-F\u0001&!\tib%\u0003\u0002(!\tq\u0011\t\u001e;sS\n,H/Z*u_J,\u0017aD1uiJL'-\u001e;f'R|'/\u001a\u0011\u0002\u0011%t7\u000f^1oG\u0016\u0004\"a\u000b\u0017\u000e\u00039I!!\f\b\u0003#\r\u000b7o]1oIJ\f\u0017J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0004aE\u0012\u0004CA\u0016\u0001\u0011\u0015\u0019C\u00011\u0001&\u0011\u0015IC\u00011\u0001+\u0003\u0019!W\r\\3uKR\u0011Q\u0007\u000f\t\u0003/YJ!a\u000e\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006s\u0015\u0001\r\u0001I\u0001\u0003S\u0012\fa\u0001\\8hO\u0016\u0014X#\u0001\u001f\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015!\u00027pOR\u001a(\"A!\u0002\u0007=\u0014x-\u0003\u0002D}\t1Aj\\4hKJD#AB#\u0011\u0005]1\u0015BA$\u0019\u0005%!(/\u00198tS\u0016tG/A\u000bDCN\u001c\u0018M\u001c3sC2\u000b\u00170\u001a:EK2,G/\u001a:\u0011\u0005-B1C\u0001\u0005\u0017)\u0005I\u0015!B1qa2LHc\u0001\u0019O%\")1E\u0003a\u0001\u001fB\u00111\u0006U\u0005\u0003#:\u0011qcQ1tg\u0006tGM]1BiR\u0014\u0018NY;uKN#xN]3\t\u000b%R\u0001\u0019\u0001\u0016\u0015\u0005A\"\u0006\"B\u0012\f\u0001\u0004yEC\u0001\u0019W\u0011\u0015IC\u00021\u0001+\u0001")
public class CassandraLayerDeleter
implements LayerDeleter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final CassandraInstance instance;
    private volatile transient boolean bitmap$trans$0;

    public static CassandraLayerDeleter apply(CassandraInstance cassandraInstance) {
        return CassandraLayerDeleter$.MODULE$.apply(cassandraInstance);
    }

    public static CassandraLayerDeleter apply(CassandraAttributeStore cassandraAttributeStore) {
        return CassandraLayerDeleter$.MODULE$.apply(cassandraAttributeStore);
    }

    public static CassandraLayerDeleter apply(CassandraAttributeStore cassandraAttributeStore, CassandraInstance cassandraInstance) {
        return CassandraLayerDeleter$.MODULE$.apply(cassandraAttributeStore, cassandraInstance);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        CassandraLayerDeleter cassandraLayerDeleter = this;
        synchronized (cassandraLayerDeleter) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(CassandraLayerDeleter.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void delete(LayerId id) {
        try {
            try {
                CassandraLayerHeader header = (CassandraLayerHeader)this.attributeStore().readHeader(id, CassandraLayerHeader$.MODULE$.cassandraLayerHeaderDecoder());
                this.instance.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
                    Select.Where squery = QueryBuilder.select((String[])new String[]{"key"}).from(header.keyspace(), header.tileTable()).allowFiltering().where(QueryBuilder.eq((String)"name", (Object)id.name())).and(QueryBuilder.eq((String)"zoom", (Object)BoxesRunTime.boxToInteger((int)id.zoom())));
                    Delete.Where dquery = QueryBuilder.delete().from(header.keyspace(), header.tileTable()).where(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"name", (Object)id.name())).and(QueryBuilder.eq((String)"zoom", (Object)BoxesRunTime.boxToInteger((int)id.zoom())));
                    PreparedStatement statement = session.prepare((RegularStatement)dquery);
                    return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(session.execute((Statement)squery).all()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> session.execute((Statement)statement.bind(new Object[]{entry.getVarint("key")})), Buffer$.MODULE$.canBuildFrom());
                });
            }
            catch (package.AttributeNotFoundError e) {
                if (this.logger().isInfoEnabled()) {
                    this.logger().info(new StringBuilder(92).append("Metadata for ").append(id).append(" was not found. Any associated layer data (if any) will require manual deletion").toString());
                }
                throw new package.LayerDeleteError(id).initCause((Throwable)e);
            }
        }
        finally {
            this.attributeStore().delete(id);
        }
    }

    public CassandraLayerDeleter(AttributeStore attributeStore, CassandraInstance instance) {
        this.attributeStore = attributeStore;
        this.instance = instance;
    }
}

