/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hbase;

import com.github.blemale.scaffeine.Cache;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeCaching;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.COGLayerAttributes;
import geotrellis.spark.io.DiscreteLayerAttributeStore;
import geotrellis.spark.io.LayerAttributes;
import geotrellis.spark.io.LayerType;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.hbase.HBaseAttributeStore$;
import geotrellis.spark.io.hbase.HBaseInstance;
import geotrellis.spark.io.hbase.HBaseRDDWriter$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.spark.io.package$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.util.Bytes;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spray.json.DefaultJsonProtocol$;
import spray.json.JsValue;
import spray.json.JsonFormat;
import spray.json.JsonReader;
import spray.json.JsonWriter;

@ScalaSignature(bytes="\u0006\u0001\u0005Ex!B\u0001\u0003\u0011\u0003Y\u0011a\u0005%CCN,\u0017\t\u001e;sS\n,H/Z*u_J,'BA\u0002\u0005\u0003\u0015A'-Y:f\u0015\t)a!\u0001\u0002j_*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0002\u0013\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019)aB\u0001E\u0001\u001f\t\u0019\u0002JQ1tK\u0006#HO]5ckR,7\u000b^8sKN\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\ta1+\u001a:jC2L'0\u00192mK\")!$\u0004C\u00017\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u0006;5!\tAH\u0001\u0006CB\u0004H.\u001f\u000b\u0004?\u0005m\u0007C\u0001\u0007!\r\u0011q!\u0001A\u0011\u0014\u0007\u0001\u0002\"\u0005\u0005\u0002$I5\tA!\u0003\u0002&\t\tYB)[:de\u0016$X\rT1zKJ\fE\u000f\u001e:jEV$Xm\u0015;pe\u0016D\u0001b\n\u0011\u0003\u0006\u0004%\t\u0001K\u0001\tS:\u001cH/\u00198dKV\t\u0011\u0006\u0005\u0002\rU%\u00111F\u0001\u0002\u000e\u0011\n\u000b7/Z%ogR\fgnY3\t\u00115\u0002#\u0011!Q\u0001\n%\n\u0011\"\u001b8ti\u0006t7-\u001a\u0011\t\u0011=\u0002#Q1A\u0005\u0002A\na\"\u0019;ue&\u0014W\u000f^3UC\ndW-F\u00012!\t\u0011\u0014H\u0004\u00024oA\u0011AGE\u0007\u0002k)\u0011aGC\u0001\u0007yI|w\u000e\u001e \n\u0005a\u0012\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\n\t\u0011u\u0002#\u0011!Q\u0001\nE\nq\"\u0019;ue&\u0014W\u000f^3UC\ndW\r\t\u0005\u00065\u0001\"\ta\u0010\u000b\u0004?\u0001\u000b\u0005\"B\u0014?\u0001\u0004I\u0003\"B\u0018?\u0001\u0004\t\u0004bB\"!\u0005\u0004%I\u0001R\u0001\u0013CR$(/\u001b2vi\u0016$\u0016M\u00197f\u001d\u0006lW-F\u0001F!\t1e*D\u0001H\u0015\t\u0019\u0001J\u0003\u0002J\u0015\u00061\u0001.\u00193p_BT!a\u0013'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0015aA8sO&\u0011qj\u0012\u0002\n)\u0006\u0014G.\u001a(b[\u0016Da!\u0015\u0011!\u0002\u0013)\u0015aE1uiJL'-\u001e;f)\u0006\u0014G.\u001a(b[\u0016\u0004\u0003bB*!\u0005\u0004%\t\u0001V\u0001\u0004'\u0016\u0003V#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001\u00027b]\u001eT\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002;/\"1Q\f\tQ\u0001\nU\u000bAaU#QA!)q\f\tC\u0001A\u0006iA.Y=fe&#7\u000b\u001e:j]\u001e$\"!M1\t\u000b\tt\u0006\u0019A2\u0002\u000f1\f\u00170\u001a:JIB\u0011A-Z\u0007\u0002\r%\u0011aM\u0002\u0002\b\u0019\u0006LXM]%e\u0011\u0015A\u0007\u0005\"\u0003j\u0003%\tG\rZ\"pYVlg\u000e\u0006\u0002kaR\u00111N\u001c\t\u0003#1L!!\u001c\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006_\u001e\u0004\r!M\u0001\u0003G\u001aDQ!]4A\u0002I\fQ\u0001^1cY\u0016\u0004\"a\u001d<\u000e\u0003QT!!^$\u0002\r\rd\u0017.\u001a8u\u0013\t9HOA\u0003UC\ndW\rC\u0003zA\u0011%!0A\u0003gKR\u001c\u0007\u000eF\u0003|\u0003\u001f\t9\u0002E\u0003}\u0003\u0007\tIA\u0004\u0002~\u007f:\u0011AG`\u0005\u0002'%\u0019\u0011\u0011\u0001\n\u0002\u000fA\f7m[1hK&!\u0011QAA\u0004\u0005\u00191Vm\u0019;pe*\u0019\u0011\u0011\u0001\n\u0011\u0007M\fY!C\u0002\u0002\u000eQ\u0014aAU3tk2$\bB\u00022y\u0001\u0004\t\t\u0002\u0005\u0003\u0012\u0003'\u0019\u0017bAA\u000b%\t1q\n\u001d;j_:Da!!\u0007y\u0001\u0004\t\u0014!D1uiJL'-\u001e;f\u001d\u0006lW\rC\u0004\u0002\u001e\u0001\"I!a\b\u0002\r\u0011,G.\u001a;f)\u0015Y\u0017\u0011EA\u0012\u0011\u0019\u0011\u00171\u0004a\u0001G\"A\u0011\u0011DA\u000e\u0001\u0004\t)\u0003\u0005\u0003\u0012\u0003'\t\u0004bBA\u0015A\u0011\u0005\u00111F\u0001\u0005e\u0016\fG-\u0006\u0003\u0002.\u0005UBCBA\u0018\u00037\ni\u0006\u0006\u0003\u00022\u0005\u001d\u0003\u0003BA\u001a\u0003ka\u0001\u0001\u0002\u0005\u00028\u0005\u001d\"\u0019AA\u001d\u0005\u0005!\u0016\u0003BA\u001e\u0003\u0003\u00022!EA\u001f\u0013\r\tyD\u0005\u0002\b\u001d>$\b.\u001b8h!\r\t\u00121I\u0005\u0004\u0003\u000b\u0012\"aA!os\"Q\u0011\u0011JA\u0014\u0003\u0003\u0005\u001d!a\u0013\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002N\u0005]\u0013\u0011G\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005!!n]8o\u0015\t\t)&A\u0003taJ\f\u00170\u0003\u0003\u0002Z\u0005=#A\u0003&t_:4uN]7bi\"1!-a\nA\u0002\rDq!!\u0007\u0002(\u0001\u0007\u0011\u0007C\u0004\u0002b\u0001\"\t!a\u0019\u0002\u000fI,\u0017\rZ!mYV!\u0011QMA9)\u0011\t9'!\u001f\u0015\t\u0005%\u00141\u000f\t\u0007e\u0005-4-a\u001c\n\u0007\u000554HA\u0002NCB\u0004B!a\r\u0002r\u0011A\u0011qGA0\u0005\u0004\tI\u0004\u0003\u0006\u0002v\u0005}\u0013\u0011!a\u0002\u0003o\n!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\ti%a\u0016\u0002p!9\u0011\u0011DA0\u0001\u0004\t\u0004bBA?A\u0011\u0005\u0011qP\u0001\u0006oJLG/Z\u000b\u0005\u0003\u0003\u000bi\t\u0006\u0005\u0002\u0004\u0006=\u0015\u0011SAJ)\rY\u0017Q\u0011\u0005\u000b\u0003\u000f\u000bY(!AA\u0004\u0005%\u0015AC3wS\u0012,gnY3%gA1\u0011QJA,\u0003\u0017\u0003B!a\r\u0002\u000e\u0012A\u0011qGA>\u0005\u0004\tI\u0004\u0003\u0004c\u0003w\u0002\ra\u0019\u0005\b\u00033\tY\b1\u00012\u0011!\t)*a\u001fA\u0002\u0005-\u0015!\u0002<bYV,\u0007bBAMA\u0011\u0005\u00111T\u0001\fY\u0006LXM]#ySN$8\u000f\u0006\u0003\u0002\u001e\u0006\r\u0006cA\t\u0002 &\u0019\u0011\u0011\u0015\n\u0003\u000f\t{w\u000e\\3b]\"1!-a&A\u0002\rDq!!\b!\t\u0003\t9\u000bF\u0002l\u0003SCaAYAS\u0001\u0004\u0019\u0007bBA\u000fA\u0011\u0005\u0011Q\u0016\u000b\u0006W\u0006=\u0016\u0011\u0017\u0005\u0007E\u0006-\u0006\u0019A2\t\u000f\u0005e\u00111\u0016a\u0001c!9\u0011Q\u0017\u0011\u0005\u0002\u0005]\u0016\u0001\u00037bs\u0016\u0014\u0018\nZ:\u0016\u0005\u0005e\u0006\u0003\u0002?\u0002<\u000eLA!!0\u0002\b\t\u00191+Z9\t\u000f\u0005\u0005\u0007\u0005\"\u0001\u0002D\u0006\u0019\u0012M^1jY\u0006\u0014G.Z!uiJL'-\u001e;fgR!\u0011QYAd!\u0011a\u00181X\u0019\t\r\t\fy\f1\u0001d\u0011\u001d\tY\r\tC!\u0003\u001b\f1#\u0019<bS2\f'\r\\3[_>lG*\u001a<fYN$B!a4\u0002XB)A0a/\u0002RB\u0019\u0011#a5\n\u0007\u0005U'CA\u0002J]RDq!!7\u0002J\u0002\u0007\u0011'A\u0005mCf,'OT1nK\")q\u0005\ba\u0001S!1Q$\u0004C\u0001\u0003?$RaHAq\u0003GDaaJAo\u0001\u0004I\u0003BB\u0018\u0002^\u0002\u0007\u0011\u0007C\u0005\u0002h6\t\t\u0011\"\u0003\u0002j\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u000fE\u0002W\u0003[L1!a<X\u0005\u0019y%M[3di\u0002")
public class HBaseAttributeStore
implements DiscreteLayerAttributeStore {
    private final HBaseInstance instance;
    private final String attributeTable;
    private final TableName attributeTableName;
    private final String SEP;
    private transient Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache;
    private volatile transient boolean bitmap$trans$0;

    public static HBaseAttributeStore apply(HBaseInstance hBaseInstance, String string) {
        return HBaseAttributeStore$.MODULE$.apply(hBaseInstance, string);
    }

    public static HBaseAttributeStore apply(HBaseInstance hBaseInstance) {
        return HBaseAttributeStore$.MODULE$.apply(hBaseInstance);
    }

    public <K> Map<ZoomRange, KeyIndex<K>> readKeyIndexes(LayerId id, ClassTag<K> evidence$32) {
        return DiscreteLayerAttributeStore.readKeyIndexes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$32);
    }

    public <H> H readHeader(LayerId id, JsonFormat<H> evidence$33) {
        return (H)DiscreteLayerAttributeStore.readHeader$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$33);
    }

    public <M> M readMetadata(LayerId id, JsonFormat<M> evidence$34) {
        return (M)DiscreteLayerAttributeStore.readMetadata$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$34);
    }

    public <K> KeyIndex<K> readKeyIndex(LayerId id, ClassTag<K> evidence$35) {
        return DiscreteLayerAttributeStore.readKeyIndex$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$35);
    }

    public Schema readSchema(LayerId id) {
        return DiscreteLayerAttributeStore.readSchema$((DiscreteLayerAttributeStore)this, (LayerId)id);
    }

    public <H, M, K> LayerAttributes<H, M, K> readLayerAttributes(LayerId id, JsonFormat<H> evidence$36, JsonFormat<M> evidence$37, ClassTag<K> evidence$38) {
        return DiscreteLayerAttributeStore.readLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$36, evidence$37, evidence$38);
    }

    public <H, M, K> void writeLayerAttributes(LayerId id, H header, M metadata, KeyIndex<K> keyIndex, Schema schema, JsonFormat<H> evidence$39, JsonFormat<M> evidence$40, ClassTag<K> evidence$41) {
        DiscreteLayerAttributeStore.writeLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, header, metadata, keyIndex, (Schema)schema, evidence$39, evidence$40, evidence$41);
    }

    public <H, M> COGLayerAttributes<H, M> readCOGLayerAttributes(LayerId id, JsonFormat<H> evidence$42, JsonFormat<M> evidence$43) {
        return DiscreteLayerAttributeStore.readCOGLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, evidence$42, evidence$43);
    }

    public <H, M> void writeCOGLayerAttributes(LayerId id, H header, M metadata, JsonFormat<H> evidence$44, JsonFormat<M> evidence$45) {
        DiscreteLayerAttributeStore.writeCOGLayerAttributes$((DiscreteLayerAttributeStore)this, (LayerId)id, header, metadata, evidence$44, evidence$45);
    }

    public boolean isCOGLayer(LayerId id) {
        return AttributeStore.isCOGLayer$((AttributeStore)this, (LayerId)id);
    }

    public LayerType layerType(LayerId id) {
        return AttributeStore.layerType$((AttributeStore)this, (LayerId)id);
    }

    public Map<String, Seq<Object>> layersWithZoomLevels() {
        return AttributeStore.layersWithZoomLevels$((AttributeStore)this);
    }

    public void copy(LayerId from, LayerId to) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to);
    }

    public void copy(LayerId from, LayerId to, Seq<String> attributes) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to, attributes);
    }

    public <T> T cacheRead(LayerId layerId, String attributeName, JsonFormat<T> evidence$1) {
        return (T)AttributeCaching.cacheRead$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, evidence$1);
    }

    public LayerType cacheLayerType(LayerId layerId, LayerType layerType) {
        return AttributeCaching.cacheLayerType$((AttributeCaching)this, (LayerId)layerId, (LayerType)layerType);
    }

    public <T> void cacheWrite(LayerId layerId, String attributeName, T value, JsonFormat<T> evidence$2) {
        AttributeCaching.cacheWrite$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, value, evidence$2);
    }

    public void clearCache() {
        AttributeCaching.clearCache$((AttributeCaching)this);
    }

    public void clearCache(LayerId id) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id);
    }

    public void clearCache(LayerId id, String attribute) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id, (String)attribute);
    }

    private Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache$lzycompute() {
        HBaseAttributeStore hBaseAttributeStore = this;
        synchronized (hBaseAttributeStore) {
            if (!this.bitmap$trans$0) {
                this.geotrellis$spark$io$AttributeCaching$$cache = AttributeCaching.geotrellis$spark$io$AttributeCaching$$cache$((AttributeCaching)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.geotrellis$spark$io$AttributeCaching$$cache;
    }

    public Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache() {
        return !this.bitmap$trans$0 ? this.geotrellis$spark$io$AttributeCaching$$cache$lzycompute() : this.geotrellis$spark$io$AttributeCaching$$cache;
    }

    public HBaseInstance instance() {
        return this.instance;
    }

    public String attributeTable() {
        return this.attributeTable;
    }

    private TableName attributeTableName() {
        return this.attributeTableName;
    }

    public String SEP() {
        return this.SEP;
    }

    public String layerIdString(LayerId layerId) {
        return new StringBuilder(0).append(layerId.name()).append(this.SEP()).append(layerId.zoom()).toString();
    }

    private void addColumn(Table table, String cf) {
        block0: {
            if (table.getDescriptor().hasColumnFamily(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(cf))) break block0;
            this.instance().getAdmin().addColumnFamily(this.attributeTableName(), ColumnFamilyDescriptorBuilder.of((String)cf));
        }
    }

    private Vector<Result> fetch(Option<LayerId> layerId, String attributeName) {
        return (Vector)this.instance().withTableConnectionDo(this.attributeTableName(), (Function1 & Serializable & scala.Serializable)table -> {
            Vector vector;
            if (table.getDescriptor().hasColumnFamily(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(attributeName))) {
                Scan scan = new Scan();
                layerId.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    scan.withStartRow(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(this.layerIdString((LayerId)id)), true);
                    return scan.withStopRow(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(this.layerIdString((LayerId)id)), true);
                });
                scan.addFamily(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(attributeName));
                try (ResultScanner scanner = table.getScanner(scan);){
                    vector = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).toVector();
                }
            } else {
                vector = (Vector)scala.package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
            }
            return vector;
        });
    }

    private void delete(LayerId layerId, Option<String> attributeName) {
        this.instance().withTableConnectionDo(this.attributeTableName(), (Function1 & Serializable & scala.Serializable)table -> {
            HBaseAttributeStore.$anonfun$delete$1(this, layerId, attributeName, table);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T read(LayerId layerId, String attributeName, JsonFormat<T> evidence$1) {
        Vector<Result> values = this.fetch((Option<LayerId>)new Some((Object)layerId), attributeName);
        if (values.isEmpty()) {
            throw new package.AttributeNotFoundError(attributeName, layerId);
        }
        if (values.size() > 1) {
            throw new package.LayerIOError(new StringBuilder(41).append("Multiple attributes found for ").append(attributeName).append(" for layer ").append(layerId).toString());
        }
        return (T)((Tuple2)spray.json.package$.MODULE$.enrichString(Bytes.toString((byte[])((Result)values.head()).getValue(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(attributeName), geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes("")))).parseJson().convertTo((JsonReader)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$1)))._2();
    }

    public <T> Map<LayerId, T> readAll(String attributeName, JsonFormat<T> evidence$2) {
        return ((TraversableOnce)this.fetch((Option<LayerId>)None$.MODULE$, attributeName).map((Function1 & Serializable & scala.Serializable)row -> (Tuple2)spray.json.package$.MODULE$.enrichString(Bytes.toString((byte[])row.getValue(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(attributeName), geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes("")))).parseJson().convertTo((JsonReader)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$2)), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public <T> void write(LayerId layerId, String attributeName, T value, JsonFormat<T> evidence$3) {
        this.instance().withTableConnectionDo(this.attributeTableName(), (Function1 & Serializable & scala.Serializable)table -> {
            HBaseAttributeStore.$anonfun$write$1(this, layerId, attributeName, value, evidence$3, table);
            return BoxedUnit.UNIT;
        });
    }

    public boolean layerExists(LayerId layerId) {
        return this.fetch((Option<LayerId>)new Some((Object)layerId), AttributeStore.Fields$.MODULE$.metadata()).nonEmpty();
    }

    public void delete(LayerId layerId) {
        this.delete(layerId, (Option<String>)None$.MODULE$);
    }

    public void delete(LayerId layerId, String attributeName) {
        this.delete(layerId, (Option<String>)new Some((Object)attributeName));
    }

    public Seq<LayerId> layerIds() {
        return (Seq)this.instance().withTableConnectionDo(this.attributeTableName(), (Function1 & Serializable & scala.Serializable)table -> {
            Seq seq;
            try (ResultScanner scanner = table.getScanner(new Scan());){
                seq = (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> {
                    List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Bytes.toString((byte[])kv.getRow()).split(this.SEP()))).toList();
                    Some some = List$.MODULE$.unapplySeq((Seq)list);
                    if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) {
                        throw new MatchError((Object)list);
                    }
                    String name = (String)((LinearSeqOptimized)some.get()).apply(0);
                    String zoomStr = (String)((LinearSeqOptimized)some.get()).apply(1);
                    Tuple2 tuple2 = new Tuple2((Object)name, (Object)zoomStr);
                    Tuple2 tuple22 = tuple2;
                    String name2 = (String)tuple22._1();
                    String zoomStr2 = (String)tuple22._2();
                    return new LayerId(name2, new StringOps(Predef$.MODULE$.augmentString(zoomStr2)).toInt());
                }).toList().distinct();
            }
            return seq;
        });
    }

    public Seq<String> availableAttributes(LayerId layerId) {
        return (Seq)this.instance().withTableConnectionDo(this.attributeTableName(), (Function1 & Serializable & scala.Serializable)x$3 -> ((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(x$3.getDescriptor().getColumnFamilyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> Bytes.toString((byte[])x$1), Set$.MODULE$.canBuildFrom())).toSeq());
    }

    public Seq<Object> availableZoomLevels(String layerName) {
        return (Seq)this.instance().withTableConnectionDo(this.attributeTableName(), (Function1 & Serializable & scala.Serializable)table -> {
            Seq seq;
            Scan scan = new Scan();
            FilterList filter = new FilterList(new Filter[]{new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(new StringBuilder(2).append(layerName).append(this.SEP()).append(".*").toString()))});
            scan.setFilter((Filter)filter);
            try (ResultScanner scanner = table.getScanner(scan);){
                seq = (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToInteger((int)HBaseAttributeStore.$anonfun$availableZoomLevels$2(this, kv))).toList().distinct();
            }
            return seq;
        });
    }

    public static final /* synthetic */ void $anonfun$new$1(HBaseAttributeStore $this, Admin admin) {
        block0: {
            if (admin.tableExists($this.attributeTableName())) break block0;
            ColumnFamilyDescriptor headerColumnFamilyDesc = ColumnFamilyDescriptorBuilder.of((String)AttributeStore.Fields$.MODULE$.header());
            TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)$this.attributeTableName()).setColumnFamily(headerColumnFamilyDesc).build();
            admin.createTable(tableDesc);
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(HBaseAttributeStore $this, LayerId layerId$2, Option attributeName$2, Table table) {
        Delete delete = new Delete(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes($this.layerIdString(layerId$2)));
        attributeName$2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> delete.addFamily(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes((String)x$1)));
        table.delete(delete);
        Option option = attributeName$2;
        if (option instanceof Some) {
            Some some = (Some)option;
            String attribute = (String)some.value();
            TableDescriptorBuilder.newBuilder((TableDescriptor)table.getDescriptor()).removeColumnFamily(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(attribute)).build();
            $this.clearCache(layerId$2, attribute);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            $this.clearCache(layerId$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$write$1(HBaseAttributeStore $this, LayerId layerId$3, String attributeName$4, Object value$1, JsonFormat evidence$3$1, Table table) {
        $this.addColumn(table, attributeName$4);
        Put put = new Put(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes($this.layerIdString(layerId$3)));
        put.addColumn(geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(attributeName$4), geotrellis.spark.io.hbase.package$.MODULE$.stringToBytes(""), System.currentTimeMillis(), spray.json.package$.MODULE$.enrichAny((Object)new Tuple2((Object)layerId$3, value$1)).toJson((JsonWriter)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$3$1)).compactPrint().getBytes());
        table.put(put);
    }

    public static final /* synthetic */ int $anonfun$availableZoomLevels$2(HBaseAttributeStore $this, Result kv) {
        String zoomStr;
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Bytes.toString((byte[])kv.getRow()).split($this.SEP()))).toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)list);
        }
        String string = zoomStr = (String)((LinearSeqOptimized)some.get()).apply(1);
        String zoomStr2 = string;
        return new StringOps(Predef$.MODULE$.augmentString(zoomStr2)).toInt();
    }

    public HBaseAttributeStore(HBaseInstance instance, String attributeTable) {
        this.instance = instance;
        this.attributeTable = attributeTable;
        AttributeCaching.$init$((AttributeCaching)this);
        AttributeStore.$init$((AttributeStore)this);
        DiscreteLayerAttributeStore.$init$((DiscreteLayerAttributeStore)this);
        this.attributeTableName = geotrellis.spark.io.hbase.package$.MODULE$.stringToTableName(attributeTable);
        instance.withAdminDo((Function1 & Serializable & scala.Serializable)admin -> {
            HBaseAttributeStore.$anonfun$new$1(this, admin);
            return BoxedUnit.UNIT;
        });
        this.SEP = HBaseRDDWriter$.MODULE$.SEP();
    }
}

