/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hbase;

import geotrellis.spark.Boundable;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.KeyBounds$;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.avro.AvroEncoder$;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec$;
import geotrellis.spark.io.hbase.HBaseInstance;
import geotrellis.spark.io.hbase.HBaseKeyEncoder$;
import geotrellis.spark.io.hbase.HBaseRDDWriter$;
import geotrellis.spark.io.hbase.package$;
import geotrellis.spark.io.index.MergeQueue$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HBaseCollectionReader$ {
    public static HBaseCollectionReader$ MODULE$;

    static {
        new HBaseCollectionReader$();
    }

    public <K, V> Seq<Tuple2<K, V>> read(HBaseInstance instance, String table, LayerId layerId, Seq<KeyBounds<K>> queryKeyBounds, Function1<KeyBounds<K>, Seq<Tuple2<BigInt, BigInt>>> decomposeBounds, boolean filterIndexOnly, Option<Schema> writerSchema, Option<Object> numPartitions, Boundable<K> evidence$1, AvroRecordCodec<K> evidence$2, ClassTag<K> evidence$3, AvroRecordCodec<V> evidence$4, ClassTag<V> evidence$5) {
        if (queryKeyBounds.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Function1 & Serializable & scala.Serializable includeKey = (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)HBaseCollectionReader$.$anonfun$read$1(queryKeyBounds, evidence$1, key));
        KeyValueRecordCodec _recordCodec = KeyValueRecordCodec$.MODULE$.apply(evidence$2, evidence$4);
        KryoWrapper kwWriterSchema = KryoWrapper$.MODULE$.apply(writerSchema, ClassTag$.MODULE$.apply(Option.class));
        Seq ranges = queryKeyBounds.length() > 1 ? MergeQueue$.MODULE$.apply((TraversableOnce)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom())) : (Seq)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom());
        Scan scan = new Scan();
        scan.addFamily(package$.MODULE$.stringToBytes(HBaseRDDWriter$.MODULE$.tilesCF()));
        scan.setFilter((Filter)new FilterList(new Filter[]{new PrefixFilter(package$.MODULE$.stringToBytes(HBaseRDDWriter$.MODULE$.layerIdString(layerId))), new MultiRowRangeFilter(Arrays.asList((Object[])((TraversableOnce)ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BigInt start = (BigInt)tuple2._1();
            BigInt stop = (BigInt)tuple2._2();
            MultiRowRangeFilter.RowRange rowRange = new MultiRowRangeFilter.RowRange(HBaseKeyEncoder$.MODULE$.encode(layerId, start, HBaseKeyEncoder$.MODULE$.encode$default$3()), true, HBaseKeyEncoder$.MODULE$.encode(layerId, stop, HBaseKeyEncoder$.MODULE$.encode$default$3()), true);
            return rowRange;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(MultiRowRangeFilter.RowRange.class))))}));
        return (Seq)instance.withTableConnectionDo(package$.MODULE$.stringToTableName(table), (Function1 & Serializable & scala.Serializable)tableConnection -> {
            Vector vector;
            try (ResultScanner scanner = tableConnection.getScanner(scan);){
                vector = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)row2 -> {
                    byte[] bytes = row2.getValue(package$.MODULE$.stringToBytes(HBaseRDDWriter$.MODULE$.tilesCF()), package$.MODULE$.stringToBytes(""));
                    Vector recs = (Vector)AvroEncoder$.MODULE$.fromBinary((Schema)((Option)kwWriterSchema.value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> _recordCodec.schema()), bytes, (AvroRecordCodec)_recordCodec);
                    return filterIndexOnly ? recs : (Vector)recs.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)HBaseCollectionReader$.$anonfun$read$6(includeKey, row)));
                }).toVector();
            }
            return vector;
        });
    }

    public <K, V> Option<Schema> read$default$7() {
        return None$.MODULE$;
    }

    public <K, V> Option<Object> read$default$8() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$read$1(Seq queryKeyBounds$1, Boundable evidence$1$1, Object key) {
        return KeyBounds$.MODULE$.KeyBoundsSeqMethods(queryKeyBounds$1, evidence$1$1).includeKey(key);
    }

    public static final /* synthetic */ boolean $anonfun$read$6(Function1 includeKey$1, Tuple2 row) {
        return BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply(row._1()));
    }

    private HBaseCollectionReader$() {
        MODULE$ = this;
    }
}

