/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hbase;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.LayerDeleter;
import geotrellis.spark.io.hbase.HBaseAttributeStore;
import geotrellis.spark.io.hbase.HBaseInstance;
import geotrellis.spark.io.hbase.HBaseLayerDeleter$;
import geotrellis.spark.io.hbase.HBaseLayerHeader;
import geotrellis.spark.io.hbase.HBaseLayerHeader$CassandraLayerMetadataFormat$;
import geotrellis.spark.io.hbase.HBaseRDDWriter$;
import geotrellis.spark.io.hbase.package$;
import geotrellis.spark.io.package;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spray.json.JsonFormat;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u0017\t\t\u0002JQ1tK2\u000b\u00170\u001a:EK2,G/\u001a:\u000b\u0005\r!\u0011!\u00025cCN,'BA\u0003\u0007\u0003\tIwN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\t\u0011\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007cA\n\u0015-5\tA!\u0003\u0002\u0016\t\taA*Y=fe\u0012+G.\u001a;feB\u0011q\u0003G\u0007\u0002\r%\u0011\u0011D\u0002\u0002\b\u0019\u0006LXM]%e\u0011!Y\u0002A!b\u0001\n\u0003a\u0012AD1uiJL'-\u001e;f'R|'/Z\u000b\u0002;A\u00111CH\u0005\u0003?\u0011\u0011a\"\u0011;ue&\u0014W\u000f^3Ti>\u0014X\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001e\u0003=\tG\u000f\u001e:jEV$Xm\u0015;pe\u0016\u0004\u0003\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0011%t7\u000f^1oG\u0016\u0004\"!\n\u0014\u000e\u0003\tI!a\n\u0002\u0003\u001b!\u0013\u0015m]3J]N$\u0018M\\2f\u0011\u0015I\u0003\u0001\"\u0001+\u0003\u0019a\u0014N\\5u}Q\u00191\u0006L\u0017\u0011\u0005\u0015\u0002\u0001\"B\u000e)\u0001\u0004i\u0002\"B\u0012)\u0001\u0004!\u0003\"B\u0018\u0001\t\u0003\u0001\u0014A\u00023fY\u0016$X\r\u0006\u00022iA\u0011QBM\u0005\u0003g9\u0011A!\u00168ji\")QG\fa\u0001-\u0005\u0011\u0011\u000e\u001a\u0005\to\u0001A)\u0019!C\tq\u00051An\\4hKJ,\u0012!\u000f\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\nAb]2bY\u0006dwnZ4j]\u001eT!AP \u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001Q\u0001\u0004G>l\u0017B\u0001\"<\u0005\u0019aunZ4fe\"\u0012a\u0007\u0012\t\u0003\u001b\u0015K!A\u0012\b\u0003\u0013Q\u0014\u0018M\\:jK:$x!\u0002%\u0003\u0011\u0003I\u0015!\u0005%CCN,G*Y=fe\u0012+G.\u001a;feB\u0011QE\u0013\u0004\u0006\u0003\tA\taS\n\u0003\u00152AQ!\u000b&\u0005\u00025#\u0012!\u0013\u0005\u0006\u001f*#\t\u0001U\u0001\u0006CB\u0004H.\u001f\u000b\u0004WE\u0013\u0006\"B\u000eO\u0001\u0004i\u0002\"B\u0012O\u0001\u0004!\u0003\"B(K\t\u0003!FCA\u0016V\u0011\u0015Y2\u000b1\u0001W!\t)s+\u0003\u0002Y\u0005\t\u0019\u0002JQ1tK\u0006#HO]5ckR,7\u000b^8sK\")qJ\u0013C\u00015R\u00111f\u0017\u0005\u0006Ge\u0003\r\u0001\n")
public class HBaseLayerDeleter
implements LayerDeleter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final HBaseInstance instance;
    private volatile transient boolean bitmap$trans$0;

    public static HBaseLayerDeleter apply(HBaseInstance hBaseInstance) {
        return HBaseLayerDeleter$.MODULE$.apply(hBaseInstance);
    }

    public static HBaseLayerDeleter apply(HBaseAttributeStore hBaseAttributeStore) {
        return HBaseLayerDeleter$.MODULE$.apply(hBaseAttributeStore);
    }

    public static HBaseLayerDeleter apply(AttributeStore attributeStore, HBaseInstance hBaseInstance) {
        return HBaseLayerDeleter$.MODULE$.apply(attributeStore, hBaseInstance);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        HBaseLayerDeleter hBaseLayerDeleter = this;
        synchronized (hBaseLayerDeleter) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void delete(LayerId id) {
        try {
            try {
                HBaseLayerHeader header = (HBaseLayerHeader)this.attributeStore().readHeader(id, (JsonFormat)HBaseLayerHeader$CassandraLayerMetadataFormat$.MODULE$);
                ArrayList list = new ArrayList();
                Scan scan = new Scan();
                scan.addFamily(package$.MODULE$.stringToBytes(HBaseRDDWriter$.MODULE$.tilesCF()));
                scan.setFilter((Filter)new PrefixFilter(package$.MODULE$.stringToBytes(HBaseRDDWriter$.MODULE$.layerIdString(id))));
                this.instance.withTableConnectionDo(package$.MODULE$.stringToTableName(header.tileTable()), (Function1 & Serializable & scala.Serializable)table -> {
                    HBaseLayerDeleter.$anonfun$delete$1(list, scan, table);
                    return BoxedUnit.UNIT;
                });
            }
            catch (package.AttributeNotFoundError e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Metadata for {} was not found. Any associated layer data (if any) will require manual deletion", new Object[]{id});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new package.LayerDeleteError(id).initCause((Throwable)e);
            }
        }
        finally {
            this.attributeStore().delete(id);
        }
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(ArrayList list$1, Result kv) {
        Delete delete = new Delete(kv.getRow());
        delete.addFamily(package$.MODULE$.stringToBytes(HBaseRDDWriter$.MODULE$.tilesCF()));
        return list$1.add(delete);
    }

    public static final /* synthetic */ void $anonfun$delete$1(ArrayList list$1, Scan scan$1, Table table) {
        try (ResultScanner scanner = table.getScanner(scan$1);){
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)HBaseLayerDeleter.$anonfun$delete$2(list$1, kv)));
        }
        table.delete((List)list$1);
    }

    public HBaseLayerDeleter(AttributeStore attributeStore, HBaseInstance instance) {
        this.attributeStore = attributeStore;
        this.instance = instance;
    }
}

