/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hbase;

import geotrellis.spark.LayerId;
import geotrellis.spark.io.LayerWriter$;
import geotrellis.spark.io.avro.AvroEncoder$;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec$;
import geotrellis.spark.io.hbase.HBaseInstance;
import geotrellis.spark.io.hbase.HBaseKeyEncoder$;
import geotrellis.spark.io.hbase.package$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class HBaseRDDWriter$ {
    public static HBaseRDDWriter$ MODULE$;
    private final String tilesCF;
    private final String SEP;

    static {
        new HBaseRDDWriter$();
    }

    public String tilesCF() {
        return this.tilesCF;
    }

    public String SEP() {
        return this.SEP;
    }

    public String layerIdString(LayerId layerId) {
        return new StringBuilder(1).append(layerId.name()).append(this.SEP()).append(layerId.zoom()).append("|").toString();
    }

    public <K, V> void write(RDD<Tuple2<K, V>> raster, HBaseInstance instance, LayerId layerId, Function1<K, BigInt> decomposeKey, String table, AvroRecordCodec<K> evidence$1, AvroRecordCodec<V> evidence$2) {
        this.update(raster, instance, layerId, decomposeKey, table, (Option<Schema>)None$.MODULE$, (Option<Function2<V, V, V>>)None$.MODULE$, evidence$1, evidence$2);
    }

    public <K, V> void update(RDD<Tuple2<K, V>> raster, HBaseInstance instance, LayerId layerId, Function1<K, BigInt> decomposeKey, String table, Option<Schema> writerSchema, Option<Function2<V, V, V>> mergeFunc, AvroRecordCodec<K> evidence$3, AvroRecordCodec<V> evidence$4) {
        SparkContext sc = raster.sparkContext();
        KeyValueRecordCodec codec = KeyValueRecordCodec$.MODULE$.apply(evidence$3, evidence$4);
        instance.withAdminDo((Function1 & Serializable & scala.Serializable)admin -> {
            HBaseRDDWriter$.$anonfun$update$1(table, admin);
            return BoxedUnit.UNIT;
        });
        KeyValueRecordCodec _recordCodec = KeyValueRecordCodec$.MODULE$.apply(evidence$3, evidence$4);
        KryoWrapper kwWriterSchema = KryoWrapper$.MODULE$.apply(writerSchema, ClassTag$.MODULE$.apply(Option.class));
        raster.groupBy((Function1 & Serializable & scala.Serializable)row -> (BigInt)decomposeKey.apply(row._1()), raster.partitions().length, ClassTag$.MODULE$.apply(BigInt.class)).foreachPartition((Function1 & Serializable & scala.Serializable)partition -> {
            HBaseRDDWriter$.$anonfun$update$3(instance, layerId, table, mergeFunc, codec, _recordCodec, kwWriterSchema, partition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(String table$1, Admin admin) {
        block0: {
            if (admin.tableExists(package$.MODULE$.stringToTableName(table$1))) break block0;
            ColumnFamilyDescriptor idsColumnFamilyDesc = ColumnFamilyDescriptorBuilder.of((String)MODULE$.tilesCF());
            TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)package$.MODULE$.stringToTableName(table$1)).setColumnFamily(idsColumnFamilyDesc).build();
            admin.createTable(tableDesc);
        }
    }

    public static final /* synthetic */ void $anonfun$update$5(LayerId layerId$1, Option mergeFunc$1, KeyValueRecordCodec codec$1, KeyValueRecordCodec _recordCodec$1, KryoWrapper kwWriterSchema$1, BufferedMutator mutator$1, Table tableConnection$1, Tuple2 recs) {
        BigInt id = (BigInt)recs._1();
        Vector current = ((TraversableOnce)recs._2()).toVector();
        Vector updated = LayerWriter$.MODULE$.updateRecords(mergeFunc$1, current, (Function0 & Serializable & scala.Serializable)() -> {
            Scan scan = new Scan();
            scan.addFamily(package$.MODULE$.stringToBytes(MODULE$.tilesCF()));
            FilterList filter = new FilterList(new Filter[]{new PrefixFilter(package$.MODULE$.stringToBytes(MODULE$.layerIdString(layerId$1))), new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(HBaseKeyEncoder$.MODULE$.encode(layerId$1, id, HBaseKeyEncoder$.MODULE$.encode$default$3())))});
            scan.setFilter((Filter)filter);
            ResultScanner scanner = tableConnection$1.getScanner(scan);
            Vector results = (Vector)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).toVector().flatMap((Function1 & Serializable & scala.Serializable)result -> {
                byte[] bytes = result.getValue(package$.MODULE$.stringToBytes(MODULE$.tilesCF()), package$.MODULE$.stringToBytes(""));
                Schema schema = (Schema)((Option)kwWriterSchema$1.value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> _recordCodec$1.schema());
                return (Vector)AvroEncoder$.MODULE$.fromBinary(schema, bytes, (AvroRecordCodec)_recordCodec$1);
            }, Vector$.MODULE$.canBuildFrom());
            scanner.close();
            return results;
        });
        byte[] bytes = AvroEncoder$.MODULE$.toBinary((Object)updated, (AvroRecordCodec)codec$1);
        Put put = new Put(HBaseKeyEncoder$.MODULE$.encode(layerId$1, id, HBaseKeyEncoder$.MODULE$.encode$default$3()));
        put.addColumn(package$.MODULE$.stringToBytes(MODULE$.tilesCF()), package$.MODULE$.stringToBytes(""), System.currentTimeMillis(), bytes);
        mutator$1.mutate((Mutation)put);
    }

    public static final /* synthetic */ void $anonfun$update$4(LayerId layerId$1, String table$1, Option mergeFunc$1, KeyValueRecordCodec codec$1, KeyValueRecordCodec _recordCodec$1, KryoWrapper kwWriterSchema$1, Iterator partition$1, Connection connection) {
        BufferedMutator mutator = connection.getBufferedMutator(package$.MODULE$.stringToTableName(table$1));
        Table tableConnection = connection.getTable(package$.MODULE$.stringToTableName(table$1));
        partition$1.foreach((Function1 & Serializable & scala.Serializable)recs -> {
            HBaseRDDWriter$.$anonfun$update$5(layerId$1, mergeFunc$1, codec$1, _recordCodec$1, kwWriterSchema$1, mutator, tableConnection, recs);
            return BoxedUnit.UNIT;
        });
        tableConnection.close();
        mutator.flush();
        mutator.close();
    }

    public static final /* synthetic */ void $anonfun$update$3(HBaseInstance instance$1, LayerId layerId$1, String table$1, Option mergeFunc$1, KeyValueRecordCodec codec$1, KeyValueRecordCodec _recordCodec$1, KryoWrapper kwWriterSchema$1, Iterator partition) {
        block0: {
            if (!partition.nonEmpty()) break block0;
            instance$1.withConnectionDo((Function1 & Serializable & scala.Serializable)connection -> {
                HBaseRDDWriter$.$anonfun$update$4(layerId$1, table$1, mergeFunc$1, codec$1, _recordCodec$1, kwWriterSchema$1, partition, connection);
                return BoxedUnit.UNIT;
            });
        }
    }

    private HBaseRDDWriter$() {
        MODULE$ = this;
        this.tilesCF = "tiles";
        this.SEP = "__.__";
    }
}

