/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer;

import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutTileSource;
import geotrellis.layer.SpaceTimeKey;
import geotrellis.layer.SpaceTimeKey$;
import geotrellis.layer.SpatialKey;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterSource;
import geotrellis.util.Component;
import geotrellis.util.package$;
import org.scalactic.Tolerance$;
import org.scalactic.TripleEquals$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class LayoutTileSource$ {
    public static LayoutTileSource$ MODULE$;

    static {
        new LayoutTileSource$();
    }

    public <K> LayoutTileSource<K> apply(RasterSource source, LayoutDefinition layout, Function1<SpatialKey, K> tileKeyTransform, Component<K, SpatialKey> evidence$2) {
        return new LayoutTileSource<K>(source, layout, tileKeyTransform, evidence$2);
    }

    public LayoutTileSource<SpatialKey> spatial(RasterSource source, LayoutDefinition layout) {
        return new LayoutTileSource<SpatialKey>(source, layout, (Function1 & java.io.Serializable & Serializable)x -> (SpatialKey)Predef$.MODULE$.identity(x), package$.MODULE$.identityComponent());
    }

    public LayoutTileSource<SpaceTimeKey> temporal(RasterSource source, LayoutDefinition layout, Function1<SpatialKey, SpaceTimeKey> tileKeyTransform) {
        return new LayoutTileSource<SpaceTimeKey>(source, layout, tileKeyTransform, SpaceTimeKey$.MODULE$.spatialComponent());
    }

    public void geotrellis$layer$LayoutTileSource$$requireGridAligned(GridExtent<Object> a, GridExtent<Object> b) {
        double epsX = scala.math.package$.MODULE$.min(a.cellwidth(), b.cellwidth()) * 0.01;
        double epsY = scala.math.package$.MODULE$.min(a.cellheight(), b.cellheight()) * 0.01;
        Predef$.MODULE$.require(TripleEquals$.MODULE$.convertToEqualizer((Object)BoxesRunTime.boxToDouble((double)a.cellwidth())).$eq$eq$eq(Tolerance$.MODULE$.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToDouble((double)b.cellwidth()), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)epsX))) && TripleEquals$.MODULE$.convertToEqualizer((Object)BoxesRunTime.boxToDouble((double)a.cellheight())).$eq$eq$eq(Tolerance$.MODULE$.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToDouble((double)b.cellheight()), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)epsY))), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("CellSize differs: ").append(a.cellSize()).append(", ").append(b.cellSize()).toString());
        long deltaX = scala.math.package$.MODULE$.round((a.extent().xmin() - b.extent().xmin()) / b.cellwidth());
        long deltaY = scala.math.package$.MODULE$.round((a.extent().ymin() - b.extent().ymin()) / b.cellheight());
        double resultX = (double)deltaX * b.cellwidth() + b.extent().xmin();
        double resultY = (double)deltaY * b.cellheight() + b.extent().ymin();
        Predef$.MODULE$.require(TripleEquals$.MODULE$.convertToEqualizer((Object)BoxesRunTime.boxToDouble((double)a.extent().xmin())).$eq$eq$eq(Tolerance$.MODULE$.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToDouble((double)resultX), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)epsX))), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(22).append("x-aligned: offset by ").append(a.cellSize()).append(" ").append(LayoutTileSource$.offset$1(a.extent().xmin(), resultX, a.cellwidth())).toString());
        Predef$.MODULE$.require(TripleEquals$.MODULE$.convertToEqualizer((Object)BoxesRunTime.boxToDouble((double)a.extent().ymin())).$eq$eq$eq(Tolerance$.MODULE$.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToDouble((double)resultY), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)epsY))), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(22).append("y-aligned: offset by ").append(a.cellSize()).append(" ").append(LayoutTileSource$.offset$1(a.extent().ymin(), resultY, a.cellheight())).toString());
    }

    private static final double offset$1(double a, double b, double w) {
        double cols = (a - b) / w;
        return cols - scala.math.package$.MODULE$.floor(cols);
    }

    private LayoutTileSource$() {
        MODULE$ = this;
    }
}

