/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer;

import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutTileSource$;
import geotrellis.layer.SpaceTimeKey;
import geotrellis.layer.SpatialKey;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.GridExtent;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.PaddedTile;
import geotrellis.raster.RasterRegion;
import geotrellis.raster.RasterRegion$;
import geotrellis.raster.RasterSource;
import geotrellis.raster.Tile;
import geotrellis.util.Component;
import geotrellis.util.package$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyDouble;
import scala.runtime.RichInt$;
import spire.math.Integral;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005U!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00034\u0011!A\u0004A!b\u0001\n\u0003I\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u00111\u0003!1!Q\u0001\f5CQ\u0001\u0016\u0001\u0005\u0002UCQ\u0001\u0018\u0001\u0005\u0002uCQ!\u0019\u0001\u0005\u0002uCQA\u0019\u0001\u0005\u0002\rDQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001c\u0001\u0005\u0002MDq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\f\u0001!\t!a\t\t\u000f\u0005-\u0001\u0001\"\u0001\u0002(!9\u0011Q\u0004\u0001\u0005\u0002\u0005%\u0002bBA\u001e\u0001\u0011\u0005\u0011QH\u0004\b\u0003\u0007Z\u0002\u0012AA#\r\u0019Q2\u0004#\u0001\u0002H!1A\u000b\u0006C\u0001\u0003\u0013Bq!a\u0013\u0015\t\u0003\ti\u0005C\u0004\u0002hQ!\t!!\u001b\t\u000f\u0005ED\u0003\"\u0001\u0002t!9\u0011Q\u0011\u000b\u0005\n\u0005\u001d%\u0001\u0005'bs>,H\u000fV5mKN{WO]2f\u0015\taR$A\u0003mCf,'OC\u0001\u001f\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001+\t\t#i\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\faa]8ve\u000e,W#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00055j\u0012A\u0002:bgR,'/\u0003\u00020Y\ta!+Y:uKJ\u001cv.\u001e:dK\u000691o\\;sG\u0016\u0004\u0013A\u00027bs>,H/F\u00014!\t!T'D\u0001\u001c\u0013\t14D\u0001\tMCf|W\u000f\u001e#fM&t\u0017\u000e^5p]\u00069A.Y=pkR\u0004\u0013\u0001\u0005;jY\u0016\\U-\u001f+sC:\u001chm\u001c:n+\u0005Q\u0004\u0003B\u0012<{\u0001K!\u0001\u0010\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u001b?\u0013\ty4D\u0001\u0006Ta\u0006$\u0018.\u00197LKf\u0004\"!\u0011\"\r\u0001\u0011)1\t\u0001b\u0001\t\n\t1*\u0005\u0002F\u0011B\u00111ER\u0005\u0003\u000f\u0012\u0012qAT8uQ&tw\r\u0005\u0002$\u0013&\u0011!\n\n\u0002\u0004\u0003:L\u0018!\u0005;jY\u0016\\U-\u001f+sC:\u001chm\u001c:nA\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u00079\u000b\u0006I\u0004\u00025\u001f&\u0011\u0001kG\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116K\u0001\tTa\u0006$\u0018.\u00197D_6\u0004xN\\3oi*\u0011\u0001kG\u0001\u0007y%t\u0017\u000e\u001e \u0015\tYK&l\u0017\u000b\u0003/b\u00032\u0001\u000e\u0001A\u0011\u0015a\u0005\u0002q\u0001N\u0011\u0015A\u0003\u00021\u0001+\u0011\u0015\t\u0004\u00021\u00014\u0011\u0015A\u0004\u00021\u0001;\u0003=\u0019x.\u001e:dK\u000e{Gn\u00144gg\u0016$X#\u00010\u0011\u0005\rz\u0016B\u00011%\u0005\u0011auN\\4\u0002\u001fM|WO]2f%><xJ\u001a4tKR\f!C]1ti\u0016\u0014(+Z4j_:4uN]&fsR\u0011AM\u001b\t\u0004G\u0015<\u0017B\u00014%\u0005\u0019y\u0005\u000f^5p]B\u00111\u0006[\u0005\u0003S2\u0012ABU1ti\u0016\u0014(+Z4j_:DQa[\u0006A\u0002\u0001\u000b1a[3z\u0003\u0011\u0011X-\u00193\u0015\u00059\u0014\bcA\u0012f_B\u00111\u0006]\u0005\u0003c2\u0012Q\"T;mi&\u0014\u0017M\u001c3US2,\u0007\"B6\r\u0001\u0004\u0001Ec\u00018uk\")1.\u0004a\u0001\u0001\")a/\u0004a\u0001o\u0006)!-\u00198egB!\u0001p`A\u0003\u001d\tIhP\u0004\u0002{{6\t1P\u0003\u0002}?\u00051AH]8pizJ\u0011!J\u0005\u0003!\u0012JA!!\u0001\u0002\u0004\t\u00191+Z9\u000b\u0005A#\u0003cA\u0012\u0002\b%\u0019\u0011\u0011\u0002\u0013\u0003\u0007%sG/A\u0004sK\u0006$\u0017\t\u001c7\u0015\r\u0005=\u00111DA\u0011!\u0015A\u0018\u0011CA\u000b\u0013\u0011\t\u0019\"a\u0001\u0003\u0011%#XM]1u_J\u0004RaIA\f\u0001>L1!!\u0007%\u0005\u0019!V\u000f\u001d7fe!9\u0011Q\u0004\bA\u0002\u0005}\u0011\u0001B6fsN\u0004B\u0001_A\t\u0001\")aO\u0004a\u0001oR!\u0011qBA\u0013\u0011\u001d\tib\u0004a\u0001\u0003?!\"!a\u0004\u0016\u0005\u0005-\u0002#BA\u0017\u0003k\u0001e\u0002BA\u0018\u0003c\u0001\"A\u001f\u0013\n\u0007\u0005MB%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\tIDA\u0002TKRT1!a\r%\u0003IYW-_3e%\u0006\u001cH/\u001a:SK\u001eLwN\\:\u0015\u0005\u0005}\u0002#\u0002=\u0002\u0012\u0005\u0005\u0003#B\u0012\u0002\u0018\u0001;\u0017\u0001\u0005'bs>,H\u000fV5mKN{WO]2f!\t!Dc\u0005\u0002\u0015EQ\u0011\u0011QI\u0001\u0006CB\u0004H._\u000b\u0005\u0003\u001f\n9\u0006\u0006\u0005\u0002R\u0005}\u0013\u0011MA2)\u0011\t\u0019&!\u0017\u0011\tQ\u0002\u0011Q\u000b\t\u0004\u0003\u0006]C!B\"\u0017\u0005\u0004!\u0005\"CA.-\u0005\u0005\t9AA/\u0003))g/\u001b3f]\u000e,GE\r\t\u0005\u001dF\u000b)\u0006C\u0003)-\u0001\u0007!\u0006C\u00032-\u0001\u00071\u0007\u0003\u00049-\u0001\u0007\u0011Q\r\t\u0006Gmj\u0014QK\u0001\bgB\fG/[1m)\u0019\tY'!\u001c\u0002pA\u0019A\u0007A\u001f\t\u000b!:\u0002\u0019\u0001\u0016\t\u000bE:\u0002\u0019A\u001a\u0002\u0011Q,W\u000e]8sC2$\u0002\"!\u001e\u0002~\u0005}\u0014\u0011\u0011\t\u0005i\u0001\t9\bE\u00025\u0003sJ1!a\u001f\u001c\u00051\u0019\u0006/Y2f)&lWmS3z\u0011\u0015A\u0003\u00041\u0001+\u0011\u0015\t\u0004\u00041\u00014\u0011\u0019A\u0004\u00041\u0001\u0002\u0004B)1eO\u001f\u0002x\u0005\u0011\"/Z9vSJ,wI]5e\u00032LwM\\3e)\u0019\tI)a$\u0002\u001aB\u00191%a#\n\u0007\u00055EE\u0001\u0003V]&$\bbBAI3\u0001\u0007\u00111S\u0001\u0002CB!1&!&_\u0013\r\t9\n\f\u0002\u000b\u000fJLG-\u0012=uK:$\bbBAN3\u0001\u0007\u00111S\u0001\u0002E\u0002")
public class LayoutTileSource<K> {
    private final RasterSource source;
    private final LayoutDefinition layout;
    private final Function1<SpatialKey, K> tileKeyTransform;
    private final Component<K, SpatialKey> evidence$1;

    public static LayoutTileSource<SpaceTimeKey> temporal(RasterSource rasterSource, LayoutDefinition layoutDefinition, Function1<SpatialKey, SpaceTimeKey> function1) {
        return LayoutTileSource$.MODULE$.temporal(rasterSource, layoutDefinition, function1);
    }

    public static LayoutTileSource<SpatialKey> spatial(RasterSource rasterSource, LayoutDefinition layoutDefinition) {
        return LayoutTileSource$.MODULE$.spatial(rasterSource, layoutDefinition);
    }

    public static <K> LayoutTileSource<K> apply(RasterSource rasterSource, LayoutDefinition layoutDefinition, Function1<SpatialKey, K> function1, Component<K, SpatialKey> component) {
        return LayoutTileSource$.MODULE$.apply(rasterSource, layoutDefinition, function1, component);
    }

    public RasterSource source() {
        return this.source;
    }

    public LayoutDefinition layout() {
        return this.layout;
    }

    public Function1<SpatialKey, K> tileKeyTransform() {
        return this.tileKeyTransform;
    }

    public long sourceColOffset() {
        return (long)((this.source().extent().xmin() - this.layout().extent().xmin()) / this.layout().cellwidth());
    }

    public long sourceRowOffset() {
        return (long)((this.layout().extent().ymax() - this.source().extent().ymax()) / this.layout().cellheight());
    }

    public Option<RasterRegion> rasterRegionForKey(K key) {
        SpatialKey spatialComponent = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent(this.evidence$1);
        long col = spatialComponent.col();
        long row = spatialComponent.row();
        GridBounds.mcJ.sp sourcePixelBounds = new GridBounds.mcJ.sp(col * (long)this.layout().tileCols() - this.sourceColOffset(), row * (long)this.layout().tileRows() - this.sourceRowOffset(), (col + 1L) * (long)this.layout().tileCols() - 1L - this.sourceColOffset(), (row + 1L) * (long)this.layout().tileRows() - 1L - this.sourceRowOffset(), (Integral)Integral$.MODULE$.LongIsIntegral());
        return sourcePixelBounds.intersects$mcJ$sp(this.source().dimensions()) ? new Some((Object)RasterRegion$.MODULE$.apply(this.source(), (GridBounds)sourcePixelBounds)) : None$.MODULE$;
    }

    public Option<MultibandTile> read(K key) {
        return this.read(key, (Seq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.source().bandCount()));
    }

    public Option<MultibandTile> read(K key, Seq<Object> bands) {
        SpatialKey spatialComponent = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent(this.evidence$1);
        long col = spatialComponent.col();
        long row = spatialComponent.row();
        GridBounds sourcePixelBounds = GridBounds$.MODULE$.apply(col * (long)this.layout().tileCols() - this.sourceColOffset(), row * (long)this.layout().tileRows() - this.sourceRowOffset(), (col + 1L) * (long)this.layout().tileCols() - 1L - this.sourceColOffset(), (row + 1L) * (long)this.layout().tileRows() - 1L - this.sourceRowOffset());
        return sourcePixelBounds.intersection$mcJ$sp(this.source().dimensions()).flatMap((Function1 & Serializable & scala.Serializable)bounds -> this.source().read(bounds, bands).map((Function1 & Serializable & scala.Serializable)raster -> {
            MultibandTile multibandTile;
            if (BoxesRunTime.unboxToInt((Object)raster.tile().cols()) == this.layout().tileCols() && BoxesRunTime.unboxToInt((Object)raster.tile().rows()) == this.layout().tileRows()) {
                multibandTile = (MultibandTile)raster.tile();
            } else {
                long colOffset = bounds.colMin$mcJ$sp() - sourcePixelBounds.colMin$mcJ$sp();
                long rowOffset = bounds.rowMin$mcJ$sp() - sourcePixelBounds.rowMin$mcJ$sp();
                multibandTile = ((MultibandTile)raster.tile()).mapBands((Function2 & Serializable & scala.Serializable)(x$1, band) -> LayoutTileSource.$anonfun$read$3(this, colOffset, rowOffset, BoxesRunTime.unboxToInt((Object)x$1), band));
            }
            return multibandTile;
        }));
    }

    public Iterator<Tuple2<K, MultibandTile>> readAll(Iterator<K> keys, Seq<Object> bands) {
        return keys.map((Function1 & Serializable & scala.Serializable)key -> {
            SpatialKey spatialComponent = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent($this.evidence$1);
            long col = spatialComponent.col();
            long row = spatialComponent.row();
            GridBounds sourcePixelBounds = GridBounds$.MODULE$.apply(col * (long)this.layout().tileCols() - this.sourceColOffset(), row * (long)this.layout().tileRows() - this.sourceRowOffset(), (col + 1L) * (long)this.layout().tileCols() - 1L - this.sourceColOffset(), (row + 1L) * (long)this.layout().tileRows() - 1L - this.sourceRowOffset());
            return new Tuple5(key, (Object)spatialComponent, (Object)BoxesRunTime.boxToLong((long)col), (Object)BoxesRunTime.boxToLong((long)row), (Object)sourcePixelBounds);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple5 tuple5 = x$3;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Object key = tuple5._1();
            GridBounds sourcePixelBounds = (GridBounds)tuple5._5();
            Iterable iterable = Option$.MODULE$.option2Iterable(sourcePixelBounds.intersection$mcJ$sp(this.source().dimensions()).flatMap((Function1 & Serializable & scala.Serializable)bounds -> this.source().read(bounds, bands).map((Function1 & Serializable & scala.Serializable)raster -> {
                MultibandTile multibandTile;
                if (BoxesRunTime.unboxToInt((Object)raster.tile().cols()) == this.layout().tileCols() && BoxesRunTime.unboxToInt((Object)raster.tile().rows()) == this.layout().tileRows()) {
                    multibandTile = (MultibandTile)raster.tile();
                } else {
                    long colOffset = bounds.colMin$mcJ$sp() - sourcePixelBounds.colMin$mcJ$sp();
                    long rowOffset = bounds.rowMin$mcJ$sp() - sourcePixelBounds.rowMin$mcJ$sp();
                    multibandTile = ((MultibandTile)raster.tile()).mapBands((Function2 & Serializable & scala.Serializable)(x$2, band) -> LayoutTileSource.$anonfun$readAll$5(this, colOffset, rowOffset, BoxesRunTime.unboxToInt((Object)x$2), band));
                }
                MultibandTile tile = multibandTile;
                return new Tuple2(key, (Object)tile);
            })));
            return iterable;
        });
    }

    public Iterator<Tuple2<K, MultibandTile>> readAll(Iterator<K> keys) {
        return this.readAll(keys, (Seq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.source().bandCount()));
    }

    public Iterator<Tuple2<K, MultibandTile>> readAll() {
        return this.readAll(this.keys().toIterator());
    }

    public Set<K> keys() {
        Set set;
        LazyDouble buffX$lzy = new LazyDouble();
        LazyDouble buffY$lzy = new LazyDouble();
        Option option = this.layout().extent().intersection(this.source().extent());
        if (option instanceof Some) {
            Some some = (Some)option;
            Extent intersection = (Extent)some.value();
            Extent buffered = intersection.copy(intersection.xmin() - this.buffX$1(buffX$lzy), intersection.ymin() - this.buffY$1(buffY$lzy), intersection.xmax() + this.buffX$1(buffX$lzy), intersection.ymax() + this.buffY$1(buffY$lzy));
            set = (Set)this.layout().mapTransform().keysForGeometry(buffered.toPolygon()).map(this.tileKeyTransform(), Set$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError((Object)option);
        }
        return set;
    }

    public Iterator<Tuple2<K, RasterRegion>> keyedRasterRegions() {
        return this.keys().toIterator().flatMap((Function1 & Serializable & scala.Serializable)key -> {
            Option<RasterRegion> result = this.rasterRegionForKey(key);
            return Option$.MODULE$.option2Iterable(result.map((Function1 & Serializable & scala.Serializable)region -> new Tuple2(key, region)));
        });
    }

    public static final /* synthetic */ PaddedTile $anonfun$read$3(LayoutTileSource $this, long colOffset$1, long rowOffset$1, int x$1, Tile band) {
        return new PaddedTile(band, (int)colOffset$1, (int)rowOffset$1, $this.layout().tileCols(), $this.layout().tileRows());
    }

    public static final /* synthetic */ PaddedTile $anonfun$readAll$5(LayoutTileSource $this, long colOffset$2, long rowOffset$2, int x$2, Tile band) {
        return new PaddedTile(band, (int)colOffset$2, (int)rowOffset$2, $this.layout().tileCols(), $this.layout().tileRows());
    }

    private final /* synthetic */ double buffX$lzycompute$1(LazyDouble buffX$lzy$1) {
        double d;
        LazyDouble lazyDouble = buffX$lzy$1;
        synchronized (lazyDouble) {
            d = buffX$lzy$1.initialized() ? buffX$lzy$1.value() : buffX$lzy$1.initialize(this.layout().cellSize().width() * -0.25);
        }
        return d;
    }

    private final double buffX$1(LazyDouble buffX$lzy$1) {
        return buffX$lzy$1.initialized() ? buffX$lzy$1.value() : this.buffX$lzycompute$1(buffX$lzy$1);
    }

    private final /* synthetic */ double buffY$lzycompute$1(LazyDouble buffY$lzy$1) {
        double d;
        LazyDouble lazyDouble = buffY$lzy$1;
        synchronized (lazyDouble) {
            d = buffY$lzy$1.initialized() ? buffY$lzy$1.value() : buffY$lzy$1.initialize(this.layout().cellSize().height() * -0.25);
        }
        return d;
    }

    private final double buffY$1(LazyDouble buffY$lzy$1) {
        return buffY$lzy$1.initialized() ? buffY$lzy$1.value() : this.buffY$lzycompute$1(buffY$lzy$1);
    }

    public LayoutTileSource(RasterSource source, LayoutDefinition layout, Function1<SpatialKey, K> tileKeyTransform, Component<K, SpatialKey> evidence$1) {
        this.source = source;
        this.layout = layout;
        this.tileKeyTransform = tileKeyTransform;
        this.evidence$1 = evidence$1;
        LayoutTileSource$.MODULE$.geotrellis$layer$LayoutTileSource$$requireGridAligned((GridExtent<Object>)source.gridExtent(), (GridExtent<Object>)layout);
    }
}

