/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer.buffer;

import geotrellis.layer.SpatialKey;
import geotrellis.layer.buffer.BufferTiles$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.buffer.BufferSizes;
import geotrellis.raster.buffer.BufferedTile;
import geotrellis.raster.buffer.Direction;
import geotrellis.raster.buffer.Direction$Bottom$;
import geotrellis.raster.buffer.Direction$BottomLeft$;
import geotrellis.raster.buffer.Direction$BottomRight$;
import geotrellis.raster.buffer.Direction$Center$;
import geotrellis.raster.buffer.Direction$Left$;
import geotrellis.raster.buffer.Direction$Right$;
import geotrellis.raster.buffer.Direction$Top$;
import geotrellis.raster.buffer.Direction$TopLeft$;
import geotrellis.raster.buffer.Direction$TopRight$;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.util.package$;
import java.io.Serializable;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEr!\u0002\u0007\u000e\u0011\u0003!b!\u0002\f\u000e\u0011\u00039\u0002b\u0002B\u0017\u0003\u0011\u0005!q\u0006\u0004\b-5\u0001\n1!\u0001 \u0011\u0015\u00013\u0001\"\u0001\"\u0011\u001d)3A1A\u0005\u0002\u0019BQ!M\u0002\u0005\u0002IBq!a\u0007\u0004\t\u0003\ti\u0002C\u0004\u0002X\r!\t!!\u0017\t\u000f\u0005]3\u0001\"\u0001\u0002\f\"9\u0011qK\u0002\u0005\u0002\u0005u\u0006bBA,\u0007\u0011\u0005\u00111_\u0001\f\u0005V4g-\u001a:US2,7O\u0003\u0002\u000f\u001f\u00051!-\u001e4gKJT!\u0001E\t\u0002\u000b1\f\u00170\u001a:\u000b\u0003I\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0001\"!F\u0001\u000e\u00035\u00111BQ;gM\u0016\u0014H+\u001b7fgN\u0019\u0011\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\t)2a\u0005\u0002\u00041\u00051A%\u001b8ji\u0012\"\u0012A\t\t\u00033\rJ!\u0001\n\u000e\u0003\tUs\u0017\u000e^\u0001\u0007Y><w-\u001a:\u0016\u0003\u001d\u0002\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\u000b1|w\r\u000e6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0005\u0003a%\u0012a\u0001T8hO\u0016\u0014\u0018\u0001G2pY2,7\r^,ji\"$\u0016\u000e\\3OK&<\u0007NY8sgV\u00191G\u0012-\u0015\rQJ80`A\b)\r)$M\u001c\t\u0004my\neBA\u001c=\u001d\tA4(D\u0001:\u0015\tQ4#\u0001\u0004=e>|GOP\u0005\u00027%\u0011QHG\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004IA\u0002TKFT!!\u0010\u000e\u0011\te\u0011EiT\u0005\u0003\u0007j\u0011a\u0001V;qY\u0016\u0014\u0004CA#G\u0019\u0001!Qa\u0012\u0004C\u0002!\u0013\u0011aS\t\u0003\u00132\u0003\"!\u0007&\n\u0005-S\"a\u0002(pi\"Lgn\u001a\t\u000335K!A\u0014\u000e\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u001a\u0005B;\u0006CA)V\u001b\u0005\u0011&B\u0001\bT\u0015\t!\u0016#\u0001\u0004sCN$XM]\u0005\u0003-J\u0013\u0011\u0002R5sK\u000e$\u0018n\u001c8\u0011\u0005\u0015CF!B-\u0007\u0005\u0004Q&!\u0001,\u0012\u0005%[\u0006c\u0001/^?6\t1+\u0003\u0002_'\nA1)\u001a7m\u000fJLG\r\u0005\u0002\u001aA&\u0011\u0011M\u0007\u0002\u0004\u0013:$\bbB2\u0007\u0003\u0003\u0005\u001d\u0001Z\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA3l\t:\u0011aM\u001b\b\u0003O&t!\u0001\u000f5\n\u0003II!\u0001E\t\n\u0005uz\u0011B\u00017n\u0005A\u0019\u0006/\u0019;jC2\u001cu.\u001c9p]\u0016tGO\u0003\u0002>\u001f!9qNBA\u0001\u0002\b\u0001\u0018AC3wS\u0012,gnY3%eA!\u0011$],t\u0013\t\u0011(DA\u0005Gk:\u001cG/[8ocA\u0019Ao^,\u000e\u0003UT!A^*\u0002\t\r\u0014x\u000e]\u0005\u0003qV\u00141b\u0011:pa6+G\u000f[8eg\")!P\u0002a\u0001\t\u0006\u00191.Z=\t\u000bq4\u0001\u0019A,\u0002\tQLG.\u001a\u0005\u0006}\u001a\u0001\ra`\u0001\u000bS:\u001cG.\u001e3f\u0017\u0016L\bCB\rr\u0003\u0003\tI\u0001\u0005\u0003\u0002\u0004\u0005\u0015Q\"A\b\n\u0007\u0005\u001dqB\u0001\u0006Ta\u0006$\u0018.\u00197LKf\u00042!GA\u0006\u0013\r\tiA\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\t\tB\u0002a\u0001\u0003'\tabZ3u\u0005V4g-\u001a:TSj,7\u000f\u0005\u0004\u001ac\u0006\u0005\u0011Q\u0003\t\u0004#\u0006]\u0011bAA\r%\nY!)\u001e4gKJ\u001c\u0016N_3t\u0003M\u0011WO\u001a4fe^KG\u000f\u001b(fS\u001eD'm\u001c:t+\u0019\ty\"!\u000b\u00024Q!\u0011\u0011EA&)\u0019\t\u0019#!\u000e\u0002<A!aGPA\u0013!\u0019I\")a\n\u0002,A\u0019Q)!\u000b\u0005\u000b\u001d;!\u0019\u0001%\u0011\u000bE\u000bi#!\r\n\u0007\u0005=\"K\u0001\u0007Ck\u001a4WM]3e)&dW\rE\u0002F\u0003g!Q!W\u0004C\u0002iC\u0011\"a\u000e\b\u0003\u0003\u0005\u001d!!\u000f\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0003fW\u0006\u001d\u0002\"CA\u001f\u000f\u0005\u0005\t9AA \u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0007\u0003\u0003\n9%!\r\u000e\u0005\u0005\r#bAA#'\u000611\u000f^5uG\"LA!!\u0013\u0002D\tA1\u000b^5uG\",'\u000fC\u0004\u0002N\u001d\u0001\r!a\u0014\u0002\u0007M,\u0017\u000f\u0005\u00037}\u0005E\u0003CB\rC\u0003O\t\u0019\u0006\u0005\u00037}\u0005U\u0003#B\rC!\u0006E\u0012!B1qa2LXCBA.\u0003K\nY\u0007\u0006\u0004\u0002^\u0005\u0005\u0015q\u0011\u000b\t\u0003?\ni'a\u001d\u0002zA!aGPA1!\u0019I\")a\u0019\u0002hA\u0019Q)!\u001a\u0005\u000b\u001dC!\u0019\u0001%\u0011\u000bE\u000bi#!\u001b\u0011\u0007\u0015\u000bY\u0007B\u0003Z\u0011\t\u0007!\fC\u0005\u0002p!\t\t\u0011q\u0001\u0002r\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\t\u0015\\\u00171\r\u0005\n\u0003kB\u0011\u0011!a\u0002\u0003o\n!\"\u001a<jI\u0016t7-\u001a\u00137!\u0019\t\t%a\u0012\u0002j!I\u00111\u0010\u0005\u0002\u0002\u0003\u000f\u0011QP\u0001\u000bKZLG-\u001a8dK\u0012:\u0004CB\rr\u0003S\ny\b\u0005\u0003uo\u0006%\u0004bBA'\u0011\u0001\u0007\u00111\u0011\t\u0005my\n)\t\u0005\u0004\u001a\u0005\u0006\r\u0014\u0011\u000e\u0005\u0007\u0003\u0013C\u0001\u0019A0\u0002\u0015\t,hMZ3s'&TX-\u0006\u0004\u0002\u000e\u0006]\u0015Q\u0014\u000b\u0007\u0003\u001f\u000b\u0019,!/\u0015\u0011\u0005E\u0015qTAS\u0003W\u0003BA\u000e \u0002\u0014B1\u0011DQAK\u00033\u00032!RAL\t\u00159\u0015B1\u0001I!\u0015\t\u0016QFAN!\r)\u0015Q\u0014\u0003\u00063&\u0011\rA\u0017\u0005\n\u0003CK\u0011\u0011!a\u0002\u0003G\u000b!\"\u001a<jI\u0016t7-\u001a\u00139!\u0011)7.!&\t\u0013\u0005\u001d\u0016\"!AA\u0004\u0005%\u0016AC3wS\u0012,gnY3%sA1\u0011\u0011IA$\u00037C\u0011\"!,\n\u0003\u0003\u0005\u001d!a,\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\r\t\u00073E\fY*!-\u0011\tQ<\u00181\u0014\u0005\b\u0003\u001bJ\u0001\u0019AA[!\u00111d(a.\u0011\re\u0011\u0015QSAN\u0011\u001d\t\t\"\u0003a\u0001\u0003w\u0003b!G9\u0002\u0016\u0006UQCBA`\u0003\u0013\fy\r\u0006\u0004\u0002B\u0006\u0015\u00181\u001e\u000b\t\u0003\u0007\f\t.a6\u0002^B!aGPAc!\u0019I\")a2\u0002LB\u0019Q)!3\u0005\u000b\u001dS!\u0019\u0001%\u0011\u000bE\u000bi#!4\u0011\u0007\u0015\u000by\rB\u0003Z\u0015\t\u0007!\fC\u0005\u0002T*\t\t\u0011q\u0001\u0002V\u0006YQM^5eK:\u001cW\rJ\u00192!\u0011)7.a2\t\u0013\u0005e'\"!AA\u0004\u0005m\u0017aC3wS\u0012,gnY3%cI\u0002b!!\u0011\u0002H\u00055\u0007\"CAp\u0015\u0005\u0005\t9AAq\u0003-)g/\u001b3f]\u000e,G%M\u001a\u0011\re\t\u0018QZAr!\u0011!x/!4\t\u000f\u00055#\u00021\u0001\u0002hB!aGPAu!\u0019I\")a2\u0002N\"9\u0011Q\u001e\u0006A\u0002\u0005=\u0018!\u00052vM\u001a,'oU5{KN\u0004VM]&fsB!aGPAy!\u0019I\")a2\u0002\u0016U1\u0011Q_A\u0000\u0005\u000b!\u0002\"a>\u0003\u001c\t\u0005\"1\u0005\u000b\t\u0003s\u00149A!\u0004\u0003\u0014A!aGPA~!\u0019I\")!@\u0003\u0002A\u0019Q)a@\u0005\u000b\u001d[!\u0019\u0001%\u0011\u000bE\u000biCa\u0001\u0011\u0007\u0015\u0013)\u0001B\u0003Z\u0017\t\u0007!\fC\u0005\u0003\n-\t\t\u0011q\u0001\u0003\f\u0005YQM^5eK:\u001cW\rJ\u00195!\u0011)7.!@\t\u0013\t=1\"!AA\u0004\tE\u0011aC3wS\u0012,gnY3%cU\u0002b!!\u0011\u0002H\t\r\u0001\"\u0003B\u000b\u0017\u0005\u0005\t9\u0001B\f\u0003-)g/\u001b3f]\u000e,G%\r\u001c\u0011\re\t(1\u0001B\r!\u0011!xOa\u0001\t\u000f\u000553\u00021\u0001\u0003\u001eA!aG\u0010B\u0010!\u0019I\")!@\u0003\u0004!1\u0011\u0011R\u0006A\u0002}CqA!\n\f\u0001\u0004\u00119#A\u0006mCf,'OQ8v]\u0012\u001c\bcA3\u0003*%\u0019!1F7\u0003\u0015QKG.\u001a\"pk:$7/\u0001\u0004=S:LGO\u0010\u000b\u0002)\u0001")
public interface BufferTiles {
    public void geotrellis$layer$buffer$BufferTiles$_setter_$logger_$eq(Logger var1);

    public Logger logger();

    public static /* synthetic */ Seq collectWithTileNeighbors$(BufferTiles $this, Object key, CellGrid tile, Function1 includeKey, Function1 getBufferSizes, Component evidence$1, Function1 evidence$2) {
        return $this.collectWithTileNeighbors(key, tile, (Function1<SpatialKey, Object>)includeKey, (Function1<SpatialKey, BufferSizes>)getBufferSizes, evidence$1, evidence$2);
    }

    default public <K, V extends CellGrid<Object>> Seq<Tuple2<K, Tuple2<Direction, V>>> collectWithTileNeighbors(K key, V tile, Function1<SpatialKey, Object> includeKey, Function1<SpatialKey, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$1, Function1<V, CropMethods<V>> evidence$2) {
        SpatialKey spatialKey = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent(evidence$1);
        if (spatialKey == null) {
            throw new MatchError((Object)spatialKey);
        }
        int col = spatialKey.col();
        int row = spatialKey.row();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
        Tuple2.mcII.sp sp3 = sp2;
        int col2 = sp3._1$mcI$sp();
        int row2 = sp3._2$mcI$sp();
        ArrayBuffer parts = new ArrayBuffer(9);
        int cols = BoxesRunTime.unboxToInt((Object)tile.cols());
        int rows = BoxesRunTime.unboxToInt((Object)tile.rows());
        BufferTiles.addSlice$1(new SpatialKey(col2, row2), (Function0 & Serializable & scala.Serializable)() -> Direction$Center$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        BufferTiles.addSlice$1(new SpatialKey(col2 - 1, row2), (Function0 & Serializable & scala.Serializable)() -> Direction$Right$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        BufferTiles.addSlice$1(new SpatialKey(col2 + 1, row2), (Function0 & Serializable & scala.Serializable)() -> Direction$Left$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        BufferTiles.addSlice$1(new SpatialKey(col2, row2 - 1), (Function0 & Serializable & scala.Serializable)() -> Direction$Bottom$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        BufferTiles.addSlice$1(new SpatialKey(col2, row2 + 1), (Function0 & Serializable & scala.Serializable)() -> Direction$Top$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        BufferTiles.addSlice$1(new SpatialKey(col2 - 1, row2 - 1), (Function0 & Serializable & scala.Serializable)() -> Direction$BottomRight$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        BufferTiles.addSlice$1(new SpatialKey(col2 + 1, row2 - 1), (Function0 & Serializable & scala.Serializable)() -> Direction$BottomLeft$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        BufferTiles.addSlice$1(new SpatialKey(col2 + 1, row2 + 1), (Function0 & Serializable & scala.Serializable)() -> Direction$TopLeft$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        BufferTiles.addSlice$1(new SpatialKey(col2 - 1, row2 + 1), (Function0 & Serializable & scala.Serializable)() -> Direction$TopRight$.MODULE$, includeKey, getBufferSizes, tile, evidence$2, rows, cols, parts, key, evidence$1);
        return parts;
    }

    public static /* synthetic */ Seq bufferWithNeighbors$(BufferTiles $this, Seq seq, Component evidence$3, Stitcher evidence$4) {
        return $this.bufferWithNeighbors(seq, evidence$3, evidence$4);
    }

    default public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> bufferWithNeighbors(Seq<Tuple2<K, Seq<Tuple2<Direction, V>>>> seq, Component<K, SpatialKey> evidence$3, Stitcher<V> evidence$4) {
        return (Seq)seq.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Seq neighbors = (Seq)tuple2._2();
            Option opt = neighbors.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BufferTiles.$anonfun$bufferWithNeighbors$2(x$2))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                CellGrid centerTile = (CellGrid)tuple2._2();
                BufferSizes bufferSizes = (BufferSizes)neighbors.foldLeft((Object)new BufferSizes(0, 0, 0, 0), (Function2 & Serializable & scala.Serializable)(acc, tup) -> {
                    BufferSizes bufferSizes;
                    Tuple2 tuple2 = tup;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Direction direction = (Direction)tuple2._1();
                    CellGrid slice = (CellGrid)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)direction, (Object)slice);
                    Tuple2 tuple23 = tuple22;
                    Direction direction2 = (Direction)tuple23._1();
                    CellGrid slice2 = (CellGrid)tuple23._2();
                    Direction direction3 = direction2;
                    if (Direction$Left$.MODULE$.equals(direction3)) {
                        bufferSizes = acc.copy(BoxesRunTime.unboxToInt((Object)slice2.cols()), acc.copy$default$2(), acc.copy$default$3(), acc.copy$default$4());
                    } else if (Direction$Right$.MODULE$.equals(direction3)) {
                        int x$1 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                        int x$2 = acc.copy$default$1();
                        int x$3 = acc.copy$default$3();
                        int x$4 = acc.copy$default$4();
                        bufferSizes = acc.copy(x$2, x$1, x$3, x$4);
                    } else if (Direction$Top$.MODULE$.equals(direction3)) {
                        int x$5 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                        int x$6 = acc.copy$default$1();
                        int x$7 = acc.copy$default$2();
                        int x$8 = acc.copy$default$3();
                        bufferSizes = acc.copy(x$6, x$7, x$8, x$5);
                    } else if (Direction$Bottom$.MODULE$.equals(direction3)) {
                        int x$9 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                        int x$10 = acc.copy$default$1();
                        int x$11 = acc.copy$default$2();
                        int x$12 = acc.copy$default$4();
                        bufferSizes = acc.copy(x$10, x$11, x$9, x$12);
                    } else if (Direction$BottomRight$.MODULE$.equals(direction3)) {
                        int x$13 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                        int x$14 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                        int x$15 = acc.copy$default$1();
                        int x$16 = acc.copy$default$4();
                        bufferSizes = acc.copy(x$15, x$14, x$13, x$16);
                    } else if (Direction$BottomLeft$.MODULE$.equals(direction3)) {
                        int x$17 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                        int x$18 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                        int x$19 = acc.copy$default$2();
                        int x$20 = acc.copy$default$4();
                        bufferSizes = acc.copy(x$18, x$19, x$17, x$20);
                    } else if (Direction$TopRight$.MODULE$.equals(direction3)) {
                        int x$21 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                        int x$22 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                        int x$23 = acc.copy$default$1();
                        int x$24 = acc.copy$default$3();
                        bufferSizes = acc.copy(x$23, x$22, x$24, x$21);
                    } else if (Direction$TopLeft$.MODULE$.equals(direction3)) {
                        int x$25 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                        int x$26 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                        int x$27 = acc.copy$default$2();
                        int x$28 = acc.copy$default$3();
                        bufferSizes = acc.copy(x$26, x$27, x$28, x$25);
                    } else {
                        bufferSizes = acc;
                    }
                    return bufferSizes;
                });
                Seq pieces = (Seq)neighbors.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2.mcII.sp sp2;
                    CellGrid slice;
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        Tuple2.mcII.sp sp3;
                        Direction direction = (Direction)tuple2._1();
                        slice = (CellGrid)tuple2._2();
                        Direction direction2 = direction;
                        if (Direction$Center$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left(), bufferSizes.top());
                        } else if (Direction$Left$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(0, bufferSizes.top());
                        } else if (Direction$Right$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left() + BoxesRunTime.unboxToInt((Object)centerTile.cols()), bufferSizes.top());
                        } else if (Direction$Top$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left(), 0);
                        } else if (Direction$Bottom$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left(), bufferSizes.top() + BoxesRunTime.unboxToInt((Object)centerTile.rows()));
                        } else if (Direction$TopLeft$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(0, 0);
                        } else if (Direction$TopRight$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left() + BoxesRunTime.unboxToInt((Object)centerTile.cols()), 0);
                        } else if (Direction$BottomLeft$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(0, bufferSizes.top() + BoxesRunTime.unboxToInt((Object)centerTile.rows()));
                        } else if (Direction$BottomRight$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left() + BoxesRunTime.unboxToInt((Object)centerTile.cols()), bufferSizes.top() + BoxesRunTime.unboxToInt((Object)centerTile.rows()));
                        } else {
                            throw new MatchError((Object)direction2);
                        }
                        Tuple2.mcII.sp sp4 = sp3;
                        if (sp4 == null) {
                            throw new MatchError((Object)sp4);
                        }
                        int updateColMin = sp4._1$mcI$sp();
                        int updateRowMin = sp4._2$mcI$sp();
                        sp2 = new Tuple2.mcII.sp(updateColMin, updateRowMin);
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Tuple2.mcII.sp sp5 = sp2;
                    int updateColMin = sp5._1$mcI$sp();
                    int updateRowMin = sp5._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)slice, (Object)new Tuple2.mcII.sp(updateColMin, updateRowMin));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom());
                int cols = BoxesRunTime.unboxToInt((Object)centerTile.cols()) + bufferSizes.left() + bufferSizes.right();
                int rows = BoxesRunTime.unboxToInt((Object)centerTile.rows()) + bufferSizes.top() + bufferSizes.bottom();
                CellGrid stitched = (CellGrid)((Stitcher)Predef$.MODULE$.implicitly((Object)evidence$4)).stitch((Iterable)pieces, cols, rows);
                BufferedTile bufferedTile = new BufferedTile((Object)stitched, GridBounds$.MODULE$.apply(bufferSizes.left(), bufferSizes.top(), cols - bufferSizes.right() - 1, rows - bufferSizes.bottom() - 1));
                return bufferedTile;
            });
            Iterable iterable = opt.isEmpty() ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), opt.get())));
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ Seq apply$(BufferTiles $this, Seq seq, int bufferSize, Component evidence$5, Stitcher evidence$6, Function1 evidence$7) {
        return $this.apply(seq, bufferSize, evidence$5, evidence$6, evidence$7);
    }

    default public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, int bufferSize, Component<K, SpatialKey> evidence$5, Stitcher<V> evidence$6, Function1<V, CropMethods<V>> evidence$7) {
        return this.apply(seq, bufferSize, (GridBounds<Object>)GridBounds$.MODULE$.apply(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), evidence$5, evidence$6, evidence$7);
    }

    public static /* synthetic */ Seq apply$(BufferTiles $this, Seq seq, Function1 getBufferSizes, Component evidence$8, Stitcher evidence$9, Function1 evidence$10) {
        return $this.apply(seq, getBufferSizes, evidence$8, evidence$9, evidence$10);
    }

    default public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, Function1<K, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$8, Stitcher<V> evidence$9, Function1<V, CropMethods<V>> evidence$10) {
        return this.apply(seq, (Seq)seq.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), getBufferSizes.apply(key));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom()), evidence$8, evidence$9, evidence$10);
    }

    public static /* synthetic */ Seq apply$(BufferTiles $this, Seq seq, Seq bufferSizesPerKey, Component evidence$11, Stitcher evidence$12, Function1 evidence$13) {
        return $this.apply(seq, bufferSizesPerKey, evidence$11, evidence$12, evidence$13);
    }

    default public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, Seq<Tuple2<K, BufferSizes>> bufferSizesPerKey, Component<K, SpatialKey> evidence$11, Stitcher<V> evidence$12, Function1<V, CropMethods<V>> evidence$13) {
        Seq contributingKeys = (Seq)bufferSizesPerKey.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3;
            BufferSizes bufferSizes;
            Object key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                key = tuple2._1();
                bufferSizes = (BufferSizes)tuple2._2();
                SpatialKey spatialKey = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$11);
                if (spatialKey == null) {
                    throw new MatchError((Object)spatialKey);
                }
                int col = spatialKey.col();
                int row = spatialKey.row();
                tuple3 = new Tuple3((Object)spatialKey, (Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row));
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple32 = tuple3;
            SpatialKey spatialKey = (SpatialKey)tuple32._1();
            int col = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int row = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(key, (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col - 1, row), (SetComponent)evidence$11), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col + 1, row), (SetComponent)evidence$11), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col, row - 1), (SetComponent)evidence$11), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col, row + 1), (SetComponent)evidence$11), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col - 1, row - 1), (SetComponent)evidence$11), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col + 1, row - 1), (SetComponent)evidence$11), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col + 1, row + 1), (SetComponent)evidence$11), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col - 1, row + 1), (SetComponent)evidence$11), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes))}));
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        Seq surroundingBufferSizes = contributingKeys.groupBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6._1()).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)x$7.map((Function1 & Serializable & scala.Serializable)x$8 -> (Tuple2)x$8._2(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).toSeq();
        Seq grouped = ((TraversableLike)((TraversableLike)seq.zip((GenIterable)surroundingBufferSizes, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            CellGrid tile;
            Object key2;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    key2 = tuple23._1();
                    tile = (CellGrid)tuple23._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Map bufferSizesMap = (Map)tuple2._2();
            Seq<Tuple2<Object, Tuple2<Direction, CellGrid>>> seq = this.collectWithTileNeighbors(key2, tile, (Function1<SpatialKey, Object>)(Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)bufferSizesMap.contains((Object)key)), (Function1<SpatialKey, BufferSizes>)bufferSizesMap, evidence$11, evidence$13);
            return seq;
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$9 -> x$9._1()).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> (Seq)x$10.map((Function1 & Serializable & scala.Serializable)x$11 -> (Tuple2)x$11._2(), Seq$.MODULE$.canBuildFrom())).toSeq();
        return this.bufferWithNeighbors(grouped, evidence$11, evidence$12);
    }

    public static /* synthetic */ Seq apply$(BufferTiles $this, Seq seq, int bufferSize, GridBounds layerBounds, Component evidence$14, Stitcher evidence$15, Function1 evidence$16) {
        return $this.apply(seq, bufferSize, (GridBounds<Object>)layerBounds, evidence$14, evidence$15, evidence$16);
    }

    default public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, int bufferSize, GridBounds<Object> layerBounds, Component<K, SpatialKey> evidence$14, Stitcher<V> evidence$15, Function1<V, CropMethods<V>> evidence$16) {
        BufferSizes bufferSizes = new BufferSizes(bufferSize, bufferSize, bufferSize, bufferSize);
        Seq grouped = ((TraversableLike)seq.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key2 = tuple2._1();
            CellGrid tile = (CellGrid)tuple2._2();
            Seq<Tuple2<Object, Tuple2<Direction, CellGrid>>> seq = this.collectWithTileNeighbors(key2, tile, (Function1<SpatialKey, Object>)(Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)layerBounds.contains$mcI$sp(key.col(), key.row())), (Function1<SpatialKey, BufferSizes>)(Function1 & Serializable & scala.Serializable)key -> bufferSizes, evidence$14, evidence$16);
            return seq;
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$12 -> x$12._1()).mapValues((Function1 & Serializable & scala.Serializable)x$13 -> (Seq)x$13.map((Function1 & Serializable & scala.Serializable)x$14 -> (Tuple2)x$14._2(), Seq$.MODULE$.canBuildFrom())).toSeq();
        return this.bufferWithNeighbors(grouped, evidence$14, evidence$15);
    }

    private static void addSlice$1(SpatialKey spatialKey, Function0 direction, Function1 includeKey$1, Function1 getBufferSizes$1, CellGrid tile$1, Function1 evidence$2$1, int rows$1, int cols$1, ArrayBuffer parts$1, Object key$1, Component evidence$1$1) {
        block18: {
            CellGrid cellGrid;
            if (!BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply((Object)spatialKey))) break block18;
            BufferSizes bufferSizes = (BufferSizes)getBufferSizes$1.apply((Object)spatialKey);
            Direction direction2 = (Direction)direction.apply();
            if (Direction$Center$.MODULE$.equals(direction2)) {
                cellGrid = tile$1;
            } else if (Direction$Right$.MODULE$.equals(direction2)) {
                boolean x$1 = true;
                boolean x$2 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, 0, bufferSizes.right() - 1, rows$1 - 1, new Crop.Options(x$2, x$1));
            } else if (Direction$Left$.MODULE$.equals(direction2)) {
                boolean x$3 = true;
                boolean x$4 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(cols$1 - bufferSizes.left(), 0, cols$1 - 1, rows$1 - 1, new Crop.Options(x$4, x$3));
            } else if (Direction$Top$.MODULE$.equals(direction2)) {
                boolean x$5 = true;
                boolean x$6 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, rows$1 - bufferSizes.top(), cols$1 - 1, rows$1 - 1, new Crop.Options(x$6, x$5));
            } else if (Direction$Bottom$.MODULE$.equals(direction2)) {
                boolean x$7 = true;
                boolean x$8 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, 0, cols$1 - 1, bufferSizes.bottom() - 1, new Crop.Options(x$8, x$7));
            } else if (Direction$TopLeft$.MODULE$.equals(direction2)) {
                boolean x$9 = true;
                boolean x$10 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(cols$1 - bufferSizes.left(), rows$1 - bufferSizes.top(), cols$1 - 1, rows$1 - 1, new Crop.Options(x$10, x$9));
            } else if (Direction$TopRight$.MODULE$.equals(direction2)) {
                boolean x$11 = true;
                boolean x$12 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, rows$1 - bufferSizes.top(), bufferSizes.right() - 1, rows$1 - 1, new Crop.Options(x$12, x$11));
            } else if (Direction$BottomLeft$.MODULE$.equals(direction2)) {
                boolean x$13 = true;
                boolean x$14 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(cols$1 - bufferSizes.left(), 0, cols$1 - 1, bufferSizes.bottom() - 1, new Crop.Options(x$14, x$13));
            } else if (Direction$BottomRight$.MODULE$.equals(direction2)) {
                boolean x$15 = true;
                boolean x$16 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, 0, bufferSizes.right() - 1, bufferSizes.bottom() - 1, new Crop.Options(x$16, x$15));
            } else {
                throw new MatchError((Object)direction2);
            }
            CellGrid part = cellGrid;
            parts$1.$plus$eq((Object)new Tuple2(package$.MODULE$.withSetComponentMethods(key$1).setComponent((Object)spatialKey, (SetComponent)evidence$1$1), (Object)new Tuple2(direction.apply(), (Object)part)));
        }
    }

    public static /* synthetic */ boolean $anonfun$bufferWithNeighbors$2(Tuple2 x$2) {
        Object object = x$2._1();
        Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
        return !(object != null ? !object.equals(direction$Center$) : direction$Center$ != null);
    }

    public static void $init$(BufferTiles $this) {
        $this.geotrellis$layer$buffer$BufferTiles$_setter_$logger_$eq(Logger.getLogger(BufferTiles$.MODULE$.getClass()));
    }
}

